/*
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 */


#ifndef __PATCHUTIL_FIRMWARE_H__
#define __PATCHUTIL_FIRMWARE_H__


/*
#include <sys/mutex.h>
#include <sys/cond.h>
*/

#include "common.h"
#include "debug.h"
#include "syncutil.h"


/*
 * globals
 */


/*
 * defines
 */

#define HVCALL_PEEK                               14
#define HVCALL_POKE                               16

#define HVCALL_RUN                                203
#define HVCALL_ALLOC                              204
#define HVCALL_FREE                               205
#define HVCALL_COPY                               206

#define SYSCALL_LV2_PEEK               6
#define SYSCALL_LV2_POKE               7

#define SYSCALL_LV2_LV1_PEEK           8
#define SYSCALL_LV2_LV1_POKE           9
#define SYSCALL_LV2_LV1_CALL           10

#define SYSCALL_LV2_LV1_PEEK_356       10
#define SYSCALL_LV2_LV1_POKE_356       11

#define SYSCALL_RUN                    203
#define SYSCALL_ALLOC                  204
#define SYSCALL_FREE                   205
#define SYSCALL_COPY                   206

#define SYSCALL_SM_SHUTDOWN            379
#define SYSCALL_LED                    386
#define SYSCALL_BEEP                   392
#define SYSCALL_TTY_WRITE              403

#define SYSCALL_HVSC_POKE              811 /* mkdir (lv1 poke) hvsc redirect */
#define SYSCALL_ICBI_POKE              813 /* rmdir (icbi poke) */

#define SYSCALL_TRM_INTERFACE          862
#define SYSCALL_UM_INTERFACE           863
#define SYSCALL_SM_INTERFACE           864
#define SYSCALL_SS_RTC                 866
#define SYSCALL_SS_AIM                 867
#define SYSCALL_SS_IIM                 868
#define SYSCALL_SS_FLASHFLAG           874

#define SYSCALL_TARGET                 985

/* LV1 */
#define HVCALL_LV1_ADDR                            ( 0ULL )
#define SYSCALL_LV1_ADDR                           ( 0ULL )

/* LV2 */
#define SYSCALL_LV2_ADDR                           ( 1ULL << 63 )

#define SYSCALL_HV_BASE                            0x8000000014000000ULL /* lv2 address to map lv1 */
#define SYSCALL_HV_PAGE_SIZE                       0x1000                /* 4k from lv1 */
#define SYSCALL_HV_PAGE_SHIFT                      0x0c                  /* 4k 1<<0x0c */
#define SYSCALL_MEMORY_POOL                        0x27

#define SYSCALL_BEEP_ONCE                      0x1004, 0x4, 0x6
#define SYSCALL_BEEP_THRICE                    0x1004, 0xa, 0x1b6
#define SYSCALL_BEEP_CONSTANT                  0x1004, 0xa, 0xfff


#define BD_DEVICE                              0x0101000000000006ULL
#define HDD_DEVICE                             0x0101000000000007ULL

#define LV2_STORAGE_SEND_ATAPI_COMMAND         (1)

/*
 * structs
 */

typedef struct _patch_data
{
  s32 lv1_patch;
  s32 lv1_peek;
  s32 lv1_poke;
  s32 lv1_hvcall;

  s32 lv2_patch;
  s32 lv2_peek;
  s32 lv2_poke;
  s32 lv2_hvcall;
  s32 lv2_copyfromuser;

  s32 *patched;

  sys_mutex_t mutex;
  sys_mutex_attr_t mutex_attr;

  sys_cond_t cond;
  sys_cond_attr_t cond_attr;
} patchData;

typedef struct _fw_version
{
  s32 type;
  u64 id;
  u64 toc;
  u64 sctable;
  u64 hvtable;
  u64 memcpy;
  u64 memset;
  u64 strcpy;
  u64 strncmp;
  u64 strlen;
  u64 pathdup;
  u64 copyfromuser;
  u64 copytouser;
  u64 alloccopyfromuser;
  u64 strdupuser;
  u64 strlenuser;
  u64 alloc;
  u64 free;
  u64 printf;
  u64 printfnull;
  u64 membase;
  u64 icbipoke;
  u64 hvscpoke;
  u64 smpatch;
  u64 sspatch;
  u64 hookopen;
  u64 lv2protect;
  u8 hash[16];
} fwVersion;

typedef struct _fw_versions
{
  s32 type;
  u64 id;
  u64 toc;
  u64 sctable;
  u64 hvtable;
  s32 fw_version;
  s32 fw_major;
  s32 fw_minor;
  s32 fw_nano;
  s32 spoof;
  s32 spoof_version;
  s32 spoof_major;
  s32 spoof_minor;
  s32 spoof_nano;
  fwVersion *current;
  fwVersion version[85];
} fwVersions;

struct storage_device_info {
  uint8_t res1[32];
  uint32_t vendor_id;
  uint32_t device_id;
  uint64_t capacity;
  uint32_t sector_size;
  uint32_t media_count;
  uint8_t res2[8];
};


/*
 * functions
 */

/*
 * patchutils
 */

s32 patchutilInitialization ( patchData *patchdata );


/*
 * firmware
 */
void firmwareGetVersion(s32 *fw_version, s32 *fw_major, s32 *fw_minor, s32 *fw_nano, s32 *spoof);
void firmwareGetMd5Version(s32 *fw_version, s32 *fw_major, s32 *fw_minor, s32 *fw_nano);
void firmwareGetSysVersion(s32 *fw_version, s32 *fw_major, s32 *fw_minor, s32 *fw_nano);
void firmwareGetTocVersion(s32 *fw_version, s32 *fw_major, s32 *fw_minor, s32 *fw_nano);
void firmwareGetLv1Version(s32 *fw_version, s32 *fw_major, s32 *fw_minor, s32 *fw_nano);
s32 firmwareGetMD5Version();
s32 firmwareGetTOCVersion();
s32 firmwareGetLV1Version();

u64 firmwareGetTocAddress ();
u64 firmwareGetSyscallTableAddress ();
u64 firmwareGetMemcpyAddress ();
u64 firmwareGetMemsetAddress ();
u64 firmwareGetStrcpyAddress ();
u64 firmwareGetStrncmpAddress ();
u64 firmwareGetStrlenAddress ();
u64 firmwareGetPathdupAddress ();
u64 firmwareGetCopyFromUserAddress ();
u64 firmwareGetCopyToUserAddress ();
u64 firmwareGetAllocCopyFromUserAddress ();
u64 firmwareGetStrdupUserAddress ();
u64 firmwareGetStrlenUserAddress ();
u64 firmwareGetAllocAddress ();
u64 firmwareGetFreeAddress ();
u64 firmwareGetPrintfAddress ();
u64 firmwareGetPrintfNullAddress ();
u64 firmwareGetMemBaseAddress ();
u64 firmwareGetIcbiPokeAddress ();
u64 firmwareGetHvscRedirectAddress ();
u64 firmwareGetStorageManagerPatchAddress ();
u64 firmwareGetHookOpenAddress ();
u64 firmwareGetLv2ProtectionPatchAddress ();
u64 firmwareGetSsPatchAddress ();

u64 firmwareGetHvcallTableAddress ();
u64 firmwareGetHvcallCopyFromUserAddress ();
u64 firmwareGetHvcallCopyToUserAddress ();
u64 firmwareGetHvcallEaToRaAddress ();

/*
 * hvcall
 */

s32 hvcall_test_lv1peek ();
s32 hvcall_test_lv1poke ();
s32 hvcall_test_hvcall ();

u64 hvcall_set (s32 hvcall, u64 addr);
s32 hvcall_run (u64 addr);
s32 hvcall_ea_to_ra (u64 ea_addr, u64 ra_addr, u64 unknown);
void hvcall_trap (u64 addr);

u64 hvcall_lv1_peek (u64 addr);
u64 hvcall_lv1_peekq (u64 addr);
u32 hvcall_lv1_peek32 (u64 addr);

s32 hvcall_lv1_poke (u64 addr, u64 value);
s32 hvcall_lv1_pokeq (u64 addr, u64 value);
s32 hvcall_lv1_poke32 (u64 addr, u32 value);

u64 hvcall_lv1_hvcall0(u64 hvcall);
u64 hvcall_lv1_hvcall1(u64 hvcall, u64 arg1);
u64 hvcall_lv1_hvcall2(u64 hvcall, u64 arg1, u64 arg2);
u64 hvcall_lv1_hvcall3(u64 hvcall, u64 arg1, u64 arg2, u64 arg3);
u64 hvcall_lv1_hvcall4(u64 hvcall, u64 arg1, u64 arg2, u64 arg3, u64 arg4);
u64 hvcall_lv1_hvcall5(u64 hvcall, u64 arg1, u64 arg2, u64 arg3, u64 arg4, u64 arg5);
u64 hvcall_lv1_hvcall6(u64 hvcall, u64 arg1, u64 arg2, u64 arg3, u64 arg4, u64 arg5, u64 arg6);
u64 hvcall_lv1_hvcall7(u64 hvcall, u64 arg1, u64 arg2, u64 arg3, u64 arg4, u64 arg5, u64 arg6, u64 arg7);

s32 hvcall_lv1_allocate_memory(u64 size, u64 page_size_exp, u64 flags, u64 *addr, u64 *muid);
s32 hvcall_lv1_insert_htab_entry(u64 htab_id, u64 hpte_group, u64 hpte_v, u64 hpte_r, u64 bolted_flag, u64 flags, u64 *hpte_index, u64 *hpte_evicted_v, u64 *hpte_evicted_r);
s32 hvcall_lv1_create_repository_node_value(u64 n1, u64 n2, u64 n3, u64 n4, u64 v1, u64 v2);
s32 hvcall_lv1_get_repository_node_value(u64 lpar_id, u64 n1, u64 n2, u64 n3, u64 n4, u64 *v1, u64 *v2);
s32 hvcall_lv1_modify_repository_node_value(u64 n1, u64 n2, u64 n3, u64 n4, u64 v1, u64 v2);
s32 hvcall_lv1_undocumented_function_114(u64 start, u64 page_size, u64 size, u64 *lpar_addr);
void hvcall_lv1_undocumented_function_115(u64 lpar_addr);
s32 hvcall_lv1_get_version_info(u64 *data);
s32 hvcall_lv1_write_htab_entry(u64 vas_id, u64 slot, u64 va, u64 pa);
s32 hvcall_lv1_set_dabr(u64 addr, u64 flat);
void hvcall_lv1_panic ( u64 reboot );

/*
 * interface
 */

s32 interface_ss_vtrm_mgr(u32 packet_id, u64 arg1, u64 arg2, u64 arg3, u64 arg4);
s32 interface_ss_update_mgr(u32 packet_id, u64 arg1, u64 arg2, u64 arg3, u64 arg4, u64 arg5, u64 arg6);
s32 interface_ss_update_mgr8(u32 packet_id, u64 arg1, u64 arg2, u64 arg3, u64 arg4, u64 arg5, u64 arg6, u64 arg7);
s32 interface_ss_stor_mgr(u32 packet_id, u64 arg1);
s32 interface_ss_secure_rtc(u32 packet_id, u64 arg1, u64 arg2, u64 arg3);
s32 interface_ss_aim(u32 packet_id, u64 arg1);
s32 interface_ss_indi_info_mgr(u32 packet_id, u64 arg1, u64 arg2, u64 arg3, u64 arg4);
s32 interface_ss_get_cache_of_flash_ext_flag(u8 *flag);

/*
 * log
 */

s32 syscall_tty_write(s32 channel, const void *ptr, u32 len, u32 *written);
s32 write_tty(const char *string);

s32 open_log(const char *file, u32 *fd);
u64 write_log(const char *string, u32 *fd);
s32 close_log(u32 *fd);

/*
 * lv1_patches
 */

s32 patch_lv1_peek_poke ();
s32 patch_lv1_peek_poke_call ();
s32 patch_lv2_lv1_peek_poke ();
s32 patch_lv2_allow_lv1_peek_poke ();
s32 patch_lv2_allow_lv1_peek_poke_call ();
s32 patch_lv2_allow_lv1_call ();

s32 patch_lv1_storage_skip_acl_check ( s32 version );
s32 patch_lv1_htab_write (s32 version);
s32 patch_lv1_repo_node_lpar (s32 version);
s32 patch_lv1_dabr_priv_mask (s32 version);
s32 patch_lv1_mfc_sr1_mask ( s32 version );
s32 patch_lv1_sysmgr_disable_integrity_check (s32 version);
s32 patch_lv1_gameos_sysmgr_ability (s32 version);
s32 patch_lv1_um_extract_pkg (s32 version);
s32 patch_lv1_um_write_eprom_product_mode ( s32 version );
s32 patch_lv1_iimgr_access (s32 version);
s32 patch_lv1_dispmgr_access (s32 version);
s32 patch_lv1_mask (s32 version);
s32 patch_lv1_unmask (s32 version);
s32 patch_lv1_debug_print (s32 version);

/*
 * lv2_protect
 */

s32 patch_lv2_protect(s32 version);
s32 patch_lv2_modification(s32 version);

/*
 * md5util
 */

s32 MD5File(const char *filename, u8 *digest) ;
s32 MD5String(const char *string) ;

/*
 * mm
 */

s32 hvcall_mm_insert_htab_entry(unsigned long vas_id, u64 va_addr, u64 lpar_addr, u64 page_shift, u64 vflags, u64 rflags, u64 *index);
s32 hvcall_mm_map_lpar_memory_region(unsigned long vas_id, u64 va_start_addr, u64 lpar_start_addr, u64 size, u64 page_shift, u64 vflags, u64 rflags);

/*
 * storage
 */

s32 map_lv1_ss (u64 *mmap_lpar_addr);
void unmap_lv1_ss (u64 *mmap_lpar_addr);

s32 patch_storage_manager();
s32 unpatch_storage_manager();

s32 patch_sys_storage(u8 *ss_patched);
s32 unpatch_sys_storage(u8 *ss_patched);

s32 sys_storage_reset_bd();
s32 sys_storage_auth_bd();

u8 storage_get_psx_region_cd ();

s32 storage_open(u64 id, u32 *fd);
s32 storage_close(u32 fd);
s32 storage_read(u32 fd, u64 unknown1, u64 start_sector, u64 sector_count, const void *buf, u32 *sectors_read, u64 flags);
s32 storage_write(u32 fd, u64 unknown1, u64 start_sector, u64 sector_count, const void *buf, u32 *sectors_written, u64 flags);
s32 storage_async_configure(u32 fd, s32 buffer, u32 eqid, s32 *unknown);
s32 storage_get_device_info(u64 id, struct storage_device_info *info);
s32 storage_create_region(u32 fd, u64 start_sector, u64 sector_count, u64 unknown, u64 laid, u64 *region_id);
s32 storage_delete_region(u32 fd, u64 region_id);
s32 storage_execute_device_command(u32 fd, u64 cmd, const void *cmdbuf, u64 cmdbuf_size, void *databuf, u64 databuf_size, u64 *unknown);
s32 storage_util_mount(const char *dev_name, const char *dev_fs, const char *path, u32 prot);
s32 storage_util_umount(const char *path );
s32 storage_util_sync(const char *dir);
s32 storage_reset_bd ();
s32 storage_auth_bd ();
s32 storage_ctrl_bd ( s32 func );
s32 storage_set_bdemu ();

u64 storage_get_console_id(u8 *buf);

/*
 * syscall
 */

s32 syscall_test_lv2peek ();
s32 syscall_test_lv2poke ();
s32 syscall_test_hvcall114 ();

u64 syscall_lv2_set (s32 syscall, u64 addr);
s32 syscall_memcpy (u64 dst_addr, u64 src_addr, u64 size);
s32 syscall_copy_from_user (u64 dst_addr, u64 size, u64 src_addr);
s32 syscall_copy_to_user (u64 dst_addr, u64 src_addr, u64 size);
s32 syscall_alloc_copy_from_user (u64 dst_addr, u64 size, u64 src_addr);
u64 syscall_alloc (u64 size);
s32 syscall_free (u64 addr);
void syscall_run (u64 addr);
s32 syscall_launch (u64 addr);

void syscall_install_icbi_poke ();
void syscall_uninstall_icbi_poke ();

s32 syscall_test_lv1peek ();
s32 syscall_test_lv1poke ();
s32 syscall_test_hvcall ();

u64 syscall_lv1_peek (u64 addr);
s32 syscall_lv1_poke (u64 addr, u64 value);

u64 syscall_lv2_peek (u64 addr);
u64 syscall_lv2_peekq (u64 addr);
s32 syscall_lv2_poke (u64 addr, u64 value);
s32 syscall_lv2_pokeq (u64 addr, u64 value);
s32 syscall_lv2_poke32 (u64 addr, u32 value);

u64 syscall_lv2_lv1_peek (u64 addr);
u64 syscall_lv2_lv1_peekq (u64 addr);
s32 syscall_lv2_lv1_poke (u64 addr, u64 value);
s32 syscall_lv2_lv1_pokeq (u64 addr, u64 value);
s32 syscall_lv2_lv1_poke32 (u64 addr, u32 value);

u64 syscall_lv2_lv1_peek_356 (u64 addr);
s32 syscall_lv2_lv1_poke_356 (u64 addr, u64 value);

u64 syscall_lv1_hvcall1(u64 hvcall, u64 arg1);
u64 syscall_lv1_hvcall2(u64 hvcall, u64 arg1, u64 arg2);
u64 syscall_lv1_hvcall3(u64 hvcall, u64 arg1, u64 arg2, u64 arg3);
u64 syscall_lv1_hvcall4(u64 hvcall, u64 arg1, u64 arg2, u64 arg3, u64 arg4);
u64 syscall_lv1_hvcall5(u64 hvcall, u64 arg1, u64 arg2, u64 arg3, u64 arg4, u64 arg5);
u64 syscall_lv1_hvcall6(u64 hvcall, u64 arg1, u64 arg2, u64 arg3, u64 arg4, u64 arg5, u64 arg6);
u64 syscall_lv1_hvcall7(u64 hvcall, u64 arg1, u64 arg2, u64 arg3, u64 arg4, u64 arg5, u64 arg6, u64 arg7);

u64 syscall_lv1_set (s32 hvcall, u64 addr);

s32 syscall_lv2_memcpy (u64 dst_addr, u64 src_addr, u64 size);
s32 syscall_lv2_copy_from_user (u64 dst_addr, u64 size, u64 src_addr);
s32 syscall_lv2_copy_to_user (u64 dst_addr, u64 src_addr, u64 size);
s32 syscall_lv2_alloc_copy_from_user (u64 dst_addr, u64 size, u64 src_addr);

u64 syscall_lv2_alloc (u64 size);
s32 syscall_lv2_free (u64 addr);

s32 syscall_lv2_led(u8 p, u8 s);
s32 syscall_lv2_beep(u64 unknown1, u8 unknown2, u32 unknown3);
s32 syscall_lv2_ttywrite(s32 channel, const void *ptr, u32 len, u32 *written);

s32 syscall_lv2_get_target ( u64 *type );

s32 syscall_lv2_get_address_from_dabr(u64 *addr, u64 *flag);
s32 syscall_lv2_set_address_to_dabr(u64 addr, u64 flag);

s32 syscall_sm_get_params(u64 arg1, u64 arg2, u64 arg3, u64 arg4);

void syscall_trap (u64 addr);
void syscall_trap_now ();


#endif /* __PATCHUTIL_FIRMWARE_H__ */

