/*
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 */


#ifndef __PADUTIL_H__
#define __PADUTIL_H__


#include <ppu-types.h>

#include <sys/sem.h>
#include <sys/mutex.h>
#include <sys/cond.h>
#include <sys/rwlock.h>
#include <sys/thread.h>
#include <sys/event_queue.h>

#include "common.h"
#include "eventutil.h"


#define PADUTIL_EVENT_MENU 0xDEADBEEFULL

/* △  */
#define PADUTIL_TRIANGLE   1
/* ◯  */
#define PADUTIL_CIRCLE     2
/* ✕  */
#define PADUTIL_CROSS      3
/* ☐  */
#define PADUTIL_SQUARE     4
/* SELECT */
#define PADUTIL_SELECT     5
/* START */
#define PADUTIL_START      6
/* ▲  */ 
#define PADUTIL_UP         7
/* ▶  */ 
#define PADUTIL_RIGHT      8
/* ▼  */
#define PADUTIL_DOWN       9
/* ◀  */ 
#define PADUTIL_LEFT       10
/* BD Remote */
#define PADUTIL_BDCODE     11


typedef struct _pad_btn_data
{
  s32 btn;
  s32 now;
  s32 last;
  s32 *action;
  s32 *exitapp;

  eventData *e_data;

  sys_sem_t sem;
  sys_sem_attr_t sem_attr;

  sys_mutex_t mutex;
  sys_mutex_attr_t mutex_attr;

  sys_rwlock_t rwlock;
  sys_rwlock_attr_t rwlock_attr;

  sys_cond_t cond;
  sys_cond_attr_t cond_attr;

  sys_event_port_t *port;
  sys_event_queue_t *queue;

  sys_ppu_thread_t ppu_thread;
} padBtnData;


void padutilInitialization(eventData *e_data, u64 *priority);
void padutilFinish(padBtnData *pdata);

void padutilThread(eventData *e_data, u64 *priority);
void padutilWorker(void *arg);

s32 padutilCheck(padBtnData *pdata);
s32 padutilCheckState(padBtnData *pdata);

void padutilSendButton(padBtnData *pdata, s32 button);

s32 padutilExitappRead(eventData *e_data);
void padutilExitappWrite(eventData *e_data);

s32 padutilButtonRead(padBtnData *pdata);
void padutilButtonWrite(padBtnData *pdata, s32 value);


#endif /* __PADUTIL_H__ */

