/*
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 */


#ifndef __IMAGEUTIL_IMAGE_H__
#define __IMAGEUTIL_IMAGE_H__

#include <ppu-types.h>
#include <pngdec/pngdec.h>
#include <jpgdec/jpgdec.h>

#include "common.h"
#include "gcmutil.h"


#define MAX_BITMAPS      20

#define COLOR_TO_ARGB(alpha, red, green, blue) (((alpha) << 24) | ((red) << 16) | ((green) << 8) | (blue))
#define COLOR_TO_RGB(red, green, blue) (((red) << 16) | ((green) << 8) | (blue))

#define VALUE_TO_ARGB(value) (((value) << 24) | ((value) << 16) | ((value) << 8) | (value))
#define VALUE_TO_RGB(value) (((value) << 16) | ((value) << 8) | (value))

#define A(argb)  (((argb) >> 24) & 0xFF)
#define R(argb)  (((argb) >> 16) & 0xFF)
#define G(argb)  (((argb) >>  8) & 0xFF)
#define B(argb)  ( (argb)        & 0xFF)

typedef gcmBuffer imageBuffer;

/* bitmap */
typedef struct _image_bitmap
{
  u32 *buffer;
  u32 offset;

  u32 size;
  u32 width;
  u32 height;
  u32 pitch;
  u32 depth;
  void *ptr;
  pngData png;
  jpgData jpg;
} imageBitmap;

typedef struct _bitmap_data
{
  u8 num;
  GcmContextData *context;
  imageBitmap bitmap[MAX_BITMAPS];
} imageData;

/* image */
void imageutilInitialization(void *i_data);
void imageutilFinish(void *i_data);

void imageutilBufferClear(void *i_buf);

void imageutilLoadPngFromMemory(u8 index, void *buf, u32 size, void *i_data);
void imageutilLoadPngFromFile(u8 index, const char *filename, void *i_data);
void imageutilLoadJpgFromMemory(u8 index, void *buf, u32 size, void *i_data);
void imageutilLoadJpgFromFile(u8 index, const char *filename, void *i_data);
void imageutilGetImagePointer(u8 index, void **ptr, void *i_data);

void imageutilCopy(void *ctx, u32 src_offset, u32 src_pitch, u32 dst_offset, u32 dst_pitch, u32 size, u32 rows);

void imageutilDraw(u8 index, u8 blend, u8 from, u32 x, u32 y, void *ctx, void *i_data, void *i_buf);
void imageutilDrawScaled(u8 index, u8 blend, u8 from, u32 x, u32 y, float zoom, void *ctx, void *i_data, void *i_buf);


#endif /* __IMAGEUTIL_IMAGE_H__ */

