/*
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 */

#ifndef __GCMUTIL_GCM_H__
#define __GCMUTIL_GCM_H__


#include <sysutil/video.h>


extern struct GcmContextData *gGcmCurrentContext ATTRIBUTE_PRXPTR;


#define GCMUTIL_MAX_BUFFERS               ( 2 )

#define GCMUTIL_DEPTH_BUFFER_TILE_INDEX   ( 1 )

#define GCMUTIL_PIXEL_BUFFER_ID              ( 2 )
#define GCMUTIL_PIXEL_BUFFER_TILE_INDEX      ( 2 )

#define GCMUTIL_CB_SIZE                   ( 0x100000 )
#define GCMUTIL_HOST_SIZE                 (32*1024*1024)
#define GCMUTIL_DEPTH_VALUE               ( 0x00000000 )

#define GCMUTIL_VIDEO_PRIMARY             ( 0 )
#define GCMUTIL_VIDEO_DEVICE_INDEX        ( 0 )
#define GCMUTIL_VIDEO_RES_UNDEFINED       ( 0 )

#define GCMUTIL_GCM_LABEL_INDEX           ( 255 )

#define GCMUTIL_CHROMAKEY                 ( 0x00ffffff )
#define GCMUTIL_COMPRESSION                  ( GCM_COMPMODE_DISABLED )
//#define GCMUTIL_COMPRESSION                  ( GCM_COMPMODE_C32_2X1 ) 
//#define GCMUTIL_COMPRESSION                  ( GCM_COMPMODE_C32_2X2 ) 

#define GCMUTIL_MEMORY_SIZE               ( 0x10000000 )             /* 256MB */
#define GCMUTIL_PARTITION_SIZE            ( GCM_MEMORY_SIZE / 2 )    /* 128MB */
#define GCMUTIL_BANK_SIZE                 ( GCM_PARTITION_SIZE / 8 ) /* 16MB */
#define GCMUTIL_PAGE_SIZE                 ( GCM_BANK_SIZE / 4096 )   /* 4KB */

#define ALIGN(alignment,value)            ( alignment == 0 ? value : ( value == 0 ? 0 : ( ( (u32) ( ( value - 1 ) / alignment ) + 1 ) * alignment ) ) )
#define ROUNDUP(alignment,value)          ( ( ( value ) + ( ( alignment ) - 1 ) ) & ( ~ ( ( alignment ) - 1 ) ) )
#define ALIGN32B(value)                   ALIGN(GCM_TILE_LOCAL_ALIGN_HEIGHT, value)
#define ALIGN64B(value)                   ALIGN(GCM_SURFACE_LINEAR_ALIGN_OFFSET, value)
#define ALIGN256B(value)                  ALIGN(GCM_TILE_ALIGN_PITCH, value)
#define ALIGN64K(value)                   ALIGN(GCM_TILE_ALIGN_OFFSET, value)
#define ROUND32B(value)                   ROUNDUP(GCM_TILE_LOCAL_ALIGN_HEIGHT, value)
#define ROUND64B(value)                   ROUNDUP(GCM_SURFACE_LINEAR_ALIGN_OFFSET, value)
#define ROUND256B(value)                  ROUNDUP(GCM_TILE_ALIGN_PITCH, value)
#define ROUND64K(value)                   ROUNDUP(GCM_TILE_ALIGN_OFFSET, value)

#define PIXEL_DEPTH()                     (u32)sizeof( u32 )
#define TILED_PITCH(width)                gcmGetTiledPitchSize( width * PIXEL_DEPTH() )
#define TILED_HEIGHT(height)              ROUND32B( height )
#define TILED_SIZE(height,pitch)          ALIGN64K( TILED_HEIGHT( height ) * pitch )
#define TILED_BASE(size)                  ( size / 0x10000 )
#define TILED_MEMALIGN(size)              gcmutilMemalign( GCM_TILE_ALIGN_OFFSET, size )

#define GCMUTIL_COLOR_NONE                   -1
#define GCMUTIL_COLOR_BLACK                  0xff000000
#define GCMUTIL_COLOR_GREY                   0xff444444
#define GCMUTIL_COLOR_WHITE                  0xffffffff

#define GCMUTIL_COLOR_RED                    0xfffa001c
#define GCMUTIL_COLOR_ORANGE                 0xfffa8500
#define GCMUTIL_COLOR_YELLOW                 0xfffae900
#define GCMUTIL_COLOR_GREEN                  0xff3fd711
#define GCMUTIL_COLOR_BLUE                   0xff1775ca

#define GCMUTIL_COLOR_CLEAR                  GCMUTIL_COLOR_BLACK


typedef struct GcmSurface
{
  u8    type;
  u8    antialias;

  u8    colorFormat;
  u8    colorTarget;
  u8    colorLocation[4];
  u32   colorOffset[4];
  u32   colorPitch[4];

  u8    depthFormat;
  u8    depthLocation;
  u8    _padding[2];
  u32   depthOffset;
  u32   depthPitch;

  u16   width;
  u16   height;
  u16   x;
  u16   y;
} GcmSurface;

typedef struct GcmTexture
{
  u8    format;
  u8    mipmap;
  u8    dimension;
  u8    cubemap;

  u32   remap;

  u16   width;
  u16   height;
  u16   depth;
  u8    location;
  u8    _padding;

  u32   pitch;
  u32   offset;
} GcmTexture;

//struct GcmContextData;
//typedef s32 (*GcmContextCallback)(struct GcmContextData *, u32);

typedef struct GcmContextData
{
  u32   *__restrict begin ATTRIBUTE_PRXPTR;
  u32   *__restrict end ATTRIBUTE_PRXPTR;
  u32   *__restrict current ATTRIBUTE_PRXPTR;
  void *callback ATTRIBUTE_PRXPTR;
} GcmContextData;

typedef struct GcmTransferScale
{
  u32   conversion;
  u32   format;
  u32   operation;
  s16   clipX;
  s16   clipY;
  u16   clipW;
  u16   clipH;
  s16   outX;
  s16   outY;
  u16   outW;
  u16   outH;
  s32   ratioX;
  s32   ratioY;

  u16   inW;
  u16   inH;
  u16   pitch;
  u8    origin;
  u8    interp;
  u32   offset;
  u16   inX;
  u16   inY;
} GcmTransferScale;

typedef struct GcmTransferSurface
{
  u32   format;
  u16   pitch;
  u16   _padding;
  u32   offset;
} GcmTransferSurface;

typedef struct GcmTileInfo
{
  u32   tile;
  u32   limit;
  u32   pitch;
  u32   format;
} GcmTileInfo;

typedef struct GcmDisplayInfo
{
  u32   offset;
  u32   pitch;
  u32   width;
  u32   height;
} GcmDisplayInfo;

/* texture */
typedef struct _gcm_texture
{
  u32 *buffer;
  u32 offset;

  u32 size;
  u32 width;
  u32 height;
  u32 pitch;
  u32 depth;
  void *ptr;
  GcmTexture texture;
} gcmTexture;

/* buffer */
typedef struct _gcm_buffer
{
  s32 id;
  s32 tile_index;
  u16 width;
  u16 height;
  u16 tiled_height;
  u16 base;
  u32 bank;
  u32 length;
  u32 chromakey;
  u32 *ptr;

  /* */
  u32 offset;
  u32 depth;
  u32 pitch;
  s32 size;
} gcmBuffer;

typedef gcmBuffer pixelBuffer;
typedef gcmBuffer colorBuffer;
typedef gcmBuffer depthBuffer;

typedef struct _gcm_buffers
{
  u16 width;
  u16 height;
  u32 depth;
  u16 color_current_buffer;

  pixelBuffer pixel_buffer;
  colorBuffer color_buffer[GCMUTIL_MAX_BUFFERS];
  depthBuffer color_depth_buffer;

  GcmSurface pixel_surface;
  GcmSurface color_surface[GCMUTIL_MAX_BUFFERS];
  GcmSurface color_surfaces;
} gcmBuffers;

/* data */
typedef struct _gcm_data
{
  GcmContextData *context;
  GcmSurface *gcm_surface;
  videoState video_state;
  videoConfiguration video_config;
  videoDeviceInfo video_device_info;
  videoResolution video_resolution;

  void *gcm_host_addr;

  u16 gcm_width;
  u16 gcm_height;
  u32 gcm_pitch;
  u32 gcm_chromakey;

  u16 *color_current_buffer;
  u16 color_buffers_num;
  gcmBuffers gcm_buffers;
} gcmData;

/* initialize gcm */
void gcmutilInitialization(void *gcmdata);

/* memory */
s32 gcmutilMakeBuffer(u32 align, gcmBuffer *gcm_buffer);
s32 gcmutilMakeTiledBuffer(u8 id, gcmBuffer *gcm_buffer);
void* gcmutilMemalign(u32 alignment, u32 size);
s32 gcmutilAddressToOffset(void *gcm_ptr, u32 *gcm_off);
s32 gcmutilTileMemory(u8 index, u32 offset, u32 size, u32 pitch,u16 base, u32 bank);
void gcmutilClearBuffer(void *gcmbuffer);

/* surface functions */
void gcmutilInitSurface(void *gcmcontext, void *gcmsurface, void *gcmbuffer);
void gcmutilInitSurfaceMRT(void *gcmcontext, void *gcmsurface, void *gcmbuffers);
void gcmutilSetSurface(void *gcmcontext, void *gcmsurface);
void gcmutilClearSurface(void *gcmcontext, u32 color);

/* Sets the target buffer to render to */
void gcmutilSetRenderTarget(void *gcmcontext, void *gcmsurface);

void gcmutilBlend(void *gcmcontext);
void gcmutilBufferDraw(void *gcmcontext, void *pixelbuffer, void *colorbuffer);
void gcmutilBufferDrawScale(void *gcmcontext, void *pixelbuffer, void *colorbuffer);

/* Block the PPU thread untill the previous flip operation has finished. */
void gcmutilWaitFlip();
/* Flip a buffer onto the screen. Returns TRUE on success */
int gcmutilFlip(void *gcmcontext, void *gcmdata);

void gcmutilWaitIdle(void *gcmcontext);

void gcmutilFree(u32 *gcm_ptr);

/* finish gcm */
void gcmutilFinish(void *gcmdata);


/* lazy psl1ght maintainers left this function out */
extern s32 videoGetResolutionAvailability(u32 videoOut, u32 resolutionId, u32 aspect, u32 option);


#endif /* __GCMUTIL_GCM_H__ */

