/*
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 */

#ifndef __EVENTUTIL_H__
#define __EVENTUTIL_H__

#include <sys/sem.h>
#include <sys/mutex.h>
#include <sys/rwlock.h>
#include <sys/cond.h>
#include <sys/event_queue.h>

#include "common.h"


typedef struct _event_data
{
  s32 exitapp;
  s32 xmbopen;
  s32 menu;

  u64 key;

  sys_sem_t sem;
  sys_sem_attr_t sem_attr;

  sys_mutex_t mutex;
  sys_mutex_attr_t mutex_attr;

  sys_rwlock_t rwlock;
  sys_rwlock_attr_t rwlock_attr;

  sys_cond_t cond;
  sys_cond_attr_t cond_attr;

  sys_event_t pad_event;
  sys_event_queue_t pad_queue;
  sys_event_queue_attr_t pad_queue_attr;
  sys_event_port_t pad_port;

  sys_event_t vid_event;
  sys_event_queue_t vid_queue;
  sys_event_queue_attr_t vid_queue_attr;
  sys_event_port_t vid_port;

  sys_event_t mnu_event;
  sys_event_queue_t mnu_queue;
  sys_event_queue_attr_t mnu_queue_attr;
  sys_event_port_t mnu_port;

  sys_event_t dmp_event;
  sys_event_queue_t dmp_queue;
  sys_event_queue_attr_t dmp_queue_attr;
  sys_event_port_t dmp_port;

  sys_event_t img_event;
  sys_event_queue_t img_queue;
  sys_event_queue_attr_t img_queue_attr;
  sys_event_port_t img_port;
} eventData;


void eventutilInitialization(eventData *e_data);
void eventutilHandler(u64 status, u64 param, void *userdata);
void eventutilSignalPorts(eventData *e_data);
void eventutilFinish(eventData *e_data);

s32 eventutilCheckCallback();

s32 eventutilCreateEventQueue(sys_event_queue_t *queue, sys_event_queue_attr_t *attr, u64 key, s32 size);
s32 eventutilDestroyEventQueue(sys_event_queue_t *queue, s32 mode);
s32 eventutilReceiveEventQueue(sys_event_queue_t *queue, sys_event_t *event, u64 timeout);
s32 eventutilTryReceiveEventQueue(sys_event_queue_t *queue, sys_event_t *event, s32 size, s32 *number);
s32 eventutilDrainEventQueue(sys_event_queue_t *queue);

s32 eventutilCreatePort(sys_event_port_t *port, s32 type, u64 name);
s32 eventutilDestroyPort(sys_event_port_t *port);
s32 eventutilSendPort(sys_event_port_t *port, u64 data0, u64 data1, u64 data2);
s32 eventutilConnectLocalPort(sys_event_port_t *port, sys_event_queue_t *queue);
s32 eventutilDisconnectPort(sys_event_port_t *port);


#endif /* __EVENTUTIL_H__ */

