/*
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 */


#ifndef __AIOUTIL_H__
#define __AIOUTIL_H__


/*
 * includes
 */
#include "common.h"
#include "debug.h"

#include <sys/file.h>
#include <sys/sem.h>
#include <sys/mutex.h>
#include <sys/rwlock.h>
#include <sys/cond.h>


/*
 * defines
 */


/*
 * structs
 */

typedef struct _aio_data
{
  u8 buffered ;
  s32 id ;
  s32 fd ;
  s32 flags ;
  char *path ;
  char *filename ;
  void *buf ;
  u64 bufsize ;
  sysFSAio aio;

  sys_sem_t sem;
  sys_sem_attr_t sem_attr;

  sys_lwmutex_t lwmutex;
  sys_lwmutex_attr_t lwmutex_attr;

  sys_lwcond_t lwcond;
  sys_lwcond_attr_t lwcond_attr;

  sys_rwlock_t rwlock;
  sys_rwlock_attr_t rwlock_attr;
} aioData ;

/*
 * functions
 */

s32 aioutilInitialize(aioData *adata, char *path);
s32 aioutilFinish(aioData *adata);
s32 aioutilOpen(aioData *adata);
s32 aioutilRead(aioData *adata);
s32 aioutilWrite(aioData *adata);
s32 aioutilClose(aioData *adata);

void aioutilReadCallback(sysFSAio *aio, s32 error, s32 id, u64 size);
void aioutilWriteCallback(sysFSAio *aio, s32 error, s32 id, u64 size);

#endif /* __AIOUTIL_H__ */

