/*
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 */

#ifndef __MENU_H__
#define __MENU_H__


/*
 * includes
 */

#include <ppu-types.h>

#include <sys/sem.h>
#include <sys/mutex.h>
#include <sys/cond.h>
#include <sys/rwlock.h>
#include <sys/event_queue.h>
#include <sys/thread.h>

#include "common.h"
#include "debug.h"

#include "syncutil.h"
#include "eventutil.h"
#include "aioutil.h"
#include "patchutil.h"
#include "videoutil.h"
#include "imageutil.h"
#include "tilesetutil.h"

#include "digits.h"
#include "buttons.h"
#include "dumping.h"

//#define PS3D 1

#ifdef PS3D
#include "image_board_black_1280_720_png.h"           /* PNG bitmap in memory */
#endif

#ifndef PS3D
#include "image_board_brown_1280_720_png.h"           /* PNG bitmap in memory */
#include "image_board_red_1280_720_png.h"             /* PNG bitmap in memory */
#include "image_board_green_1280_720_png.h"           /* PNG bitmap in memory */
#include "image_board_blue_1280_720_png.h"            /* PNG bitmap in memory */
#endif

#include "image_main_1024_512_png.h"         /* PNG bitmap in memory */
#include "image_help_1024_512_png.h"         /* PNG bitmap in memory */
#include "image_about_1024_512_png.h"        /* PNG bitmap in memory */
#include "image_dump_1024_512_png.h"         /* PNG bitmap in memory */

#include "image_page_1024_1_png.h"           /* PNG bitmap in memory */
#include "image_page_1024_16_png.h"          /* PNG bitmap in memory */


/*
 * defines
 */

#define MENU_EXIT            -1

#define MAX_FONTS            3
#define LINE_INDENT          64
#define LINE_SIZE            38

#ifdef PS3D
#define IMAGE_FRAME_BLACK    1
#endif

#ifndef PS3D
#define IMAGE_FRAME_BROWN    1
#define IMAGE_FRAME_RED      2
#define IMAGE_FRAME_GREEN    3
#define IMAGE_FRAME_BLUE     4
#endif

#define IMAGE_MAIN           5
#define IMAGE_HELP           6
#define IMAGE_ABOUT          7
#define IMAGE_DUMP           8
#define IMAGE_PAGE           9

#define IMAGE_PAGE1          11
#define IMAGE_PAGE2          12
#define IMAGE_PAGE3          13
#define IMAGE_PAGE4          14

#define MENU_MAIN            1
#define MENU_HELP            2
#define MENU_ABOUT           3
#define MENU_DUMP            4
#define MENU_DONE            5

/* △  */
#define MENU_TRIANGLE        1
/* ◯  */
#define MENU_CIRCLE          2
/* ✕  */
#define MENU_CROSS           3
/* ☐  */
#define MENU_SQUARE          4
/* SELECT */
#define MENU_SELECT          5
/* START */
#define MENU_START           6
/* ▲  */
#define MENU_UP              7
/* ▶  */
#define MENU_RIGHT           8
/* ▼  */
#define MENU_DOWN            9
/* ◀  */
#define MENU_LEFT            10
/* BD Remote */
#define MENU_BDCODE          11


/*
 * globals
 */

extern fwVersions fw_data ;
extern u32 log_fd ;
extern char string[MAX_STRING] ;


/*
 * structs
 */

typedef struct _menu_data
{
  s32 *exitapp;
  s32 *menu;
  s32 *update;
  s32 *action;
  s32 *focus;

  s32 *indent;
  s32 *line;
  char *string;

  char *sevenseg;
  s32 buttons;

  eventData *e_data;
  videoutilData *vu_data;
  dumpData *dump_data;
  aioData *aio_data;

  digitsData *digits_data;
  buttonsData *buttons_data;

  digitsBuffer *digits_buffer;
  buttonsBuffer *buttons_buffer;

  sys_sem_t sem;
  sys_sem_attr_t sem_attr;

  sys_mutex_t mutex;
  sys_mutex_attr_t mutex_attr;

  sys_rwlock_t rwlock;
  sys_rwlock_attr_t rwlock_attr;

  sys_cond_t cond;
  sys_cond_attr_t cond_attr;

  u64 key;

  sys_event_t *pad_event;
  sys_event_queue_t *pad_queue;
  sys_event_queue_attr_t *pad_queue_attr;
  sys_event_port_t *pad_port;

  sys_event_t *vid_event;
  sys_event_queue_t *vid_queue;
  sys_event_queue_attr_t *vid_queue_attr;
  sys_event_port_t *vid_port;

  sys_event_t *mnu_event;
  sys_event_queue_t *mnu_queue;
  sys_event_queue_attr_t *mnu_queue_attr;
  sys_event_port_t *mnu_port;

  sys_event_t *dmp_event;
  sys_event_queue_t *dmp_queue;
  sys_event_queue_attr_t *dmp_queue_attr;
  sys_event_port_t *dmp_port;

  sys_ppu_thread_t ppu_thread;
} menuData;


/*
 * functions
 */

/* menu.c */
void menuInitialization(menuData *m_data, eventData *e_data, dumpData *d_data, videoutilData *vu_data, u64 *priority);
void menuFinish(menuData *m_data);

void menuThread(menuData *m_data, u64 *priority);
void menuWorker(void *arg);

/* menuCheck.c */
void menuCheckUpdate(menuData *m_data);
  
void menuCheckInput(menuData *m_data);
void menuCheckVideo(menuData *m_data);
  
s32 menuCheckMain(menuData *m_data);
s32 menuCheckHelp(menuData *m_data);
s32 menuCheckAbout(menuData *m_data);
s32 menuCheckDumping(menuData *m_data);

/* menuDraw.c */
void menuDraw(menuData *m_data);
void menuDrawBackground( menuData *m_data);
void menuDrawMain( menuData *m_data);
void menuDrawHelp( menuData *m_data);
void menuDrawAbout( menuData *m_data);
void menuDrawDumping( menuData *m_data);
  
void menuDrawClearBuffer(menuData *m_data, videoutilData *vu_data);

void menuDrawImages(menuData *m_data, videoutilData *vu_data);
void menuDrawDipswitch(menuData *m_data, videoutilData *vu_data);
void menuDrawSevenSegment(menuData *m_data, videoutilData *vu_data);
void menuDrawButtons(menuData *m_data, videoutilData *vu_data);
void menuDrawMemoryLeds(menuData *m_data, videoutilData *vu_data);
void menuDrawIoLeds(menuData *m_data, videoutilData *vu_data);
void menuDrawProgressLeds(menuData *m_data, videoutilData *vu_data);

void menuDrawImageBackground(menuData *m_data, videoutilData *vu_data);
void menuDrawImageMainBuffer(menuData *m_data, videoutilData *vu_data);
void menuDrawImageHelpBuffer(menuData *m_data, videoutilData *vu_data);
void menuDrawImageAboutBuffer(menuData *m_data, videoutilData *vu_data);
void menuDrawImageDumpBuffer(menuData *m_data, videoutilData *vu_data);

void menuUpdateImages(menuData *m_data, videoutilData *vu_data);
void menuUpdateDipswitch(menuData *m_data, videoutilData *vu_data);
void menuUpdateSevenSegment(menuData *m_data, videoutilData *vu_data);
void menuUpdateButtons(menuData *m_data, videoutilData *vu_data);
void menuUpdateMemoryLeds(menuData *m_data, videoutilData *vu_data);
void menuUpdateIoLeds(menuData *m_data, videoutilData *vu_data);
void menuUpdateProgressLeds(menuData *m_data, videoutilData *vu_data);

void menuUpdateDumpBufferImages(menuData *m_data, videoutilData *vu_data);

void menuDrawButtonTriangle(menuData *m_data, videoutilData *vu_data);
void menuDrawButtonCircle(menuData *m_data, videoutilData *vu_data);
void menuDrawButtonCross(menuData *m_data, videoutilData *vu_data);
void menuDrawButtonSquare(menuData *m_data, videoutilData *vu_data);

void menuDrawDigit1(u8 number, u8 state, menuData *m_data, videoutilData *vu_data);
void menuDrawDigit2(u8 number, u8 state, menuData *m_data, videoutilData *vu_data);
void menuDrawDigit3(u8 number, u8 state, menuData *m_data, videoutilData *vu_data);
void menuDrawDigit4(u8 number, u8 state, menuData *m_data, videoutilData *vu_data);

void menuDrawDip0(menuData *m_data, videoutilData *vu_data);
void menuDrawDip1(menuData *m_data, videoutilData *vu_data);
void menuDrawDip2(menuData *m_data, videoutilData *vu_data);
void menuDrawDip3(menuData *m_data, videoutilData *vu_data);

void menuDrawMemLeds0(menuData *m_data, videoutilData *vu_data);
void menuDrawMemLeds1(menuData *m_data, videoutilData *vu_data);
void menuDrawMemLeds2(menuData *m_data, videoutilData *vu_data);
void menuDrawMemLeds3(menuData *m_data, videoutilData *vu_data);

void menuDrawIoLeds0(menuData *m_data, videoutilData *vu_data);
void menuDrawIoLeds1(menuData *m_data, videoutilData *vu_data);
void menuDrawIoLeds2(menuData *m_data, videoutilData *vu_data);
void menuDrawIoLeds3(menuData *m_data, videoutilData *vu_data);

void menuDrawProgLeds0(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds3(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds6(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds9(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds10(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds13(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds16(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds19(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds20(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds23(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds26(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds29(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds30(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds33(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds36(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds39(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds40(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds43(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds46(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds49(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds50(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds53(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds56(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds59(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds60(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds63(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds66(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds69(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds70(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds73(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds76(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds79(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds80(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds83(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds86(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds89(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds90(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds93(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds96(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds99(menuData *m_data, videoutilData *vu_data);
void menuDrawProgLeds100(menuData *m_data, videoutilData *vu_data);

void menuDrawImage(u8 index, u8 from, s32 x, s32 y, menuData *m_data, videoutilData *vu_data);
void menuDrawButton(u8 object, u8 state, s32 x, s32 y, menuData *m_data, videoutilData *vu_data);
void menuDrawDigit(u8 object, u8 state, s32 x, s32 y, menuData *m_data, videoutilData *vu_data);
void menuDrawDip(u8 object, u8 state, s32 x, s32 y, menuData *m_data, videoutilData *vu_data);
void menuDrawLed(u8 object, u8 state, s32 x, s32 y, menuData *m_data, videoutilData *vu_data);

void menuDrawHeaderText(u8 idx, s32 *x, s32 *y, menuData *m_data, videoutilData *vu_data);
void menuDrawFirmwareVersion(u8 idx, s32 *x, s32 *y, menuData *m_data, videoutilData *vu_data);

/* menuReceive.c */
s32 menuReceivePadInput(menuData *m_data);
s32 menuReceivePadUpdate(menuData *m_data);

s32 menuReceiveVideoInput(menuData *m_data);
s32 menuReceiveVideoUpdate(menuData *m_data);

/* menuUpdate.c */
void menuUpdateImages(menuData *m_data, videoutilData *vu_data);
void menuUpdateDipswitch(menuData *m_data, videoutilData *vu_data);
void menuUpdateSevenSegment(menuData *m_data, videoutilData *vu_data);
void menuUpdateButtons(menuData *m_data, videoutilData *vu_data);
void menuUpdateMemoryLeds(menuData *m_data, videoutilData *vu_data);
void menuUpdateIoLeds(menuData *m_data, videoutilData *vu_data);
void menuUpdateProgressLeds(menuData *m_data, videoutilData *vu_data);

void menuUpdateDumpBufferImages(menuData *m_data, videoutilData *vu_data);

/* menuUtils.c */
void menuLoadImages(menuData *m_data, videoutilData *vu_data);
void menuUnloadImages(menuData *m_data, videoutilData *vu_data);

void menuLoadTilesets(menuData *m_data, videoutilData *vu_data);
void menuUnloadTilesets(menuData *m_data, videoutilData *vu_data);

void menuGetBufferImagePointer(menuData *m_data, videoutilData *vu_data);
void menuGetPageImagePointer(menuData *m_data, videoutilData *vu_data);

s32 menuReadMenu(menuData *m_data);
void menuWriteMenu(s32 menu, menuData *m_data);
void menuWriteMenuIncrement(menuData *m_data);
void menuWriteMenuDecrement(menuData *m_data);

void menuWriteAction(s32 action, menuData *m_data);
void menuWriteFocus(s32 focus, menuData *m_data);

s32 menuReadExitapp(eventData *e_data);
void menuWriteExitapp(eventData *e_data);

void menuSendDump(menuData *m_data, s32 dump);

u32 menuGetRandomSeed();
u8 menuGetRandom(u8 size);


#endif /* __MENU_H__ */

