/*
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 */

#ifndef __TILESET_LEDS_H__
#define __TILESET_LEDS_H__


#include <ppu-types.h>

#include "common.h"
#include "tilesetutil.h"

#include "tileset_leds_png.h"          /* PNG bitmap */


#define LED_OBJECTS       5
#define LED_STATES        4

#define LED_WIDTH         14
#define LED_HEIGHT        11

#define LED_NONE          0
#define LED_LV1           1
#define LED_LV2           2
#define LED_MMIO          3

#define LED_LV1_X         94
#define LED_LV1_Y         514
#define LED_LV2_X         94
#define LED_LV2_Y         581
#define LED_MMIO_X        94
#define LED_MMIO_Y        447

#define LED_MEM           1
#define LED_FLASH         2
#define LED_DISK          3

#define LED_MEM_X         251
#define LED_MEM_Y         667
#define LED_FLASH_X       385
#define LED_FLASH_Y       667
#define LED_DISK_X        519
#define LED_DISK_Y        667

#define LED_PROG0         0
#define LED_PROG3         3
#define LED_PROG6         6
#define LED_PROG9         9
#define LED_PROG10        10
#define LED_PROG13        13
#define LED_PROG16        16
#define LED_PROG19        19
#define LED_PROG20        20
#define LED_PROG23        23
#define LED_PROG26        26
#define LED_PROG29        29
#define LED_PROG30        30
#define LED_PROG33        33
#define LED_PROG36        36
#define LED_PROG39        39
#define LED_PROG40        40
#define LED_PROG43        43
#define LED_PROG46        46
#define LED_PROG49        49
#define LED_PROG50        50
#define LED_PROG53        53
#define LED_PROG56        56
#define LED_PROG59        59
#define LED_PROG60        60
#define LED_PROG63        63
#define LED_PROG66        66
#define LED_PROG69        69
#define LED_PROG70        70
#define LED_PROG73        73
#define LED_PROG76        76
#define LED_PROG79        79
#define LED_PROG80        80
#define LED_PROG83        83
#define LED_PROG86        86
#define LED_PROG89        89
#define LED_PROG90        90
#define LED_PROG93        93
#define LED_PROG96        96
#define LED_PROG99        99
#define LED_PROG100       100

#define LED_PROG10_X      1172
#define LED_PROG10_Y      611
#define LED_PROG20_X      1172
#define LED_PROG20_Y      582
#define LED_PROG30_X      1172
#define LED_PROG30_Y      553
#define LED_PROG40_X      1172
#define LED_PROG40_Y      524
#define LED_PROG50_X      1172
#define LED_PROG50_Y      495
#define LED_PROG60_X      1172
#define LED_PROG60_Y      466
#define LED_PROG70_X      1172
#define LED_PROG70_Y      437
#define LED_PROG80_X      1172
#define LED_PROG80_Y      408
#define LED_PROG90_X      1172
#define LED_PROG90_Y      379
#define LED_PROG100_X     1172
#define LED_PROG100_Y     350

#define LED_RED           0
#define LED_ORANGE        1
#define LED_YELLOW        2
#define LED_GREEN         3
#define LED_BLUE          4

#define LED_OFF           0
#define LED_LOW           1
#define LED_MED           2
#define LED_HIGH          3


typedef tilesetData ledsData;
typedef tilesetBuffer ledsBuffer;
typedef tileBitmapData ledBitmapData;


/* leds */
void ledsInitialization(void *d_data);
void ledsDataInitialization(void *d_data);
void ledsFinish(void *d_data);
void ledsBufferClear(void *d_data);
void ledsLoadTileset(void *mem, u32 size, void *d_data);
void ledsLoadTiles(void *d_data);
void ledDraw(u8 idx, u8 state, u8 from, s32 x, s32 y, void *vu_data);


#endif /* __TILESET_LEDS_H__ */

