/*
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 */

#ifndef __IMAGES_H__
#define __IMAGES_H__


/*
 * includes
 */

#include <ppu-types.h>

#include <sys/sem.h>
#include <sys/mutex.h>
#include <sys/cond.h>
#include <sys/rwlock.h>
#include <sys/event_queue.h>
#include <sys/thread.h>

#include "common.h"
#include "debug.h"

#include "syncutil.h"
#include "eventutil.h"
#include "videoutil.h"
#include "imageutil.h"
#include "tilesetutil.h"

#include "dumping.h"

//#include "buttons.h"
//#include "digits.h"
#include "dipswitch.h"
#include "leds.h"


/*
 * defines
 */

#define IMAGE_EXIT           -1

#define IMAGE_UPDATE         0
#define IMAGE_UPDATE_MAIN    1
#define IMAGE_UPDATE_HELP    2
#define IMAGE_UPDATE_ABOUT   3
#define IMAGE_UPDATE_DUMP    4
#define IMAGE_UPDATE_MEMLED  5
#define IMAGE_UPDATE_IOLED   6
#define IMAGE_UPDATE_PROGLED 7

#define IMAGE_FRAME_BROWN    1
#define IMAGE_FRAME_RED      2
#define IMAGE_FRAME_GREEN    3
#define IMAGE_FRAME_BLUE     4

#define IMAGE_MAIN           5
#define IMAGE_HELP           6
#define IMAGE_ABOUT          7
#define IMAGE_DUMP           8
#define IMAGE_PAGE           9

#define IMAGE_PAGE1          11
#define IMAGE_PAGE2          12
#define IMAGE_PAGE3          13
#define IMAGE_PAGE4          14


/*
 * globals
 */

extern fwVersions fw_data ;
extern u32 log_fd ;
extern char string[MAX_STRING] ;


/*
 * structs
 */

typedef struct _images_data
{
  s32 *exitapp;
  s32 *update;

  //char *sevenseg;
  //s32 buttons;
  s32 dipswitch;
  s32 memleds;
  s32 ioleds;
  s32 progleds;

  eventData *e_data;
  videoutilData *vu_data;
  dumpData *dump_data;

  //digitsData *digits_data;
  //buttonsData *buttons_data;
  dipswitchData *dipswitch_data;
  ledsData *leds_data;

  //digitsBuffer *digits_buffer;
  //buttonsBuffer *buttons_buffer;
  dipswitchBuffer *dipswitch_buffer;
  ledsBuffer *leds_buffer;

  sys_sem_t sem;
  sys_sem_attr_t sem_attr;

  sys_mutex_t mutex;
  sys_mutex_attr_t mutex_attr;

  sys_rwlock_t rwlock;
  sys_rwlock_attr_t rwlock_attr;

  sys_cond_t cond;
  sys_cond_attr_t cond_attr;

  u64 key;

  sys_event_t *vid_event;
  sys_event_queue_t *vid_queue;
  sys_event_queue_attr_t *vid_queue_attr;
  sys_event_port_t *vid_port;

  sys_event_t *img_event;
  sys_event_queue_t *img_queue;
  sys_event_queue_attr_t *img_queue_attr;
  sys_event_port_t *img_port;

  sys_ppu_thread_t ppu_thread;
} imagesData;


/*
 * functions
 */

/* images.c */
void imagesInitialization(imagesData *m_data, eventData *e_data, dumpData *d_data, videoutilData *vu_data, u64 *priority);
void imagesFinish(imagesData *m_data);

void imagesThread(imagesData *m_data, u64 *priority);
void imagesWorker(void *arg);

/* imagesCheck.c */
void imagesCheckUpdate(imagesData *m_data);
  
/* imagesDraw.c */
void imagesDraw(imagesData *m_data, videoutilData *vu_data);
  
void imagesDrawDipswitch(imagesData *m_data, videoutilData *vu_data);
void imagesDrawMemoryLeds(imagesData *m_data, videoutilData *vu_data);
void imagesDrawIoLeds(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgressLeds(imagesData *m_data, videoutilData *vu_data);

void imagesDrawImageBackground(imagesData *m_data, videoutilData *vu_data);
void imagesDrawImageMainBuffer(imagesData *m_data, videoutilData *vu_data);
void imagesDrawImageHelpBuffer(imagesData *m_data, videoutilData *vu_data);
void imagesDrawImageAboutBuffer(imagesData *m_data, videoutilData *vu_data);
void imagesDrawImageDumpBuffer(imagesData *m_data, videoutilData *vu_data);

void imagesUpdateImages(imagesData *m_data, videoutilData *vu_data);
void imagesUpdateDipswitch(imagesData *m_data, videoutilData *vu_data);
void imagesUpdateMemoryLeds(imagesData *m_data, videoutilData *vu_data);
void imagesUpdateIoLeds(imagesData *m_data, videoutilData *vu_data);
void imagesUpdateProgressLeds(imagesData *m_data, videoutilData *vu_data);

void imagesUpdateDumpBufferImages(imagesData *m_data, videoutilData *vu_data);

void imagesDrawDip0(imagesData *m_data, videoutilData *vu_data);
void imagesDrawDip1(imagesData *m_data, videoutilData *vu_data);
void imagesDrawDip2(imagesData *m_data, videoutilData *vu_data);
void imagesDrawDip3(imagesData *m_data, videoutilData *vu_data);

void imagesDrawMemLeds0(imagesData *m_data, videoutilData *vu_data);
void imagesDrawMemLeds1(imagesData *m_data, videoutilData *vu_data);
void imagesDrawMemLeds2(imagesData *m_data, videoutilData *vu_data);
void imagesDrawMemLeds3(imagesData *m_data, videoutilData *vu_data);

void imagesDrawIoLeds0(imagesData *m_data, videoutilData *vu_data);
void imagesDrawIoLeds1(imagesData *m_data, videoutilData *vu_data);
void imagesDrawIoLeds2(imagesData *m_data, videoutilData *vu_data);
void imagesDrawIoLeds3(imagesData *m_data, videoutilData *vu_data);

void imagesDrawProgLeds0(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds3(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds6(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds9(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds10(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds13(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds16(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds19(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds20(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds23(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds26(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds29(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds30(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds33(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds36(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds39(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds40(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds43(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds46(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds49(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds50(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds53(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds56(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds59(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds60(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds63(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds66(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds69(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds70(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds73(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds76(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds79(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds80(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds83(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds86(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds89(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds90(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds93(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds96(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds99(imagesData *m_data, videoutilData *vu_data);
void imagesDrawProgLeds100(imagesData *m_data, videoutilData *vu_data);

void imagesDrawImage(u8 index, u8 from, s32 x, s32 y, imagesData *m_data, videoutilData *vu_data);
void imagesDrawDip(u8 object, u8 state, s32 x, s32 y, imagesData *m_data, videoutilData *vu_data);
void imagesDrawLed(u8 object, u8 state, s32 x, s32 y, imagesData *m_data, videoutilData *vu_data);

/* imagesReceive.c */
s32 imagesReceiveVideoUpdate(imagesData *m_data);

/* imagesUpdate.c */
void imagesUpdateImages(imagesData *m_data, videoutilData *vu_data);
void imagesUpdateDipswitch(imagesData *m_data, videoutilData *vu_data);
void imagesUpdateSevenSegment(imagesData *m_data, videoutilData *vu_data);
void imagesUpdateButtons(imagesData *m_data, videoutilData *vu_data);
void imagesUpdateMemoryLeds(imagesData *m_data, videoutilData *vu_data);
void imagesUpdateIoLeds(imagesData *m_data, videoutilData *vu_data);
void imagesUpdateProgressLeds(imagesData *m_data, videoutilData *vu_data);

void imagesUpdateMainBufferImages(imagesData *m_data, videoutilData *vu_data);
void imagesUpdateHelpBufferImages(imagesData *m_data, videoutilData *vu_data);
void imagesUpdateAboutBufferImages(imagesData *m_data, videoutilData *vu_data);
void imagesUpdateDumpBufferImages(imagesData *m_data, videoutilData *vu_data);

/* imagesUtils.c */
void imagesLoadImages(imagesData *m_data, videoutilData *vu_data);
void imagesUnloadImages(imagesData *m_data, videoutilData *vu_data);

void imagesLoadTilesets(imagesData *m_data, videoutilData *vu_data);
void imagesUnloadTilesets(imagesData *m_data, videoutilData *vu_data);

void imagesGetBufferImagePointer(imagesData *m_data, videoutilData *vu_data);
void imagesGetPageImagePointer(imagesData *m_data, videoutilData *vu_data);

s32 imagesReadExitapp(eventData *e_data);
void imagesWriteExitapp(eventData *e_data);

u32 imagesGetRandomSeed();
u8 imagesGetRandom(u8 size);


#endif /* __IMAGES_H__ */

