/*
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 */

#ifndef __dumping_H__
#define __dumping_H__


/*
 * includes
 */

#include <stdio.h>
#include <unistd.h>
#include <time.h>
#include <inttypes.h>

#include <sys/sem.h>
#include <sys/mutex.h>
#include <sys/cond.h>
#include <sys/thread.h>           /* for threads */

#include "common.h"
#include "debug.h"
#include "eventutil.h"
#include "aioutil.h"
#include "videoutil.h"
#include "imageutil.h"


/*
 * defines
 */

#define IMAGE_UPDATE          0
#define IMAGE_UPDATE_MAIN     1
#define IMAGE_UPDATE_HELP     2
#define IMAGE_UPDATE_ABOUT    3
#define IMAGE_UPDATE_DUMP     4
#define IMAGE_UPDATE_MEMLED   5
#define IMAGE_UPDATE_IOLED    6
#define IMAGE_UPDATE_PROGLED  7

#define DUMP_EXIT             -1
#define DUMP_NONE             0
#define DUMP_LV1              1
#define DUMP_LV2              2
#define DUMP_FLASH            3
#define DUMP_eEID             4
#define DUMP_MMIO_NOR_FLASH   5
#define DUMP_IDPS             6

#define DUMP_DIP_NONE         0
#define DUMP_DIP_ONE          1
#define DUMP_DIP_TWO          2
#define DUMP_DIP_THREE        3

#define DUMP_LED_NONE         0
#define DUMP_LED_LV1          1
#define DUMP_LED_LV2          2
#define DUMP_LED_MMIO         3

#define DUMP_LED_MEM          1
#define DUMP_LED_FLASH        2
#define DUMP_LED_DISK         3

#define DUMP_LED_DONE         100


#define DUMP_SPU0_LS          10
#define DUMP_SPU1_LS          11
#define DUMP_SPU2_LS          12
#define DUMP_SPU3_LS          13
#define DUMP_SPU4_LS          14
#define DUMP_SPU5_LS          15
#define DUMP_SPU6_LS          16
#define DUMP_SPU7_LS          17

#define DUMP_SPU0_PS          20
#define DUMP_SPU1_PS          21
#define DUMP_SPU2_PS          22
#define DUMP_SPU3_PS          23
#define DUMP_SPU4_PS          24
#define DUMP_SPU5_PS          25
#define DUMP_SPU6_PS          26
#define DUMP_SPU7_PS          27

#define DUMP_SPU0_PRIV2       30
#define DUMP_SPU1_PRIV2       31
#define DUMP_SPU2_PRIV2       32
#define DUMP_SPU3_PRIV2       33
#define DUMP_SPU4_PRIV2       34
#define DUMP_SPU5_PRIV2       35
#define DUMP_SPU6_PRIV2       36
#define DUMP_SPU7_PRIV2       37

#define DUMP_SPU0_PRIV1       40
#define DUMP_SPU1_PRIV1       41
#define DUMP_SPU2_PRIV1       42
#define DUMP_SPU3_PRIV1       43
#define DUMP_SPU4_PRIV1       44
#define DUMP_SPU5_PRIV1       45
#define DUMP_SPU6_PRIV1       46
#define DUMP_SPU7_PRIV1       47

#define DUMP_PPE_PRIV         50

#define DUMP_BEI_IIC          60

#define DUMP_PRV_TLA          70
#define DUMP_PRV_PERFMON      71
#define DUMP_PRV_THERPWR      72
#define DUMP_PRV_RAS          73

#define DUMP_MIC_MICTOKENMGR  80

#define DUMP_BEI_IOTRANS      90
#define DUMP_BEI_BIC0NCLK     91
#define DUMP_BEI_BIC1NCLK     92
#define DUMP_BEI_EIB          93
#define DUMP_BEI_IOCMDS       94
#define DUMP_BEI_BIC0BCLK     95
#define DUMP_BEI_BIC1BCLK     96


/*
 * structs
 */

typedef struct _dump_data
{
  s32 row;
  s32 dump;
  s32 *action;
  s32 *exitapp;
  s32 *patched;
  s32 *dumped;

  s32 *dipswitch;
  s32 *memleds;
  s32 *ioleds;
  s32 *progleds;

  eventData *e_data;
  aioData *aio_data;
  videoutilData *vu_data;

  imageBitmap *page_bitmap_ptr[4];
  imageBitmap *buffer_bitmap_ptr;

  sys_sem_t sem;
  sys_sem_attr_t sem_attr;

  sys_mutex_t mutex;
  sys_mutex_attr_t mutex_attr;

  sys_rwlock_t rwlock;
  sys_rwlock_attr_t rwlock_attr;

  sys_cond_t cond;
  sys_cond_attr_t cond_attr;

  sys_event_t *mnu_event;
  sys_event_queue_t *mnu_queue;
  sys_event_queue_attr_t *mnu_queue_attr;
  sys_event_port_t *mnu_port;

  sys_event_t *dmp_event;
  sys_event_queue_t *dmp_queue;
  sys_event_queue_attr_t *dmp_queue_attr;
  sys_event_port_t *dmp_port;

  sys_event_t *img_event;
  sys_event_queue_t *img_queue;
  sys_event_queue_attr_t *img_queue_attr;
  sys_event_port_t *img_port;

  sys_ppu_thread_t ppu_thread;
} dumpData;


/*
 * functions
 */

void dumpingInitialization(dumpData *d_data, eventData *edata, videoutilData *vu_data, u64 *priority);
void dumpingFinish(dumpData *d_data);
void dumpingThread(dumpData *d_data, u64 *priority);
void dumpingWorker(void *arg);
s32 dumpShit( dumpData *d_data );

void dumpingCheckUpdate(dumpData *d_data);
s32 dumpingCheckDumpEvent(dumpData *d_data);
s32 dumpingReceiveDumpEvent(dumpData *d_data);
void dumpingWriteExitapp(eventData *e_data);

/* dumpingSend.c */
void dumpingSendMainUpdate(dumpData *d_data);
void dumpingSendHelpUpdate(dumpData *d_data);
void dumpingSendAboutUpdate(dumpData *d_data);
void dumpingSendDumpUpdate(dumpData *d_data);
void dumpingSendMemoryLed(s32 value, dumpData *d_data);
void dumpingSendIoLed(s32 value, dumpData *d_data);
void dumpingSendProgressLed(s32 value, dumpData *d_data);


#endif /* __dumping_H__ */

