/*
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 */


#ifndef __TILESET_DIPS_H__
#define __TILESET_DIPS_H__


#include <ppu-types.h>

#include "common.h"
#include "tilesetutil.h"

#include "tileset_dipswitch_png.h"          /* PNG bitmap */


#define DIP_OBJECTS       3
#define DIP_STATES        2

#define DIP_WIDTH         16
#define DIP_HEIGHT        8

#define DIP_SWITCH1_X     88
#define DIP_SWITCH1_Y     105
#define DIP_SWITCH2_X     88
#define DIP_SWITCH2_Y     114

#define DIP_NONE          0
#define DIP_ONE           1
#define DIP_TWO           2
#define DIP_THREE         3

#define DIP_OFF           0
#define DIP_ON            1


typedef tilesetData dipswitchData;
typedef tilesetBuffer dipswitchBuffer;
typedef tileBitmapData dipswitchBitmapData;


/* dips */
void dipswitchInitialization(void *d_data);
void dipswitchDataInitialization(void *d_data);
void dipswitchFinish(void *d_data);
void dipswitchBufferClear(void *d_data);
void dipswitchLoadTileset(void *mem, u32 size, void *d_data);
void dipswitchLoadTiles(void *d_data);
void dipDraw(u8 idx, u8 state, u8 from, s32 x, s32 y, void *vu_data);


#endif /* __TILESET_DIPS_H__ */

