/*
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 */


#ifndef __TILESET_DIGITS_H__
#define __TILESET_DIGITS_H__


#include <ppu-types.h>

#include "common.h"
#include "tilesetutil.h"

#include "tileset_digits_png.h"          /* PNG bitmap */


#define DIGIT_OBJECTS     10
#define DIGIT_STATES      3

#define DIGIT_WIDTH       40
#define DIGIT_HEIGHT      60

#define DIGIT_7SEG1_X     677
#define DIGIT_7SEG1_Y     55
#define DIGIT_7SEG2_X     734
#define DIGIT_7SEG2_Y     55
#define DIGIT_7SEG3_X     791
#define DIGIT_7SEG3_Y     55
#define DIGIT_7SEG4_X     848
#define DIGIT_7SEG4_Y     55

#define DIGIT_ZERO        0
#define DIGIT_ONE         1
#define DIGIT_TWO         2
#define DIGIT_THREE       3
#define DIGIT_FOUR        4
#define DIGIT_FIVE        5
#define DIGIT_SIX         6
#define DIGIT_SEVEN       7
#define DIGIT_EIGHT       8
#define DIGIT_NINE        9

#define DIGIT_OFF         0
#define DIGIT_NODOT       1
#define DIGIT_DOTON       2


typedef tilesetData digitsData;
typedef tilesetBuffer digitsBuffer;
typedef tileBitmapData digitBitmapData;


/* digits */
void digitsInitialization(void *d_data);
void digitsDataInitialization(void *d_data);
void digitsFinish(void *d_data);
void digitsBufferClear(void *d_data);
void digitsLoadTileset(void *mem, u32 size, void *d_data);
void digitsLoadTiles(void *d_data);
void digitDraw(u8 idx, u8 state, u8 from, s32 x, s32 y, void *vu_data);


#endif /* __TILESET_DIGITS_H__ */

