/*
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 */

#ifndef __MEMDUMP_DEBUG_H__
#define __MEMDUMP_DEBUG_H__


/*
 * 0 NONE
 * 1 file log printing
 * 2 tty printing and file log
 * 3 timing, tty printing, and file log
*/
#define DEBUG              2

#include "common.h"

#include <ppu_intrinsics.h>

#if DEBUG > 0
#include "patchutil.h"
#endif


#define ANSI_BLACK         30
#define ANSI_RED           31
#define ANSI_GREEN         32
#define ANSI_YELLOW        33
#define ANSI_BLUE          34
#define ANSI_MAGENTA       35
#define ANSI_CYAN          36
#define ANSI_WHITE         37

#if DEBUG > 0
#include "patchutil.h"
#endif

#if DEBUG > 0
#define logprintf(format,args...) if ( DEBUG > 0 ) { \
  fprintf( stdout, "\033[0;%dm%s:%s():#%d :: "format"\033[0m\n", ANSI_CYAN, __FILE__, __func__, __LINE__+1, args ) ; \
  sprintf ( string, "%s:%s():#%d :: "format"\n", __FILE__, __func__, __LINE__+1, args ) ; \
  write_log ( string, &log_fd ) ; \
} 
#else
#define logprintf(format,args...) ;
#endif

#if DEBUG > 1
#define dbgprintf(format) if ( DEBUG > 1 ) { \
  fprintf( stdout, "\033[0;%dm%s:%s():#%d :: "format"\033[0m\n", ANSI_GREEN, __FILE__, __func__, __LINE__+1 ) ; \
  sprintf ( string, "%s:%s():#%d :: "format"\n", __FILE__, __func__, __LINE__+1 ) ; \
  write_log ( string, &log_fd ) ; \
}

#define argprintf(format,args...) if ( DEBUG > 1 ) { \
  fprintf( stdout, "\033[0;%dm%s:%s():#%d :: "format"\033[0m\n", ANSI_BLUE, __FILE__, __func__, __LINE__+1, args ) ; \
  sprintf ( string, "%s:%s():#%d :: "format"\n", __FILE__, __func__, __LINE__+1, args ) ; \
  write_log ( string, &log_fd ) ; \
} 

#define errprintf(format,args...) if ( DEBUG > 1 ) { \
  fprintf( stderr, "\033[0;%dm%s:%s():#%d :: "format"\033[0m\n", ANSI_RED, __FILE__, __func__, __LINE__+1, args ) ; \
  sprintf ( string, "%s:%s():#%d :: "format"\n", __FILE__, __func__, __LINE__+1, args ) ; \
  write_log ( string, &log_fd ) ; \
}
#else
#define dbgprintf(format) ;
#define argprintf(format,args...) ;
#define errprintf(format,args...) ;
#endif

#if DEBUG > 2
#define TIMING_START() u64 start = __mftb () ;

#define TIMING_END() u64 end = __mftb () ;

#define TIMING_PRINT() if ( DEBUG > 2 ) { \
  argprintf ( "time = %"PRId64, end - start ) ; \
}
#else
#define TIMING_START() ;
#define TIMING_END() ;
#define TIMING_PRINT() ;
#endif


#endif /* __MEMDUMP_DEBUG_H__ */

