/*
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 */


#ifndef __COPY_MEMORY_H__
#define __COPY_MEMORY_H__


/*
 * includes
 */
#include "common.h"
#include "debug.h"
#include "dumping.h"


/*
 * defines
 */

#define ALIGN(alignment,value) ( alignment == 0 ? value : ( value == 0 ? 0 : ( ( (u32) ( ( value - 1 ) / alignment ) + 1 ) * alignment ) ) )
#define ROUNDUP(alignment,value) ( ( ( value ) + ( ( alignment ) - 1 ) ) & ( ~ ( ( alignment ) - 1 ) ) )

#define ALIGN1M(value) ALIGN( 0x100000, value )
#define ROUND1M(value) ROUNDUP( 0x100000, value )

#define ALIGNPAGE(value) ALIGN( PAGE_SIZE, value )
#define ROUNDPAGE(value) ROUNDUP( PAGE_SIZE, value )


/*
 * structs
 */


/*
 * functions
 */

s32 copy_memory(s32 type, s32 store, u64 offset, u64 size, const char *filename, dumpData *ddata);


#endif /* __COPY_MEMORY_H__ */

