/*
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 */

#ifndef __MEMDUMP_COMMON_H__
#define __MEMDUMP_COMMON_H__


#include <ppu-types.h>


#define MEMDUMP_TITLE                      "memdump"
#define MEMDUMP_VERSION                    "v0.01"

#define WIDTH                              1280
#define HEIGHT                             720

#define LOG_NAME                           "memdump"
#define LOG_EXTENSION                      "log"

#define DEV_HDD_PATH                       "/dev/hdd0/tmp"

#define FILE_EXTENSION                     "bin"

#define PAGE_SIZE                          0x1000

#define RSX_MEMORY_SIZE                    ( 0x10000000 )             /* 256MB */
#define RSX_PARTITION_SIZE                 ( RSX_MEMORY_SIZE / 2 )    /* 128MB */
#define RSX_BANK_SIZE                      ( RSX_PARTITION_SIZE / 8 ) /* 16MB */
#define RSX_PAGE_SIZE                      ( RSX_BANK_SIZE / 4096 )   /* 4KB */

#define SEM_CONSUMERS                      2
#define TIMEOUT                            100000
#define NO_TIMEOUT                         0

#define CHROMAKEY                          0x00ffffff
#define DEPTH_VALUE                        0x00000000

#define FONT_COLOR_NONE                    -1
#define FONT_COLOR_BLACK                   0xff000000
#define FONT_COLOR_GREY                    0xff444444
#define FONT_COLOR_WHITE                   0xffffffff

#define FONT_COLOR_RED                     0xfffa001c
#define FONT_COLOR_ORANGE                  0xfffa8500
#define FONT_COLOR_YELLOW                  0xfffae900
#define FONT_COLOR_GREEN                   0xff3fd711
#define FONT_COLOR_BLUE                    0xff1775ca

#define FONT_COLOR_FG                      FONT_COLOR_YELLOW
#define FONT_COLOR_BG                      FONT_COLOR_BLACK

/* libutils */
#define VIDEO_KEY                          0x101
#define RESC_KEY                           0x102
#define PAD_KEY                            0x103
#define AUDIO_KEY                          0x104
#define EVENT_KEY                          0x105
#define AIO_KEY                            0x106
#define LOG_KEY                            0x107

/* local code */
#define MENU_KEY                           0x01
#define IMAGES_KEY                         0x02
#define DUMP_KEY                           0x03
#define PATCH_KEY                          0x04

/* maximum string size */
#define MAX_STRING                         512

/* memory types */
#define TYPE_LV1                           1
#define TYPE_LV2                           2
#define TYPE_MMIO                          3
#define TYPE_LV1_356                       4

/* log, dump storage types */
#define STORE_HDD0                         1
#define STORE_USB                          2

#define BP_BASE                            ( 0x0000020000000000ULL )
#define IOIF0_ADDR                         ( 0x0000028000000000ULL )
#define IOIF1_ADDR                         ( 0x0000024000000000ULL )

#define BE_MMIO_BASE                       BP_BASE

#define BEI_BE_MMIO_BASE                   ( 0x200005 << 20 )
#define PPE_BE_MMIO_BASE                   ( 0x20000500 << 12 )
#define PRV_BE_MMIO_BASE                   ( 0x20000509 << 12 )
#define MIC_BE_MMIO_BASE                   ( 0x2000050A << 12 )

#define SPE1_BE_MMIO_BASE                  0x40000
#define SPE3_BE_MMIO_BASE                  0x40000
#define SPE5_BE_MMIO_BASE                  0x40000
#define SPE7_BE_MMIO_BASE                  0x40000
#define SPE6_BE_MMIO_BASE                  0x40000
#define SPE4_BE_MMIO_BASE                  0x40000
#define SPE2_BE_MMIO_BASE                  0x40000
#define SPE0_BE_MMIO_BASE                  0x40000

#define SPU0_LS_OFFSET                     ( 0x000000ULL | BE_MMIO_BASE )
#define SPU0_PS_OFFSET                     ( 0x040000ULL | BE_MMIO_BASE )
#define SPU0_P2_OFFSET                     ( 0x060000ULL | BE_MMIO_BASE )
#define SPU0_P1_OFFSET                     ( 0x400000ULL | BE_MMIO_BASE )

#define SPU1_LS_OFFSET                     ( 0x080000ULL | BE_MMIO_BASE )
#define SPU1_PS_OFFSET                     ( 0x0C0000ULL | BE_MMIO_BASE )
#define SPU1_P2_OFFSET                     ( 0x0E0000ULL | BE_MMIO_BASE )
#define SPU1_P1_OFFSET                     ( 0x402000ULL | BE_MMIO_BASE )

#define SPU2_LS_OFFSET                     ( 0x100000ULL | BE_MMIO_BASE )
#define SPU2_PS_OFFSET                     ( 0x140000ULL | BE_MMIO_BASE )
#define SPU2_P2_OFFSET                     ( 0x160000ULL | BE_MMIO_BASE )
#define SPU2_P1_OFFSET                     ( 0x404000ULL | BE_MMIO_BASE )

#define SPU3_LS_OFFSET                     ( 0x180000ULL | BE_MMIO_BASE )
#define SPU3_PS_OFFSET                     ( 0x1C0000ULL | BE_MMIO_BASE )
#define SPU3_P2_OFFSET                     ( 0x1E0000ULL | BE_MMIO_BASE )
#define SPU3_P1_OFFSET                     ( 0x406000ULL | BE_MMIO_BASE )

#define SPU4_LS_OFFSET                     ( 0x200000ULL | BE_MMIO_BASE )
#define SPU4_PS_OFFSET                     ( 0x240000ULL | BE_MMIO_BASE )
#define SPU4_P2_OFFSET                     ( 0x260000ULL | BE_MMIO_BASE )
#define SPU4_P1_OFFSET                     ( 0x408000ULL | BE_MMIO_BASE )

#define SPU5_LS_OFFSET                     ( 0x280000ULL | BE_MMIO_BASE )
#define SPU5_PS_OFFSET                     ( 0x2C0000ULL | BE_MMIO_BASE )
#define SPU5_P2_OFFSET                     ( 0x2E0000ULL | BE_MMIO_BASE )
#define SPU5_P1_OFFSET                     ( 0x40A000ULL | BE_MMIO_BASE )

#define SPU6_LS_OFFSET                     ( 0x300000ULL | BE_MMIO_BASE )
#define SPU6_PS_OFFSET                     ( 0x340000ULL | BE_MMIO_BASE )
#define SPU6_P2_OFFSET                     ( 0x360000ULL | BE_MMIO_BASE )
#define SPU6_P1_OFFSET                     ( 0x40C000ULL | BE_MMIO_BASE )

#define SPU7_LS_OFFSET                     ( 0x380000ULL | BE_MMIO_BASE )
#define SPU7_PS_OFFSET                     ( 0x3C0000ULL | BE_MMIO_BASE )
#define SPU7_P2_OFFSET                     ( 0x3E0000ULL | BE_MMIO_BASE )
#define SPU7_P1_OFFSET                     ( 0x40E000ULL | BE_MMIO_BASE )

#define SPE_PS_MFC_MSSync                  ( 0x00000 )
#define SPE_PS_MFC_LSA                     ( 0x03004 )
#define SPE_PS_MFC_EAH                     ( 0x03008 )
#define SPE_PS_MFC_EAL                     ( 0x0300C )
#define SPE_PS_MFC_Size                    ( 0x03010 )
#define SPE_PS_MFC_Tag                     ( 0x03010 )
#define SPE_PS_MFC_ClassID                 ( 0x03014 )
#define SPE_PS_MFC_Cmd                     ( 0x03014 )
#define SPE_PS_MFC_CMDStatus               ( 0x03014 )
#define SPE_PS_MFC_QStatus                 ( 0x03104 )
#define SPE_PS_Prxy_QueryType              ( 0x03204 )
#define SPE_PS_Prxy_QueryMask              ( 0x0321C )
#define SPE_PS_Prxy_TagStatus              ( 0x0322C )
#define SPE_PS_SPU_Out_Mbox                ( 0x04004 )
#define SPE_PS_SPU_In_Mbox                 ( 0x0400C )
#define SPE_PS_SPU_Mbox_Stat               ( 0x04014 )
#define SPE_PS_SPU_RunCntl                 ( 0x0401C )
#define SPE_PS_SPU_Status                  ( 0x04024 )
#define SPE_PS_SPU_NPC                     ( 0x04034 )
#define SPE_PS_SPU_Sig_Notify_1            ( 0x1400C )
#define SPE_PS_SPU_Sig_Notify_2            ( 0x1C00C )

#define SPE_P1_MFC_SR1                     ( 0x0000 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_MFC_LPID                    ( 0x0008 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_SPU_ID                      ( 0x0010 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_MFC_VR                      ( 0x0018 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_SPU_VR                      ( 0x0020 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_INT_Mask_class0             ( 0x0100 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_INT_Mask_class1             ( 0x0108 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_INT_Mask_class2             ( 0x0110 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_INT_Stat_class0             ( 0x0140 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_INT_Stat_class1             ( 0x0148 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_INT_Stat_class2             ( 0x0150 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_INT_Route                   ( 0x0180 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_MFC_Atomic_Flush            ( 0x0200 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_SPU_Cache_ImplRegs          ( 0x0208 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_MFC_SDR                     ( 0x0400 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_MFC_TLB_Index_Hint          ( 0x0500 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_MFC_TLB_Index               ( 0x0508 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_MFC_TLB_VPN                 ( 0x0510 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_MFC_TLB_RPN                 ( 0x0518 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_MFC_TLB_Invalidate_Entry    ( 0x0540 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_MFC_TLB_Invalidate_All      ( 0x0548 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_SPE_MMU_ImplRegs            ( 0x0580 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_MFC_ACCR                    ( 0x0600 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_MFC_DSISR                   ( 0x0610 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_MFC_DAR                     ( 0x0620 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_MFC_TLB_RMT_Index           ( 0x0700 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_MFC_TLB_RMT_Data            ( 0x0710 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_SPE_RMT_ImplRegs            ( 0x0718 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_MFC_DSIPR                   ( 0x0800 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_MFC_LSACR                   ( 0x0808 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_MFC_LSCRR                   ( 0x0810 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_MFC_RMAB                    ( 0x0900 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_MFC_CER                     ( 0x0C00 ) /* OR with SPUn_P1_OFFSET */
#define SPE_P1_PV1_ImplRegs                ( 0x1000 ) /* OR with SPUn_P1_OFFSET */

#define SPE_P2_SLB_Index                   ( 0x01108 ) /* OR with SPUn_P2_OFFSET */
#define SPE_P2_SLB_ESID                    ( 0x01110 ) /* OR with SPUn_P2_OFFSET */
#define SPE_P2_SLB_VSID                    ( 0x01118 ) /* OR with SPUn_P2_OFFSET */
#define SPE_P2_SLB_Invalidate_Entry        ( 0x01120 ) /* OR with SPUn_P2_OFFSET */
#define SPE_P2_SLB_Invalidate_All          ( 0x01128 ) /* OR with SPUn_P2_OFFSET */
#define SPE_P2_MFC_CSR_ImplRegs            ( 0x02000 ) /* OR with SPUn_P2_OFFSET */
#define SPE_P2_MFC_CNTL                    ( 0x03000 ) /* OR with SPUn_P2_OFFSET */
#define SPE_P2_MFC_Cntl1_ImplRegs          ( 0x03008 ) /* OR with SPUn_P2_OFFSET */
#define SPE_P2_SPU_Out_Intr_Mbox           ( 0x04000 ) /* OR with SPUn_P2_OFFSET */
#define SPE_P2_SPU_PrivCntl                ( 0x04040 ) /* OR with SPUn_P2_OFFSET */
#define SPE_P2_SPU_LSLR                    ( 0x04058 ) /* OR with SPUn_P2_OFFSET */
#define SPE_P2_SPU_ChnlIndex               ( 0x04060 ) /* OR with SPUn_P2_OFFSET */
#define SPE_P2_SPU_ChnlCnt                 ( 0x04068 ) /* OR with SPUn_P2_OFFSET */
#define SPE_P2_SPU_ChnlData                ( 0x04070 ) /* OR with SPUn_P2_OFFSET */
#define SPE_P2_SPU_Cfg                     ( 0x04078 ) /* OR with SPUn_P2_OFFSET */
#define SPE_P2_PV2_ImplRegs                ( 0x05000 ) /* OR with SPUn_P2_OFFSET */

#define PPE_PA_OFFSET                      ( 0x000ULL | PPE_BE_MMIO_BASE )
#define BEI_IIC_OFFSET                     ( 0x08000ULL | BEI_BE_MMIO_BASE )
#define PRV_TLA_OFFSET                     ( 0x000ULL | PRV_BE_MMIO_BASE )
#define PRV_PM_OFFSET                      ( 0x400ULL | PRV_BE_MMIO_BASE )
#define PRV_TPM_OFFSET                     ( 0x800ULL | PRV_BE_MMIO_BASE )
#define PRV_RAS_OFFSET                     ( 0xC00ULL | PRV_BE_MMIO_BASE )
#define MIC_MICTKM_OFFSET                  ( 0x000ULL | MIC_BE_MMIO_BASE )
#define BEI_IOC_IOAT_OFFSET                ( 0x10000ULL | BEI_BE_MMIO_BASE )
#define BEI_BIC_BIC0NCLK_OFFSET            ( 0x11000ULL | BEI_BE_MMIO_BASE )
#define BEI_BIC_BIC1NCLK_OFFSET            ( 0x11400ULL | BEI_BE_MMIO_BASE )
#define BEI_EIB_OFFSET                     ( 0x11800ULL | BEI_BE_MMIO_BASE )
#define BEI_IOC_IOC                        ( 0x11C00ULL | BEI_BE_MMIO_BASE )
#define BEI_BIC_BIC0BCLK_OFFSET            ( 0x12000ULL | BEI_BE_MMIO_BASE )
#define BEI_BIC_BIC1BCLK_OFFSET            ( 0x13000ULL | BEI_BE_MMIO_BASE )

#define PPE_PA_L2_RMT_Index                ( 0x0300 | PPE_PA_OFFSET )
#define PPE_PA_L2_RMT_Data                 ( 0x0310 | PPE_PA_OFFSET )
#define PPE_PA_PPEPV_ImplRegs              ( 0x0800 | PPE_PA_OFFSET )

#define BEI_IIC_INT_Pending_NonD           ( 0x000 ) /* OR with BEI_IIC_OFFSET + 0x400 + ( thread# * 0x20 ) */
#define BEI_IIC_INT_Pending_D              ( 0x008 ) /* OR with BEI_IIC_OFFSET + 0x400 + ( thread# * 0x20 ) */
#define BEI_IIC_INT_Generation             ( 0x010 ) /* OR with BEI_IIC_OFFSET + 0x400 + ( thread# * 0x20 ) */
#define BEI_IIC_INT_CPL                    ( 0x018 ) /* OR with BEI_IIC_OFFSET + 0x400 + ( thread# * 0x20 ) */

/* device 0 */
#define SB_GELIC_0_OFFSET                  ( 0x2800ULL | IOIF1_ADDR )
#define SB_GELIC_1_OFFSET                  ( 0x3004000ULL | IOIF1_ADDR )

/* device 1 */
#define SB_SATA1_0_OFFSET                  ( 0x2000ULL | IOIF1_ADDR )
#define SB_SATA1_1_OFFSET                  ( 0x3000000ULL | IOIF1_ADDR )
#define SB_SATA1_2_OFFSET                  ( 0x3800000ULL | IOIF1_ADDR )
#define SB_SATA1_3_OFFSET                  ( 0x3802000ULL | IOIF1_ADDR )

/* device 2 */
#define SB_SATA2_0_OFFSET                  ( 0x2200ULL | IOIF1_ADDR )
#define SB_SATA2_1_OFFSET                  ( 0x3001000ULL | IOIF1_ADDR )
#define SB_SATA2_2_OFFSET                  ( 0x3803000ULL | IOIF1_ADDR )
#define SB_SATA2_3_OFFSET                  ( 0x3803000ULL | IOIF1_ADDR )

/* device 3 */
#define SB_USB1_0_OFFSET                   ( 0x2400ULL | IOIF1_ADDR )
#define SB_USB1_1_OFFSET                   ( 0x3010000ULL | IOIF1_ADDR )
#define SB_USB1_2_OFFSET                   ( 0x3810000ULL | IOIF1_ADDR )

/* device 4 */
#define SB_USB2_0_OFFSET                   ( 0x2600ULL | IOIF1_ADDR )
#define SB_USB2_1_OFFSET                   ( 0x3020000ULL | IOIF1_ADDR )
#define SB_USB2_2_OFFSET                   ( 0x3820000ULL | IOIF1_ADDR )

/* device 7 */
#define SB_ENCDEC_0_OFFSET                 ( 0x2C00 | IOIF1_ADDR )
#define SB_ENCDEC_1_OFFSET                 ( 0x3005000 | IOIF1_ADDR )
#define SB_ENCDEC_2_OFFSET                 ( 0x3006000 | IOIF1_ADDR )

/* device 9 */

/* LPARs */
#define LPAR1_BASE                         0x0000000ULL
#define LPAR2_BASE                         0x8000000000000000ULL

/* LV1 */
#define DUMP_LV1_OFFSET                    ( LPAR1_BASE )
#define DUMP_LV1_SIZE                      0x1000000ULL
#define DUMP_LV1_FILENAME                  "lv1_dump"
#define COPY_LV1_FILENAME                  "lv1_copy"

/* LV2 */
#define DUMP_LV2_OFFSET                    ( LPAR2_BASE )
#define DUMP_LV2_SIZE                      0x800000ULL
#define DUMP_LV2_FILENAME                  "lv2_dump"
#define COPY_LV2_FILENAME                  "lv2_copy"

/* LPAR1 */
#define DUMP_MEM1_OFFSET                   ( LPAR1_BASE )
#define DUMP_MEM1_SIZE                     0x10000000ULL
#define DUMP_MEM1_FILENAME                 "mem_dump"
#define COPY_MEM1_FILENAME                 "mem_copy"

/* SPU0 */
#define DUMP_MMIO_SPU0_OFFSET              SPU0_LS_OFFSET
#define DUMP_MMIO_SPU0_SIZE                0x80000ULL
#define DUMP_MMIO_SPU0_FILENAME            "spu0_dump"
#define COPY_MMIO_SPU0_FILENAME            "spu0_copy"

#define DUMP_MMIO_SPU0_LS_OFFSET           SPU0_LS_OFFSET
#define DUMP_MMIO_SPU0_LS_SIZE             0x40000ULL
#define DUMP_MMIO_SPU0_LS_FILENAME         "spu0_ls_dump"
#define COPY_MMIO_SPU0_LS_FILENAME         "spu0_ls_copy"

#define DUMP_MMIO_SPU0_PS_OFFSET           SPU0_PS_OFFSET
#define DUMP_MMIO_SPU0_PS_SIZE             0x20000ULL
#define DUMP_MMIO_SPU0_PS_FILENAME         "spu0_ps_dump"
#define COPY_MMIO_SPU0_PS_FILENAME         "spu0_ps_copy"

#define DUMP_MMIO_SPU0_PRIV2_OFFSET        SPU0_P2_OFFSET
#define DUMP_MMIO_SPU0_PRIV2_SIZE          0x20000ULL
#define DUMP_MMIO_SPU0_PRIV2_FILENAME      "spu0_priv2area_dump"
#define COPY_MMIO_SPU0_PRIV2_FILENAME      "spu0_priv2area_copy"

#define DUMP_MMIO_SPU0_PRIV1_OFFSET        SPU0_P1_OFFSET
#define DUMP_MMIO_SPU0_PRIV1_SIZE          0x2000ULL
#define DUMP_MMIO_SPU0_PRIV1_FILENAME      "spu0_priv1area_dump"
#define COPY_MMIO_SPU0_PRIV1_FILENAME      "spu0_priv1area_copy"

/* SPU1 */
#define DUMP_MMIO_SPU1_OFFSET              SPU1_LS_OFFSET
#define DUMP_MMIO_SPU1_SIZE                0x80000ULL
#define DUMP_MMIO_SPU1_FILENAME            "spu1_dump"
#define COPY_MMIO_SPU1_FILENAME            "spu1_copy"

#define DUMP_MMIO_SPU1_LS_OFFSET           SPU1_LS_OFFSET
#define DUMP_MMIO_SPU1_LS_SIZE             0x40000ULL
#define DUMP_MMIO_SPU1_LS_FILENAME         "spu1_ls_dump"
#define COPY_MMIO_SPU1_LS_FILENAME         "spu1_ls_copy"

#define DUMP_MMIO_SPU1_PS_OFFSET           SPU1_PS_OFFSET
#define DUMP_MMIO_SPU1_PS_SIZE             0x20000ULL
#define DUMP_MMIO_SPU1_PS_FILENAME         "spu1_ps_dump"
#define COPY_MMIO_SPU1_PS_FILENAME         "spu1_ps_copy"

#define DUMP_MMIO_SPU1_PRIV2_OFFSET        SPU1_P2_OFFSET
#define DUMP_MMIO_SPU1_PRIV2_SIZE          0x20000ULL
#define DUMP_MMIO_SPU1_PRIV2_FILENAME      "spu1_priv2area_dump"
#define COPY_MMIO_SPU1_PRIV2_FILENAME      "spu1_priv2area_copy"

#define DUMP_MMIO_SPU1_PRIV1_OFFSET        SPU1_P1_OFFSET
#define DUMP_MMIO_SPU1_PRIV1_SIZE          0x2000ULL
#define DUMP_MMIO_SPU1_PRIV1_FILENAME      "spu1_priv1area_dump"
#define COPY_MMIO_SPU1_PRIV1_FILENAME      "spu1_priv1area_copy"

/* SPU2 */
#define DUMP_MMIO_SPU2_OFFSET              SPU2_LS_OFFSET
#define DUMP_MMIO_SPU2_SIZE                0x80000ULL
#define DUMP_MMIO_SPU2_FILENAME            "spu2_dump"
#define COPY_MMIO_SPU2_FILENAME            "spu2_copy"

#define DUMP_MMIO_SPU2_LS_OFFSET           SPU2_LS_OFFSET
#define DUMP_MMIO_SPU2_LS_SIZE             0x40000ULL
#define DUMP_MMIO_SPU2_LS_FILENAME         "spu2_ls_dump"
#define COPY_MMIO_SPU2_LS_FILENAME         "spu2_ls_copy"

#define DUMP_MMIO_SPU2_PS_OFFSET           SPU2_PS_OFFSET
#define DUMP_MMIO_SPU2_PS_SIZE             0x20000ULL
#define DUMP_MMIO_SPU2_PS_FILENAME         "spu2_ps_dump"
#define COPY_MMIO_SPU2_PS_FILENAME         "spu2_ps_copy"

#define DUMP_MMIO_SPU2_PRIV2_OFFSET        SPU2_P2_OFFSET
#define DUMP_MMIO_SPU2_PRIV2_SIZE          0x20000ULL
#define DUMP_MMIO_SPU2_PRIV2_FILENAME      "spu2_priv2area_dump"
#define COPY_MMIO_SPU2_PRIV2_FILENAME      "spu2_priv2area_copy"

#define DUMP_MMIO_SPU2_PRIV1_OFFSET        SPU2_P1_OFFSET
#define DUMP_MMIO_SPU2_PRIV1_SIZE          0x2000ULL
#define DUMP_MMIO_SPU2_PRIV1_FILENAME      "spu2_priv1area_dump"
#define COPY_MMIO_SPU2_PRIV1_FILENAME      "spu2_priv1area_copy"

/* SPU3 */
#define DUMP_MMIO_SPU3_OFFSET              SPU3_LS_OFFSET
#define DUMP_MMIO_SPU3_SIZE                0x80000ULL
#define DUMP_MMIO_SPU3_FILENAME            "spu3_dump"
#define COPY_MMIO_SPU3_FILENAME            "spu3_copy"

#define DUMP_MMIO_SPU3_LS_OFFSET           SPU3_LS_OFFSET
#define DUMP_MMIO_SPU3_LS_SIZE             0x40000ULL
#define DUMP_MMIO_SPU3_LS_FILENAME         "spu3_ls_dump"
#define COPY_MMIO_SPU3_LS_FILENAME         "spu3_ls_copy"

#define DUMP_MMIO_SPU3_PS_OFFSET           SPU3_PS_OFFSET
#define DUMP_MMIO_SPU3_PS_SIZE             0x20000ULL
#define DUMP_MMIO_SPU3_PS_FILENAME         "spu3_ps_dump"
#define COPY_MMIO_SPU3_PS_FILENAME         "spu3_ps_copy"

#define DUMP_MMIO_SPU3_PRIV2_OFFSET        SPU3_P2_OFFSET
#define DUMP_MMIO_SPU3_PRIV2_SIZE          0x20000ULL
#define DUMP_MMIO_SPU3_PRIV2_FILENAME      "spu3_priv2area_dump"
#define COPY_MMIO_SPU3_PRIV2_FILENAME      "spu3_priv2area_copy"

#define DUMP_MMIO_SPU3_PRIV1_OFFSET        SPU3_P1_OFFSET
#define DUMP_MMIO_SPU3_PRIV1_SIZE          0x2000ULL
#define DUMP_MMIO_SPU3_PRIV1_FILENAME      "spu3_priv1area_dump"
#define COPY_MMIO_SPU3_PRIV1_FILENAME      "spu3_priv1area_copy"

/* SPU4 */
#define DUMP_MMIO_SPU4_OFFSET              SPU4_LS_OFFSET
#define DUMP_MMIO_SPU4_SIZE                0x80000ULL
#define DUMP_MMIO_SPU4_FILENAME            "spu4_dump"
#define COPY_MMIO_SPU4_FILENAME            "spu4_copy"

#define DUMP_MMIO_SPU4_LS_OFFSET           SPU4_LS_OFFSET
#define DUMP_MMIO_SPU4_LS_SIZE             0x40000ULL
#define DUMP_MMIO_SPU4_LS_FILENAME         "spu4_ls_dump"
#define COPY_MMIO_SPU4_LS_FILENAME         "spu4_ls_copy"

#define DUMP_MMIO_SPU4_PS_OFFSET           SPU4_PS_OFFSET
#define DUMP_MMIO_SPU4_PS_SIZE             0x20000ULL
#define DUMP_MMIO_SPU4_PS_FILENAME         "spu4_ps_dump"
#define COPY_MMIO_SPU4_PS_FILENAME         "spu4_ps_copy"

#define DUMP_MMIO_SPU4_PRIV2_OFFSET        SPU4_P1_OFFSET
#define DUMP_MMIO_SPU4_PRIV2_SIZE          0x20000ULL
#define DUMP_MMIO_SPU4_PRIV2_FILENAME      "spu4_priv2area_dump"
#define COPY_MMIO_SPU4_PRIV2_FILENAME      "spu4_priv2area_copy"

#define DUMP_MMIO_SPU4_PRIV1_OFFSET        SPU4_P2_OFFSET
#define DUMP_MMIO_SPU4_PRIV1_SIZE          0x2000ULL
#define DUMP_MMIO_SPU4_PRIV1_FILENAME      "spu4_priv1area_dump"
#define COPY_MMIO_SPU4_PRIV1_FILENAME      "spu4_priv1area_copy"

/* SPU5 */
#define DUMP_MMIO_SPU5_OFFSET              SPU5_LS_OFFSET
#define DUMP_MMIO_SPU5_SIZE                0x80000ULL
#define DUMP_MMIO_SPU5_FILENAME            "spu5_dump"
#define COPY_MMIO_SPU5_FILENAME            "spu5_copy"

#define DUMP_MMIO_SPU5_LS_OFFSET           SPU5_LS_OFFSET
#define DUMP_MMIO_SPU5_LS_SIZE             0x40000ULL
#define DUMP_MMIO_SPU5_LS_FILENAME         "spu5_ls_dump"
#define COPY_MMIO_SPU5_LS_FILENAME         "spu5_ls_copy"

#define DUMP_MMIO_SPU5_PS_OFFSET           SPU5_PS_OFFSET
#define DUMP_MMIO_SPU5_PS_SIZE             0x20000ULL
#define DUMP_MMIO_SPU5_PS_FILENAME         "spu5_ps_dump"
#define COPY_MMIO_SPU5_PS_FILENAME         "spu5_ps_copy"

#define DUMP_MMIO_SPU5_PRIV2_OFFSET        SPU5_P2_OFFSET
#define DUMP_MMIO_SPU5_PRIV2_SIZE          0x20000ULL
#define DUMP_MMIO_SPU5_PRIV2_FILENAME      "spu5_priv2area_dump"
#define COPY_MMIO_SPU5_PRIV2_FILENAME      "spu5_priv2area_copy"

#define DUMP_MMIO_SPU5_PRIV1_OFFSET        SPU5_P1_OFFSET
#define DUMP_MMIO_SPU5_PRIV1_SIZE          0x2000ULL
#define DUMP_MMIO_SPU5_PRIV1_FILENAME      "spu5_priv1area_dump"
#define COPY_MMIO_SPU5_PRIV1_FILENAME      "spu5_priv1area_copy"

/* SPU6 */
#define DUMP_MMIO_SPU6_OFFSET              SPU6_LS_OFFSET
#define DUMP_MMIO_SPU6_SIZE                0x80000ULL
#define DUMP_MMIO_SPU6_FILENAME            "spu6_dump"
#define COPY_MMIO_SPU6_FILENAME            "spu6_copy"

#define DUMP_MMIO_SPU6_LS_OFFSET           SPU6_LS_OFFSET
#define DUMP_MMIO_SPU6_LS_SIZE             0x40000ULL
#define DUMP_MMIO_SPU6_LS_FILENAME         "spu6_ls_dump"
#define COPY_MMIO_SPU6_LS_FILENAME         "spu6_ls_copy"

#define DUMP_MMIO_SPU6_PS_OFFSET           SPU6_PS_OFFSET
#define DUMP_MMIO_SPU6_PS_SIZE             0x20000ULL
#define DUMP_MMIO_SPU6_PS_FILENAME         "spu6_ps_dump"
#define COPY_MMIO_SPU6_PS_FILENAME         "spu6_ps_copy"

#define DUMP_MMIO_SPU6_PRIV2_OFFSET        SPU6_P2_OFFSET
#define DUMP_MMIO_SPU6_PRIV2_SIZE          0x20000ULL
#define DUMP_MMIO_SPU6_PRIV2_FILENAME      "spu6_priv2area_dump"
#define COPY_MMIO_SPU6_PRIV2_FILENAME      "spu6_priv2area_copy"

#define DUMP_MMIO_SPU6_PRIV1_OFFSET        SPU6_P1_OFFSET
#define DUMP_MMIO_SPU6_PRIV1_SIZE          0x2000ULL
#define DUMP_MMIO_SPU6_PRIV1_FILENAME      "spu6_priv1area_dump"
#define COPY_MMIO_SPU6_PRIV1_FILENAME      "spu6_priv1area_copy"

/* SPU7 */
#define DUMP_MMIO_SPU7_OFFSET              SPU7_LS_OFFSET
#define DUMP_MMIO_SPU7_SIZE                0x80000ULL
#define DUMP_MMIO_SPU7_FILENAME            "spu7_dump"
#define COPY_MMIO_SPU7_FILENAME            "spu7_copy"

#define DUMP_MMIO_SPU7_LS_OFFSET           SPU7_LS_OFFSET
#define DUMP_MMIO_SPU7_LS_SIZE             0x40000ULL
#define DUMP_MMIO_SPU7_LS_FILENAME         "spu7_ls_dump"
#define COPY_MMIO_SPU7_LS_FILENAME         "spu7_ls_copy"

#define DUMP_MMIO_SPU7_PS_OFFSET           SPU7_PS_OFFSET
#define DUMP_MMIO_SPU7_PS_SIZE             0x20000ULL
#define DUMP_MMIO_SPU7_PS_FILENAME         "spu7_ps_dump"
#define COPY_MMIO_SPU7_PS_FILENAME         "spu7_ps_copy"

#define DUMP_MMIO_SPU7_PRIV2_OFFSET        SPU7_P2_OFFSET
#define DUMP_MMIO_SPU7_PRIV2_SIZE          0x20000ULL
#define DUMP_MMIO_SPU7_PRIV2_FILENAME      "spu7_priv2area_dump"
#define COPY_MMIO_SPU7_PRIV2_FILENAME      "spu7_priv2area_copy"

#define DUMP_MMIO_SPU7_PRIV1_OFFSET        SPU7_P1_OFFSET
#define DUMP_MMIO_SPU7_PRIV1_SIZE          0x2000ULL
#define DUMP_MMIO_SPU7_PRIV1_FILENAME      "spu7_priv1area_dump"
#define COPY_MMIO_SPU7_PRIV1_FILENAME      "spu7_priv1area_copy"

/* PPE privilege area */
#define DUMP_MMIO_PPE_PRIV_OFFSET          PPE_PA_OFFSET
#define DUMP_MMIO_PPE_PRIV_SIZE            0x1000ULL
#define DUMP_MMIO_PPE_PRIV_FILENAME        "ppe_privarea_dump"
#define COPY_MMIO_PPE_PRIV_FILENAME        "ppe_privarea_copy"

/* Broadband Engine Interface (BEI) Internal Interrupt Controller (IIC) */
#define DUMP_MMIO_BEI_IIC_OFFSET           BEI_IIC_OFFSET
#define DUMP_MMIO_BEI_IIC_SIZE             0x1000ULL
#define DUMP_MMIO_BEI_IIC_FILENAME         "bei_iic_dump"
#define COPY_MMIO_BEI_IIC_FILENAME         "bei_iic_copy"

/* Pervasive logic (PRV) trace logic array */
#define DUMP_MMIO_PRV_TLA_OFFSET           PRV_TLA_OFFSET
#define DUMP_MMIO_PRV_TLA_SIZE             0x400ULL
#define DUMP_MMIO_PRV_TLA_FILENAME         "prv_tla_dump"
#define COPY_MMIO_PRV_TLA_FILENAME         "prv_tla_copy"

/* Pervasive logic (PRV) performance monitor */
#define DUMP_MMIO_PRV_PERFMON_OFFSET       PRV_PM_OFFSET
#define DUMP_MMIO_PRV_PERFMON_SIZE         0x400ULL
#define DUMP_MMIO_PRV_PERFMON_FILENAME     "prv_perfmon_dump"
#define COPY_MMIO_PRV_PERFMON_FILENAME     "prv_perfmon_copy"

/* Pervasive logic (PRV) thermal and power management */
#define DUMP_MMIO_PRV_THERMPWR_OFFSET      PRV_TPM_OFFSET
#define DUMP_MMIO_PRV_THERMPWR_SIZE        0x400ULL
#define DUMP_MMIO_PRV_THERMPWR_FILENAME    "prv_thermpwr_dump"
#define COPY_MMIO_PRV_THERMPWR_FILENAME    "prv_thermpwr_copy"

/* Pervasive logic (PRV) reliability, availability, servicability */
#define DUMP_MMIO_PRV_RAS_OFFSET           PRV_RAS_OFFSET
#define DUMP_MMIO_PRV_RAS_SIZE             0x400ULL
#define DUMP_MMIO_PRV_RAS_FILENAME         "prv_ras_dump"
#define COPY_MMIO_PRV_RAS_FILENAME         "prv_ras_copy"

/* Memory Interface Controller (MIC) and Token Manager (TKM) */
#define DUMP_MMIO_MIC_MICTOKENMGR_OFFSET   MIC_MICTKM_OFFSET
#define DUMP_MMIO_MIC_MICTOKENMGR_SIZE     0x1000ULL
#define DUMP_MMIO_MIC_MICTOKENMGR_FILENAME "mic_mictokenmgr_dump"
#define COPY_MMIO_MIC_MICTOKENMGR_FILENAME "mic_mictokenmgr_copy"

/* Broadband Engine Interface (BEI) IOC I/O address translation */
#define DUMP_MMIO_BEI_IOTRANS_OFFSET       BEI_IOC_IOT_OFFSET
#define DUMP_MMIO_BEI_IOTRANS_SIZE         0x1000ULL
#define DUMP_MMIO_BEI_IOTRANS_FILENAME     "bei_iotrans_dump"
#define COPY_MMIO_BEI_IOTRANS_FILENAME     "bei_iotrans_copy"

/* Broadband Engine Interface (BEI) BIC BIC0 NClk */
#define DUMP_MMIO_BEI_BIC0NCLK_OFFSET      BEI_BIC_BIC0NCLK_OFFSET
#define DUMP_MMIO_BEI_BIC0NCLK_SIZE        0x400ULL
#define DUMP_MMIO_BEI_BIC0NCLK_FILENAME    "bei_bic0nclk_dump"
#define COPY_MMIO_BEI_BIC0NCLK_FILENAME    "bei_bic0nclk_copy"

/* Broadband Engine Interface (BEI) BIC BIC1 NClk */
#define DUMP_MMIO_BEI_BIC1NCLK_OFFSET      BEI_BIC_BIC1NCLK_OFFSET
#define DUMP_MMIO_BEI_BIC1NCLK_SIZE        0x400ULL
#define DUMP_MMIO_BEI_BIC1NCLK_FILENAME    "bei_bic1nclk_dump"
#define COPY_MMIO_BEI_BIC1NCLK_FILENAME    "bei_bic1nclk_copy"

/* Broadband Engine Interface (BEI) EIB */
#define DUMP_MMIO_BEI_EIB_OFFSET           BEI_EIB_OFFSET
#define DUMP_MMIO_BEI_EIB_SIZE             0x400ULL
#define DUMP_MMIO_BEI_EIB_FILENAME         "bei_eib_dump"
#define COPY_MMIO_BEI_EIB_FILENAME         "bei_eib_copy"

/* Broadband Engine Interface (BEI) IOC I/O commands */
#define DUMP_MMIO_BEI_IOCMDS_OFFSET        BEI_IOC_IOC_OFFSET
#define DUMP_MMIO_BEI_IOCMDS_SIZE          0x400ULL
#define DUMP_MMIO_BEI_IOCMDS_FILENAME      "bei_iocmds_dump"
#define COPY_MMIO_BEI_IOCMDS_FILENAME      "bei_iocmds_copy"

/* Broadband Engine Interface (BEI) BIC BIC0 BClk */
#define DUMP_MMIO_BEI_BIC0BCLK_OFFSET      BEI_BIC_BIC0BCLK_OFFSET
#define DUMP_MMIO_BEI_BIC0BCLK_SIZE        0x1000ULL
#define DUMP_MMIO_BEI_BIC0BCLK_FILENAME    "bei_bic0bclk_dump"
#define COPY_MMIO_BEI_BIC0BCLK_FILENAME    "bei_bic0bclk_copy"

/* Broadband Engine Interface (BEI) BIC BIC1 BClk */
#define DUMP_MMIO_BEI_BIC1BCLK_OFFSET      BEI_BIC_BIC1BCLK_OFFSET
#define DUMP_MMIO_BEI_BIC1BCLK_SIZE        0x1000ULL
#define DUMP_MMIO_BEI_BIC1BCLK_FILENAME    "bei_bic1bclk_dump"
#define COPY_MMIO_BEI_BIC1BCLK_FILENAME    "bei_bic1bclk_copy"

/* Available to Software */
#define DUMP_MMIO_BE_SOFTWARE_OFFSET       ( 0x800000ULL | BE_MMIO_BASE )
#define DUMP_MMIO_BE_SOFTWARE_SIZE         0x1000ULL
#define DUMP_MMIO_BE_SOFTWARE_FILENAME     "be_software_dump"
#define COPY_MMIO_BE_SOFTWARE_FILENAME     "be_software_copy"

/* gelic */
#define DUMP_MMIO_SB_GELIC1_OFFSET         ( 0x2800ULL | IOIF1_ADDR )
#define DUMP_MMIO_SB_GELIC1_SIZE           0x200ULL
#define DUMP_MMIO_SB_GELIC1_FILENAME       "gelic1_dump"
#define COPY_MMIO_SB_GELIC1_FILENAME       "gelic1_copy"

#define DUMP_MMIO_SB_GELIC2_OFFSET         ( 0x3004000ULL | IOIF1_ADDR )
#define DUMP_MMIO_SB_GELIC2_SIZE           0x1000ULL
#define DUMP_MMIO_SB_GELIC2_FILENAME       "gelic2_dump"
#define COPY_MMIO_SB_GELIC2_FILENAME       "gelic2_copy"

/* nand flash */
#define DUMP_MMIO_NAND_FLASH_OFFSET        ( 0x1e000000ULL | IOIF1_ADDR )
#define DUMP_MMIO_NAND_FLASH_SIZE          0xf00000ULL
#define DUMP_MMIO_NAND_FLASH_FILENAME      "flashmmio_dump"
#define COPY_MMIO_NAND_FLASH_FILENAME      "flashmmio_copy"

/* nor flash */
#define DUMP_MMIO_NOR_FLASH_OFFSET         ( 0x1f000000ULL | IOIF1_ADDR )
#define DUMP_MMIO_NOR_FLASH_SIZE           0x1000000ULL
#define DUMP_MMIO_NOR_FLASH_FILENAME       "flashmmio_dump"
#define COPY_MMIO_NOR_FLASH_FILENAME       "flashmmio_copy"

#define DUMP_MMIO_NOR_FLASH_OFFSET         ( 0x1f000000ULL | IOIF1_ADDR )
#define DUMP_MMIO_NOR_FLASH_SIZE           0x1000000ULL
#define DUMP_MMIO_NOR_FLASH_FILENAME       "flashmmio_dump"
#define COPY_MMIO_NOR_FLASH_FILENAME       "flashmmio_copy"

/* sysrom */
#define DUMP_MMIO_NOR_SYSROM_OFFSET        ( 0x1fc00000ULL | IOIF1_ADDR )
#define DUMP_MMIO_NOR_SYSROM_SIZE          0x40000ULL
#define DUMP_MMIO_NOR_SYSROM_FILENAME      "sysrom_dump"
#define COPY_MMIO_NOR_SYSROM_FILENAME      "sysrom_copy"

/* nor cvtrm */
#define DUMP_MMIO_NOR_CVTRM_OFFSET         ( 0x1fec0000ULL | IOIF1_ADDR )
#define DUMP_MMIO_NOR_CVTRM_SIZE           0x40000ULL
#define DUMP_MMIO_NOR_CVTRM_FILENAME       "cvtrm_dump"
#define COPY_MMIO_NOR_CVTRM_FILENAME       "cvtrm_copy"

/* nor extnor */
#define DUMP_MMIO_NOR_EXTNOR_OFFSET        ( 0x1ff20000ULL | IOIF1_ADDR )
#define DUMP_MMIO_NOR_EXTNOR_SIZE          0xa0000ULL
#define DUMP_MMIO_NOR_EXTNOR_FILENAME      "extnor_dump"
#define COPY_MMIO_NOR_EXTNOR_FILENAME      "extnor_copy"

/* nor bootldr */
#define DUMP_MMIO_NOR_BOOTLDR_OFFSET       ( 0x1ffc0000ULL | IOIF1_ADDR )
#define DUMP_MMIO_NOR_BOOTLDR_SIZE         0x30000ULL
#define DUMP_MMIO_NOR_BOOTLDR_FILENAME     "bootldr_dump"
#define COPY_MMIO_NOR_BOOTLDR_FILENAME     "bootldr_copy"

/* RSX */
#define DUMP_MMIO_RSX1_OFFSET              ( 0x80000000ULL | IOIF0_ADDR )
#define DUMP_MMIO_RSX1_SIZE                0xfe00000ULL
#define DUMP_MMIO_RSX1_FILENAME            "rsx1_dump"
#define COPY_MMIO_RSX1_FILENAME            "rsx1_copy"

#define DUMP_MMIO_RSX3_OFFSET              ( 0x8fe00000ULL | IOIF0_ADDR )
#define DUMP_MMIO_RSX3_SIZE                0x40000ULL
#define DUMP_MMIO_RSX3_FILENAME            "rsx3_dump"
#define COPY_MMIO_RSX3_FILENAME            "rsx3_copy"

#define DUMP_MMIO_RSX4_OFFSET              ( 0xc00000ULL | IOIF0_ADDR )
#define DUMP_MMIO_RSX4_SIZE                0x20000ULL
#define DUMP_MMIO_RSX4_FILENAME            "rsx4_dump"
#define COPY_MMIO_RSX4_FILENAME            "rsx4_copy"

#define DUMP_MMIO_RSX5_OFFSET              ( 0x80100ULL | IOIF0_ADDR )
#define DUMP_MMIO_RSX5_SIZE                0x8000ULL
#define DUMP_MMIO_RSX5_FILENAME            "rsx5_dump"
#define COPY_MMIO_RSX5_FILENAME            "rsx5_copy"

/* HTAB */
#define DUMP_HTAB_OFFSET                   ( 0xF000000ULL | LPAR2_BASE )
#define DUMP_HTAB_SIZE                     0x40000ULL
#define DUMP_HTAB_FILENAME                 "htab_dump"
#define COPY_HTAB_FILENAME                 "htab_copy"

/* FLASH device ids, sector size */
#define DUMP_FLASH_NAND_DEVID              0x100000000000001ULL
#define DUMP_FLASH_NOR_DEVID               0x100000000000004ULL
#define DUMP_FLASH_SECTOR_SIZE             0x200

/* FLASH */
#define DUMP_FLASH_START_SECTOR            0x0
#define DUMP_FLASH_FLAGS                   0x22ULL
#define DUMP_FLASH_FILENAME                "flash_stor"
#define COPY_FLASH_FILENAME                "flash_mmio"
#define WRITE_FLASH_FILENAME               "flash_write"
#define WRITE_FLASH_FLAGS                   0x6ULL

/* PTAB */
#define DUMP_PTAB_NAND_START_SECTOR        0x7600
#define DUMP_PTAB_NOR_START_SECTOR         0x0
#define DUMP_PTAB_SECTOR_COUNT             0x2
#define DUMP_PTAB_FLAGS                    0x6ULL
#define DUMP_PTAB_FILENAME                 "flash_ptab"

/* eEID */
#define DUMP_eEID_NAND_START_SECTOR        0x204ULL
#define DUMP_eEID_NOR_START_SECTOR         0x178ULL
#define DUMP_eEID_SECTOR_COUNT             0x80ULL
#define DUMP_eEID_FLAGS                    0x6ULL
#define DUMP_eEID_FILENAME                 "flash_eEID"

/* IDPS */
#define DUMP_IDPS_FILENAME                 "idps"
#define DUMP_IDPS_SIZE                     0x10


#endif /* __MEMDUMP_COMMON_H__ */

