/*
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 */


#ifndef __TILESET_BUTTONS_H__
#define __TILESET_BUTTONS_H__


#include <ppu-types.h>

#include "common.h"
#include "tilesetutil.h"

#include "tileset_buttons_png.h"          /* PNG bitmap */


#define BUTTON_OBJECTS    5
#define BUTTON_STATES     2

#define BUTTON_WIDTH      30
#define BUTTON_HEIGHT     30

#define BUTTON_NONE       0
#define BUTTON_TRIANGLE   1
#define BUTTON_CIRCLE     2
#define BUTTON_CROSS      3
#define BUTTON_SQUARE     4

#define BUTTON_UP         0
#define BUTTON_DOWN       1

#define BUTTON_TRIANGLE_X 1173
#define BUTTON_TRIANGLE_Y 141
#define BUTTON_CIRCLE_X   1173
#define BUTTON_CIRCLE_Y   189
#define BUTTON_CROSS_X    1173
#define BUTTON_CROSS_Y    237
#define BUTTON_SQUARE_X   1173
#define BUTTON_SQUARE_Y   285


typedef tilesetData buttonsData;
typedef tilesetBuffer buttonsBuffer;
typedef tileBitmapData buttonBitmapData;


/* buttons */
void buttonsInitialization(void *b_data);
void buttonsDataInitialization(void *b_data);
void buttonsFinish(void *b_data);
void buttonsBufferClear(void *b_data);
void buttonsLoadTileset(void *mem, u32 size, void *b_data);
void buttonsLoadTiles(void *b_data);
void buttonDraw(u8 idx, u8 state, u8 from, s32 x, s32 y, void *vu_data);


#endif /* __TILESET_BUTTONS_H__ */

