#ifndef DEBUG_H
#define DEBUG_H

#include "common.h"

ssize_t debug_print_to_socket(int sockd, const void *vptr);
void debug_wait_for_client();

#if DEBUG
#define PRINTF(fmt, args...) do { sprintf(debug_buffer, fmt, ## args); debug_print_to_socket(debug_sock, debug_buffer); } while(0)
#else
#define PRINTF(fmt, args...) do { if (debug_sock == -1) break; sprintf(debug_buffer, fmt, ## args); debug_print_to_socket(debug_sock, debug_buffer); } while(0)
#endif

#endif
