/****************************************************************************
 * libwiigui Template
 * Tantric 2009
 *
 * filebrowser.h
 *
 * Generic file routines - reading, writing, browsing
 ***************************************************************************/

#ifndef FILEBROWSER_H
#define FILEBROWSER_H

#include <string>
#include <unistd.h>
#include <ppu-types.h>

#include "fileops.h"

#define MAXJOLIET 255
#define MAXDISPLAY 45

typedef struct
{
	char dir[MAXPATHLEN]; // directory path of browserList
	int numEntries; // # of entries in browserList
	int selIndex; // currently selected index of browserList
	int pageIndex; // starting index of browserList page display
	u8 mode;		//display files, folders, or both.  use DIR_FILES and DI_DIRS
} BROWSERINFO;

typedef struct
{
	u64 offset; // DVD offset
	unsigned int length; // file length
	char isdir; // 0 - file, 1 - directory
	char filename[MAXJOLIET + 1]; // full filename
	char displayname[MAXDISPLAY + 1]; // name for browser display
} BROWSERENTRY;

namespace FileBrowser
{
extern BROWSERINFO browser;
extern BROWSERENTRY * browserList;
extern char rootdir[ 0x10 ];

int UpdateDirName(int method);
int FileSortCallback(const void *f1, const void *f2);
void Reset();
int ChangeFolder();
int BrowseDevice( const std::string &device, std::string dir );

void Init();
void SetDisplayMode( u8 mode );
bool GoToParentDir();
int ParseDirectory();

}
#endif // FILEBROWSER_H
