/* 
   TINY3D sample / (c) 2010 Hermes  <www.elotrolado.net>

*/

#ifndef UTILS_H
#define UTILS_H

#include <tiny3d.h>
#include <psl1ght/lv2/thread.h>

#define MIN( x, y ) ( ( x ) < ( y ) ? ( x ) : ( y ) )
#define MAX( x, y ) ( ( x ) > ( y ) ? ( x ) : ( y ) )
#define RU(x,n)	(-(-(x) & -(n)))

#define le16(i) ((((u16) ((i) & 0xFF)) << 8) | ((u16) (((i) & 0xFF00) >> 8)))
#define le32(i) ((((u32)le16((i) & 0xFFFF)) << 16) | ((u32)le16(((i) & 0xFFFF0000) >> 16)))
#define le64(i) ((((u64)le32((i) & 0xFFFFFFFFLL)) << 32) | ((u64)le32(((i) & 0xFFFFFFFF00000000LL) >> 32)))

#define PI 				3.14159265f

#define THREAD_SLEEP 100

#define INC_FILE( x ) \
	extern const u8 x [];\
	extern const u32 x##_size;

#ifdef __cplusplus
extern "C"
{
#endif

void hexdump( const void *d, int len );
void mutex_init( sys_mutex_t *m );
void cond_init( sys_cond_t *c, sys_mutex_t *m );


#ifdef __cplusplus
}
#endif


#endif

