#include <stdio.h>
#include <string.h>
#include <stdio.h>
#include <malloc.h>
#include <sys/stat.h>
#include <vector>
#include <map>

#include "rsxmem.h"
#include "utils.h"


// i dont know whats going on with the toolchain, but it is giving goofy-ass compile & linking errors. so for now, these go here
static MemItr ptr[ RSX_MEM_MAX_TEXTURES ];
static u32 numPtrs = 0;


static sys_mutex_t rsxMutex;

u32 RsxMem::memSize = 0;
u32 *RsxMem::memStart = NULL;
RsxMem::RsxMem()
{
}

bool RsxMem::Init( u32 size )
{
	//printf("RsxMem::Init( %08x )\n", size );

	//make sure we're not already inited
	if( memSize )
	{
		printf("RsxMem::Init( %08x ) failed:  init is already called\n", size );
		return false;
	}

    //create mutex
    mutex_init( &rsxMutex );

	//try to grab the big chunk of memory
	memStart = (u32*)tiny3d_AllocTexture( size );
	if( !memStart )
	{
		printf("RsxMem::Init( %08x ) failed to allocate memory\n", size );
		return false;
	}

	//set variables
	memSize = size;
	memset( (void*)&ptr, 0, sizeof( MemItr ) * RSX_MEM_MAX_TEXTURES );

	//printf("memSize: %08x\nmemStart: %p\n", memSize, memStart );
	return true;
}

u8 *RsxMem::Alloc( u32 bytes, u32* off )
{
    sys_mutex_lock( rsxMutex, 0 );
	//printf("RsxMem::Alloc( %08x )\n", bytes );
	//check for max entries
	if( numPtrs >= RSX_MEM_MAX_TEXTURES )
	{
        printf("RsxMem::Alloc() :max entries reached\n");
        sys_mutex_unlock( rsxMutex );
		return NULL;
	}
	//align
	bytes = RU( bytes, 4 );

	//find the first available chunk of memory big enough
	u32 offset = 0;
	u32 i = 0;
	for( i = 0; i < numPtrs; i++ )//TODO: remove this middle statement
	{
		//if there is another chunk of allocated memory after this one, check the space between them
		if( i + 1 < numPtrs )
		{
			if( ( ptr[ i + 1 ].start - ptr[ i ].end ) >= bytes )
			{
				offset = ptr[ i ].end;
				i++;
				break;
			}
		}
		//if this is the last texture
		else if( i == numPtrs - 1 )
		{
			if( ( memSize - ptr[ i ].end ) >= bytes )
			{
				offset = ptr[ i ].end;
				i++;
			}
			else
			{
                printf("RsxMem::Alloc() :didnt find enough free space for %08x\n", bytes );
                sys_mutex_unlock( rsxMutex );
				return NULL;
			}
			break;
		}
	}
	numPtrs++;
	//printf("will insert new entry at %u\n", i  );
	//insert new entry in the list
	for( u32 j = numPtrs; j > i; j-- )
	{
		ptr[ j ].start = ptr[ j - 1 ].start;
		ptr[ j ].end = ptr[ j - 1 ].end;
	}

	//u32 off2 = ;


	ptr[ i ].start = offset;
	ptr[ i ].end = offset + bytes;
	//printf("returning %016llx %08x %016llx\n", (long long unsigned int)memStart, offset, ((long long unsigned int)(memStart + offset)) );

	if( off )
	{
		*off = tiny3d_TextureOffset( (u8*)memStart + offset );
	}

    u8 *ret = ((u8*)memStart) + offset;
    sys_mutex_unlock( rsxMutex );
    return ret;
}

void RsxMem::Free( u8 *p )
{
    sys_mutex_lock( rsxMutex, 0 );
	//printf("RsxMem::Free( %p )\n", p );
	u32 offset = p - ((u8*)memStart);
	//printf("looking for offset: %08x\n", offset );
	u32 i = 0;
	for( i = 0; i < numPtrs; i++ )//TODO: delete this middle statement
	{
		if( ptr[ i ].start == offset )
		{
			//printf("will free # %u\n", i );
			break;
		}
		if( i + 1 >= numPtrs )
		{
            printf("RsxMem::Free( %p ) :no entry matched that pointer\n", p );
            sys_mutex_unlock( rsxMutex );
			return;
		}
	}

	//remove entry
	for( u32 j = i; j < numPtrs; j++ )
	{
		ptr[ j ].start = ptr[ j + 1 ].start;
		ptr[ j ].end = ptr[ j + 1 ].end;
	}
    numPtrs--;
    sys_mutex_unlock( rsxMutex );
}

u32 RsxMem::Offset( u8 *p )
{
	return tiny3d_TextureOffset( (u32*)p );
}

void RsxMem::PrintInfo( bool verbose )
{
    sys_mutex_lock( rsxMutex, 0 );
	printf("-------------------------------------------------------------------------\n");
	printf("RsxMem::PrintInfo\n");
	printf("memSize: %08x (%.2fMiB)  memStart: %p  numPtrs: %u\n", memSize, (float)((float)memSize/(float)1048576.0f ), memStart, numPtrs );
	u32 used = 0;
	u32 free = 0;
	if( verbose )
		printf("[idx]   start  ->    end   (   size   )    addr       rsxAddr\n" );
	for( u32 i = 0; i < numPtrs; i++ )
	{
		u32 bytes = ( ptr[ i ].end - ptr[ i ].start );
		if( verbose )
		{
			printf("[ %u ] %08x -> %08x ( %08x ) %p %08x\n",\
				   i, ptr[ i ].start, ptr[ i ].end, bytes, ( ((u8*)memStart) + ptr[ i ].start ), tiny3d_TextureOffset( memStart + ptr[ i ].start ) );
			//hexdump( ( ((u8*)memStart) + ptr[ i ].start ), 0x50 );
		}
		used += bytes;
	}
	free = memSize - used;
	printf("used: %08x (%.2fMiB)  free: %08x (%.2fMiB)\n", used, (float)((float)used/(float)1048576.0f ), free, (float)((float)free/(float)1048576.0f ) );
	printf("-------------------------------------------------------------------------\n");
    sys_mutex_unlock( rsxMutex );
}


