#ifndef MENU_H
#define MENU_H

//alignment
#define ALIGN_LEFT		1
#define ALIGN_RIGHT		2
#define ALIGN_CENTER	4
#define ALIGN_CENTRE	ALIGN_CENTER

#define ALIGN_TOP		0x10
#define ALIGN_BOTTOM	0x20
#define ALIGN_MIDDLE	0x40

//window size
#define WINDOW_HEIGHT	511.0f
#define WINDOW_WIDTH	847.0f

#include <tiny3d.h>


enum
{
	MENU_EXIT = 1,
	MENU_SETTINGS,
	MENU_MAIN_SCREEN,
	MENU_ABOUT,
	MENU_GAME
};

void MenuPrepareToDraw();
void AdjustViewport( float x, float y );

int WindowPrompt(const char *title, const char *msg, const char *btn1Label, const char *btn2Label);
void ErrorPrompt( const char* message );

void ProgressWindow( const char *title, const char *msg );


//void MenuDrawRectangle( u32 rgba, float width, float height, float x, float y, float z, u32 alignment, u8 filled );

void MenuDrawImage( u32 rsxOffset, float width, float height, u32 wpitch, float x, float y, float z, float angleZ, u8 alpha, float scale );
void MenuDrawRectangle( u32 rgba, float width, float height, float x, float y, float z, u8 filled, float angleZ, float scale );

u8 MenuPrompt2( const char* header, const char* question, const char* btn1, const char*btn2, u8 defaultBtn );
void MenuFillBackground( u32 rgba );
u8 MenuNewGameOptions( u8 *rows, u8 *cols, u8 *player1, u8 *player2 );


int MainMenu( int menu );
void HaltGui();
void ResumeGui();
void exiting();
void InitGuiThread();
void InitGameSettings();

#endif // MENU_H
