/*
   TINY3D sample / (c) 2010 Hermes  <www.elotrolado.net>

*/

#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <assert.h>
#include <unistd.h>
#include <math.h>



#include <sysmodule/sysmodule.h>
#include <pngdec/loadpng.h>


#include <psl1ght/lv2/thread.h>
#include <tiny3d.h>

#include "utils.h"

#include "gui.h"
#include "pad.h"
#include "menu.h"
#include "rsxmem.h"


s32 main(s32 argc, const char* argv[])
{
	//init the sound stuff
	if( !GuiSound::Init() )
		exit( 0 );

	tiny3d_Init( 1024 * 1024 );
	tiny3d_Project2D();

    //make the scene take up all of the TV ( im only using 1080p so this might be too much for other resolutions )
    AdjustViewport( -42.0f, -42.0f );

	//init muh pad stuff
	PadInit();

	SysLoadModule( SYSMODULE_PNGDEC );

	atexit( exiting ); // Tiny3D register the event 3 and do exit() call when you exit  to the menu

	//this allocates the memory heap used to store fonts and textures
	RsxMem::Init();

	//set tiny3d to work in 2d mode
	tiny3d_Project2D();

	//set initial settings
	InitGameSettings();

	//create thread to handle gui stuff
	InitGuiThread();

	//start looping and crap
	MainMenu( MENU_MAIN_SCREEN );

	exit( 0 );

	return 0;
}

