#ifndef GUIFONT_H
#define GUIFONT_H

#include <tiny3d.h>
#include <ft2build.h>
#include <freetype/freetype.h>
#include <freetype/ftglyph.h>
#include <wchar.h>

//im not sure how many characters are actually needed so you can change it here
#define FONT_MAX_CHARS 0x200

//not sure what a preset size to load is, so set it here
#define FONT_LOAD_SIZE 32

class GuiFont
{
public:
	//create a font from a .ttf stored in memory
	//! mem is a pointer to the font in memory
	//! len is the length of the font buffer
	//! fChar is the first character to load
	//! lChar is the last character to load
	//! size is the size for each bitmap.  you should use a power of 2 from 8 and 256
	GuiFont( u8* mem, u32 len, u16 fChar = 32, u16 lchar = 126, u16 size = FONT_LOAD_SIZE );

	~GuiFont();

	//draw some text
	//! x, y, and z are coords
	//! text is the text to draw
	//! rgba is the color to use
	//! size is the size on the screen the text should appear.  this is scaled from the size the font is loaded with
	//! textStyle is not used
	void DrawText( float x, float y, float z, wchar_t *text, u32 rgba, u32 size, uint16_t textStyle );

	//same as above except it accepts "len" if you already know it and avoids checking strlen
	void DrawText( float x, float y, float z, wchar_t *text, u32 len, u32 rgba, u32 size, uint16_t textStyle );

	//draw a letter on the screen
	//! parameters are the same as above
	void DrawCh( float x, float y, float z, u16 chr, u32 rgba, u32 size );

	//get the width of some text if drawn with a certain size
	u32 TextWidth( wchar_t *text, u32 size );

	//same as above, but accepts a length if you already know it
	u32 TextWidth( wchar_t *text, u32 len, u32 size );

private:
	u32 GetTextureSize( u32 numchars, u16 size = FONT_LOAD_SIZE );
	void CreateTexture( u32 size );
	void TTF_to_Bitmap( u16 chr, u8 * bitmap, short *w, short *h, short *y_correction );
	FT_Face face;
	u16 firstChar;
	u16 lastChar;
	u32 rsxOffset;
	u32 rsxBytesPerChar;
	u8 *pointer;
	u16 storedSize;

	u8 bh;

	short fw[ FONT_MAX_CHARS ];
	short fy[ FONT_MAX_CHARS ];
};

#endif // GUIFONT_H
