#ifdef OPENGL
GLuint spritesheettexture = NULL;
#endif

#ifdef RSX
#include "spritesheettexture.bin.h"
Image spritesheettexture_image;
#endif

#ifdef GX
GXTexObj spritesheettexture_GXTexObj;
TPLFile spritesheettextureTPL;
#include "spritesheettexture_tpl.h"
#include "spritesheettexture.h"
#endif

float logotexturecoords[8];
float episodetexturecoords[8];
float wallpapertexturecoords[8];
float fadetoblacktexturecoords[8];
float framedtexturecoords[6][8];
float bunnytexturecoords[8];
float bananatexturecoords[8];
float zorbingtexturecoords[8];

float textbubbletexturecoords[3][4][3][8];

void gentexturecoords(float (*coords),
					  float xsize,float ysize,
					  float xoffset,float yoffset,
					  float fullsizex,float fullsizey){
		xsize-=0.f;
		ysize-=0.f;
		xoffset+=0.f;
		yoffset+=0.f;
		xsize/=fullsizex;
		ysize/=fullsizey;
		xoffset/=fullsizex;
		yoffset/=fullsizey;
		coords[0]=xoffset;
		coords[1]=yoffset+ysize;
		coords[2]=xoffset+xsize;
		coords[3]=yoffset+ysize;
		coords[4]=xoffset+xsize;
		coords[5]=yoffset;
		coords[6]=xoffset;
		coords[7]=yoffset;
}

void setuptextures(){

	//load textures
	#ifdef OPENGL
	spritesheettexture=loadtexture((char*)"Media/spritesheettexture.png",mipmapping);
	#endif
	#ifdef RSX	
	spritesheettexture_image = loadPng(spritesheettexture_bin);
	#endif
	#ifdef GX
	TPL_OpenTPLFromMemory(&spritesheettextureTPL,(void *)spritesheettexture_tpl,spritesheettexture_tpl_size);
	TPL_GetTexture(&spritesheettextureTPL,spritesheettexture,&spritesheettexture_GXTexObj);
	#endif

	//set the texture coordinates
	gentexturecoords(&logotexturecoords[0],
		7*64,5*64,
		0*64,0*64,
		1024,1024);
	gentexturecoords(&episodetexturecoords[0],
		8*64,2*64,
		2*64,10*64,
		1024,1024);

	gentexturecoords(&wallpapertexturecoords[0],
		4*64,4*64,
		11*64,11*64,
		1024,1024);

	gentexturecoords(&fadetoblacktexturecoords[0],
		1*64,1*64,
		0*64+1*32,10*64+1*32,
		1024,1024);

	gentexturecoords(&framedtexturecoords[0][0],
		3*64,5*64,
		7*64,0*64,
		1024,1024);
	gentexturecoords(&framedtexturecoords[1][0],
		3*64,5*64,
		10*64,0*64,
		1024,1024);
	gentexturecoords(&framedtexturecoords[2][0],
		3*64,5*64,
		13*64,0*64,
		1024,1024);
	gentexturecoords(&framedtexturecoords[3][0],
		3*64,5*64,
		7*64,5*64,
		1024,1024);
	gentexturecoords(&framedtexturecoords[4][0],
		3*64,5*64,
		10*64,5*64,
		1024,1024);
	gentexturecoords(&framedtexturecoords[5][0],
		3*64,5*64,
		13*64,5*64,
		1024,1024);

	gentexturecoords(&bunnytexturecoords[0],
		2*64,4*64,
		0*64,12*64,
		1024,1024);
	gentexturecoords(&bananatexturecoords[0],
		4*64,4*64,
		2*64,12*64,
		1024,1024);
	gentexturecoords(&zorbingtexturecoords[0],
		4*64,4*64,
		6*64,12*64,
		1024,1024);

	for(int a=0;a<3;a++)for(int x=0;x<4;x++)for(int y=0;y<3;y++)
		gentexturecoords(&textbubbletexturecoords[a][x][y][0],
			1*32,1*32,
			x*32+a*4*32,y*32+8.5*64,
			1024,1024);

}
