void play(float gamespeed){

	//get input
	float inputspeed=0;
	float inputangle=0;
	bool jump=0;
	#ifdef WIN
		bool up=0,down=0,left=0,right=0;
		if(keystate[SDLK_w]|keystate[SDLK_UP])up=1;
		if(keystate[SDLK_s]|keystate[SDLK_DOWN])down=1;
		if(keystate[SDLK_a]|keystate[SDLK_LEFT])left=1;
		if(keystate[SDLK_d]|keystate[SDLK_RIGHT])right=1;
		inputangle=atan2((float)right-(float)left,(float)up-(float)down)-90.f*radiansindegree;
		inputspeed=dist2d((float)right-(float)left,(float)up-(float)down,0,0);
		if(inputspeed>1.f)inputspeed=1.f;
		if(keystate[SDLK_SPACE])jump=1;
	#endif
	#ifdef PS3
		inputspeed=dist2d(0,0,(float)(paddata[0].ANA_L_V-128),(float)(paddata[0].ANA_L_H-128))/128.f;
		if(inputspeed>0.2f){
			if(inputspeed>1.f)inputspeed=1.f;
			inputangle=atan2((float)(paddata[0].ANA_L_V-128),(float)(paddata[0].ANA_L_H-128));
		}else{
			inputspeed=0.f;
		}
		if(BTN_CROSS[0])jump=1;
	#endif

	//keep track of your starting position
	float oldx=playerposx;
	float oldy=playerposy;
	float oldz=playerposz;

	playermovx=playermovx*0.9f;
	playermovx+=cos(inputangle)*inputspeed*0.002f*gamespeed;
	playermovy-=0.002f*gamespeed;
	if(jump && playerposy<0.1105f)playermovy=0.045f;

	playerposx+=playermovx*gamespeed;
	playerposy+=playermovy*gamespeed;
	playerposz+=playermovz*gamespeed;
	float distance=dist2d(zebraposx,zebraposy,playerposx,playerposy);
	if(zebraposx>3.75f+0.15f*2.f+0.11f*2.f && distance<0.11f+0.15f){
		float angle=atan2(playerposy-zebraposy,playerposx-zebraposx);
		playerposx+=cos(angle)*(0.11f+0.15f-distance);
		playerposy+=sin(angle)*(0.11f+0.15f-distance);
	}
	if(playerposx<3.75f)playerposx=3.75f;
	if(playerposy<0.11f)playerposy=0.11f;

	playermovx=(playerposx-oldx)/gamespeed;
	playermovy=(playerposy-oldy)/gamespeed;
	playermovz=(playerposz-oldz)/gamespeed;

	zebraposx-=0.009f*gamespeed;
	zebraposy=0.15f;
	if(zebraposx<camposx-2.5f)zebraposx=camposx+2.5f+(float)(rand()%200)*0.01f;

	camposx+=(playerposx+0.25f-camposx)*0.1f*gamespeed;
	camposy+=(playerposy*0.5f+0.9f-camposy)*0.1f*gamespeed;
	#ifdef PS3
	camposz+=(playerposz+1.4f-camposz)*0.1f*gamespeed;
	#else
	camposz+=(playerposz+1.6f-camposz)*0.1f*gamespeed;
	#endif
	camangx=15.f*radiansindegree;
	camangy=0.f*radiansindegree;
	camangz=0.f*radiansindegree;

}
