#ifdef OPENGL
GLuint thatotherpongtexture = NULL;
#endif

#ifdef RSX
#include "thatotherpongtexture.bin.h"
Image thatotherpongtexture_image;
#endif

#ifdef GX
GXTexObj thatotherpongtexture_GXTexObj;
TPLFile thatotherpongtextureTPL;
#include "thatotherpongtexture_tpl.h"
#include "thatotherpongtexture.h"
#endif

float backgroundtexturecoords[8];
float darknesstexturecoords[8];
float blacktexturecoords[8];
float titletexturecoords[8];
float lpaddletexturecoords[8];
float rpaddletexturecoords[8];
float balltexturecoords[8];

float ltextbackingtexturecoords[8];
float rtextbackingtexturecoords[8];

float buttontexturecoords[2][9][8];

void gentexturecoords(float (*coords),
					  float xsize,float ysize,
					  float xoffset,float yoffset,
					  float fullsizex,float fullsizey,
					  float indent){
		if(xsize>=0.f){xsize-=indent*2.f;}else{xsize+=indent*2.f;}
		if(ysize>=0.f){ysize-=indent*2.f;}else{ysize+=indent*2.f;}
		if(xsize>=0.f){xoffset+=indent;}else{xoffset-=indent;}
		if(ysize>=0.f){yoffset+=indent;}else{yoffset-=indent;}
		xsize/=fullsizex;
		ysize/=fullsizey;
		xoffset/=fullsizex;
		yoffset/=fullsizey;
		coords[0]=xoffset;
		coords[1]=yoffset+ysize;
		coords[2]=xoffset+xsize;
		coords[3]=yoffset+ysize;
		coords[4]=xoffset+xsize;
		coords[5]=yoffset;
		coords[6]=xoffset;
		coords[7]=yoffset;
}

void setuptextures(){

	//load textures
	#ifdef OPENGL
	thatotherpongtexture=loadtexture((char*)"Media/thatotherpongtexture.png",mipmapping);
	#endif
	#ifdef RSX	
	thatotherpongtexture_image = loadPng(thatotherpongtexture_bin);
	#endif
	#ifdef GX
	TPL_OpenTPLFromMemory(&thatotherpongtextureTPL,(void *)thatotherpongtexture_tpl,thatotherpongtexture_tpl_size);
	TPL_GetTexture(&thatotherpongtextureTPL,thatotherpongtexture,&thatotherpongtexture_GXTexObj);
	#endif

	//set the texture coordinates
	gentexturecoords(&backgroundtexturecoords[0],
		128.f,128.f,
		128.f,128.f,
		1024.f,1024.f,0);
	gentexturecoords(&darknesstexturecoords[0],
		64.f*6.f,64.f*6.f,
		0.f,64.f*6.f,
		1024.f,1024.f,1);

	gentexturecoords(&blacktexturecoords[0],
		0.f,0.f,
		64.f*3.f,64.f*14.f,
		1024.f,1024.f,0);

	gentexturecoords(&titletexturecoords[0],
		64.f*4.f,64.f,
		64.f*8.f,64.f*2.f,
		1024.f,1024.f,0);

	gentexturecoords(&lpaddletexturecoords[0],
		64.f,64.f*3.f,
		64.f*6.f,0.f,
		1024.f,1024.f,0);
	gentexturecoords(&rpaddletexturecoords[0],
		64.f,64.f*3.f,
		64.f*7.f,0.f,
		1024.f,1024.f,0);

	gentexturecoords(&balltexturecoords[0],
		128.f,128.f,
		64.f*8.f,0.f,
		1024.f,1024.f,0);

	for(int y=0;y<3;y++)for(int x=0;x<3;x++){
		gentexturecoords(
			&buttontexturecoords[0][y*3+x][0],
			64.f,64.f,
			6.f*64.f+(float)x*64.f,
			10.f*64.f+(float)y*64.f,
			1024.f,1024.f,7.5f);
		gentexturecoords(
			&buttontexturecoords[1][y*3+x][0],
			64.f,64.f,
			9.f*64.f+(float)x*64.f,
			10.f*64.f+(float)y*64.f,
			1024.f,1024.f,7.5f);
	}

	gentexturecoords(&ltextbackingtexturecoords[0],
		-64.f*4.f,64.f*3.f,
		1024.f,0.f,
		1024.f,1024.f,5);

	gentexturecoords(&rtextbackingtexturecoords[0],
		64.f*4.f,64.f*3.f,
		64.f*12.f,0.f,
		1024.f,1024.f,5);

}

void button(float posx,float posy,float sizex,float sizey,bool glow){
	float edgesize=32.f;
	draw2dquad(
		posx-edgesize,	posy-edgesize,
		edgesize,		edgesize,
		buttontexturecoords[glow][0],0,0.f);
	draw2dquad(
		posx,			posy-edgesize,
		sizex,			edgesize,
		buttontexturecoords[glow][1],0,0.f);
	draw2dquad(
		posx+sizex,		posy-edgesize,
		edgesize,		edgesize,
		buttontexturecoords[glow][2],0,0.f);
	if(sizey>0.f){
		draw2dquad(
			posx-edgesize,	posy,
			edgesize,		sizey,
			buttontexturecoords[glow][3],0,0.f);
		draw2dquad(
			posx,			posy,
			sizex,			sizey,
			buttontexturecoords[glow][4],0,0.f);
		draw2dquad(
			posx+sizex,		posy,
			edgesize,		sizey,
			buttontexturecoords[glow][5],0,0.f);
	}
	draw2dquad(
		posx-edgesize,	posy+sizey,
		edgesize,		edgesize,
		buttontexturecoords[glow][6],0,0.f);
	draw2dquad(
		posx,			posy+sizey,
		sizex,			edgesize,
		buttontexturecoords[glow][7],0,0.f);
	draw2dquad(
		posx+sizex,		posy+sizey,
		edgesize,		edgesize,
		buttontexturecoords[glow][8],0,0.f);
}
