#ifdef OPENGL
GLuint worldtexture = NULL;
#endif

#ifdef RSX
#include "worldtexture.bin.h"
Image worldtexture_image;
#endif

#ifdef GX
GXTexObj worldtexture_GXTexObj;
TPLFile worldtextureTPL;
#include "worldtexture_tpl.h"
#include "worldtexture.h"
#endif

void gentexturecoords(float (*coords),
					  float xsize,float ysize,
					  float xoffset,float yoffset,
					  float fullsizex,float fullsizey,
					  float indent){
	if(indent>0.f){
		if(xsize>=0.f){xsize-=indent*2.f;}else{xsize+=indent*2.f;}
		if(ysize>=0.f){ysize-=indent*2.f;}else{ysize+=indent*2.f;}
		if(xsize>=0.f){xoffset+=indent;}else{xoffset-=indent;}
		if(ysize>=0.f){yoffset+=indent;}else{yoffset-=indent;}
	}
	xsize/=fullsizex;
	ysize/=fullsizey;
	xoffset/=fullsizex;
	yoffset/=fullsizey;
	coords[0]=xoffset;
	coords[1]=yoffset+ysize;
	coords[2]=xoffset+xsize;
	coords[3]=yoffset+ysize;
	coords[4]=xoffset+xsize;
	coords[5]=yoffset;
	coords[6]=xoffset;
	coords[7]=yoffset;
}

void setuptextures(){

	//load textures
	#ifdef OPENGL
	worldtexture=loadtexture((char*)"Media/worldtexture.png",mipmapping);
	#endif
	#ifdef RSX	
	worldtexture_image = loadPng(worldtexture_bin);
	#endif
	#ifdef GX
	TPL_OpenTPLFromMemory(&worldtextureTPL,(void *)worldtexture_tpl,worldtexture_tpl_size);
	TPL_GetTexture(&worldtextureTPL,worldtexture,&worldtexture_GXTexObj);
	#endif

}
