void play(float gamespeed){

	//score
	score+=0.1f*gamespeed;

	if(playerposy>=1.4f){
		if(score>highscore)highscore=score;
		score=0.f;
		resetgame();
	}

	//turn
	#ifdef WIN
	bool left=0,right=0;
	if(keystate[SDLK_a]|keystate[SDLK_LEFT])left=1;
	if(keystate[SDLK_d]|keystate[SDLK_RIGHT])right=1;
	playerturnspeed+=((float)right-(float)left)*0.0045f*gamespeed;
	#endif
	#ifdef PS3
	playerturnspeed+=lowfloat(1.f,highfloat(-1.f,((float)paddata[0].ANA_L_H-128.f)/128.f+((float)paddata[0].ANA_R_H-128.f)/128.f))*0.0045f*gamespeed;
	#endif
	#ifdef WII
	playerturnspeed-=lowfloat(1.f,highfloat(-1.f,(float)gforce[0].y*0.95f))*0.0045f*gamespeed;
	#endif
	playerangy+=playerturnspeed*gamespeed;
	playerturnspeed*=(1.f-0.075*gamespeed);

	//you trigger blocks when you fly over them
	if(map[(int)floor(playerposx)][(int)floor(playerposz)]==0
	&& mapheight[(int)floor(playerposx)][(int)floor(playerposz)]<0.f)
		map[(int)floor(playerposx)][(int)floor(playerposz)]=1;

	//triggered blocks raise up
	for(int x=0;x<mapsizex;x++)for(int z=0;z<mapsizez;z++)if(map[x][z]!=0){
		mapheight[x][z]+=0.015f*gamespeed;
		if(mapheight[x][z]>1.f)mapheight[x][z]=1.f;
	}
	
	//keep track of the starting position
	float oldx=playerposx;
	float oldy=playerposy;
	float oldz=playerposz;
	//constant forward motion
	playermovx+=cos(playerangy)*0.02f*gamespeed;
	playermovz+=sin(playerangy)*0.02f*gamespeed;
	//gravity
	playermovy-=0.02f*gamespeed;
	//movement takes effect
	playerposx+=playermovx*gamespeed;
	playerposy+=playermovy*gamespeed;
	playerposz+=playermovz*gamespeed;
	//bump into blocks
	bumpintoworld(&playerposx,&playerposy,&playerposz,0.4f);
	//correct movement speed
	playermovx=(playerposx-oldx)/gamespeed;
	playermovy=(playerposy-oldy)/gamespeed;
	playermovz=(playerposz-oldz)/gamespeed;
	//lose some movement speed
	playermovx*=(1.f-0.2*gamespeed);
	playermovy*=(1.f-0.125*gamespeed);
	playermovz*=(1.f-0.2*gamespeed);

	//update the camera
	camangx=37.5f*radiansindegree;
	camangy+=(playerangy+90.f*radiansindegree-camangy)*0.1f*gamespeed;
	camangz=0.f;
	camposx=playerposx;
	camposy=playerposy+0.85f;
	camposz=playerposz;
	float camdist=4.f;
	camposx+=camdist*cos(camangx)*cos(camangy+90.f*radiansindegree);
	camposy+=camdist*sin(camangx);
	camposz+=camdist*cos(camangx)*sin(camangy+90.f*radiansindegree);
	camposx=camposx*0.85f+playerposx*0.15f;
	camposz=camposz*0.85f+playerposz*0.15f;

}
