void drawworld(){

	//prep for drawing
	#ifdef OPENGL
	glEnable(GL_TEXTURE_2D);
	glEnableClientState(GL_VERTEX_ARRAY);
	glEnableClientState(GL_TEXTURE_COORD_ARRAY);
	#endif

	//setup the camera
	set3dcamera(
		camposx,camposy,camposz,
		//camangx,camangy,camangz,
		camangx,camangy,camangz,
		camfov,screena,camnear,camfar);

	//use the world texture
	#ifdef OPENGL
	glBindTexture(GL_TEXTURE_2D,worldtexture);
	#endif
	#ifdef GX
	GX_LoadTexObj(&worldtexture_GXTexObj,GX_TEXMAP0);
	#endif
	#ifdef RSX
	usetexture(worldtexture_image);
	#endif

	//draw the tops of blocks
	if(1){
		float xoffset=1;
		float yoffset=1;
		float xsize=2;
		float ysize=2;
		xoffset*=64.f/1024.f;
		yoffset*=64.f/1024.f;
		xsize*=64.f/1024.f;
		ysize*=64.f/1024.f;
		float texturearray[]={
			xoffset,		yoffset+ysize,
			xoffset+xsize,	yoffset+ysize,
			xoffset+xsize,	yoffset,
			xoffset,		yoffset,};
		for(int x=1;x<mapsizex-1;x++)for(int z=1;z<mapsizez-1;z++){
			float vertexarray[]={
				(float)x+1.f,	highfloat(0.f,mapheight[x][z]),	(float)z+1.f,
				(float)x+1.f,	highfloat(0.f,mapheight[x][z]),	(float)z,
				(float)x,		highfloat(0.f,mapheight[x][z]),	(float)z,
				(float)x,		highfloat(0.f,mapheight[x][z]),	(float)z+1.f,};
			draw3dquadmesh(4,&vertexarray[0],&texturearray[0],NULL,NULL);
		}
	}

	//draw the sides of blocks
	for(int a=0;a<5;a++){
		float xoffset=0,yoffset=0,xsize=0,ysize=0;
		xoffset=1;
		if(a==0)yoffset=1;
		if(a==1)yoffset=4;
		if(a==2)yoffset=7;
		if(a==3)yoffset=10;
		if(a==4)yoffset=13;
		xsize=2;
		ysize=2;
		xoffset*=64.f/1024.f;
		yoffset*=64.f/1024.f;
		xsize*=64.f/1024.f;
		ysize*=64.f/1024.f;
		float texturearray[]={
			xoffset,		yoffset+ysize,
			xoffset+xsize,	yoffset+ysize,
			xoffset+xsize,	yoffset,
			xoffset,		yoffset,};
		for(int x=1;x<mapsizex-1;x++)for(int z=1;z<mapsizez-1;z++)if(map[x][z]==a){
			if(mapheight[x][z]>mapheight[x-1][z]){
				float vertexarray[]={
					(float)x,	highfloat(0.f,mapheight[x][z])-1.f,	(float)z,
					(float)x,	highfloat(0.f,mapheight[x][z])-1.f,	(float)z+1.f,
					(float)x,	highfloat(0.f,mapheight[x][z]),		(float)z+1.f,
					(float)x,	highfloat(0.f,mapheight[x][z]),		(float)z,};
				draw3dquadmesh(4,&vertexarray[0],&texturearray[0],NULL,NULL);
			}
			if(mapheight[x][z]>mapheight[x][z-1]){
				float vertexarray[]={
					(float)x+1.f,	highfloat(0.f,mapheight[x][z])-1.f,	(float)z,
					(float)x,		highfloat(0.f,mapheight[x][z])-1.f,	(float)z,
					(float)x,		highfloat(0.f,mapheight[x][z]),		(float)z,
					(float)x+1.f,	highfloat(0.f,mapheight[x][z]),		(float)z,};
				draw3dquadmesh(4,&vertexarray[0],&texturearray[0],NULL,NULL);
			}
			if(mapheight[x][z]>mapheight[x+1][z]){
				float vertexarray[]={
					(float)x+1.f,	highfloat(0.f,mapheight[x][z])-1.f,	(float)z+1.f,
					(float)x+1.f,	highfloat(0.f,mapheight[x][z])-1.f,	(float)z,
					(float)x+1.f,	highfloat(0.f,mapheight[x][z]),		(float)z,
					(float)x+1.f,	highfloat(0.f,mapheight[x][z]),		(float)z+1.f,};
				draw3dquadmesh(4,&vertexarray[0],&texturearray[0],NULL,NULL);
			}
			if(mapheight[x][z]>mapheight[x][z+1]){
				float vertexarray[]={
					(float)x,		highfloat(0.f,mapheight[x][z])-1.f,	(float)z+1.f,
					(float)x+1.f,	highfloat(0.f,mapheight[x][z])-1.f,	(float)z+1.f,
					(float)x+1.f,	highfloat(0.f,mapheight[x][z]),		(float)z+1.f,
					(float)x,		highfloat(0.f,mapheight[x][z]),		(float)z+1.f,};
				draw3dquadmesh(4,&vertexarray[0],&texturearray[0],NULL,NULL);
			}
		}
	}

	savecammatrix();
	translatecam(playerposx,playerposy,playerposz);
	rotatecam(180-playerangy*degreesinradian,0,1,0);
	rotatecam(-playerturnspeed*950,1,0,0);
	scalecam(0.05f,0.05f,0.05f);
	draw3dtrianglemesh(shipvertexcount,shipvertexarray,shiptexturearray,NULL,NULL);
	loadcammatrix();

	//hud
	set2dcamera(-400.f,400.f,-400.f*screena,400.f*screena);
	#ifdef OPENGL
	glEnable(GL_BLEND);
	glEnable(GL_ALPHA_TEST);
	#endif
	#ifdef GX
	GX_SetBlendMode(GX_BM_BLEND, GX_BL_SRCALPHA, GX_BL_INVSRCALPHA, GX_LO_CLEAR);
	GX_SetAlphaUpdate(GX_TRUE);
	#endif

	char temptext[256];
	sprintf(temptext,"%s%i","Highscore ",(int)floor(highscore));
	drawtext(-350,-350,(char*)temptext,0.75f);
	sprintf(temptext,"%s%i","Score     ",(int)floor(score));
	drawtext(-350,-325,(char*)temptext,0.75f);

	#ifdef OPENGL
	glDisable(GL_BLEND);
	glDisable(GL_ALPHA_TEST);
	#endif
	#ifdef GX
	GX_SetAlphaUpdate(GX_FALSE);
	#endif

	//done drawing
	#ifdef OPENGL
	glDisableClientState(GL_VERTEX_ARRAY);
	glDisableClientState(GL_TEXTURE_COORD_ARRAY);
	glDisable(GL_TEXTURE_2D);
	#endif

}
