void bumpintosideofblock(float *posx,float *posy,float *posz,float radius,
						 float blockx,float blockw,
						 float blocky,float blockh,
						 float blockz,float blockd){
	//check if you are close enough for a collission to be possible
	if(*posx+radius>blockx && *posx-radius<blockx+blockw
	&& *posy+radius>blocky && *posy-radius<blocky+blockh
	&& *posz+radius>blockz && *posz-radius<blockz+blockd)
	//just give up and do nothing if you are already inside it
	if(*posx<blockx || *posx>blockx+blockw
	|| *posy<blocky || *posy>blocky+blockh
	|| *posz<blockz || *posz>blockz+blockd){
		//hit the top or bottom side
		if(*posx>blockx && *posx<blockx+blockw
		&& *posz>blockz && *posz<blockz+blockd){
			if(*posy<blocky+blockh*0.5f){
				*posy=blocky-radius;
			}else{
				*posy=blocky+blockh+radius;
			}
		}else
		//hit the left or right side
		if(*posy>blocky && *posy<blocky+blockh
		&& *posz>blockz && *posz<blockz+blockd){
			if(*posx<blockx+blockw*0.5f){
				*posx=blockx-radius;
			}else{
				*posx=blockx+blockw+radius;
			}
		}else
		//hit the front or back side
		if(*posy>blocky && *posy<blocky+blockh
		&& *posx>blockx && *posx<blockx+blockw){
			if(*posz<blockz+blockd*0.5f){
				*posz=blockz-radius;
			}else{
				*posz=blockz+blockd+radius;
			}
		}
	}
}

void bumpintoedgeofblock(float *posx,float *posy,float *posz,float radius,
						 float blockx,float blockw,
						 float blocky,float blockh,
						 float blockz,float blockd){
	//check if you are close enough for a collission to be possible
	if(*posx+radius>blockx && *posx-radius<blockx+blockw
	&& *posy+radius>blocky && *posy-radius<blocky+blockh
	&& *posz+radius>blockz && *posz-radius<blockz+blockd)
	//just give up and do nothing if you are already inside it
	if(*posx<blockx || *posx>blockx+blockw
	|| *posy<blocky || *posy>blocky+blockh
	|| *posz<blockz || *posz>blockz+blockd){
		//usefull variables
		float impactx=0,impacty=0,impactz=0;
		//get where the collission would occure
		if(*posx>blockx+blockw){impactx=blockx+blockw;}
		else if(*posx<blockx){impactx=blockx;}
		else{impactx=*posx;}
		if(*posy>blocky+blockh){impacty=blocky+blockh;}
		else if(*posy<blocky){impacty=blocky;}
		else{impacty=*posy;}
		if(*posz>blockz+blockd){impactz=blockz+blockd;}
		else if(*posz<blockz){impactz=blockz;}
		else{impactz=*posz;}
		//check if its actually colliding
		float distance=dist3d(*posx,*posy,*posz,impactx,impacty,impactz);
		if(distance<radius && distance!=0.f){
			//and push back if it is
			float percentx=(*posx-impactx)/distance;
			float percenty=(*posy-impacty)/distance;
			float percentz=(*posz-impactz)/distance;
			*posx=impactx+percentx*radius;
			*posy=impacty+percenty*radius;
			*posz=impactz+percentz*radius;
		}
	}
}

void bumpintoworld(float *posx,float *posy,float *posz,float radius){

	int xgridpos=(int)floor(*posx);
	int zgridpos=(int)floor(*posz);
	int range=(int)floor(radius)+1;

	for(int x=highint(0,xgridpos-range);x<lowint(mapsizex,xgridpos+range+1);x++)
	for(int z=highint(0,zgridpos-range);z<lowint(mapsizez,zgridpos+range+1);z++)
		bumpintosideofblock(posx,posy,posz,radius,(float)x,1.f,0.f,highfloat(0.f,mapheight[x][z]),(float)z,1.f);

	for(int x=highint(0,xgridpos-range);x<lowint(mapsizex,xgridpos+range+1);x++)
	for(int z=highint(0,zgridpos-range);z<lowint(mapsizez,zgridpos+range+1);z++)
		bumpintoedgeofblock(posx,posy,posz,radius,(float)x,1.f,0.f,highfloat(0.f,mapheight[x][z]),(float)z,1.f);

}