#include "projectspecific/meshes/ship.h"

#define mapsizex (55)
#define mapsizez (55)
int map[mapsizex][mapsizez];
float mapheight[mapsizex][mapsizez];

float camposx,camposy,camposz;
float camangx,camangy,camangz;
float camfov,camnear,camfar;

float playerposx,playerposy,playerposz;
float playermovx,playermovy,playermovz;
float playerangy;
float playerturnspeed;

float score=0.f,highscore=0.f;

void resetgame(){
	for(int x=0;x<mapsizex;x++)for(int z=0;z<mapsizez;z++)map[x][z]=0;
	for(int x=0;x<mapsizex;x++)for(int z=0;z<mapsizez;z++){
		if(x==1 || x==mapsizex-2 || z==1 || z==mapsizez-2){
			mapheight[x][z]=1.f;
		}else{
			mapheight[x][z]=-0.25f;
		}
	}
	camposx=mapsizex*0.5f;
	camposy=25.f;
	camposz=mapsizez*0.5f;
	camangx=0.f;
	camangy=90.f*radiansindegree;
	camangz=0.f;
	camfov=50.f;
	camnear=0.1f;
	camfar=1000.f;
	playerposx=mapsizex*0.5f;
	playerposy=0.5f;
	playerposz=mapsizez*0.5f;
	playermovx=0.f;
	playermovy=0.f;
	playermovz=0.f;
	playerangy=0.f;
	playerturnspeed=0.f;
}

#include "projectspecific/textures.h"
#include "projectspecific/bumpintoworld.h"
#include "projectspecific/play.h"
#include "projectspecific/text.h"
#include "projectspecific/drawworld.h"

void projectsetup(){

	//feed info to the dashboard
	sprintf(dash_bars_gamename,"%s","Neo Trail");
	dash_bars_gameversion=0.2;

	setuptextures();
	setuptext();

	for(int a=0;a<shipvertexcount/3;a++){
		shiptexturearray[a*3*2+0]=4*64.f/1024.f;
		shiptexturearray[a*3*2+1]=4*64.f/1024.f;
		shiptexturearray[a*3*2+2]=4*64.f/1024.f;
		shiptexturearray[a*3*2+3]=6*64.f/1024.f;
		shiptexturearray[a*3*2+4]=6*64.f/1024.f;
		shiptexturearray[a*3*2+5]=6*64.f/1024.f;
	}

	resetgame();

}
