/*
  Project: Extract metldr
  Author: Nicola Dalle Ave <rancido@ps3ita.it>
  Copyright: 2012 Nicola Dalle Ave
  License: GPL-2+
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.
*/

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>

#define MAGIC_NUMBER		0xffe0ac0f
#define	MAGIC2_NUMBER		0xEFBEADDE

#define OFF_MAGIC_NOR		0x14
#define OFF_MAGIC2_NOR		0x1C
#define OFF_MAGIC_NAND		0x40014
#define OFF_MAGIC_NAND2		0x4001C

#define METLDR_HEADER 		0x40
#define METLDR_NAME			"metldr"
#define METLDR_START_NOR	0x840
#define METLDR_START_NAND	0x40840


uint16_t swap_word( uint16_t valore )
{
    return ((valore>>8)&0x00FF) | ((valore<<8)&0xFF00);
}


int main( int argv, char *argc[ ] )
{

    FILE *flash_dump;
    FILE *metldr;
    uint32_t magic;
    uint64_t off_head_metldr, off_name_metldr, off_len_metldr;
    uint8_t header;
    char name[ 8 ];
    uint16_t len_metldr;
    int tmp = 0;

    if( argv != 3 )
    {
        printf( "Usage: %s <flash.bin> <destination>\n", argc[ 0 ] );
        exit( 1 );
    }

    flash_dump = fopen( argc[ 1 ], "rb" );
    if( flash_dump == NULL )
    {
        perror( "Error opening file\n" );
        exit( 1 );
    }

    char *flash_type;

    fseek( flash_dump, OFF_MAGIC_NOR, SEEK_SET );
    fread( &magic, 1, sizeof( uint32_t ), flash_dump );

    if( magic == MAGIC_NUMBER )
    {
        fseek( flash_dump, OFF_MAGIC2_NOR, SEEK_SET );
        fread( &magic, 1, sizeof( uint32_t ), flash_dump );

        if( magic != MAGIC2_NUMBER )
        {
            printf( "\nERROR!! Nor dump is not valid!!\n" );
            exit( 1 );
        }
        else
        {
            flash_type = "NOR";

            off_head_metldr = 0x817;
            off_name_metldr = 0x820;
            off_len_metldr	= 0x81E;
        }
    }
    else
    {
        fseek( flash_dump, OFF_MAGIC_NAND, SEEK_SET );
        fread( &magic, 1, sizeof( uint32_t ), flash_dump );

        if( magic != MAGIC_NUMBER )
        {
            printf( "\nERROR!! Dump is not valid!!\n" );
            exit( 1 );
        }
        else
        {
            fseek( flash_dump, OFF_MAGIC_NAND2, SEEK_SET );
            fread( &magic, 1, sizeof( uint32_t ), flash_dump );

            if( magic != MAGIC2_NUMBER )
            {
                printf( "\nERROR!! NAND dump is not valid!!\n" );
                exit( 1 );
            }

            else
            {
                flash_type = "NAND";

                off_head_metldr = 0x40817;
                off_name_metldr = 0x40820;
                off_len_metldr	= 0x4081E;
            }
        }
    }

    fseek( flash_dump, off_head_metldr, SEEK_SET );
    fread( &header, 1, 1, flash_dump );

    if( header != METLDR_HEADER )
    {
        printf( "\nERROR!! %s dump is not valid!!\n", flash_type );
        exit( 1 );
    }

    fseek( flash_dump, off_name_metldr, SEEK_SET );
    fread( name, 1, sizeof( name ), flash_dump );

    if( strcmp( name, METLDR_NAME ) != 0 )
    {
        printf( "\nERROR!! %s dump is not valid!!\n", flash_type );
        exit( 1 );
    }

    fseek( flash_dump, off_len_metldr, SEEK_SET );
    fread( &len_metldr, 1, sizeof( uint16_t ), flash_dump );

    len_metldr = swap_word( len_metldr );

    uint8_t read[ len_metldr ];
    int i;
    int buf = 0;

    if( strcmp( flash_type, "NAND" ) == 0 )
        fseek( flash_dump, METLDR_START_NAND, SEEK_SET );

    else
        fseek( flash_dump, METLDR_START_NOR, SEEK_SET );

    for( i = 0; buf < len_metldr; i++ )
    {
        tmp = fread( &read[ i ], 1, 1, flash_dump );
        buf = buf + tmp;
    }
    fclose( flash_dump );

    metldr = fopen( argc[ 2 ], "wb" );
    fwrite( read, sizeof( read ), 1, metldr );

    fclose( metldr );

    printf( "Metldr successfully extracted! :D\n" );

    return 0;
}
