#include "NoRSX_image.h"

struct _NoRSX NoRSX;

//Load
	//Load image from file(automatically detects the extension)
		NoRSX_Image *NoRSX_LoadIMG(const char* filename){
			char *file_extension = NoRSX_GetFileExtension(filename);		
			if(file_extension == NULL)
				return NULL;
				
			NoRSX_Image *image = (NoRSX_Image *)malloc(sizeof(NoRSX_Image *));
			if(strcmp(file_extension, "png") == 0 || strcmp(file_extension, "PNG") == 0){
				NoRSX_LoadPNG(filename);
			}else if(strcmp(file_extension, "jpg") == 0 || strcmp(file_extension, "JPG") == 0){
				NoRSX_LoadPNG(filename);	
			}		
			return image;
		}
	//PNG from file
		NoRSX_Image *NoRSX_LoadPNG(const char* filename){
			pngData *png = (pngData *)malloc(sizeof(pngData *));
			NoRSX_Image *image = (NoRSX_Image *)malloc(sizeof(NoRSX_Image *));
			pngLoadFromFile(filename, png);
			image->w = png->width;
			image->h = png->height;
			image->type = PNG;
			image->data = (void *)png;
			return image;
		}
	//JPG from file
		NoRSX_Image *NoRSX_LoadJPG(const char* filename){
			jpgData *jpg = (jpgData *)malloc(sizeof(jpgData *));
			NoRSX_Image *image = (NoRSX_Image *)malloc(sizeof(NoRSX_Image *));
			jpgLoadFromFile(filename, jpg);
			image->w = jpg->width;
			image->h = jpg->height;
			image->type = JPG;
			image->data = (void *)jpg;
			return image;
		}
	//PNG from buffer
		NoRSX_Image *NoRSX_LoadPNG_Buf(const void* name, u32 name_size){
			pngData *png = (pngData *)malloc(sizeof(pngData *));
			NoRSX_Image *image = (NoRSX_Image *)malloc(sizeof(NoRSX_Image *));
			pngLoadFromBuffer(name, name_size, png);
			image->w = png->width;
			image->h = png->height;
			image->type = PNG;
			image->data = (void *)png;
			return image;
		}
	//JPG from buffer
		NoRSX_Image *NoRSX_LoadJPG_Buf(const void* name, u32 name_size){
			jpgData *jpg = (jpgData *)malloc(sizeof(jpgData *));
			NoRSX_Image *image = (NoRSX_Image *)malloc(sizeof(NoRSX_Image *));
			jpgLoadFromBuffer(name, name_size, jpg);
			image->w = jpg->width;
			image->h = jpg->height;
			image->type = JPG;
			image->data = (void *)jpg;
			return image;
		}
//Image manipulation
	//Get image width
		int NoRSX_ImageW(NoRSX_Image *image){
			return image->w;
		}
	//Get image height
		int NoRSX_ImageH(NoRSX_Image *image){
			return image->h;
		}
//Draw (blit)
	//Draw PNG
		void NoRSX_DrawPNG(NoRSX_Image *image, int x, int y){
			pngData *png = (pngData *)(image->data);
			if( image->type == PNG && png->bmp_out){
				u32 *scr = (u32 *)NoRSX.screen.buffers[NoRSX.screen.currentBuffer].ptr;
				u32 *png_data = (u32 *)(void *)png->bmp_out;
				unsigned int n, m;
				scr += x + y * NoRSX.screen.buffers[NoRSX.screen.currentBuffer].width;
				for(n = 0; n < png->height; n++){
					if( (y + n) >= NoRSX.screen.buffers[NoRSX.screen.currentBuffer].height) break;
					for( m = 0; m < png->width; m++){
						if( (x + m) >= NoRSX.screen.buffers[NoRSX.screen.currentBuffer].width) break;
						scr[m] = png_data[m];
					}
					png_data += png->pitch>>2;
					scr += NoRSX.screen.buffers[NoRSX.screen.currentBuffer].width;
				}		
			}	
		}
	//Draw JPG
		void NoRSX_DrawJPG(NoRSX_Image *image, int x, int y){
			jpgData *jpg = (jpgData *)(image->data);
			if( image->type == JPG && jpg->bmp_out){
				u32 *scr = (u32 *)NoRSX.screen.buffers[NoRSX.screen.currentBuffer].ptr;
				u32 *jpg_data = (u32 *)(void *)jpg->bmp_out;
				unsigned int n, m;
				scr += x + y * NoRSX.screen.buffers[NoRSX.screen.currentBuffer].width;
				for(n = 0; n < jpg->height; n++){
					if((y + n) >= NoRSX.screen.buffers[NoRSX.screen.currentBuffer].height) break;
					for(m=0; m < jpg->width; m++){
						if((x + m) >= NoRSX.screen.buffers[NoRSX.screen.currentBuffer].width) break;
						scr[m] = jpg_data[m];
					}
					jpg_data += jpg->pitch>>2;
					scr += NoRSX.screen.buffers[NoRSX.screen.currentBuffer].width;
				}		
			}
		}
	//Draw an image
		void NoRSX_DrawIMG(NoRSX_Image *image, int x, int y){
			switch(image->type){
				case PNG:
					NoRSX_DrawPNG(image, x, y);
					break;
				case JPG:
					NoRSX_DrawJPG(image, x, y);
					break;			
				default:
					break;
			}
		}
	//Draw partial image PNG
		void NoRSX_DrawPartialImagePNG(NoRSX_Image *image, int x, int y, unsigned int s_width, unsigned int s_height,
											 unsigned int e_width, unsigned int e_height, unsigned int bg, unsigned int color){
										
			pngData	*img = (pngData *)image->data;
			if(img->bmp_out){
				u32 *scr = (u32 *)NoRSX.screen.buffers[NoRSX.screen.currentBuffer].ptr;
				u32 *image_data = (u32 *)(void *)img->bmp_out;	
				unsigned int n, m;

				scr += x + y * NoRSX.screen.buffers[NoRSX.screen.currentBuffer].width;
				
				if(s_height > 0)
					for(unsigned int i = 0; i < s_height; i++)
						image_data += img->pitch>>2;
					
				for(n = s_height; n < e_height + s_height; n++){
					if((y + n) >= NoRSX.screen.buffers[NoRSX.screen.currentBuffer].height) break;
					for(m = s_width; m < e_width + s_width; m++){
						if((x + m) >= NoRSX.screen.buffers[NoRSX.screen.currentBuffer].width) break;
						if(image_data[m] != bg)
							scr[m - s_width]=color;
					}
					image_data += img->pitch>>2;
					scr += NoRSX.screen.buffers[NoRSX.screen.currentBuffer].width;
				}
			}
		}

		//Draw partial image JPG
			void NoRSX_DrawPartialImageJPG(NoRSX_Image *image, int x, int y, unsigned int s_width, unsigned int s_height,
											 unsigned int e_width, unsigned int e_height, unsigned int bg, unsigned int color){
											
				jpgData	*img = (jpgData *)image->data;
				if(img->bmp_out){
					u32 *scr = (u32 *)NoRSX.screen.buffers[NoRSX.screen.currentBuffer].ptr;
					u32 *image_data = (u32 *)(void *)img->bmp_out;	
					unsigned int n, m;
					
					scr += x + y * NoRSX.screen.buffers[NoRSX.screen.currentBuffer].width;		
					if(s_height > 0)
						for(unsigned int i = 0; i < s_height; i++)
							image_data += img->pitch>>2;
						
					for(n = s_height; n < e_height + s_height; n++){
						if((y + n) >= NoRSX.screen.buffers[NoRSX.screen.currentBuffer].height) break;
						for(m = s_width; m < e_width + s_width; m++){
							if((x + m) >= NoRSX.screen.buffers[NoRSX.screen.currentBuffer].width) break;
							if(image_data[m] != bg)
								scr[m - s_width]=color;
						}
						image_data += img->pitch>>2;
						scr += NoRSX.screen.buffers[NoRSX.screen.currentBuffer].width;
					}
				}
			}
	//Draw partial image
		void NoRSX_DrawPartialImage(NoRSX_Image *image, int x, int y, unsigned int s_width, unsigned int s_height,
											 unsigned int e_width, unsigned int e_height, unsigned int bg, unsigned int color){
			switch(image->type){
				case PNG:
					NoRSX_DrawPartialImagePNG(image, x, y, s_width, s_height, e_width, e_height, bg, color);
					break;
				case JPG:
					NoRSX_DrawPartialImageJPG(image, x, y, s_width, s_height, e_width, e_height, bg, color);
					break;			
				default:
					break;
			}
		}



		



		