#include "NoRSX_font.h"

struct _NoRSX NoRSX;

const char Alphabet[]={  'A','B','C','D','E','F','G','H','I','J','K','L','M'	//12
						,'N','O','P','Q','R','S','T','U','V','W','X','Y','Z'	//13 (25)
						,',','.',';','!','?',' '								//6  (31)
						,'1','2','3','4','5','6','7','8','9','0'				//10 (41)
};	

//Font
	//Load font from file(image)
		NoRSX_Font *NoRSX_LoadFont(const char* filename){
			NoRSX_Font *font = (NoRSX_Font *)malloc(sizeof(NoRSX_Font *));
			font->image = NoRSX_LoadIMG(filename);
			return font;
		}
	//Load PNG from buffer
		NoRSX_Font *NoRSX_LoadFontPNG_Buf(const void* name, u32 name_size){
			NoRSX_Font *font = (NoRSX_Font *)malloc(sizeof(NoRSX_Font *));
			font->image = NoRSX_LoadPNG_Buf(name, name_size);
			return font;
		}
	//Load JPG from buffer
		NoRSX_Font *NoRSX_LoadFontJPG_Buf(const void* name, u32 name_size){
			NoRSX_Font *font = (NoRSX_Font *)malloc(sizeof(NoRSX_Font *));
			font->image = NoRSX_LoadJPG_Buf(name, name_size);
			return font;
		}
	//Print with the font
		void NoRSX_FontPrint(NoRSX_Font *font, int x, int y, unsigned int color, const char *txt){
			unsigned int k, H, K;
			if (x >= 0 && y >= 0){
				for(unsigned int i = 0; i < strlen(txt); i++){
					H = 0; K = 0;
					for(k = 0; k < strlen(Alphabet); k++)
						if(txt[i] == Alphabet[k])break;
					 if(k <= 12){
						K = k;
					}else if(k > 12){
						H = 1;
						if(k > 25){
							H = 2;
							if(k > 31){
								H = 3;
								K = k - 32;
							}else{
								K = k - 26;
							}
						}else{
							K = k - 13;
						}
					}
					NoRSX_DrawPartialImage(font->image, x + (i * 24), y, K * 24, H * 20, 24, 20, 0xffffffff, color);
				}
			}	
		
		}
	//Print formatted with the font
		void NoRSX_FontPrintf(NoRSX_Font *font, int x, int y, unsigned int color, const char *a, ...){
			char msg[1024];
			va_list va;
			va_start(va, a);
			vsnprintf(msg, sizeof(msg), a, va);
			NoRSX_FontPrint(font, x, y, color, msg);		
		}





		



		