#include "NoRSX_draw.h"

struct _NoRSX NoRSX;

//Draw

	//Draw pixel
		int NoRSX_drawPixel(u32 x, u32 y, u32 color){
			if( y >= NoRSX.screen.buffers[NoRSX.screen.currentBuffer].height || y < 0) return -1;
			if( x >= NoRSX.screen.buffers[NoRSX.screen.currentBuffer].width  || x < 0) return -1;
			NoRSX.screen.buffers[NoRSX.screen.currentBuffer].ptr[x + y * NoRSX.screen.buffers[NoRSX.screen.currentBuffer].width ] = color;
			return 1;
		}
	//Draw pixel4
		void NoRSX_drawPixel4(u32 x, u32 y, u32 color){
			NoRSX_drawPixel(x  ,y  , color);
			NoRSX_drawPixel(x+1,y  , color);
			NoRSX_drawPixel(x  ,y+1, color);
			NoRSX_drawPixel(x+1,y+1, color);
		}
	//Draw horizontal line
		void NoRSX_drawHline(u32 y, u32 x0, u32 x1, u32 color){
			if(x0 < x1){
				for(int i = x0; i < x1; i++)
					NoRSX.screen.buffers[NoRSX.screen.currentBuffer].ptr[i + y * NoRSX.screen.buffers[NoRSX.screen.currentBuffer].width ] = color;	
			}else{
				for(int i = x1; i < x0; i++)
					NoRSX.screen.buffers[NoRSX.screen.currentBuffer].ptr[i + y * NoRSX.screen.buffers[NoRSX.screen.currentBuffer].width ] = color;	
			}
		}		
	//Draw vertical line
		void NoRSX_drawVline(u32 x, u32 y0, u32 y1, u32 color){
			if(y0 < y1){
				for(int i = y0; i < y1; i++)
					NoRSX.screen.buffers[NoRSX.screen.currentBuffer].ptr[x + i * NoRSX.screen.buffers[NoRSX.screen.currentBuffer].width ] = color;	
			}else{
				for(int i = y1; i < y0; i++)
					NoRSX.screen.buffers[NoRSX.screen.currentBuffer].ptr[x + i * NoRSX.screen.buffers[NoRSX.screen.currentBuffer].width ] = color;
			}
		}	
	//Draw line
		void NoRSX_drawLine(u32 x0, u32 y0, u32 x, u32 y, u32 color){
			int t, distance;
			int xerr = 0, yerr = 0, delta_x, delta_y;
			int incx, incy;

			delta_x = x - x0;
			delta_y = y - y0;

			if(delta_x > 0) incx = 1;
			else if(delta_x == 0) incx = 0;
			else incx =- 1;

			if(delta_y > 0) incy = 1;
			else if(delta_y == 0) incy = 0;
			else incy =- 1;

			delta_x = abs(delta_x);
			delta_y = abs(delta_y);
			if(delta_x > delta_y) distance = delta_x;
			else distance = delta_y;

			/* NoRSX_draw the line */
			for(t = 0; t <= distance+1; t++) {
				NoRSX_drawPixel4(x0, y0, color);
				
				xerr += delta_x;
				yerr += delta_y;
				if(xerr > distance) {
					xerr -= distance;
					x0 += incx;
				}
				if(yerr > distance) {
					yerr -= distance;
					y0 += incy;
				}
			}
		}
	//Draw wired rectangle (only borders)
		void NoRSX_drawRectangle(u32 x, u32 y, u32 w, u32 h, u32 color){
			NoRSX_drawVline(x, y, y + h, color);
			NoRSX_drawVline(x + w, y, y + h, color);
			NoRSX_drawHline(y + h, x, x + w, color);
			NoRSX_drawHline(y, x, x + w, color);
		}	
	//Draw filled rectangle
		void NoRSX_drawFillRect(int x, int y, int w, int h, unsigned int color){
			for(int i = y; i < y + h; i++)
				NoRSX_drawHline(i, x, x + w, color);
		}
	//Draw wired circle (only border)
		void NoRSX_drawCircle(u32 X, u32 Y, u32 r, u32 color){
			u32 width;
			for(u32 y = 0; y < r; y++){
				width = sqrt(r*r - y*y);
				for(u32 x = 0; x < width; x++){
					NoRSX_drawPixel(X+x, Y+y, color);
					NoRSX_drawPixel(X+x, Y-y, color);
					NoRSX_drawPixel(X-x, Y+y, color);
					NoRSX_drawPixel(X-x, Y-y, color);
				}
			}			
		}

	//Fill screen
	void NoRSX_fillScreen(u32 color){
		u32 i, j;
		for(i = 0; i < NoRSX.screen.buffers[NoRSX.screen.currentBuffer].height; i++) {
			for(j = 0; j < NoRSX.screen.buffers[NoRSX.screen.currentBuffer].width; j++)
				NoRSX.screen.buffers[NoRSX.screen.currentBuffer].ptr[i* NoRSX.screen.buffers[NoRSX.screen.currentBuffer].width + j] = color;
		}
	}






		