#include "NoRSX.h"


//Main functions
	//Initialize the lib
		int NoRSX_Init(){
			NoRSX.screen.currentBuffer = 0;
			NoRSX.host_addr = memalign(1024 * 1024, HOST_SIZE);
			NoRSX.screen.context = initScreen(NoRSX.host_addr, HOST_SIZE);
			getResolution(&NoRSX.screen.width, &NoRSX.screen.height);
			for(int i=0; i<2; i++)
				makeBuffer(&NoRSX.screen.buffers[i], NoRSX.screen.width, NoRSX.screen.height, i);
			flip(NoRSX.screen.context, 1);
			setRenderTarget(NoRSX.screen.context, &NoRSX.screen.buffers[NoRSX.screen.currentBuffer]);
			//Load modules
				sysModuleLoad(SYSMODULE_FS);
				sysModuleLoad(SYSMODULE_PNGDEC);
				sysModuleLoad(SYSMODULE_JPGDEC);
			return 1;
		}
	//Flip the buffer
		int NoRSX_Flip(){
			flip(NoRSX.screen.context, NoRSX.screen.buffers[NoRSX.screen.currentBuffer].id); // Flip buffer onto screen
			NoRSX.screen.currentBuffer = !NoRSX.screen.currentBuffer;
			setRenderTarget(NoRSX.screen.context, &NoRSX.screen.buffers[NoRSX.screen.currentBuffer]) ;
			waitFlip();
			return 1;
		}
	//Exit
		int NoRSX_Exit(){
			gcmSetWaitFlip(NoRSX.screen.context);
			for (int i=0; i<2; i++)
				rsxFree(NoRSX.screen.buffers[i].ptr);
			rsxFinish(NoRSX.screen.context, 1);
			free(NoRSX.host_addr);
			//Unload modules
				sysModuleUnload(SYSMODULE_FS);
				sysModuleUnload(SYSMODULE_PNGDEC);
				sysModuleUnload(SYSMODULE_JPGDEC);
			return 1;
		}

//Screen functions
	//Get screen width
		int NoRSX_ScreenW(){
			return NoRSX.screen.width;
		}
	//Get screen height
		int NoRSX_ScreenH(){
			return NoRSX.screen.height;
		}
		
//Other NoRSX functions
	//Get the file extension from a char array
		char *NoRSX_GetFileExtension(const char *filename){
			char *pos = strrchr(filename, '.');
			char *ext = (char *)malloc(sizeof(pos));
			strcpy(ext, ++pos);
			return ext;
		}





	