#ifndef __NORSX_IMAGE_H__
#define __NORSX_IMAGE_H__

#include "NoRSX.h"

#include <pngdec/pngdec.h>
#include <jpgdec/jpgdec.h>
#include <sysutil/sysutil.h>
#include <sysmodule/sysmodule.h>

//Load
	//Load image from file(automatically detects the extension)
		NoRSX_Image *NoRSX_LoadIMG(const char* filename);
	//PNG from file
		NoRSX_Image *NoRSX_LoadPNG(const char* filename);
	//PNG from file
		NoRSX_Image *NoRSX_LoadJPG(const char* filename);
	//PNG from buffer
		NoRSX_Image *NoRSX_LoadPNG_Buf(const void* name, u32 name_size);
	//JPG from buffer
		NoRSX_Image *NoRSX_LoadJPG_Buf(const void* name, u32 name_size);
//Image manipulation
	//Get image width
		int NoRSX_ImageW(NoRSX_Image *image);
	//Get image height
		int NoRSX_ImageH(NoRSX_Image *image);
//Draw(blit)
	//Draw PNG
		void NoRSX_DrawPNG(NoRSX_Image *image, int x, int y);
	//Draw JPG
		void NoRSX_DrawJPG(NoRSX_Image *image, int x, int y);
	//Draw an image
		void NoRSX_DrawIMG(NoRSX_Image *image, int x, int y);
	//Draw partial image PNG
		void NoRSX_DrawPartialImagePNG(NoRSX_Image *image, int x, int y, unsigned int s_width, unsigned int s_height,
											 unsigned int e_width, unsigned int e_height, unsigned int bg, unsigned int color);
	//Draw partial image JPG
		void NoRSX_DrawPartialImageJPG(NoRSX_Image *image, int x, int y, unsigned int s_width, unsigned int s_height,
											 unsigned int e_width, unsigned int e_height, unsigned int bg, unsigned int color);
	//Draw partial image
		void NoRSX_DrawPartialImage(NoRSX_Image *image, int x, int y, unsigned int s_width, unsigned int s_height,
											 unsigned int e_width, unsigned int e_height, unsigned int bg, unsigned int color);
#endif

