#ifndef __NORSX_MAIN_H__
#define __NORSX_MAIN_H__

#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <assert.h>
#include <unistd.h>
#include <math.h>
#include "rsxutil.h"
#include <rsx/rsx.h>
#include <ppu-types.h>
#include <ppu_intrinsics.h>

#ifndef byte
	typedef unsigned char byte;
#endif

//Image types (currently PNG or JPG)
	typedef enum {PNG, JPG}NoRSX_ImageType;


typedef struct{
	u16 width;
	u16 height;
	rsxBuffer buffers[2];
	gcmContextData *context;
	int currentBuffer;
}NoRSX_Screen;

typedef struct{
	void *data;
	u32 x, y;
	u32 w, h;
	u32 centerx, centery;
	float angle;
	NoRSX_ImageType type; //PNG or JPG
}NoRSX_Image;

typedef struct{
	NoRSX_Image *image;
}NoRSX_Font;


typedef struct{
	void *data;
}NoRSX_TTF;


//NoRSX struct
	struct _NoRSX{
		NoRSX_Screen screen;
		void *host_addr;
	};	
	extern struct _NoRSX NoRSX; 


//NoRSX variables
	

//Main functions
	//Initialize the lib
		int NoRSX_Init();
	//Flip the buffer
		int NoRSX_Flip();
	//Exit
		int NoRSX_Exit();
//Screen functions
	//Get screen width
		int NoRSX_ScreenW();
	//Get screen height
		int NoRSX_ScreenH();
//Other NoRSX functions
	//Get the file extension from a char array
		char *NoRSX_GetFileExtension(const char *filename);

#include "NoRSX_draw.h"
#include "NoRSX_image.h"
#include "NoRSX_font.h"

#endif

