#!/usr/bin/tclsh
#
# ps3mfw -- PS3 MFW creators
#
# Copyright (C) RedDot-3ND7355 (For compiling tasks that are working)
# Copyright (C) B7U3 C50SS (For helping RedDot-3ND7355 compiling and to perfect it)
# Copyright (C) HABIB (Mshabib on ps3hax.net :D)
#
# This software is distributed under the terms of the GNU General Public
# License ("GPL") version 3, as published by the Free Software Foundation.
#

# Priority: 3
# Description: [4.xx] Patch lv1!

# Option --label: How to use: If you turn on habib's patterns, plz turn off toolboy's patterns! And if you want toolboy than turn off habib!
# Option --patch-lv1-features: [4.4x] Patch using habib's patterns! [Also used for Cobra!]
# Option --patch-lv1-features-45x: [4.5x] Patch using habib's patterns! [Also used for Cobra!]
# Option --patch-lv1-features-46x: [4.6x] Patch using Red's patterns! [Also used for Cobra!]
# Option --patch-lv1-otheros-450: [4.50] Patch using habib's patterns for otheros! (+ few miscs)
# Option --patch-lv1-mmap: [4.xx] Mmap out lv1!
# Option --patch-lv1-lpar: [4.xx] Patch lv1 to allow deleting/creating/modifying dir's!
# Option --patch-lv1-ENCDEC: [4.xx] Patch lv1 for deleting ENCDEC!
# Option --patch-lv1-updat-manag: [4.xx] Patch lv1 update manager!
# Option --patch-lv1-pkg-types: [4.xx] Patch lv1 to allow extraction of all pkg types!
# Option --patch-lv1-indi: [4.xx] Patch lv1 indi info manager!
# Option --patch-lv1-GPU: [4.xx] Patch lv1 to allow 4kb of GPU Access!
# Option --patch-lv1-breakpoints: [4.xx] Patch lv1 to allow settings breakpoints!
# Option --patch-lv1-spe-mfc: [4.xx] Patch lv1 (SPE) to allow all bits!
# Option --patch-lv1-htab-writing: [4.xx] Patch lv1 for HTAB Writing!
# Option --patch-lv1-acl-check: [4.xx] Patch lv1 to skip ACL Checks!
# Option --patch-lv1-inter-check: [4.xx] Patch lv1 to remove Intergrity Check!
# Option --patch-lv1-other: [4.xx] Patch lv1 using toolboy's patterns!

# Type --label: label
# Type --patch-lv1-features: boolean
# Type --patch-lv1-features-45x: boolean
# Type --patch-lv1-features-46x: boolean
# Type --patch-lv1-otheros-450: boolean
# Type --patch-lv1-mmap: boolean
# Type --patch-lv1-lpar: boolean
# Type --patch-lv1-ENCDEC: boolean
# Type --patch-lv1-updat-manag: boolean
# Type --patch-lv1-pkg-types: boolean
# Type --patch-lv1-indi: boolean
# Type --patch-lv1-GPU: boolean
# Type --patch-lv1-breakpoints: boolean
# Type --patch-lv1-spe-mfc: boolean
# Type --patch-lv1-htab-writing: boolean
# Type --patch-lv1-acl-check: boolean
# Type --patch-lv1-inter-check: boolean
# Type --patch-lv1-other: boolean

namespace eval ::patch_lv1 {

    array set ::patch_lv1::options {
	    --label ""
        --patch-lv1-features false
		--patch-lv1-features-45x false
		--patch-lv1-features-46x true
		--patch-lv1-otheros-450 false
		--patch-lv1-mmap true
		--patch-lv1-lpar false
		--patch-lv1-ENCDEC false
		--patch-lv1-updat-manag false
		--patch-lv1-pkg-types false
		--patch-lv1-indi false
		--patch-lv1-GPU false
		--patch-lv1-breakpoints false
		--patch-lv1-spe-mfc false
		--patch-lv1-htab-writing false
		--patch-lv1-acl-check false
		--patch-lv1-inter-check false
		--patch-lv1-other false
    }
    proc main { } {
            set self "lv1.self"
            set file "lv1.self"
			set ::SELF "lv1.self"
            if { ${::OLDROUTINE} == "1" } {
			::modify_coreos_file $self ::patch_lv1::patch_self
			} elseif { ${::OLDROUTINE} == "0" } {
			::modify_coreos_file2 $self ::patch_lv1::patch_self
			}
        }

    proc patch_self {self} {
            if { ${::OLDROUTINE} == "1" } {
			::modify_self_file $self ::patch_lv1::patch_elf
            } elseif { ${::OLDROUTINE} == "0" } {
			::modify_self_file2 $self ::patch_lv1::patch_elf
			}
		}

    proc patch_elf {elf} {
	if {$::patch_lv1::options(--patch-lv1-otheros-450)} {
	
	        #Patch lv1 for otheros back to 4.xx!
			log "Patching lv1 for otheros + miscs"
			log "Patterns by habib!"
			log "Part 1"
			
			set search     "\x48\x05\xE3\x2D\x54\x63\x06\x3E\x2F\x83\x00\x00\x41\x9E\x00\x14"
			append search  "\xE8\x01\x00\x70\x54\x00\x07\xFE\x2F\x80\x00\x00\x40\x9E\x00\x18"
			set replace    "\x48\x05\xE3\x2D\x38\x60\x00\x01\x2F\x83\x00\x00\x41\x9E\x00\x14"
			append replace "\x38\x00\x00\x01\x54\x00\x07\xFE\x2F\x80\x00\x00\x40\x9E\x00\x18"
			
			catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
			
			log "Part 2"
			
			set search     "\x99\x3F\x00\x99\x88\x1F\x00\x99\x54\x00\x06\x3E\x2F\x80\x00\x00"
			append search  "\x41\x9E\x00\x28\x38\x60\x00\x00\x38\x80\x00\x00\x38\xA0\x00\x00"
			set replace    "\x99\x3F\x00\x99\x88\x1F\x00\x99\x54\x00\x06\x3E\x60\x00\x00\x00"
			append replace "\x48\x00\x00\x28\x38\x60\x00\x00\x38\x80\x00\x00\x38\xA0\x00\x00"
			
			catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
			
			log "Part 3"
			
			set search     "\xE8\xDF\x00\xD8\xE8\xFF\x00\xE0\x7C\x08\x03\x78\x39\x20\x00\x00"
			set replace    "\xE8\xDF\x00\xD8\xE8\xFF\x00\xE0\x7C\x08\x03\x78\x39\x20\x00\x01"
			
			catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"

            log "Part 4"

            set search     "\x48\x00\x03\xED\xEB\xA2\x80\x38\x2F\x83\x00\x00\x7C\x60\x1B\x78"
			append search  "\x41\x9E\x00\x24\x7C\x64\x07\xB4\xE8\x62\x80\x50\x7C\x1F\x03\x78"
			append search  "\x48\x00\x7A\xF9\xE8\xA2\x80\x58\x7F\xA3\xEB\x78\x38\x80\x00\x01"
			set replace    "\x48\x01\xBE\xC9\xEB\xA2\x80\x38\x2F\x83\x00\x00\x7C\x60\x1B\x78"
			append replace "\x41\x9E\x00\x24\x7C\x64\x07\xB4\xE8\x62\x80\x50\x7C\x1F\x03\x78"
			append replace "\x48\x00\x7A\xF9\xE8\xA2\x80\x58\x7F\xA3\xEB\x78\x38\x80\x00\x01"
			
			catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
			
			log "Part 5"
			
			set search     "\x9E\x25\x86\xE4\x87\x1C\x39\x8E\x8B\x1D\x95\x25\xAD\x4A\xD1\x91"
			append search  "\x4B\xFE\xB0\x8B\x9D\xD6\x04\x6A\x00\x00\x00\x00\x00\x00\x00\x00"
			set replace    "\x9E\x25\x86\xE4\x6C\xEA\x11\x1C\xD1\x6C\x65\x4B\x08\xB9\x79\x3E"
			append replace "\xA7\x15\xE8\xCE\x04\x6A\x48\xE5\x00\x00\x00\x00\x00\x00\x00\x00"
			
			catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
			
			log "Part 6"
			
			set search     "\x88\x1F\x00\x00\x2F\x80\x00\x00\x40\x9E\x00\x48\x48\x00\xE0\x81" 
			append search  "\x2F\x83\x00\x00\x38\x60\x00\x01\x41\x9E\x00\x20\xE8\x62\x8A\xB8"
			set replace    "\x88\x1F\x00\x00\x2F\x80\x00\x00\x40\x9E\x00\x48\x38\x60\x00\x00" 
			append replace "\x2F\x83\x00\x00\x38\x60\x00\x01\x48\x00\x00\x20\xE8\x62\x8A\xB8"
			
			catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
			
			log "Part 7"
			log "This will take a while..."
			
set search    "\xC9\x80\x00\x00\x00\x00\x00\x01\xC9\x80\x00\x00\x00\x00\x00\x01"
append search "\x00\x00\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00\x00\x00\x03"
append search "\x00\x00\x00\x00\x00\x00\xC0\x00\x00\x00\x00\x00\x00\x00\xC0\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x7A\x20\x00\x00\x00\x00\x00\x00"
append search "\x84\x30\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x01"
append search "\x04\x80\x00\x00\x00\x00\x00\x01\xC9\x80\x00\x00\x00\x01\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03"
append search "\x04\x80\x00\x00\x00\x00\x00\x00\x7A\x20\x00\x00\x00\x01\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00"
append search "\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00"
append search "\x00\x30\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00"
append search "\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x62\x7C\xB1\x80\x8A\xB9"
append search "\x38\xE3\x2C\x8C\x09\x17\x08\x72\x6A\x57\x9E\x25\x86\xE4\x81\x45"
append search "\x73\x50\x35\x9B\xB9\x49\x49\xF9\x26\xD3\x99\xAE\x63\xAF\x12\x02"
append search "\x0C\xC4\x00\x00\x00\x00\x00\x00\x00\x00\x67\x45\x8B\x6B\xC6\x23"
append search "\x7B\x32\x69\x98\x3C\x64\x73\x48\x33\x66\x51\xDC\xB0\x74\xFF\x5C"
append search "\x49\x19\x4A\x94\xE8\x2A\xEC\x58\x55\x62\x29\x1F\x8E\x23\xCD\x7C"
append search "\xE8\x46\xBA\x58\x1B\x3D\xAB\xD7\x7E\x50\xF2\x41\xB1\x2E\xFB\x1E"
append search "\xB7\x41\xE3\xA9\xE2\x79\x46\xE1\x45\x75\x7C\x00\x5F\x51\xC2\x62"
append search "\xD0\x5B\x54\x08\x20\x12\xF8\x27\xB1\x4D\x1B\x23\x16\x02\xE8\xE9"
append search "\x16\x1F\xE7\xCD\x90\x11\x8D\x43\xEF\x66\x76\x0F\x0E\x14\x5A\x25"
append search "\x52\x33\x2E\xF9\x9C\x10\x63\x72\xED\x0D\x33\xC2\xDC\x7F\x9F\xD7"
append search "\xEF\x1B\xC9\xC4\xA7\x41\x9A\x07\x68\x6B\x66\xFB\x6A\x4E\x32\x5D"
append search "\xE4\x25\x0D\x50\x9B\x51\xB7\xD7\x1B\x43\x31\xBA\x2D\x3F\x58\xE4"
append search "\x83\x7C\xA3\x30\x71\x25\x5A\xD9\xBB\x62\x25\x61\x6C\x43\x5D\x89"
append search "\x8C\x62\x05\xB1\x3A\x33\x17\xA3\x1D\x72\x58\xA8\x43\x24\xE9\x5A"
append search "\x1D\x2D\x5E\x84\x63\x67\xD4\xA8\xA2\x75\xAB\xBD\xED\x08\xB2\x8C"
append search "\x83\x79\xCD\xD0\x53\x43\xC6\xE0\x03\x0B\x9B\x76\x9A\x18\xB4\x9E"
append search "\xE4\x54\x54\x24\xF3\x71\x11\x86\xA8\x2C\x0E\xC4\x36\x08\x82\x1D"
append search "\x90\x02\x74\xF8\x95\x3A\x41\x86\x13\x08\x21\xF5\x7F\x1E\x3D\xBD"
append search "\x3D\x7C\xDC\x8D\x7B\x73\x87\xF0\xEA\x6C\x70\x1A\x22\x22\xE9\xDD"
append search "\x16\x45\x3E\xC8\x06\x30\xA1\xD4\x4F\x61\x41\xC2\x9A\x41\xE1\xF8"
append search "\x77\x55\xFC\xAD\x0B\x44\x67\x23\x07\x05\x3E\x82\x04\x38\x01\x5F"
append search "\x46\x77\x7E\xC6\x24\x77\x97\x2A\x48\x5C\xEA\xB9\x63\x24\xDC\x4A"
append search "\x88\x5E\x6B\xD3\xEA\x51\x96\x77\x51\x2D\x8F\xD7\x0B\x58\x38\xA4"
append search "\x3E\x15\x5C\x58\x55\x38\x2A\x4E\xA6\x70\xEC\x42\x23\x6A\xB0\x7C"
append search "\x48\x2A\x3B\xD4\x4E\x1D\xFB\x06\x5A\x72\x32\x9A\xD8\x2C\xAF\xCC"
append search "\xE4\x57\x3C\x8D\x6D\x7A\x54\x8F\x58\x4B\xEC\x89\x22\x54\x18\x1B"
append search "\xE9\x6D\xDB\x7F\x43\x38\x5C\xA4\x44\x76\x02\xF9\xFF\x32\x1A\x48"
append search "\x4A\x68\xFE\x78\x94\x57\x43\xBB\x9A\x74\xFB\x40\xC2\x3D\xFA\x26"
append search "\xA0\x1B\xAA\xDE\xA1\x79\x3A\xC3\xC6\x75\xFB\x85\xE6\x12\x29\xA5"
append search "\xC6\x70\xD1\xED\x0E\x52\xE6\x3F\x4A\x37\x05\xF0\x4E\x4F\x3C\xC1"
append search "\xF9\x23\x7C\xB7\x9B\x64\x94\xC7\x5A\x27\x75\x65\x38\x39\xD8\x0F"
append search "\xF1\x1C\xBE\x15\x01\x18\x61\xA8\x5B\x23\x89\x8C\x39\x47\xF9\xE9"
append search "\x4F\x35\x5C\xAF\xB5\x15\xBB\x26\x12\x74\xA8\xB6\x34\x0D\x99\x3C"
append search "\x23\x10\x0F\xB6\x6A\x3F\x95\x40\x57\x61\xB1\x57\x0C\x7E\xEB\x35"
append search "\xAE\x77\xF1\xE4\x9B\x57\xB3\x50\x0C\x31\x05\x7E\xF8\x5F\xEF\x5D"
append search "\x30\x2F\xF7\x0B\xA7\x25\x00\xBF\xBA\x1D\xE9\x84\xD0\x4A\xA1\xEA"
append search "\x48\x1F\x3A\x82\x81\x13\xE5\x0A\xB7\x5D\xCA\x8F\x0F\x10\x0B\x70"
append search "\x90\x65\xCB\x4A\x01\x15\xD0\x7F\x5E\x5F\x48\x31\x8A\x09\x47\x02"
append search "\x9D\x79\x64\x47\xB9\x06\xBD\x96\xC2\x42\x1F\x12\x8E\x16\x23\x5D"
append search "\xBA\x1E\x1E\x3F\x1E\x66\xA8\x9E\xC7\x5D\x1C\x47\x0A\x54\x7B\xEE"
append search "\xD3\x7B\x64\xC5\xD9\x51\xC5\xFD\x3E\x61\x14\x2B\xF7\x0B\x73\x7B"
append search "\x44\x11\x5A\x3E\x96\x42\xC5\x82\x03\x0A\x5E\xB1\xF2\x08\x4B\x23"
append search "\x32\x1A\x79\xD3\x0F\x3B\x63\x2F\xEB\x68\x7F\x45\x4C\x46\x02\x02"
append search "\x01\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x15\x00\x00"
append search "\x00\x01\x00\x00\x00\x00\xC0\x00\x2A\x98\x00\x00\x00\x00\x00\x00"
append search "\x00\x40\x00\x00\x00\x00\x00\x03\x8A\x50\x00\x00\x00\x00\x00\x40"
append search "\x00\x38\x00\x02\x00\x40\x00\x0C\x00\x0B\x00\x00\x00\x01\x00\x00"
append search "\x00\x07\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x80\x00"
append search "\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x01"
append search "\xC9\x80\x00\x00\x00\x00\x00\x01\xC9\x80"
set replace    "\xD0\x00\x00\x00\x00\x00\x00\x01\xD0\x00\x00\x00\x00\x00\x00\x01"
append replace "\x00\x00\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00\x00\x00\x03"
append replace "\x00\x00\x00\x00\x00\x00\xC0\x00\x00\x00\x00\x00\x00\x00\xC0\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x7A\x20\x00\x00\x00\x00\x00\x00"
append replace "\x84\x30\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x01"
append replace "\x04\x80\x00\x00\x00\x00\x00\x01\xD0\x00\x00\x00\x00\x01\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03"
append replace "\x04\x80\x00\x00\x00\x00\x00\x00\x7A\x20\x00\x00\x00\x01\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00"
append replace "\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00"
append replace "\x00\x30\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00"
append replace "\x00\x40\x00\x00\x00\x00\x00\x00\x00\x00\x62\x7C\xB1\x80\x8A\xB9"
append replace "\x38\xE3\x2C\x8C\x09\x17\x08\x72\x6A\x57\x9E\x25\x86\xE4\x09\x6E"
append replace "\x3A\xAA\x83\xDB\xE7\x2A\xF8\x76\x4A\x2A\xDE\xEB\x28\xCA\x4D\x35"
append replace "\xE3\x52\x00\x00\x00\x00\x00\x00\x00\x00\x67\x45\x8B\x6B\xC6\x23"
append replace "\x7B\x32\x69\x98\x3C\x64\x73\x48\x33\x66\x51\xDC\xB0\x74\xFF\x5C"
append replace "\x49\x19\x4A\x94\xE8\x2A\xEC\x58\x55\x62\x29\x1F\x8E\x23\xCD\x7C"
append replace "\xE8\x46\xBA\x58\x1B\x3D\xAB\xD7\x7E\x50\xF2\x41\xB1\x2E\xFB\x1E"
append replace "\xB7\x41\xE3\xA9\xE2\x79\x46\xE1\x45\x75\x7C\x00\x5F\x51\xC2\x62"
append replace "\xD0\x5B\x54\x08\x20\x12\xF8\x27\xB1\x4D\x1B\x23\x16\x02\xE8\xE9"
append replace "\x16\x1F\xE7\xCD\x90\x11\x8D\x43\xEF\x66\x76\x0F\x0E\x14\x5A\x25"
append replace "\x52\x33\x2E\xF9\x9C\x10\x63\x72\xED\x0D\x33\xC2\xDC\x7F\x9F\xD7"
append replace "\xEF\x1B\xC9\xC4\xA7\x41\x9A\x07\x68\x6B\x66\xFB\x6A\x4E\x32\x5D"
append replace "\xE4\x25\x0D\x50\x9B\x51\xB7\xD7\x1B\x43\x31\xBA\x2D\x3F\x58\xE4"
append replace "\x83\x7C\xA3\x30\x71\x25\x5A\xD9\xBB\x62\x25\x61\x6C\x43\x5D\x89"
append replace "\x8C\x62\x05\xB1\x3A\x33\x17\xA3\x1D\x72\x58\xA8\x43\x24\xE9\x5A"
append replace "\x1D\x2D\x5E\x84\x63\x67\xD4\xA8\xA2\x75\xAB\xBD\xED\x08\xB2\x8C"
append replace "\x83\x79\xCD\xD0\x53\x43\xC6\xE0\x03\x0B\x9B\x76\x9A\x18\xB4\x9E"
append replace "\xE4\x54\x54\x24\xF3\x71\x11\x86\xA8\x2C\x0E\xC4\x36\x08\x82\x1D"
append replace "\x90\x02\x74\xF8\x95\x3A\x41\x86\x13\x08\x21\xF5\x7F\x1E\x3D\xBD"
append replace "\x3D\x7C\xDC\x8D\x7B\x73\x87\xF0\xEA\x6C\x70\x1A\x22\x22\xE9\xDD"
append replace "\x16\x45\x3E\xC8\x06\x30\xA1\xD4\x4F\x61\x41\xC2\x9A\x41\xE1\xF8"
append replace "\x77\x55\xFC\xAD\x0B\x44\x67\x23\x07\x05\x3E\x82\x04\x38\x01\x5F"
append replace "\x46\x77\x7E\xC6\x24\x77\x97\x2A\x48\x5C\xEA\xB9\x63\x24\xDC\x4A"
append replace "\x88\x5E\x6B\xD3\xEA\x51\x96\x77\x51\x2D\x8F\xD7\x0B\x58\x38\xA4"
append replace "\x3E\x15\x5C\x58\x55\x38\x2A\x4E\xA6\x70\xEC\x42\x23\x6A\xB0\x7C"
append replace "\x48\x2A\x3B\xD4\x4E\x1D\xFB\x06\x5A\x72\x32\x9A\xD8\x2C\xAF\xCC"
append replace "\xE4\x57\x3C\x8D\x6D\x7A\x54\x8F\x58\x4B\xEC\x89\x22\x54\x18\x1B"
append replace "\xE9\x6D\xDB\x7F\x43\x38\x5C\xA4\x44\x76\x02\xF9\xFF\x32\x1A\x48"
append replace "\x4A\x68\xFE\x78\x94\x57\x43\xBB\x9A\x74\xFB\x40\xC2\x3D\xFA\x26"
append replace "\xA0\x1B\xAA\xDE\xA1\x79\x3A\xC3\xC6\x75\xFB\x85\xE6\x12\x29\xA5"
append replace "\xC6\x70\xD1\xED\x0E\x52\xE6\x3F\x4A\x37\x05\xF0\x4E\x4F\x3C\xC1"
append replace "\xF9\x23\x7C\xB7\x9B\x64\x94\xC7\x5A\x27\x75\x65\x38\x39\xD8\x0F"
append replace "\xF1\x1C\xBE\x15\x01\x18\x61\xA8\x5B\x23\x89\x8C\x39\x47\xF9\xE9"
append replace "\x4F\x35\x5C\xAF\xB5\x15\xBB\x26\x12\x74\xA8\xB6\x34\x0D\x99\x3C"
append replace "\x23\x10\x0F\xB6\x6A\x3F\x95\x40\x57\x61\xB1\x57\x0C\x7E\xEB\x35"
append replace "\xAE\x77\xF1\xE4\x9B\x57\xB3\x50\x0C\x31\x05\x7E\xF8\x5F\xEF\x5D"
append replace "\x30\x2F\xF7\x0B\xA7\x25\x00\xBF\xBA\x1D\xE9\x84\xD0\x4A\xA1\xEA"
append replace "\x48\x1F\x3A\x82\x81\x13\xE5\x0A\xB7\x5D\xCA\x8F\x0F\x10\x0B\x70"
append replace "\x90\x65\xCB\x4A\x01\x15\xD0\x7F\x5E\x5F\x48\x31\x8A\x09\x47\x02"
append replace "\x9D\x79\x64\x47\xB9\x06\xBD\x96\xC2\x42\x1F\x12\x8E\x16\x23\x5D"
append replace "\xBA\x1E\x1E\x3F\x1E\x66\xA8\x9E\xC7\x5D\x1C\x47\x0A\x54\x7B\xEE"
append replace "\xD3\x7B\x64\xC5\xD9\x51\xC5\xFD\x3E\x61\x14\x2B\xF7\x0B\x73\x7B"
append replace "\x44\x11\x5A\x3E\x96\x42\xC5\x82\x03\x0A\x5E\xB1\xF2\x08\x4B\x23"
append replace "\x32\x1A\x79\xD3\x0F\x3B\x63\x2F\xEB\x68\x7F\x45\x4C\x46\x02\x02"
append replace "\x01\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x15\x00\x00"
append replace "\x00\x01\x00\x00\x00\x00\xC0\x00\x2A\x98\x00\x00\x00\x00\x00\x00"
append replace "\x00\x40\x00\x00\x00\x00\x00\x03\x8A\x50\x00\x00\x00\x00\x00\x40"
append replace "\x00\x38\x00\x02\x00\x40\x00\x0C\x00\x0B\x00\x00\x00\x01\x00\x00"
append replace "\x00\x07\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x80\x00"
append replace "\x00\x00\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x01"
append replace "\xD0\x00\x00\x00\x00\x00\x00\x01\xD0\x00"

catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"

log "Sorry for the long wait"
log "Now back to work :)"
log "Part 8"
log "Ready for another long wait?"
log "I hope so :P"

set search    "\x00\x00\x00\x00\xC0\x00\x51\x08\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00"
set replace    "\x00\x00\x00\x00\xC0\x00\x51\x08\xF8\x21\xFF\x01\x7C\x08\x02\xA6"
append replace "\xF8\x01\x01\x10\xFB\x21\x00\xF8\xFB\x41\x00\xF0\xFB\x61\x00\xE8"
append replace "\xFB\x81\x00\xE0\xFB\xA1\x00\xD8\xFB\xC1\x00\xD0\xFB\xE1\x00\xC8"
append replace "\xF8\x61\x00\xC0\xF8\x81\x00\xB8\xF8\xA1\x00\xB0\x48\x00\x00\x05"
append replace "\x7F\xE8\x02\xA6\x3B\xFF\xFF\xC8\xE8\x1F\x04\xB0\xF8\x01\x00\x88"
append replace "\xE8\x1F\x04\xB8\xF8\x01\x00\x90\xE8\x1F\x04\xC0\xF8\x01\x00\x98"
append replace "\xE8\x1F\x04\xC8\xF8\x01\x00\xA0\x38\x00\x00\x00\xF8\x01\x00\x78"
append replace "\xF8\x01\x00\x80\x38\x60\x00\x01\x38\x81\x00\x88\x38\xA1\x00\x78"
append replace "\x3B\xC0\x00\x00\x67\xDE\x80\x01\x63\xDE\x37\x94\x7F\xC9\x03\xA6"
append replace "\x4E\x80\x04\x21\x2F\xA3\x00\x00\x40\x9E\x00\x18\xE8\x01\x00\x78"
append replace "\x78\x00\x06\x20\x2F\x80\x00\xFF\x3B\x60\x00\x0F\x40\x9E\x03\x6C"
append replace "\xE8\x1F\x04\xB0\xF8\x01\x00\x88\xE8\x1F\x04\xB8\xF8\x01\x00\x90"
append replace "\xE8\x1F\x04\xD0\xF8\x01\x00\x98\xE8\x1F\x04\xD8\xF8\x01\x00\xA0"
append replace "\x38\x00\x00\x00\xF8\x01\x00\x78\xF8\x01\x00\x80\x38\x60\x00\x01"
append replace "\x38\x81\x00\x88\x38\xA1\x00\x78\x3B\xC0\x00\x00\x67\xDE\x80\x01"
append replace "\x63\xDE\x37\x94\x7F\xC9\x03\xA6\x4E\x80\x04\x21\x2F\xA3\x00\x00"
append replace "\x40\x9E\x00\x18\xE8\x01\x00\x78\x78\x00\x06\x20\x2F\x80\x00\xFF"
append replace "\x3B\x60\x00\x0F\x40\x9E\x03\x04\xE8\x1F\x04\xB0\xF8\x01\x00\x88"
append replace "\xE8\x1F\x04\xB8\xF8\x01\x00\x90\xE8\x1F\x04\xE0\xF8\x01\x00\x98"
append replace "\xE8\x1F\x04\xD8\xF8\x01\x00\xA0\x38\x00\x00\x00\xF8\x01\x00\x78"
append replace "\xF8\x01\x00\x80\x38\x60\x00\x01\x38\x81\x00\x88\x38\xA1\x00\x78"
append replace "\x3B\xC0\x00\x00\x67\xDE\x80\x01\x63\xDE\x37\x94\x7F\xC9\x03\xA6"
append replace "\x4E\x80\x04\x21\x2F\xA3\x00\x00\x40\x9E\x00\x18\xE8\x01\x00\x78"
append replace "\x78\x00\x06\x20\x2F\x80\x00\xFF\x3B\x60\x00\x0F\x40\x9E\x02\x9C"
append replace "\xE8\x1F\x04\xB0\xF8\x01\x00\x88\xE8\x1F\x04\xB8\xF8\x01\x00\x90"
append replace "\xE8\x1F\x04\xE8\xF8\x01\x00\x98\xE8\x1F\x04\xD8\xF8\x01\x00\xA0"
append replace "\x38\x00\x00\x00\xF8\x01\x00\x78\xF8\x01\x00\x80\x38\x60\x00\x01"
append replace "\x38\x81\x00\x88\x38\xA1\x00\x78\x3B\xC0\x00\x00\x67\xDE\x80\x01"
append replace "\x63\xDE\x37\x94\x7F\xC9\x03\xA6\x4E\x80\x04\x21\x2F\xA3\x00\x00"
append replace "\x40\x9E\x00\x18\xE8\x01\x00\x78\x78\x00\x06\x20\x2F\x80\x00\xFF"
append replace "\x3B\x60\x00\x0F\x40\x9E\x02\x34\xE8\x61\x00\xB0\x38\x80\x00\x00"
append replace "\xEB\x5F\x04\x70\xEB\x9F\x04\x90\x7C\xBA\xE2\x14\x38\xC1\x00\xA8"
append replace "\x3B\xC0\x00\x00\x67\xDE\x80\x00\x63\xDE\x27\x14\x7F\xC9\x03\xA6"
append replace "\x4E\x80\x04\x21\x2F\x83\x00\x00\x7C\x7B\x1B\x78\x40\x9E\x01\xFC"
append replace "\xE8\x61\x00\xA8\x38\x80\x00\x00\x7F\x85\xE3\x78\x3B\xC0\x00\x00"
append replace "\x67\xDE\x80\x00\x63\xDE\x02\x78\x7F\xC9\x03\xA6\x4E\x80\x04\x21"
append replace "\x38\x7F\x04\x98\x38\x80\x00\x00\x3B\x60\x00\x10\x3B\xC0\x00\x00"
append replace "\x67\xDE\x80\x01\x63\xDE\x45\x04\x7F\xC9\x03\xA6\x4E\x80\x04\x21"
append replace "\x2F\x83\x00\x00\x7C\x7D\x1B\x78\x41\x9C\x01\x94\x7F\xA3\x07\xB4"
append replace "\xE8\x81\x00\xA8\x3B\x20\x08\x00\x7F\x25\xCB\x78\x3B\x60\x00\x10"
append replace "\x3B\xC0\x00\x00\x67\xDE\x80\x01\x63\xDE\x45\x7C\x7F\xC9\x03\xA6"
append replace "\x4E\x80\x04\x21\x7F\xA3\xC8\x00\x40\x9E\x01\x4C\x3B\x60\x00\x14"
append replace "\x38\x7F\x04\x78\xE8\x81\x00\xA8\x38\xA0\x00\x10\x3B\xC0\x00\x00"
append replace "\x67\xDE\x80\x01\x63\xDE\x41\xA4\x7F\xC9\x03\xA6\x4E\x80\x04\x21"
append replace "\x2F\xA3\x00\x00\x40\x9E\x01\x20\xE8\xA1\x00\xA8\x83\x25\x00\x10"
append replace "\x2F\x99\x00\x01\x40\x9E\x01\x10\xE8\xA1\x00\xA8\x83\x25\x00\x20"
append replace "\x2F\x99\x00\x00\x40\x9E\x01\x00\xE8\xA1\x00\xA8\x83\x25\x02\x00"
append replace "\x2F\x99\x00\x00\x41\x9E\x00\xF0\xE8\xA1\x00\xA8\x83\x25\x00\x24"
append replace "\x7F\xB9\xE0\x00\x41\x9D\x00\xE0\x7F\xA3\x07\xB4\xE8\x81\x00\xA8"
append replace "\x7F\x25\xCB\x78\x3B\x60\x00\x10\x3B\xC0\x00\x00\x67\xDE\x80\x01"
append replace "\x63\xDE\x45\x7C\x7F\xC9\x03\xA6\x4E\x80\x04\x21\x7F\xA3\xC8\x00"
append replace "\x40\x9E\x00\xB4\xE8\x1F\x04\xF0\xF8\x01\x00\x88\xE8\x1F\x04\xF8"
append replace "\xF8\x01\x00\x90\xE8\x1F\x05\x00\xF8\x01\x00\x98\xE8\x1F\x05\x08"
append replace "\xF8\x01\x00\xA0\x38\x00\x00\x00\xF8\x01\x00\x78\xF8\x01\x00\x80"
append replace "\x38\x60\x00\x01\x38\x81\x00\x88\x38\xA1\x00\x78\x3B\xC0\x00\x00"
append replace "\x67\xDE\x80\x01\x63\xDE\x37\x4C\x7F\xC9\x03\xA6\x4E\x80\x04\x21"
append replace "\x38\x60\x00\x29\x3B\xC0\x00\x00\x67\xDE\x80\x00\x63\xDE\x2D\x50"
append replace "\x7F\xC9\x03\xA6\x4E\x80\x04\x21\x39\x20\x00\x00\x48\x00\x00\x14"
append replace "\xE8\x01\x00\xA8\x7C\x09\x02\x14\x7C\x00\x00\x6C\x39\x29\x00\x80"
append replace "\x7F\xA9\xE0\x00\x41\x9C\xFF\xEC\x7C\x00\x04\xAC\x39\x20\x00\x00"
append replace "\x48\x00\x00\x14\xE8\x01\x00\xA8\x7C\x09\x02\x14\x7C\x00\x07\xAC"
append replace "\x39\x29\x00\x80\x7F\xA9\xE0\x00\x41\x9C\xFF\xEC\x4C\x00\x01\x2C"
append replace "\x3B\x60\x00\x00\x7F\xA3\x07\xB4\x3B\xC0\x00\x00\x67\xDE\x80\x01"
append replace "\x63\xDE\x45\x40\x7F\xC9\x03\xA6\x4E\x80\x04\x21\xE8\x61\x00\xA8"
append replace "\x7C\x9A\xE2\x14\x3B\xC0\x00\x00\x67\xDE\x80\x01\x63\xDE\x46\x7C"
append replace "\x7F\xC9\x03\xA6\x4E\x80\x04\x21\x7B\x63\x00\x20\xE8\x01\x01\x10"
append replace "\xEB\x21\x00\xF8\xEB\x41\x00\xF0\xEB\x61\x00\xE8\xEB\x81\x00\xE0"
append replace "\xEB\xA1\x00\xD8\xEB\xC1\x00\xD0\xEB\xE1\x00\xC8\x2F\x83\x00\x00"
append replace "\x41\x9E\x00\x2C\xE8\x61\x00\xC0\xE8\x81\x00\xB8\xE8\xA1\x00\xB0"
append replace "\x38\x21\x01\x00\x7C\x08\x03\xA6\x38\xC0\x00\x00\x64\xC6\x80\x00"
append replace "\x60\xC6\x0E\xA4\x7C\xC9\x03\xA6\x4E\x80\x04\x20\x38\x21\x01\x00"
append replace "\x7C\x08\x03\xA6\x4E\x80\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x63\x65\x6C\x6C\x5F\x65\x78\x74\x5F\x6F\x73\x5F\x61\x72\x65\x61"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x80\x00\x00"
append replace "\x2F\x64\x65\x76\x2F\x72\x66\x6C\x61\x73\x68\x5F\x6C\x78\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x73\x00\x00"
append replace "\x70\x61\x72\x61\x6D\x00\x00\x00\x75\x70\x64\x61\x74\x65\x00\x00"
append replace "\x73\x74\x61\x74\x75\x73\x00\x00\x70\x72\x6F\x64\x75\x63\x74\x00"
append replace "\x6D\x6F\x64\x65\x00\x00\x00\x00\x72\x65\x63\x6F\x76\x65\x72\x00"
append replace "\x68\x64\x64\x63\x6F\x70\x79\x00\x00\x00\x00\x00\x69\x6F\x73\x00"
append replace "\x61\x74\x61\x00\x00\x00\x00\x00\x72\x65\x67\x69\x6F\x6E\x30\x00"
append replace "\x61\x63\x63\x65\x73\x73\x00"

catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"

log "OMFG, that was long..."
log "..."
log "Sorry for the wait..."
log "Now lets go for the last small part ;)"

set search  "\x00\x00\x00\x00\x00\x02\xBB\xB0\x00\x00\x00\x00\x00\x00\x0D\xD0"
set replace "\x00\x00\x00\x00\x00\x02\xBB\xB0\x00\x00\x00\x00\x00\x00\x14\x50"

catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
log "good grief, finally done patching!"
	}

    if {$::patch_lv1::options(--patch-lv1-features)} {
     # Patch core OS Hash check core os // product mode always on
	  log "Patch core OS Hash check core os for 4.xx // product mode always on"
      log "Fixed by RedDot-3ND7355 and HABIB"

      set search  "\x41\x9E\x00\x1C\x7F\x63\xDB\x78\xE8\xA2\x85\x78"
      set replace "\x60\x00\x00\x00\x7F\x63\xDB\x78\xE8\xA2\x85\x78"

      catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"

	  # Patching LV1 to remove lv2 protect
            log "Patching LV1 hypervisior to remove LV2 protection for 4.xx"
			log "Feature fixed by HABIB"
			log "And Added by RedDot-3ND7355"
            
            set search  "\x48\x00\xE0\x35\x2F\x83\x00\x00\x38\x60\x00\x01\x41\x9E"
            set replace "\x60\x00\x00\x00\x2F\x83\x00\x00\x38\x60\x00\x01\x48\x00"
            
            catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
        
	  # Patching lv1 peek&poke OMG!
            log "Patching LV1 hypervisor to add peek/poke support for 4.xx (1189356)"
            log "Feature fixed by HABIB OMG!"
			log "And Added by RedDot-3ND7355"
			
			set search     "\x64\x00\xFF\xFF\x60\x00\xFF\xEC\xF8\x03\x00\xC0\x4E\x80\x00\x20\x38\x00\x00"
			append search  "\x00\x64\x00\xFF\xFF\x60\x00\xFF\xEC\xF8\x03\x00\xC0"			
            set replace    "\xE8\x83\x00\x18\xE8\x84\x00\x00\xF8\x83\x00\xC8\x4E\x80\x00\x20\x38\x00\x00"
			append replace "\x00\xE8\xA3\x00\x20\xE8\x83\x00\x18\xF8\xA4\x00\x00"

            catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
	}
	
	if {$::patch_lv1::options(--patch-lv1-features-45x)} {
	  log "Patch core OS Hash check core os for 4.5x"
      log "Fixed by RedDot-3ND7355 and HABIB"

      set search  "\x41\x9E\x00\x1C\x7F\x63\xDB\x78\xE8\xA2\x85\x78"
      set replace "\x60\x00\x00\x00\x7F\x63\xDB\x78\xE8\xA2\x85\x78"

      catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
	  
	  if {$::patch_lv1::options(--patch-lv1-otheros-450)} {
	  log "Skipped an patched misc..."
	  } else {
	  # Patching LV1 to remove lv2 protect if the misc patches not on!
            log "Patching LV1 hypervisior to remove LV2 protection for 4.5x"
			log "Pattern added by haz367 & verified valid using habib's patterns by RedDot ;)"
            
            set search  "\x48\x00\xE0\x81\x2F\x83\x00\x00\x38\x60\x00\x01\x41\x9E"
            set replace "\x60\x00\x00\x00\x2F\x83\x00\x00\x38\x60\x00\x01\x48\x00"
            
            catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
		}

	  # Patching lv1 peek&poke OMG!
            log "Patching LV1 hypervisor to add peek/poke support for 4.5x"
			log "Patterns by habib & Added by RedDot-3ND7355"
			
            set search     "\x64\x00\xFF\xFF\x60\x00\xFF\xEC\xF8\x03\x00\xC0\x4E\x80\x00\x20\x38\x00\x00"
			append search  "\x00\x64\x00\xFF\xFF\x60\x00\xFF\xEC\xF8\x03\x00\xC0"
            set replace    "\xE8\x83\x00\x18\xE8\x84\x00\x00\xF8\x83\x00\xC8\x4E\x80\x00\x20\x38\x00\x00"
			append replace "\x00\xE8\xA3\x00\x20\xE8\x83\x00\x18\xF8\xA4\x00\x00"

            catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
	}
	
	if {$::patch_lv1::options(--patch-lv1-features-46x)} {
	  log "Patch core OS Hash check core os for 4.6x"
      log "Added by RedDot-3ND7355"

      set search  "\x41\x9E\x00\x1C\x7F\x63\xDB\x78\xE8\xA2\x85\x78"
      set replace "\x60\x00\x00\x00\x7F\x63\xDB\x78\xE8\xA2\x85\x78"

      catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
	  
	  if {$::patch_lv1::options(--patch-lv1-otheros-450)} {
	  log "Skipped an patched misc..."
	  } else {
	  # Patching LV1 to remove lv2 protect if the misc patches not on!
            log "Patching LV1 hypervisior to remove LV2 protection for 4.6x"
			log "Added by RedDot ;)"
            
            set search  "\x48\x00\xE0\x95\x2F\x83\x00\x00\x38\x60\x00\x01\x41\x9e"
            set replace "\x60\x00\x00\x00\x2F\x83\x00\x00\x38\x60\x00\x01\x48\x00"

            catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
		}
	  
	  # Patching lv1 peek&poke OMG!
            log "Patching LV1 hypervisor to add peek/poke support for 4.6x"
			log "Added by RedDot-3ND7355"
			
            set search     "\x64\x00\xFF\xFF\x60\x00\xFF\xEC\xF8\x03\x00\xC0\x4E\x80\x00\x20\x38\x00\x00"
            append search  "\x00\x64\x00\xFF\xFF\x60\x00\xFF\xEC\xF8\x03\x00\xC0"
            set replace    "\xE8\x83\x00\x18\xE8\x84\x00\x00\xF8\x83\x00\xC8\x4E\x80\x00\x20\x38\x00\x00"
			append replace "\x00\xE8\xA3\x00\x20\xE8\x83\x00\x18\xF8\xA4\x00\x00"

            catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
	}

	  if {$::patch_lv1::options(--patch-lv1-inter-check)} {
      # Patching System Manager to disable integrity check
      log "Patching System Manager to disable integrity check"
      log "Fixed by RedDot-3ND7355"

      set search  "\x38\x60\x00\x01\xf8\x01\x00\x90\x88\x1f\x00\x00\x2f\x80\x00\x00"
      set replace "\x38\x60\x00\x00\xf8\x01\x00\x90\x88\x1f\x00\x00\x2f\x80\x00\x00"

      catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"  
      }

	  if {$::patch_lv1::options(--patch-lv1-acl-check)} {
      # Patching LV1 to enable skipping of ACL checks for all storage devices
      log "Patching LV1 to enable skipping of ACL checks for all storage devices"
      log "Confirmed Legit by RedDot-3ND7355"

      set search     "\x54\x63\x06\x3e\x2f\x83\x00\x00\x41\x9e\x00\x14\xe8\x01\x00\x70\x54\x00\x07\xfe"
	  append search  "\x2f\x80\x00\x00\x40\x9e\x00\x18"
      set replace    "\x38\x60\x00\x01\x2f\x83\x00\x00\x41\x9e\x00\x14\x38\x00\x00\x01\x54\x00\x07\xfe"
      append replace "\x2f\x80\x00\x00\x40\x9e\x00\x18"
	  
      catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]" 
      }
	  
	  if {$::patch_lv1::options(--patch-lv1-htab-writing)} {
	  # Patch LV1 HTAB WRITING
      log "Patching LV1 hypervisor to allow mapping of HTAB with write protection (1007280)"
      log "Confirmed Legit by RedDot-3ND7355"
	  
      set search  "\x2f\x1d\x00\x00\x61\x4a\x97\xd2\x7f\x80\xf0\x00\x79\x4a\x07\xc6"
	  append search "\x65\x4a\xb5\x8e\x41\xdc\x00\x54\x3d\x40\x99\x79\x41\xda\x00\x54"
      set replace "\x60\x00\x00\x00\x61\x4a\x97\xd2\x7f\x80\xf0\x00\x79\x4a\x07\xc6"
	  append replace "\x65\x4a\xb5\x8e\x41\xdc\x00\x54\x3d\x40\x99\x79\x41\xda\x00\x54"

      catch_die {::patch_elf $elf $search 28 $replace} "Unable to patch self [file tail $elf]"
	  }
	  
	  if {$::patch_lv1::options(--patch-lv1-spe-mfc)} {
	  # Patch LV1 SPE for all bits of register
	  log "Patching LV1 hypervisor to allow setting all bits of SPE register MFC_SR1 with lv1_set_spe_privilege_state_area_1_register (1123960)"
      log "Confirmed Legit by RedDot-3ND7355"
	  
      set search     "\xe8\x03\x00\x10\x39\x20\x00\x09\xe9\x43\x00\x00\x39\x00\x00\x00"
	  append search  "\x78\x00\xef\xa6\x7c\xab\x48\x38\x78\x00\x1f\xa4\x7d\x6b\x03\x78"
      set replace    "\x39\x20\xff\xff\x39\x20\x00\x09\xe9\x43\x00\x00\x39\x00\x00\x00"
	  append replace "\x78\x00\xef\xa6\x7c\xab\x48\x38\x78\x00\x1f\xa4\x7d\x6b\x03\x78"

      catch_die {::patch_elf $elf $search 4 $replace} "Unable to patch self [file tail $elf]"
	  }
	  
	  if {$::patch_lv1::options(--patch-lv1-breakpoints)} {
	  # Patch LV1 to allow setting breakpoints
	  log "Patching LV1 hypervisor to allow setting data access breakpoints in hypervisor state with lv1_set_dabr (1064180)"
	  log "Confirmed Legit by RedDot-3ND7355"

      set search  "\x60\x00\x00\x00\x38\x00\x00\x0b\x7f\xe9\x00\x38\x7f\xa9\xf8\x00"
      set replace "\x38\x00\x00\x0f\x38\x00\x00\x0b\x7f\xe9\x00\x38\x7f\xa9\xf8\x00"

      catch_die {::patch_elf $elf $search 4 $replace} "Unable to patch self [file tail $elf]"
	  }
	  
	  if {$::patch_lv1::options(--patch-lv1-GPU)} {
      # Patch LV1 to allow IO 4kb of page size for GPU
      log "Patching LV1 hypervisor to allow 4kb IO page size for GPU GART memory (215440)"
      log "Confirmed Legit by RedDot-3ND7355"
	  
      set search  "\x6d\x00\x55\x55\x2f\xa9\x00\x00\x68\x00\x55\x55\x39\x20\x00\x00"
      set replace "\x38\x00\x10\x00\x2f\xa9\x00\x00\x68\x00\x55\x55\x39\x20\x00\x00"

      catch_die {::patch_elf $elf $search 84 $replace} "Unable to patch self [file tail $elf]"
	  }
	  
	  if {$::patch_lv1::options(--patch-lv1-indi)} {
	  # Patch LV1 Indi info manager
	  log "Patching Indi Info Manager to allow access to all its services (3409824)"
      log "Confirmed Legit by RedDot-3ND7355"
	  
      set search  "\x38\x60\x00\x0d\x38\x00\x00\x0d\x7c\x63\x00\x38\x4e\x80\x00\x20"
      set replace "\x38\x60\x00\x00\x38\x00\x00\x0d\x7c\x63\x00\x38\x4e\x80\x00\x20"

      catch_die {::patch_elf $elf $search 8 $replace} "Unable to patch self [file tail $elf]"
	  }
	  
	  if {$::patch_lv1::options(--patch-lv1-pkg-types)} {
	  # Patch LV1 to enable all package types extraction
	  log "Patching Update Manager to enable extracting for all package types (2904128)"
	  log "Confirmed Legit by RedDot-3ND7355"
	  
      set search  "\x38\x1f\xff\xf9\x2f\x1d\x00\x01\x2b\x80\x00\x01\x38\x00\x00\x00"
      append search "\xf8\x1b\x00\x00\x41\x9d\x00\xa8\x7b\xfd\x00\x20\x7f\x44\xd3\x78"
      set replace "\x60\x00\x00\x00\x2f\x1d\x00\x01\x2b\x80\x00\x01\x38\x00\x00\x00"
	  append replace "\xf8\x1b\x00\x00\x41\x9d\x00\xa8\x7b\xfd\x00\x20\x7f\x44\xd3\x78"

	  catch_die {::patch_elf $elf $search 20 $replace} "Unable to patch self [file tail $elf]"
	  }
	  
	  if {$::patch_lv1::options(--patch-lv1-updat-manag)} {
	  # Patch LV1 to enable product mode using update manager
	  log "Patching Update Manager to enable setting product mode by using Update Manager Write EPROM (2914856)"
	  log "Confirmed Legit by RedDot-3ND7355"
	  
      set search  "\xe8\x18\x00\x08\x2f\xa0\x00\x00\x40\x9e\x00\x10\x7f\xc3\xf3\x78"
      set replace "\x38\x00\x00\x00\x2f\xa0\x00\x00\x40\x9e\x00\x10\x7f\xc3\xf3\x78"

      catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
	  }
	  
	  if {$::patch_lv1::options(--patch-lv1-ENCDEC)} {
	  # Patch LV1 to allow deleting all ENCDEC keys
	  log "Patching Storage Manager to allow deleting of all ENCDEC keys (2999328)"
	  log "Confirmed Legit by RedDot-3ND7355"
	  
      set search  "\x7d\x24\x4b\x78\x39\x29\xff\xf4\x7f\xa3\xeb\x78\x2b\xa9\x00\x03"
      append search "\x38\x00\x00\x09\x41\x9d\x00\x4c"
      set replace "\x60\x00\x00\x00\x39\x29\xff\xf4\x7f\xa3\xeb\x78\x2b\xa9\x00\x03"
	  append replace "\x38\x00\x00\x09\x41\x9d\x00\x4c"

      catch_die {::patch_elf $elf $search 20 $replace} "Unable to patch self [file tail $elf]"
	  }

	  if {$::patch_lv1::options(--patch-lv1-lpar)} {
	  log "Patching LV1 hypervisor to allow creating/modifying/deleting of repository nodes in any LPAR"
      log "Patching LV1 hypervisor to allow creating/modifying/deleting of repository nodes in any LPAR 1/3 (1038416)"
	  log "Confirmed Legit by RedDot-3ND7355"
			
      set search  "\x39\x20\x00\x00\xe9\x69\x00\x00\x4b\xff\xff\x68\x3d\x2d\x00\x00\x7c\x08\x02\xa6"
	  append search "\xf8\x21\xff\x11\x39\x29\x98\x18\xfb\xa1\x00\xd8"
      set replace  "\xe8\x1e\x00\x20\xe9\x3e\x00\x28\xe9\x5e\x00\x30\xe9\x1e\x00\x38\xe8\xfe\x00\x40"
	  append replace "\xe8\xde\x00\x48\xeb\xfe\x00\x18\xfb\xa1\x00\xd8"

      catch_die {::patch_elf $elf $search 64 $replace} "Unable to patch self [file tail $elf]"

	  log "Patching LV1 hypervisor to allow creating/modifying/deleting of repository nodes in any LPAR 2/3 (1039604)"
      log "Confirmed Legit by RedDot-3ND7355"
			
      set search  "\x39\x20\x00\x00\xe9\x29\x00\x00\x4b\xff\xff\x9c\x3d\x2d\x00\x00\x7c\x08\x02\xa6"
	  append search "\xf8\x21\xff\x11\x39\x29\x98\x18\xfb\xa1\x00\xd8"
      set replace  "\xe8\x1e\x00\x20\xe9\x3e\x00\x28\xe9\x5e\x00\x30\xe9\x1e\x00\x38\xe8\xfe\x00\x40"
	  append replace "\xe8\xde\x00\x48\xeb\xfe\x00\x18\xfb\xa1\x00\xd8"

      catch_die {::patch_elf $elf $search 64 $replace} "Unable to patch self [file tail $elf]"

      log "Patching LV1 hypervisor to allow creating/modifying/deleting of repository nodes in any LPAR 3/3 (1037772)"
	  log "Confirmed Legit by RedDot-3ND7355"
			
      set search  "\x39\x20\x00\x00\xe9\x29\x00\x00\x4b\xff\xfe\x70\x3d\x2d\x00\x00\x7c\x08\x02\xa6"
	  append search "\xf8\x21\xff\x31\x39\x29\x98\x18\xfb\xa1\x00\xb8"
      set replace  "\xe8\x1e\x00\x20\xe9\x5e\x00\x28\xe9\x1e\x00\x30\xe8\xfe\x00\x38\xeb\xfe\x00\x18"
	  append replace "\xf8\x21\xff\x31\x39\x29\x98\x18\xfb\xa1\x00\xb8"

      catch_die {::patch_elf $elf $search 60 $replace} "Unable to patch self [file tail $elf]"
	  }

	  if {$::patch_lv1::options(--patch-lv1-mmap)} {
	   # Patching LV1 mmap out
		    log "Patching LV1 hypervisor to allow mapping of any memory area for 4.xx (1006151)"
			log "Feature fixed by RedDot-3ND7355"
			log "OHH MYY GOD!"

            set search  "\x41\x9E\xFF\xF0\x4B\xFF\xFD\x00\x38\x60\x00\x00\x4B\xFF\xFC\x58"
            set replace "\x01\x9E\xFF\xF0\x4B\xFF\xFD\x00\x38\x60\x00\x00\x4B\xFF\xFC\x58"

            catch_die {::patch_elf $elf $search 7 $replace} "Unable to patch self [file tail $elf]"
	  }
	  
	  if {$::patch_lv1::options(--patch-lv1-other)} {
		
		    log "Using toolboy's patterns!"
            log "Patching LV1 hypervisor - peek/poke support(1189356) part 1/2"         
            set search  "\x38\x00\x00\x00\x64\x00\xff\xff\x60\x00\xff\xec\xf8\x03\x00\xc0"
	        append search "\x4e\x80\x00\x20\x38\x00\x00\x00"
            set replace "\xe8\x83\x00\x18\xe8\x84\x00\x00\xf8\x83\x00\xc8"         				

			catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
         
			log "Patching LV1 hypervisor - peek/poke support(1189356) part 2/2" 
            set search  "\x4e\x80\x00\x20\x38\x00\x00\x00\x64\x00\xff\xff\x60\x00\xff\xec"
	        append search "\xf8\x03\x00\xc0\x4e\x80\x00\x20"
            set replace "\xe8\xa3\x00\x20\xe8\x83\x00\x18\xf8\xa4\x00\x00"         			

			catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"    
            
			log "Patching to remove lv2 protect!"
			set search  "\x41\x9E\x00\x20\xE8\x62\x8A"
            set replace "\x48\x00"		
			
			catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"  
       }
	}
  }
  