#!/usr/bin/tclsh
#
# ps3mfw -- PS3 MFW creator
#
# Copyright (C) Anonymous Developers (Code Monkeys)
#
# This software is distributed under the terms of the GNU General Public
# License ("GPL") version 3, as published by the Free Software Foundation.
#
 
# Priority: 20
# Description: [4.46] Add Cobra files! Cobra ONLY -- Select it's LV0,LV1,LV2 & VSH Patches!

# Option --label5: Part 1
# Option --patch-ps2emu-cobra446: [4.46] Patch PS2EMU [SELF] -- devflash\ps2emu\ patch 1!
# Option --patch-ps2emu-cobra453: [4.53] Patch PS2EMU [SELF] -- Controller sync errors, Not Used...Use PS2 Classic-PlaceHolder!
# Option --label6: Part 2
# Option --patch-ps2gxemu-cobra446: [4.46] Patch PS2GXEMU [SELF] -- ps2emu patches!
# Option --patch-ps2gxemu-cobra453: [4.53] Patch PS2GXEMU [SELF] -- No ps2gxemu patch! Not Used!
# Option --label7: Part 3
# Option --patch-ps2netemu-cobra446: [4.46] Patch PS2NETEMU [SELF] -- ps2emu patches!
# Option --patch-ps2netemu-cobra453: [4.53] Patch PS2NETEMU [SELF] -- No ps2netemu patch! Not Used!
# Option --label8: Part 4
# Option --label: * Leave TXTBOX as is! --   When the 2 POPUP Boxes show for each SELF [Ignore those 2 btw!]
# Option --label1: * Browse to the PS3MFW Builder dir and c/paste the 2 PS2EMU stage2.bin's in the BUILD DIR
# Option --label2: * PS3MFW-MFW\update_files\dev_flash\dev_flash\ps2emu\ -- Close the BUILD DIR!! and Hit OK!
# Option --label3: * [4.46] Browse to the PS3MFW Builder dir and c/paste the MAIN stage2.bin in the BUILD DIR
# Option --label4: * [4.46] PS3MFW-MFW\update_files\dev_flash\dev_flash\sys\ -- Close the BUILD DIR!! and Hit OK!
# Option --add-cobrabins:          *** Add the 3 Cobra BIN's For 4.46 Only ***

# Type --label5: label
# Type --patch-ps2emu-cobra446: boolean
# Type --patch-ps2emu-cobra453: boolean
# Type --label6: label
# Type --patch-ps2gxemu-cobra446: boolean
# Type --patch-ps2gxemu-cobra453: boolean
# Type --label7: label
# Type --patch-ps2netemu-cobra446: boolean
# Type --patch-ps2netemu-cobra453: boolean
# Type --label8: label
# Type --label: label
# Type --label1: label
# Type --label2: label
# Type --label3: label
# Type --label4: label
# Type --add-cobrabins: textarea


namespace eval cobra {

    array set ::cobra::options {
	    --label5 ""
		--patch-ps2emu-cobra446 true
		--patch-ps2emu-cobra453 false
		--label6 ""
		--patch-ps2gxemu-cobra446 true
		--patch-ps2gxemu-cobra453 false
		--label7 ""
		--patch-ps2netemu-cobra446 true
		--patch-ps2netemu-cobra453 false
		--label8 ""
		--label ""
		--label1 ""
		--label2 ""
		--label3 ""
		--label4 ""
        --add-cobrabins "dev_flash/ps2emu/ps2_emu.self
dev_flash/sys/internal/sys_init_osd.self"
    }

    proc main {} {
	log "Part 1"
	    set self [file join dev_flash ps2emu ps2_emu.self]
		set ::SELF "ps2_emu.self"
        ::modify_devflash_file $self ::cobra::patch_self1
	log "Part 1 Done"
	log "Part 2"
	    set self [file join dev_flash ps2emu ps2_gxemu.self]
		set ::SELF "ps2_gxemu.self"
        ::modify_devflash_file $self ::cobra::patch_self2
	log "Part 2 Done"
	log "Part 3"
	    set self [file join dev_flash ps2emu ps2_netemu.self]
	    set ::SELF "ps2_netemu.self"
        ::modify_devflash_file $self ::cobra::patch_self3
	log "Part 3 Done"
	log "Part 4"
	    
        variable options
        foreach file [split $options(--add-cobrabins) "\n"] {
            if {[string equal -length 14 "dev_flash/path" ${file}] != 1} {
                if {[string equal -length 10 "dev_flash/" ${file}] == 1} {
					::modify_devflash_file ${file} ::cobra::change_file
                }
            }
        }
	log "Part 4 Done"
    }

    proc change_file { file } {
        log "The file to change is in ${file}"

        if {[package provide Tk] != "" } {
           tk_messageBox -default ok -message "Ignore! this file: '${file}' , Browse to the PS3MFW builder dir and place the BIN's in it's proper place!
		   close the BUILD DIR!!!...then press ok to continue" -icon warning
        } else {
           puts "Press \[RETURN\] or \[ENTER\] to continue"
           gets stdin
        }
    }
	
	proc patch_self1 { self } {
            if { ${::OLDROUTINE} == "1" } {
			::modify_self_file $self ::cobra::patch_elf1
            } elseif { ${::OLDROUTINE} == "0" } {
			::modify_self_file2 $self ::cobra::patch_elf1
			}
	}
	
	proc patch_self2 { self } {
            if { ${::OLDROUTINE} == "1" } {
			::modify_self_file $self ::cobra::patch_elf2
            } elseif { ${::OLDROUTINE} == "0" } {
			::modify_self_file2 $self ::cobra::patch_elf2
			}
	}
	
	proc patch_self3 { self } {
            if { ${::OLDROUTINE} == "1" } {
			::modify_self_file $self ::cobra::patch_elf3
            } elseif { ${::OLDROUTINE} == "0" } {
			::modify_self_file2 $self ::cobra::patch_elf3
			}
	}
	
	proc patch_elf1 { elf } {
	    if {$::cobra::options(--patch-ps2emu-cobra446) } {
            log "Part 1 --Patching ps2emu [file tail $elf] to allow Cobra Features"
            set search "\x7D\x80\x00\x26\xE8\x62\x8D\x68\xF8\x21\xFE\xE1"
            append search "\xFA\xA1\x00\xC8\x3A\xA1\x00\xB0\xFA\xC1\x00\xD0"
            append search "\x3A\xC1\x00\xA0\xFB\x01\x00\xE0\x3B\x01\x00\x90"
            append search "\xFA\xE1\x00\xD8\xFB\x21\x00\xE8\xFB\x41\x00\xF0"
            append search "\xFB\x61\x00\xF8\xFB\x81\x01\x00\xFB\xA1\x01\x08"
            append search "\xFB\xC1\x01\x10\xFB\xE1\x01\x18\x91\x81\x01\x28"
            append search "\x7C\x08\x02\xA6\xF8\x01\x01\x30\x4B\xFD\xFE\x89"
            append search "\x60\x00\x00\x00\x4B\xFF\xE6\x9D\x4B\xFD\xF0\x79"
            append search "\x60\x00\x00\x00\xE9\x22\x8D\x70\x80\x69\x00\x00"
            append search "\x2F\x83\x00\x00\x41\x9E\x00\x44\xE8\xA2\x8D\x20"
            append search "\x3D\x40\x70\x00\x3D\x60\x20\x00\x38\x60\x00\x82"
            append search "\xE8\x85\x00\x00\x7C\x89\x50\x38\x7C\x29\x58\x00"
            append search "\x41\x82\x00\x1C\x7C\xA9\x58\x40\x41\x85\x04\xD4"
            append search "\x2D\x29\x00\x00\x38\x60\x00\x00\x41\x8A\x00\x08"
            append search "\x38\x60\x00\x81\x4B\xFF\xB2\xA5\x60\x00\x00\x00"
            append search "\x38\x60\x00\x01\xE8\x82\x8D\x78\x44\x00\x00\x02"
			
            set replace "\xF8\x21\xFF\x61\x7C\x08\x02\xA6\xF8\x01\x00\xB0"
            append replace "\xFA\xE1\x00\x70\xFB\x01\x00\x78\xFB\x21\x00\x80"
            append replace "\xFB\x41\x00\x88\xFB\xE1\x00\x90\xFB\xC1\x00\x98"
            append replace "\x7C\x77\x1B\x78\x7C\x98\x23\x78\x7C\xB9\x2B\x78"
            append replace "\x7C\xDA\x33\x78\x3F\xE0\x02\x1F\x3B\xFF\x00\x00"
            append replace "\x38\x60\x00\x00\x3C\x80\x00\x02\x38\x84\x3D\x78"
            append replace "\x48\x04\xE0\x2B\x7C\x7E\x1B\x78\x38\x80\x00\x00"
            append replace "\x7F\xE5\xFB\x78\x3C\xC0\x00\x01\x48\x04\xDA\xFB"
            append replace "\x7F\xC3\xF3\x78\x48\x04\xE7\xB7\x7F\xE3\xFB\x78"
            append replace "\x3C\x80\x00\x01\x48\x00\x00\x25\x7E\xE3\xBB\x78"
            append replace "\x7F\x04\xC3\x78\x7F\x25\xCB\x78\x7F\x46\xD3\x78"
            append replace "\x7F\xE9\x03\xA6\x4E\x80\x04\x21\x2F\x76\x6D\x2F"
            append replace "\x70\x6D\x30\x00\x7C\x83\x22\x14\x78\x63\x06\x24"
            append replace "\x7C\x23\x20\x40\x40\x80\x00\x1C\x7C\x00\x18\x6C"
            append replace "\x7C\x00\x04\xAC\x7C\x00\x1F\xAC\x4C\x00\x01\x2C"
            append replace "\x38\x63\x00\x80\x4B\xFF\xFF\xE4\x4E\x80\x00\x20"

            catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
			
			log "Part 2"
			log "Patching 446 ps2emu Cobra Features"
			
			set search "\x00\x00\x00\x00\x00\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x00"
            append search "\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x18\x0B\x64"
			
			set replace "\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00\x00\x00\x00\x00\x00"
            append replace "\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x18\x0B\x64"
			
			catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
			
			log "Part 3"
			log "Patching 446 ps2emu Cobra Features"
			
			set search "\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x4F\x78\xB0"
            append search "\x00\x00\x00\x00\x00\x50\x78\xB0\x00\x00\x00\x00\x00\xB8\x25\x40"

            set replace "\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00\x00\x00\x4F\x78\xB0"
            append replace "\x00\x00\x00\x00\x00\x50\x78\xB0\x00\x00\x00\x00\x00\xB8\x25\x40"
			
			catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
			
        }
	    if {$::cobra::options(--patch-ps2emu-cobra453) } {
            log "Patching 4.53 [file tail $elf] to allow Cobra Features"
            set search "\x7D\x80\x00\x26\xE8\x62\x8D\x68\xF8\x21\xFE\xE1"
            append search "\xFA\xA1\x00\xC8\x3A\xA1\x00\xB0\xFA\xC1\x00\xD0"
            append search "\x3A\xC1\x00\xA0\xFB\x01\x00\xE0\x3B\x01\x00\x90"
            append search "\xFA\xE1\x00\xD8\xFB\x21\x00\xE8\xFB\x41\x00\xF0"
            append search "\xFB\x61\x00\xF8\xFB\x81\x01\x00\xFB\xA1\x01\x08"
            append search "\xFB\xC1\x01\x10\xFB\xE1\x01\x18\x91\x81\x01\x28"
            append search "\x7C\x08\x02\xA6\xF8\x01\x01\x30\x4B\xFD\xFE\x89"
            append search "\x60\x00\x00\x00\x4B\xFF\xE6\x9D\x4B\xFD\xF0\x79"
            append search "\x60\x00\x00\x00\xE9\x22\x8D\x70\x80\x69\x00\x00"
            append search "\x2F\x83\x00\x00\x41\x9E\x00\x44\xE8\xA2\x8D\x20"
            append search "\x3D\x40\x70\x00\x3D\x60\x20\x00\x38\x60\x00\x82"
            append search "\xE8\x85\x00\x00\x7C\x89\x50\x38\x7C\x29\x58\x00"
            append search "\x41\x82\x00\x1C\x7C\xA9\x58\x40\x41\x85\x04\xD4"
            append search "\x2D\x29\x00\x00\x38\x60\x00\x00\x41\x8A\x00\x08"
            append search "\x38\x60\x00\x81\x4B\xFF\xB2\xA5\x60\x00\x00\x00"
            append search "\x38\x60\x00\x01\xE8\x82\x8D\x78\x44\x00\x00\x02"
			
            set replace "\xF8\x21\xFF\x61\x7C\x08\x02\xA6\xF8\x01\x00\xB0"
            append replace "\xFA\xE1\x00\x70\xFB\x01\x00\x78\xFB\x21\x00\x80"
            append replace "\xFB\x41\x00\x88\xFB\xE1\x00\x90\xFB\xC1\x00\x98"
            append replace "\x7C\x77\x1B\x78\x7C\x98\x23\x78\x7C\xB9\x2B\x78"
            append replace "\x7C\xDA\x33\x78\x3F\xE0\x02\x1F\x3B\xFF\x00\x00"
            append replace "\x38\x60\x00\x00\x3C\x80\x00\x02\x38\x84\x3D\x78"
            append replace "\x48\x04\xE0\x2B\x7C\x7E\x1B\x78\x38\x80\x00\x00"
            append replace "\x7F\xE5\xFB\x78\x3C\xC0\x00\x01\x48\x04\xDA\xFB"
            append replace "\x7F\xC3\xF3\x78\x48\x04\xE7\xB7\x7F\xE3\xFB\x78"
            append replace "\x3C\x80\x00\x01\x48\x00\x00\x25\x7E\xE3\xBB\x78"
            append replace "\x7F\x04\xC3\x78\x7F\x25\xCB\x78\x7F\x46\xD3\x78"
            append replace "\x7F\xE9\x03\xA6\x4E\x80\x04\x21\x2F\x76\x6D\x2F"
            append replace "\x70\x6D\x30\x00\x7C\x83\x22\x14\x78\x63\x06\x24"
            append replace "\x7C\x23\x20\x40\x40\x80\x00\x1C\x7C\x00\x18\x6C"
            append replace "\x7C\x00\x04\xAC\x7C\x00\x1F\xAC\x4C\x00\x01\x2C"
            append replace "\x38\x63\x00\x80\x4B\xFF\xFF\xE4\x4E\x80\x00\x20"

            catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
			
			log "Part 2"
			log "Patching 453 ps2emu Cobra Features"
			
			set search "\x00\x00\x00\x00\x00\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x00"
            append search "\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x18\x0B\x70"
			
			set replace "\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00\x00\x00\x00\x00\x00"
            append replace "\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x18\x0B\x70"
			
			catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
			
			log "Part 3"
			log "Patching 453 ps2emu Cobra Features"
			
			set search "\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x4F\x78\xB0"
            append search "\x00\x00\x00\x00\x00\x50\x78\xB0\x00\x00\x00\x00\x00\xB8\x25\x40"

            set replace "\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00\x00\x00\x4F\x78\xB0"
            append replace "\x00\x00\x00\x00\x00\x50\x78\xB0\x00\x00\x00\x00\x00\xB8\x25\x40"
			
			catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
		}
    }
	
	proc patch_elf2 { elf } {
	if {$::cobra::options(--patch-ps2gxemu-cobra446) } {
            log "Patching ps2gxemu [file tail $elf] to allow Cobra Features"
            set search "\x7F\x45\x4C\x46\x02\x02\x01\x66\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x02\x00\x15\x00\x00\x00\x01"
append search "\x00\x00\x00\x00\x00\x00\x00\x94\x00\x00\x00\x00"
append search "\x00\x00\x00\x40\x00\x00\x00\x00\x00\x68\xCE\xA0"
append search "\x00\x00\x00\x00\x00\x40\x00\x38\x00\x01\x00\x40"
append search "\x00\x61\x00\x60\x00\x00\x00\x01\x00\x00\x00\x07"
append search "\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x67\x78\x20\x00\x00\x00\x00"
append search "\x02\xBB\x8C"
			
set replace "\x7F\x45\x4C\x46\x02\x02\x01\x66\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x02\x00\x15\x00\x00\x00\x01"
append replace "\x00\x00\x00\x00\x00\x00\x00\x94\x00\x00\x00\x00"
append replace "\x00\x00\x00\x40\x00\x00\x00\x00\x00\x68\xCE\xA0"
append replace "\x00\x00\x00\x00\x00\x40\x00\x38\x00\x01\x00\x40"
append replace "\x00\x61\x00\x60\x00\x00\x00\x01\x00\x00\x00\x07"
append replace "\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x67\x78\x20\x00\x00\x00\x00"
append replace "\x02\xBC\x8C"

            catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
			
			log "Part 2"
			log "Patching 446 ps2gxemu Cobra Features"
			
			set search "\x81\x7C\x08\x02\xA6\xFB\xC1\x00\x70\x7C\x7E\x1B"
append search "\x78\xF8\x01\x00\x90\x80\x03\x00\x04\xFB\xE1\x00"
append search "\x78\x2F\x80\x00\x00\x41\x9E\x00\x1C\xE8\x62\xA4"
append search "\x00\x4B\xFC\xA4\xB1\x60\x00\x00\x00\x7F\xC3\xF3"
append search "\x78\x38\x80\x00\x13\x4B\xFF\xF2\x3D\xEB\xE2\xA3"
append search "\x00\x88\x1F\x00\x0A\x2F\xA0\x00\x00\x41\x9E\x00"
append search "\x64\x2F\x80\x00\x01\x41\x9E\x02\x4C\x2F\x80\x00"
append search "\x12\x41\x9E\x02\xD0\x2F\x80\x00\x06\x41\x9E\x01"
append search "\x44\x7D\x20\x00\xA6\x55\x20\x04\x20\x2F\xA0\x00"
append search "\x00\x41\xDE\x03\xD4\x79\x29\x80\x42\x79\x29\x80"
append search "\x00\x7D\x20\x01\x64\x7F\xC3\xF3\x78\x4B\xFF\xF1"
append search "\x39\x7C\x00\x00\xA6\x60\x00\x80\x00\x7C\x00\x01"
append search "\x64\xE8\x01\x00\x90\xEB\xC1\x00\x70\xEB\xE1\x00"
append search "\x78\x7C\x08\x03\xA6\x38\x21\x00\x80\x4E\x80\x00"
append search "\x20\x7F\xC3\xF3\x78\x4B\xFF\xFE\x49\x88\x1F\x00"
append search "\x0A\x54\x00\x07\xFE\x2F\x80\x00\x00"
			
			set replace "\x61\x7C\x08\x02\xA6\xF8\x01\x00\xB0\xFA\xE1\x00"
append replace "\x70\xFB\x01\x00\x78\xFB\x21\x00\x80\xFB\x41\x00"
append replace "\x88\xFB\xE1\x00\x90\xFB\xC1\x00\x98\x7C\x77\x1B"
append replace "\x78\x7C\x98\x23\x78\x7C\xB9\x2B\x78\x7C\xDA\x33"
append replace "\x78\x3F\xE0\x02\xBC\x3B\xFF\x8C\x28\x38\x60\x00"
append replace "\x00\x3C\x80\x00\x09\x38\x84\xCB\x24\x48\x24\xEB"
append replace "\x73\x7C\x7E\x1B\x78\x38\x80\x00\x00\x7F\xE5\xFB"
append replace "\x78\x3C\xC0\x00\x01\x48\x24\xE8\x83\x7F\xC3\xF3"
append replace "\x78\x48\x24\xF3\x1B\x7F\xE3\xFB\x78\x3C\x80\x00"
append replace "\x01\x48\x00\x00\x25\x7E\xE3\xBB\x78\x7F\x04\xC3"
append replace "\x78\x7F\x25\xCB\x78\x7F\x46\xD3\x78\x7F\xE9\x03"
append replace "\xA6\x4E\x80\x04\x21\x2F\x76\x6D\x2F\x70\x6D\x30"
append replace "\x00\x7C\x83\x22\x14\x78\x63\x06\x24\x7C\x23\x20"
append replace "\x40\x40\x80\x00\x1C\x7C\x00\x18\x6C\x7C\x00\x04"
append replace "\xAC\x7C\x00\x1F\xAC\x4C\x00\x01\x2C\x38\x63\x00"
append replace "\x80\x4B\xFF\xFF\xE4\x4E\x80\x00\x20"
			catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
			
			log "Part 3 - Pls be patient, takes awhile!"
			log "Patching 446 ps2gxemu Cobra Features"
			
			set search "\x0B\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x20"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x14\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x06\x00\x00\x00\x00\x00\x00\x20"
append search "\x00\x00\x00\x00\x00\x00\x01\x20\x00\x00\x00\x00"
append search "\x00\x00\x00\x02\xC0\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00"
append search "\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x01\x23"
append search "\x00\x00\x00\x00\x00\x00\x00\x44\x80\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x1E\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x06\x00\x00\x00\x00\x00\x00\x67\x80\x00\x00\x00"
append search "\x00\x00\x01\x67\x80\x00\x00\x00\x00\x00\x00\x01"
append search "\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x0E\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x00\x80"
append search "\x00\x00\x00\x00\x00\x00\x01\x80\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x90\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00"
append search "\x00\x00\x00\x80\x90\x00\x00\x00\x00\x00\x01\x80"
append search "\x90\x00\x00\x00\x00\x00\x00\x39\x18\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x2C\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x06\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00"
append search "\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x78"
append search "\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x37\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x06\x00\x00\x00\x00\x00\x01\x78"
append search "\x78\x00\x00\x00\x00\x00\x02\x78\x78\x00\x00\x00"
append search "\x00\x00\x00\x1E\x08\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x42\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x06\x00\x00\x00"
append search "\x00\x00\x01\x96\x80\x00\x00\x00\x00\x00\x02\x96"
append search "\x80\x00\x00\x00\x00\x00\x01\xE8\xFC\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x4B\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x06\x00\x00\x00\x00\x00\x03\x7F\x7C\x00\x00\x00"
append search "\x00\x00\x04\x7F\x7C\x00\x00\x00\x00\x00\x00\x6E"
append search "\x4C\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x51\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x06\x00\x00\x00\x00\x00\x03\xEE"
append search "\x00\x00\x00\x00\x00\x00\x04\xEE\x00\x00\x00\x00"
append search "\x00\x00\x21\x22\x5C\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x57\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x06\x00\x00\x00"
append search "\x00\x00\x25\x10\x5C\x00\x00\x00\x00\x00\x26\x10"
append search "\x5C\x00\x00\x00\x00\x00\x00\x08\xA4\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x80\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x06\x00\x00\x00\x00\x00\x25\x19\x00\x00\x00\x00"
append search "\x00\x00\x26\x19\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\xB0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\xB5\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x06\x00\x00\x00\x00\x00\x25\x19"
append search "\xB0\x00\x00\x00\x00\x00\x26\x19\xB0\x00\x00\x00"
append search "\x00\x00\x00\x05\xE4\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\xBC\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x06\x00\x00\x00"
append search "\x00\x00\x25\x1F\x94\x00\x00\x00\x00\x00\x26\x1F"
append search "\x94\x00\x00\x00\x00\x00\x00\x01\xC0\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\xEB\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x06\x00\x00\x00\x00\x00\x25\x21\x54\x00\x00\x00"
append search "\x00\x00\x26\x21\x54\x00\x00\x00\x00\x00\x00\x05"
append search "\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x01\x21\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x06\x00\x00\x00\x00\x00\x25\x26"
append search "\x8C\x00\x00\x00\x00\x00\x26\x26\x8C\x00\x00\x00"
append search "\x00\x00\x00\x00\x0C\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x01\x4E\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x06\x00\x00\x00"
append search "\x00\x00\x25\x26\x98\x00\x00\x00\x00\x00\x26\x26"
append search "\x98\x00\x00\x00\x00\x00\x00\x00\x2C\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01"
append search "\x7B\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x06\x00\x00\x00\x00\x00\x25\x26\xC4\x00\x00\x00"
append search "\x00\x00\x26\x26\xC4\x00\x00\x00\x00\x00\x00\x02"
append search "\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x01\xA5\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x06\x00\x00\x00\x00\x00\x25\x28"
append search "\xD8\x00\x00\x00\x00\x00\x26\x28\xD8\x00\x00\x00"
append search "\x00\x00\x00\x01\x64\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x01\xDC\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x06\x00\x00\x00"
append search "\x00\x00\x25\x2A\x3C\x00\x00\x00\x00\x00\x26\x2A"
append search "\x3C\x00\x00\x00\x00\x00\x00\x02\x44\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02"
append search "\x11\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x06\x00\x00\x00\x00\x00\x25\x2C\x80\x00\x00\x00"
append search "\x00\x00\x26\x2C\x80\x00\x00\x00\x00\x00\x00\x02"
append search "\x64\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x02\x46\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x06\x00\x00\x00\x00\x00\x25\x2E"
append search "\xE4\x00\x00\x00\x00\x00\x26\x2E\xE4\x00\x00\x00"
append search "\x00\x00\x00\x03\xC8\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x02\x68\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x06\x00\x00\x00"
append search "\x00\x00\x25\x32\xAC\x00\x00\x00\x00\x00\x26\x32"
append search "\xAC\x00\x00\x00\x00\x00\x00\x02\xE0\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02"
append search "\xA0\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x06\x00\x00\x00\x00\x00\x25\x35\x8C\x00\x00\x00"
append search "\x00\x00\x26\x35\x8C\x00\x00\x00\x00\x00\x00\x01"
append search "\x2C\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x02\xD3\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x06\x00\x00\x00\x00\x00\x25\x36"
append search "\xB8\x00\x00\x00\x00\x00\x26\x36\xB8\x00\x00\x00"
append search "\x00\x00\x00\x00\x98\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x06\x00\x00\x00"
append search "\x00\x00\x25\x37\x50\x00\x00\x00\x00\x00\x26\x37"
append search "\x50\x00\x00\x00\x00\x00\x00\x01\x5C\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03"
append search "\x20\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x06\x00\x00\x00\x00\x00\x25\x38\xAC\x00\x00\x00"
append search "\x00\x00\x26\x38\xAC\x00\x00\x00\x00\x00\x00\x00"
append search "\x0C\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x03\x3E\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x06\x00\x00\x00\x00\x00\x25\x38"
append search "\xB8\x00\x00\x00\x00\x00\x26\x38\xB8\x00\x00\x00"
append search "\x00\x00\x00\x00\x0C\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x03\x5C\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x06\x00\x00\x00"
append search "\x00\x00\x25\x38\xC4\x00\x00\x00\x00\x00\x26\x38"
append search "\xC4\x00\x00\x00\x00\x00\x00\x00\x0C\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03"
append search "\x85\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x06\x00\x00\x00\x00\x00\x25\x38\xD0\x00\x00\x00"
append search "\x00\x00\x26\x38\xD0\x00\x00\x00\x00\x00\x00\x00"
append search "\x0C\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x03\xAD\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x06\x00\x00\x00\x00\x00\x25\x38"
append search "\xDC\x00\x00\x00\x00\x00\x26\x38\xDC\x00\x00\x00"
append search "\x00\x00\x00\x00\x0C\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x03\xCF\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x06\x00\x00\x00"
append search "\x00\x00\x25\x38\xE8\x00\x00\x00\x00\x00\x26\x38"
append search "\xE8\x00\x00\x00\x00\x00\x00\x00\x0C\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03"
append search "\xF4\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x06\x00\x00\x00\x00\x00\x25\x38\xF4\x00\x00\x00"
append search "\x00\x00\x26\x38\xF4\x00\x00\x00\x00\x00\x00\x00"
append search "\x0C\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x04\x1E\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x06\x00\x00\x00\x00\x00\x25\x39"
append search "\x00\x00\x00\x00\x00\x00\x26\x39\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x0C\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x04\x4A\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x06\x00\x00\x00"
append search "\x00\x00\x25\x39\x0C\x00\x00\x00\x00\x00\x26\x39"
append search "\x0C\x00\x00\x00\x00\x00\x00\x00\x0C\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04"
append search "\x75\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x06\x00\x00\x00\x00\x00\x25\x39\x18\x00\x00\x00"
append search "\x00\x00\x26\x39\x18\x00\x00\x00\x00\x00\x00\x00"
append search "\x0C\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x04\x9E\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x06\x00\x00\x00\x00\x00\x25\x39"
append search "\x24\x00\x00\x00\x00\x00\x26\x39\x24\x00\x00\x00"
append search "\x00\x00\x00\x00\x0C\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x04\xC6\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x06\x00\x00\x00"
append search "\x00\x00\x25\x39\x30\x00\x00\x00\x00\x00\x26\x39"
append search "\x30\x00\x00\x00\x00\x00\x00\x00\x0C\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04"
append search "\xEF\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x06\x00\x00\x00\x00\x00\x25\x39\x3C\x00\x00\x00"
append search "\x00\x00\x26\x39\x3C\x00\x00\x00\x00\x00\x00\x00"
append search "\x0C\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x05\x17\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x06\x00\x00\x00\x00\x00\x25\x39"
append search "\x48\x00\x00\x00\x00\x00\x26\x39\x48\x00\x00\x00"
append search "\x00\x00\x00\x00\x0C\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x05\x40\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x06\x00\x00\x00"
append search "\x00\x00\x25\x39\x54\x00\x00\x00\x00\x00\x26\x39"
append search "\x54\x00\x00\x00\x00\x00\x00\x00\x0C\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x05"
append search "\x6B\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x06\x00\x00\x00\x00\x00\x25\x39\x60\x00\x00\x00"
append search "\x00\x00\x26\x39\x60\x00\x00\x00\x00\x00\x00\x00"
append search "\x0C\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x05\x95\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x06\x00\x00\x00\x00\x00\x25\x39"
append search "\x6C\x00\x00\x00\x00\x00\x26\x39\x6C\x00\x00\x00"
append search "\x00\x00\x00\x00\x0C\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x05\xBA\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x06\x00\x00\x00"
append search "\x00\x00\x25\x39\x78\x00\x00\x00\x00\x00\x26\x39"
append search "\x78\x00\x00\x00\x00\x00\x00\x00\x0C\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x05"
append search "\xE6\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x06\x00\x00\x00\x00\x00\x25\x39\x84\x00\x00\x00"
append search "\x00\x00\x26\x39\x84\x00\x00\x00\x00\x00\x00\x00"
append search "\x0C\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x06\x08\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x06\x00\x00\x00\x00\x00\x25\x39"
append search "\x90\x00\x00\x00\x00\x00\x26\x39\x90\x00\x00\x00"
append search "\x00\x00\x00\x00\x0C\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x06\x30\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x06\x00\x00\x00"
append search "\x00\x00\x25\x39\x9C\x00\x00\x00\x00\x00\x26\x39"
append search "\x9C\x00\x00\x00\x00\x00\x00\x00\xC0\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06"
append search "\x68\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x06\x00\x00\x00\x00\x00\x25\x3A\x5C\x00\x00\x00"
append search "\x00\x00\x26\x3A\x5C\x00\x00\x00\x00\x00\x00\x01"
append search "\x4C\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x06\x9F\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x06\x00\x00\x00\x00\x00\x25\x3B"
append search "\xA8\x00\x00\x00\x00\x00\x26\x3B\xA8\x00\x00\x00"
append search "\x00\x00\x00\x01\x4C\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x06\xD7\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x06\x00\x00\x00"
append search "\x00\x00\x25\x3C\xF4\x00\x00\x00\x00\x00\x26\x3C"
append search "\xF4\x00\x00\x00\x00\x00\x00\x01\x74\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07"
append search "\x11\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x06\x00\x00\x00\x00\x00\x25\x3E\x68\x00\x00\x00"
append search "\x00\x00\x26\x3E\x68\x00\x00\x00\x00\x00\x00\x00"
append search "\xE8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x07\x4A\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x06\x00\x00\x00\x00\x00\x25\x3F"
append search "\x50\x00\x00\x00\x00\x00\x26\x3F\x50\x00\x00\x00"
append search "\x00\x00\x00\x00\xD4\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x07\x7E\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x06\x00\x00\x00"
append search "\x00\x00\x25\x40\x24\x00\x00\x00\x00\x00\x26\x40"
append search "\x24\x00\x00\x00\x00\x00\x00\x00\xFC\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07"
append search "\xB9\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x06\x00\x00\x00\x00\x00\x25\x41\x20\x00\x00\x00"
append search "\x00\x00\x26\x41\x20\x00\x00\x00\x00\x00\x00\x01"
append search "\x24\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x07\xEA\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x06\x00\x00\x00\x00\x00\x25\x42"
append search "\x44\x00\x00\x00\x00\x00\x26\x42\x44\x00\x00\x00"
append search "\x00\x00\x00\x00\xE8\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x08\x21\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00"
append search "\x00\x00\x25\x43\x80\x00\x00\x00\x00\x00\x26\x43"
append search "\x80\x00\x00\x00\x00\x00\x00\x60\xB0\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08"
append search "\x28\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x02\x00\x00\x00\x00\x00\x25\xA4\x80\x00\x00\x00"
append search "\x00\x00\x26\xA4\x80\x00\x00\x00\x00\x00\x0C\x7A"
append search "\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x08\x32\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x32\x1E"
append search "\xC0\x00\x00\x00\x00\x00\x33\x1E\xC0\x00\x00\x00"
append search "\x00\x00\x00\x72\xA4\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x08\x38\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00"
append search "\x00\x00\x32\x91\x68\x00\x00\x00\x00\x00\x33\x91"
append search "\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08"
append search "\x43\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x03\x00\x00\x00\x00\x00\x32\x91\x70\x00\x00\x00"
append search "\x00\x00\x33\x91\x70\x00\x00\x00\x00\x00\x00\x3E"
append search "\xD8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x08\x4D\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x32\xD0"
append search "\x48\x00\x00\x00\x00\x00\x33\xD0\x48\x00\x00\x00"
append search "\x00\x00\x00\xD7\x48\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x08\x5D\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00"
append search "\x00\x00\x33\xA7\x90\x00\x00\x00\x00\x00\x34\xA7"
append search "\x90\x00\x00\x00\x00\x00\x00\x33\x68\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08"
append search "\x6A\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x03\x00\x00\x00\x00\x00\x33\xDA\xF8\x00\x00\x00"
append search "\x00\x00\x34\xDA\xF8\x00\x00\x00\x00\x00\x00\xC5"
append search "\xE0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x08\x7D\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x34\xA0"
append search "\xD8\x00\x00\x00\x00\x00\x35\xA0\xD8\x00\x00\x00"
append search "\x00\x00\x00\x00\x38\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x08\xAA\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00"
append search "\x00\x00\x34\xA1\x10\x00\x00\x00\x00\x00\x35\xA1"
append search "\x10\x00\x00\x00\x00\x00\x00\x00\x38\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08"
append search "\xD6\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x03\x00\x00\x00\x00\x00\x34\xA1\x48\x00\x00\x00"
append search "\x00\x00\x35\xA1\x48\x00\x00\x00\x00\x00\x00\x00"
append search "\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x08\xDD\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x34\xA1"
append search "\x70\x00\x00\x00\x00\x00\x35\xA1\x70\x00\x00\x00"
append search "\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x09\x09\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00"
append search "\x00\x00\x34\xA1\x78\x00\x00\x00\x00\x00\x35\xA1"
append search "\x78\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09"
append search "\x2E\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x03\x00\x00\x00\x00\x00\x34\xA1\xA0\x00\x00\x00"
append search "\x00\x00\x35\xA1\xA0\x00\x00\x00\x00\x00\x00\x00"
append search "\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x09\x49\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x34\xA1"
append search "\xC8\x00\x00\x00\x00\x00\x35\xA1\xC8\x00\x00\x00"
append search "\x00\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x09\x68\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00"
append search "\x00\x00\x34\xA1\xF0\x00\x00\x00\x00\x00\x35\xA1"
append search "\xF0\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09"
append search "\x91\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x03\x00\x00\x00\x00\x00\x34\xA2\x18\x00\x00\x00"
append search "\x00\x00\x35\xA2\x18\x00\x00\x00\x00\x00\x00\x00"
append search "\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x09\xB3\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x34\xA2"
append search "\x40\x00\x00\x00\x00\x00\x35\xA2\x40\x00\x00\x00"
append search "\x00\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x09\xDA\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00"
append search "\x00\x00\x34\xA2\x68\x00\x00\x00\x00\x00\x35\xA2"
append search "\x68\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0A"
append search "\x02\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x03\x00\x00\x00\x00\x00\x34\xA2\x90\x00\x00\x00"
append search "\x00\x00\x35\xA2\x90\x00\x00\x00\x00\x00\x00\x00"
append search "\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x0A\x28\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x34\xA2"
append search "\xB8\x00\x00\x00\x00\x00\x35\xA2\xB8\x00\x00\x00"
append search "\x00\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x0A\x4D\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00"
append search "\x00\x00\x34\xA2\xE0\x00\x00\x00\x00\x00\x35\xA2"
append search "\xE0\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0A"
append search "\x73\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x02\x00\x00\x00\x00\x00\x34\xA3\x80\x00\x00\x00"
append search "\x00\x00\x35\xA3\x80\x00\x00\x00\x00\x00\x1D\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x0A\x7C\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x51\xA3"
append search "\x80\x00\x00\x00\x00\x00\x52\xA3\x80\x00\x00\x00"
append search "\x00\x00\x01\x72\x90\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x0A\x84\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x32\x00\x00\x00"
append search "\x00\x00\x53\x16\x10\x00\x00\x00\x00\x00\x54\x16"
append search "\x10\x00\x00\x00\x00\x00\x00\x5E\x9B\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x08\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x0A"
append search "\x93\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x02\x00\x00\x00\x00\x00\x53\x74\xAC\x00\x00\x00"
append search "\x00\x00\x54\x74\xAC\x00\x00\x00\x00\x00\x00\x00"
append search "\x24\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x0A\xD0\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x53\x74"
append search "\xD0\x00\x00\x00\x00\x00\x54\x74\xD0\x00\x00\x00"
append search "\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x0B\x11\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00"
append search "\x00\x00\x53\x74\xD8\x00\x00\x00\x00\x00\x54\x74"
append search "\xD8\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0B"
append search "\x52\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x02\x00\x00\x00\x00\x00\x53\x74\xE0\x00\x00\x00"
append search "\x00\x00\x54\x74\xE0\x00\x00\x00\x00\x00\x00\x00"
append search "\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x0B\x94\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x53\x74"
append search "\xE8\x00\x00\x00\x00\x00\x54\x74\xE8\x00\x00\x00"
append search "\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x0B\xD4\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00"
append search "\x00\x00\x53\x74\xF0\x00\x00\x00\x00\x00\x54\x74"
append search "\xF0\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0C"
append search "\x14\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x02\x00\x00\x00\x00\x00\x53\x74\xF8\x00\x00\x00"
append search "\x00\x00\x54\x74\xF8\x00\x00\x00\x00\x00\x00\x00"
append search "\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x0C\x55\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x53\x75"
append search "\x00\x00\x00\x00\x00\x00\x54\x75\x00\x00\x00\x00"
append search "\x00\x00\x00\x28\xF8\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x0C\x5F\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00"
append search "\x00\x00\x53\x9D\xF8\x00\x00\x00\x00\x00\x54\x9D"
append search "\xF8\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0C"
append search "\xAD\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x02\x00\x00\x00\x00\x00\x53\x9E\x00\x00\x00\x00"
append search "\x00\x00\x54\x9E\x00\x00\x00\x00\x00\x00\x10\xC5"
append search "\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x0C\xB9\x00\x00\x00\x01\x00\x00\x00"
append search "\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x64\x63"
append search "\x80\x00\x00\x00\x00\x00\x65\x63\x80\x00\x00\x00"
append search "\x00\x00\x02\xA1\xC8\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x0C\xBE\x00\x00\x00"
append search "\x01\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00"
append search "\x00\x00\x67\x05\x48\x00\x00\x00\x00\x00\x68\x05"
append search "\x48\x00\x00\x00\x00\x00\x00\x72\xD8\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0C"
append search "\xC3\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00"
append search "\x03\x00\x00\x00\x00\x00\x67\x78\x80\x00\x00\x00"
append search "\x00\x00\x68\x78\x20\x00\x00\x00\x00\x02\x54"

set replace "\x0B\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x20"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x14\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x07\x00\x00\x00\x00\x00\x00\x20"
append replace "\x00\x00\x00\x00\x00\x00\x01\x20\x00\x00\x00\x00"
append replace "\x00\x00\x00\x02\xC0\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00"
append replace "\x00\x00\x00\x23\x00\x00\x00\x00\x00\x00\x01\x23"
append replace "\x00\x00\x00\x00\x00\x00\x00\x44\x80\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x1E\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x07\x00\x00\x00\x00\x00\x00\x67\x80\x00\x00\x00"
append replace "\x00\x00\x01\x67\x80\x00\x00\x00\x00\x00\x00\x01"
append replace "\x40\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x0E\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x00\x80"
append replace "\x00\x00\x00\x00\x00\x00\x01\x80\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x90\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x26\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00"
append replace "\x00\x00\x00\x80\x90\x00\x00\x00\x00\x00\x01\x80"
append replace "\x90\x00\x00\x00\x00\x00\x00\x39\x18\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x10\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x2C\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x07\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00"
append replace "\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\x00\x78"
append replace "\x78\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x37\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x07\x00\x00\x00\x00\x00\x01\x78"
append replace "\x78\x00\x00\x00\x00\x00\x02\x78\x78\x00\x00\x00"
append replace "\x00\x00\x00\x1E\x08\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x42\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00"
append replace "\x00\x00\x01\x96\x80\x00\x00\x00\x00\x00\x02\x96"
append replace "\x80\x00\x00\x00\x00\x00\x01\xE8\xFC\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x4B\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x07\x00\x00\x00\x00\x00\x03\x7F\x7C\x00\x00\x00"
append replace "\x00\x00\x04\x7F\x7C\x00\x00\x00\x00\x00\x00\x6E"
append replace "\x4C\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x51\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x07\x00\x00\x00\x00\x00\x03\xEE"
append replace "\x00\x00\x00\x00\x00\x00\x04\xEE\x00\x00\x00\x00"
append replace "\x00\x00\x21\x22\x5C\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x57\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00"
append replace "\x00\x00\x25\x10\x5C\x00\x00\x00\x00\x00\x26\x10"
append replace "\x5C\x00\x00\x00\x00\x00\x00\x08\xA4\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x80\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x07\x00\x00\x00\x00\x00\x25\x19\x00\x00\x00\x00"
append replace "\x00\x00\x26\x19\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\xB0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\xB5\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x07\x00\x00\x00\x00\x00\x25\x19"
append replace "\xB0\x00\x00\x00\x00\x00\x26\x19\xB0\x00\x00\x00"
append replace "\x00\x00\x00\x05\xE4\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\xBC\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00"
append replace "\x00\x00\x25\x1F\x94\x00\x00\x00\x00\x00\x26\x1F"
append replace "\x94\x00\x00\x00\x00\x00\x00\x01\xC0\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\xEB\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x07\x00\x00\x00\x00\x00\x25\x21\x54\x00\x00\x00"
append replace "\x00\x00\x26\x21\x54\x00\x00\x00\x00\x00\x00\x05"
append replace "\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x01\x21\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x07\x00\x00\x00\x00\x00\x25\x26"
append replace "\x8C\x00\x00\x00\x00\x00\x26\x26\x8C\x00\x00\x00"
append replace "\x00\x00\x00\x00\x0C\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x01\x4E\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00"
append replace "\x00\x00\x25\x26\x98\x00\x00\x00\x00\x00\x26\x26"
append replace "\x98\x00\x00\x00\x00\x00\x00\x00\x2C\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01"
append replace "\x7B\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x07\x00\x00\x00\x00\x00\x25\x26\xC4\x00\x00\x00"
append replace "\x00\x00\x26\x26\xC4\x00\x00\x00\x00\x00\x00\x02"
append replace "\x14\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x01\xA5\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x07\x00\x00\x00\x00\x00\x25\x28"
append replace "\xD8\x00\x00\x00\x00\x00\x26\x28\xD8\x00\x00\x00"
append replace "\x00\x00\x00\x01\x64\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x01\xDC\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00"
append replace "\x00\x00\x25\x2A\x3C\x00\x00\x00\x00\x00\x26\x2A"
append replace "\x3C\x00\x00\x00\x00\x00\x00\x02\x44\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02"
append replace "\x11\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x07\x00\x00\x00\x00\x00\x25\x2C\x80\x00\x00\x00"
append replace "\x00\x00\x26\x2C\x80\x00\x00\x00\x00\x00\x00\x02"
append replace "\x64\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x02\x46\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x07\x00\x00\x00\x00\x00\x25\x2E"
append replace "\xE4\x00\x00\x00\x00\x00\x26\x2E\xE4\x00\x00\x00"
append replace "\x00\x00\x00\x03\xC8\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x02\x68\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00"
append replace "\x00\x00\x25\x32\xAC\x00\x00\x00\x00\x00\x26\x32"
append replace "\xAC\x00\x00\x00\x00\x00\x00\x02\xE0\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02"
append replace "\xA0\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x07\x00\x00\x00\x00\x00\x25\x35\x8C\x00\x00\x00"
append replace "\x00\x00\x26\x35\x8C\x00\x00\x00\x00\x00\x00\x01"
append replace "\x2C\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x02\xD3\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x07\x00\x00\x00\x00\x00\x25\x36"
append replace "\xB8\x00\x00\x00\x00\x00\x26\x36\xB8\x00\x00\x00"
append replace "\x00\x00\x00\x00\x98\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00"
append replace "\x00\x00\x25\x37\x50\x00\x00\x00\x00\x00\x26\x37"
append replace "\x50\x00\x00\x00\x00\x00\x00\x01\x5C\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03"
append replace "\x20\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x07\x00\x00\x00\x00\x00\x25\x38\xAC\x00\x00\x00"
append replace "\x00\x00\x26\x38\xAC\x00\x00\x00\x00\x00\x00\x00"
append replace "\x0C\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x03\x3E\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x07\x00\x00\x00\x00\x00\x25\x38"
append replace "\xB8\x00\x00\x00\x00\x00\x26\x38\xB8\x00\x00\x00"
append replace "\x00\x00\x00\x00\x0C\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x03\x5C\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00"
append replace "\x00\x00\x25\x38\xC4\x00\x00\x00\x00\x00\x26\x38"
append replace "\xC4\x00\x00\x00\x00\x00\x00\x00\x0C\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03"
append replace "\x85\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x07\x00\x00\x00\x00\x00\x25\x38\xD0\x00\x00\x00"
append replace "\x00\x00\x26\x38\xD0\x00\x00\x00\x00\x00\x00\x00"
append replace "\x0C\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x03\xAD\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x07\x00\x00\x00\x00\x00\x25\x38"
append replace "\xDC\x00\x00\x00\x00\x00\x26\x38\xDC\x00\x00\x00"
append replace "\x00\x00\x00\x00\x0C\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x03\xCF\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00"
append replace "\x00\x00\x25\x38\xE8\x00\x00\x00\x00\x00\x26\x38"
append replace "\xE8\x00\x00\x00\x00\x00\x00\x00\x0C\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03"
append replace "\xF4\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x07\x00\x00\x00\x00\x00\x25\x38\xF4\x00\x00\x00"
append replace "\x00\x00\x26\x38\xF4\x00\x00\x00\x00\x00\x00\x00"
append replace "\x0C\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x04\x1E\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x07\x00\x00\x00\x00\x00\x25\x39"
append replace "\x00\x00\x00\x00\x00\x00\x26\x39\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x0C\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x04\x4A\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00"
append replace "\x00\x00\x25\x39\x0C\x00\x00\x00\x00\x00\x26\x39"
append replace "\x0C\x00\x00\x00\x00\x00\x00\x00\x0C\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04"
append replace "\x75\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x07\x00\x00\x00\x00\x00\x25\x39\x18\x00\x00\x00"
append replace "\x00\x00\x26\x39\x18\x00\x00\x00\x00\x00\x00\x00"
append replace "\x0C\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x04\x9E\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x07\x00\x00\x00\x00\x00\x25\x39"
append replace "\x24\x00\x00\x00\x00\x00\x26\x39\x24\x00\x00\x00"
append replace "\x00\x00\x00\x00\x0C\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x04\xC6\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00"
append replace "\x00\x00\x25\x39\x30\x00\x00\x00\x00\x00\x26\x39"
append replace "\x30\x00\x00\x00\x00\x00\x00\x00\x0C\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x04"
append replace "\xEF\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x07\x00\x00\x00\x00\x00\x25\x39\x3C\x00\x00\x00"
append replace "\x00\x00\x26\x39\x3C\x00\x00\x00\x00\x00\x00\x00"
append replace "\x0C\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x05\x17\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x07\x00\x00\x00\x00\x00\x25\x39"
append replace "\x48\x00\x00\x00\x00\x00\x26\x39\x48\x00\x00\x00"
append replace "\x00\x00\x00\x00\x0C\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x05\x40\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00"
append replace "\x00\x00\x25\x39\x54\x00\x00\x00\x00\x00\x26\x39"
append replace "\x54\x00\x00\x00\x00\x00\x00\x00\x0C\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x05"
append replace "\x6B\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x07\x00\x00\x00\x00\x00\x25\x39\x60\x00\x00\x00"
append replace "\x00\x00\x26\x39\x60\x00\x00\x00\x00\x00\x00\x00"
append replace "\x0C\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x05\x95\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x07\x00\x00\x00\x00\x00\x25\x39"
append replace "\x6C\x00\x00\x00\x00\x00\x26\x39\x6C\x00\x00\x00"
append replace "\x00\x00\x00\x00\x0C\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x05\xBA\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00"
append replace "\x00\x00\x25\x39\x78\x00\x00\x00\x00\x00\x26\x39"
append replace "\x78\x00\x00\x00\x00\x00\x00\x00\x0C\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x05"
append replace "\xE6\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x07\x00\x00\x00\x00\x00\x25\x39\x84\x00\x00\x00"
append replace "\x00\x00\x26\x39\x84\x00\x00\x00\x00\x00\x00\x00"
append replace "\x0C\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x06\x08\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x07\x00\x00\x00\x00\x00\x25\x39"
append replace "\x90\x00\x00\x00\x00\x00\x26\x39\x90\x00\x00\x00"
append replace "\x00\x00\x00\x00\x0C\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x06\x30\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00"
append replace "\x00\x00\x25\x39\x9C\x00\x00\x00\x00\x00\x26\x39"
append replace "\x9C\x00\x00\x00\x00\x00\x00\x00\xC0\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x06"
append replace "\x68\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x07\x00\x00\x00\x00\x00\x25\x3A\x5C\x00\x00\x00"
append replace "\x00\x00\x26\x3A\x5C\x00\x00\x00\x00\x00\x00\x01"
append replace "\x4C\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x06\x9F\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x07\x00\x00\x00\x00\x00\x25\x3B"
append replace "\xA8\x00\x00\x00\x00\x00\x26\x3B\xA8\x00\x00\x00"
append replace "\x00\x00\x00\x01\x4C\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x06\xD7\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00"
append replace "\x00\x00\x25\x3C\xF4\x00\x00\x00\x00\x00\x26\x3C"
append replace "\xF4\x00\x00\x00\x00\x00\x00\x01\x74\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07"
append replace "\x11\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x07\x00\x00\x00\x00\x00\x25\x3E\x68\x00\x00\x00"
append replace "\x00\x00\x26\x3E\x68\x00\x00\x00\x00\x00\x00\x00"
append replace "\xE8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x07\x4A\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x07\x00\x00\x00\x00\x00\x25\x3F"
append replace "\x50\x00\x00\x00\x00\x00\x26\x3F\x50\x00\x00\x00"
append replace "\x00\x00\x00\x00\xD4\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x07\x7E\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00"
append replace "\x00\x00\x25\x40\x24\x00\x00\x00\x00\x00\x26\x40"
append replace "\x24\x00\x00\x00\x00\x00\x00\x00\xFC\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x07"
append replace "\xB9\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x07\x00\x00\x00\x00\x00\x25\x41\x20\x00\x00\x00"
append replace "\x00\x00\x26\x41\x20\x00\x00\x00\x00\x00\x00\x01"
append replace "\x24\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x07\xEA\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x07\x00\x00\x00\x00\x00\x25\x42"
append replace "\x44\x00\x00\x00\x00\x00\x26\x42\x44\x00\x00\x00"
append replace "\x00\x00\x00\x00\xE8\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x04\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x08\x21\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00"
append replace "\x00\x00\x25\x43\x80\x00\x00\x00\x00\x00\x26\x43"
append replace "\x80\x00\x00\x00\x00\x00\x00\x60\xB0\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08"
append replace "\x28\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x02\x00\x00\x00\x00\x00\x25\xA4\x80\x00\x00\x00"
append replace "\x00\x00\x26\xA4\x80\x00\x00\x00\x00\x00\x0C\x7A"
append replace "\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x08\x32\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x32\x1E"
append replace "\xC0\x00\x00\x00\x00\x00\x33\x1E\xC0\x00\x00\x00"
append replace "\x00\x00\x00\x72\xA4\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x08\x38\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00"
append replace "\x00\x00\x32\x91\x68\x00\x00\x00\x00\x00\x33\x91"
append replace "\x68\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08"
append replace "\x43\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x03\x00\x00\x00\x00\x00\x32\x91\x70\x00\x00\x00"
append replace "\x00\x00\x33\x91\x70\x00\x00\x00\x00\x00\x00\x3E"
append replace "\xD8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x08\x4D\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x32\xD0"
append replace "\x48\x00\x00\x00\x00\x00\x33\xD0\x48\x00\x00\x00"
append replace "\x00\x00\x00\xD7\x48\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x08\x5D\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00"
append replace "\x00\x00\x33\xA7\x90\x00\x00\x00\x00\x00\x34\xA7"
append replace "\x90\x00\x00\x00\x00\x00\x00\x33\x68\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08"
append replace "\x6A\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x03\x00\x00\x00\x00\x00\x33\xDA\xF8\x00\x00\x00"
append replace "\x00\x00\x34\xDA\xF8\x00\x00\x00\x00\x00\x00\xC5"
append replace "\xE0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x08\x7D\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x34\xA0"
append replace "\xD8\x00\x00\x00\x00\x00\x35\xA0\xD8\x00\x00\x00"
append replace "\x00\x00\x00\x00\x38\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x08\xAA\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00"
append replace "\x00\x00\x34\xA1\x10\x00\x00\x00\x00\x00\x35\xA1"
append replace "\x10\x00\x00\x00\x00\x00\x00\x00\x38\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08"
append replace "\xD6\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x03\x00\x00\x00\x00\x00\x34\xA1\x48\x00\x00\x00"
append replace "\x00\x00\x35\xA1\x48\x00\x00\x00\x00\x00\x00\x00"
append replace "\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x08\xDD\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x34\xA1"
append replace "\x70\x00\x00\x00\x00\x00\x35\xA1\x70\x00\x00\x00"
append replace "\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x09\x09\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00"
append replace "\x00\x00\x34\xA1\x78\x00\x00\x00\x00\x00\x35\xA1"
append replace "\x78\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09"
append replace "\x2E\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x03\x00\x00\x00\x00\x00\x34\xA1\xA0\x00\x00\x00"
append replace "\x00\x00\x35\xA1\xA0\x00\x00\x00\x00\x00\x00\x00"
append replace "\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x09\x49\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x34\xA1"
append replace "\xC8\x00\x00\x00\x00\x00\x35\xA1\xC8\x00\x00\x00"
append replace "\x00\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x09\x68\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00"
append replace "\x00\x00\x34\xA1\xF0\x00\x00\x00\x00\x00\x35\xA1"
append replace "\xF0\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x09"
append replace "\x91\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x03\x00\x00\x00\x00\x00\x34\xA2\x18\x00\x00\x00"
append replace "\x00\x00\x35\xA2\x18\x00\x00\x00\x00\x00\x00\x00"
append replace "\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x09\xB3\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x34\xA2"
append replace "\x40\x00\x00\x00\x00\x00\x35\xA2\x40\x00\x00\x00"
append replace "\x00\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x09\xDA\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00"
append replace "\x00\x00\x34\xA2\x68\x00\x00\x00\x00\x00\x35\xA2"
append replace "\x68\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0A"
append replace "\x02\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x03\x00\x00\x00\x00\x00\x34\xA2\x90\x00\x00\x00"
append replace "\x00\x00\x35\xA2\x90\x00\x00\x00\x00\x00\x00\x00"
append replace "\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x0A\x28\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x34\xA2"
append replace "\xB8\x00\x00\x00\x00\x00\x35\xA2\xB8\x00\x00\x00"
append replace "\x00\x00\x00\x00\x28\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x0A\x4D\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00"
append replace "\x00\x00\x34\xA2\xE0\x00\x00\x00\x00\x00\x35\xA2"
append replace "\xE0\x00\x00\x00\x00\x00\x00\x00\x28\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0A"
append replace "\x73\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x02\x00\x00\x00\x00\x00\x34\xA3\x80\x00\x00\x00"
append replace "\x00\x00\x35\xA3\x80\x00\x00\x00\x00\x00\x1D\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x0A\x7C\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x51\xA3"
append replace "\x80\x00\x00\x00\x00\x00\x52\xA3\x80\x00\x00\x00"
append replace "\x00\x00\x01\x72\x90\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x0A\x84\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x32\x00\x00\x00"
append replace "\x00\x00\x53\x16\x10\x00\x00\x00\x00\x00\x54\x16"
append replace "\x10\x00\x00\x00\x00\x00\x00\x5E\x9B\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x08\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x0A"
append replace "\x93\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x02\x00\x00\x00\x00\x00\x53\x74\xAC\x00\x00\x00"
append replace "\x00\x00\x54\x74\xAC\x00\x00\x00\x00\x00\x00\x00"
append replace "\x24\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x0A\xD0\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x53\x74"
append replace "\xD0\x00\x00\x00\x00\x00\x54\x74\xD0\x00\x00\x00"
append replace "\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x0B\x11\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00"
append replace "\x00\x00\x53\x74\xD8\x00\x00\x00\x00\x00\x54\x74"
append replace "\xD8\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0B"
append replace "\x52\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x02\x00\x00\x00\x00\x00\x53\x74\xE0\x00\x00\x00"
append replace "\x00\x00\x54\x74\xE0\x00\x00\x00\x00\x00\x00\x00"
append replace "\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x0B\x94\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x53\x74"
append replace "\xE8\x00\x00\x00\x00\x00\x54\x74\xE8\x00\x00\x00"
append replace "\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x0B\xD4\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00"
append replace "\x00\x00\x53\x74\xF0\x00\x00\x00\x00\x00\x54\x74"
append replace "\xF0\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0C"
append replace "\x14\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x02\x00\x00\x00\x00\x00\x53\x74\xF8\x00\x00\x00"
append replace "\x00\x00\x54\x74\xF8\x00\x00\x00\x00\x00\x00\x00"
append replace "\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x0C\x55\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x53\x75"
append replace "\x00\x00\x00\x00\x00\x00\x54\x75\x00\x00\x00\x00"
append replace "\x00\x00\x00\x28\xF8\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x0C\x5F\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00"
append replace "\x00\x00\x53\x9D\xF8\x00\x00\x00\x00\x00\x54\x9D"
append replace "\xF8\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0C"
append replace "\xAD\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x02\x00\x00\x00\x00\x00\x53\x9E\x00\x00\x00\x00"
append replace "\x00\x00\x54\x9E\x00\x00\x00\x00\x00\x00\x10\xC5"
append replace "\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x0C\xB9\x00\x00\x00\x01\x00\x00\x00"
append replace "\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x64\x63"
append replace "\x80\x00\x00\x00\x00\x00\x65\x63\x80\x00\x00\x00"
append replace "\x00\x00\x02\xA1\xC8\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x0C\xBE\x00\x00\x00"
append replace "\x01\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00"
append replace "\x00\x00\x67\x05\x48\x00\x00\x00\x00\x00\x68\x05"
append replace "\x48\x00\x00\x00\x00\x00\x00\x72\xD8\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0C"
append replace "\xC3\x00\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00"
append replace "\x07\x00\x00\x00\x00\x00\x67\x78\x80\x00\x00\x00"
append replace "\x00\x00\x68\x78\x20\x00\x00\x00\x00\x02\x55"

catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
			
        }
    }
	
	proc patch_elf3 { elf } {
	if {$::cobra::options(--patch-ps2netemu-cobra453) } {
            log "Patching 4.53 [file tail $elf] to allow Cobra Features"
            set search "\x7D\x80\x00\x26\xE8\x62\x8D\x68\xF8\x21\xFE\xE1"
            append search "\xFA\xA1\x00\xC8\x3A\xA1\x00\xB0\xFA\xC1\x00\xD0"
            append search "\x3A\xC1\x00\xA0\xFB\x01\x00\xE0\x3B\x01\x00\x90"
            append search "\xFA\xE1\x00\xD8\xFB\x21\x00\xE8\xFB\x41\x00\xF0"
            append search "\xFB\x61\x00\xF8\xFB\x81\x01\x00\xFB\xA1\x01\x08"
            append search "\xFB\xC1\x01\x10\xFB\xE1\x01\x18\x91\x81\x01\x28"
            append search "\x7C\x08\x02\xA6\xF8\x01\x01\x30\x4B\xFD\xFE\x89"
            append search "\x60\x00\x00\x00\x4B\xFF\xE6\x9D\x4B\xFD\xF0\x79"
            append search "\x60\x00\x00\x00\xE9\x22\x8D\x70\x80\x69\x00\x00"
            append search "\x2F\x83\x00\x00\x41\x9E\x00\x44\xE8\xA2\x8D\x20"
            append search "\x3D\x40\x70\x00\x3D\x60\x20\x00\x38\x60\x00\x82"
            append search "\xE8\x85\x00\x00\x7C\x89\x50\x38\x7C\x29\x58\x00"
            append search "\x41\x82\x00\x1C\x7C\xA9\x58\x40\x41\x85\x04\xD4"
            append search "\x2D\x29\x00\x00\x38\x60\x00\x00\x41\x8A\x00\x08"
            append search "\x38\x60\x00\x81\x4B\xFF\xB2\xA5\x60\x00\x00\x00"
            append search "\x38\x60\x00\x01\xE8\x82\x8D\x78\x44\x00\x00\x02"
			
            set replace "\xF8\x21\xFF\x61\x7C\x08\x02\xA6\xF8\x01\x00\xB0"
            append replace "\xFA\xE1\x00\x70\xFB\x01\x00\x78\xFB\x21\x00\x80"
            append replace "\xFB\x41\x00\x88\xFB\xE1\x00\x90\xFB\xC1\x00\x98"
            append replace "\x7C\x77\x1B\x78\x7C\x98\x23\x78\x7C\xB9\x2B\x78"
            append replace "\x7C\xDA\x33\x78\x3F\xE0\x02\x1F\x3B\xFF\x00\x00"
            append replace "\x38\x60\x00\x00\x3C\x80\x00\x02\x38\x84\x3D\x78"
            append replace "\x48\x04\xE0\x2B\x7C\x7E\x1B\x78\x38\x80\x00\x00"
            append replace "\x7F\xE5\xFB\x78\x3C\xC0\x00\x01\x48\x04\xDA\xFB"
            append replace "\x7F\xC3\xF3\x78\x48\x04\xE7\xB7\x7F\xE3\xFB\x78"
            append replace "\x3C\x80\x00\x01\x48\x00\x00\x25\x7E\xE3\xBB\x78"
            append replace "\x7F\x04\xC3\x78\x7F\x25\xCB\x78\x7F\x46\xD3\x78"
            append replace "\x7F\xE9\x03\xA6\x4E\x80\x04\x21\x2F\x76\x6D\x2F"
            append replace "\x70\x6D\x30\x00\x7C\x83\x22\x14\x78\x63\x06\x24"
            append replace "\x7C\x23\x20\x40\x40\x80\x00\x1C\x7C\x00\x18\x6C"
            append replace "\x7C\x00\x04\xAC\x7C\x00\x1F\xAC\x4C\x00\x01\x2C"
            append replace "\x38\x63\x00\x80\x4B\xFF\xFF\xE4\x4E\x80\x00\x20"

            catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
			
			log "Part 2"
			log "Patching 453 ps2netemu Cobra Features"
			
			set search "\x00\x00\x00\x00\x00\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x00"
            append search "\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x18\x0B\x70"
			
			set replace "\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00\x00\x00\x00\x00\x00"
            append replace "\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x18\x0B\x70"
			
			catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
			
			log "Part 3"
			log "Patching 453 ps2netemu Cobra Features"
			
			set search "\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x4F\x78\xB0"
            append search "\x00\x00\x00\x00\x00\x50\x78\xB0\x00\x00\x00\x00\x00\xB8\x25\x40"

            set replace "\x00\x00\x00\x00\x00\x00\x00\x07\x00\x00\x00\x00\x00\x4F\x78\xB0"
            append replace "\x00\x00\x00\x00\x00\x50\x78\xB0\x00\x00\x00\x00\x00\xB8\x25\x40"
			
			catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
	}
	
	if {$::cobra::options(--patch-ps2netemu-cobra446) } {
            log "Part 1 -- Patching [file tail $elf] to allow Cobra Features -- Please be patient!"
			log "Note: Also make sure u have selected the correct LV0 Cobra Style Patch task!"
            set search "\x7F\x45\x4C\x46\x02\x02\x01\x66\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x02\x00\x15\x00\x00\x00\x01"
append search "\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x00"
append search "\x00\x00\x00\x40\x00\x00\x00\x00\x00\x9F\x45\x28"
append search "\x00\x00\x00\x00\x00\x40\x00\x38\x00\x03\x00\x40"
append search "\x00\x2C\x00\x2B\x00\x00\x00\x01\x00\x00\x00\x07"
append search "\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x28\x90\xA8\x00\x00\x00\x00"
append search "\x00\x28\x90\xA8\x00\x00\x00\x00\x00\x01\x00\x00"
append search "\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00\x00"
append search "\x00\x2A\x00\x00\x00\x00\x00\x00\x00\x30\x00\x00"
append search "\x00\x00\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00"
append search "\x00\x44\xD0\x78\x00\x00\x00\x00\x00\x44\xD0\x78"
append search "\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x01"
append search "\x00\x00\x00\x06\x00\x00\x00\x00\x00\x6F\x10\x00"
append search "\x00\x00\x00\x00\x00\x82\x10\x00\x00\x00\x00\x00"
append search "\x00\x82\x10\x00\x00\x00\x00\x00\x00\x2F\xF3\x00"
append search "\x00\x00\x00\x00\x02\x10\x23\x88"
			
set replace "\x7F\x45\x4C\x46\x02\x02\x01\x66\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x02\x00\x15\x00\x00\x00\x01"
append replace "\x00\x00\x00\x00\x00\x00\x00\x14\x00\x00\x00\x00"
append replace "\x00\x00\x00\x40\x00\x00\x00\x00\x00\x9F\x45\x28"
append replace "\x00\x00\x00\x00\x00\x40\x00\x38\x00\x03\x00\x40"
append replace "\x00\x2C\x00\x2B\x00\x00\x00\x01\x00\x00\x00\x07"
append replace "\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x28\xF8\xA8\x00\x00\x00\x00"
append replace "\x00\x28\xF8\xA8\x00\x00\x00\x00\x00\x01\x00\x00"
append replace "\x00\x00\x00\x01\x00\x00\x00\x06\x00\x00\x00\x00"
append replace "\x00\x2A\x00\x00\x00\x00\x00\x00\x00\x30\x00\x00"
append replace "\x00\x00\x00\x00\x00\x30\x00\x00\x00\x00\x00\x00"
append replace "\x00\x44\xD0\x78\x00\x00\x00\x00\x00\x44\xD0\x78"
append replace "\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x01"
append replace "\x00\x00\x00\x06\x00\x00\x00\x00\x00\x6F\x10\x00"
append replace "\x00\x00\x00\x00\x00\x82\x10\x00\x00\x00\x00\x00"
append replace "\x00\x82\x10\x00\x00\x00\x00\x00\x00\x2F\xF3\x00"
append replace "\x00\x00\x00\x00\x02\x10\x33\x88"

            catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
			
			log "Part 2 -- offset x127858"
			log "Patching 446 ps2netemu for Cobra Features"
			
			set search "\xE8\x01\x00\x98\x2F\xA0\x07\x73"
            set replace "\x38\x00\x07\x74\x2F\xA0\x07\x73"
			
			catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
			
			log "Part 6"
			log "Patching 446 ps2netemu for Cobra Features"
			
			set search "\x0B\x6A\x2D\x60\x00\x00\x00\x2F\x83\x00\x00\x7C"
append search "\x7E\x1B\x78\x7C\x7D\x07\xB4\x41\x9C\x00\xF4\x3B"
append search "\xA1\x00\x78\x38\x80\x00\xDE\x38\xA0\x00\x30\x7F"
append search "\xA3\xEB\x78\x7F\xDC\x07\xB4\x4B\xFE\x35\x19\x60"
append search "\x00\x00\x00\x7F\xA4\xEB\x78\x7F\x83\xE3\x78\x48"
append search "\x0B\x64\xF5\x60\x00\x00\x00\x2F\x83\x00\x00\x7C"
append search "\x60\x1B\x78\x41\x9C\x02\x14\x88\x1F\x00\x32\xE8"
append search "\x61\x00\xA0\x2F\x80\x00\x00\xF8\x7F\x00\x58\x40"
append search "\x9E\x00\xCC\x2B\xA3\x3F\xFF\x40\xDD\x02\x0C\x38"
append search "\x03\xC0\x00\xE8\xE2\xA6\xF8\x93\xDF\x00\x04\xF8"
append search "\x1F\x00\x38\x39\x27\x01\x68\x38\x00\x40\x00\x38"
append search "\x60\x00\x40\xF9\x3F\x00\x40\x78\x63\x07\xC6\xF8"
append search "\x1F\x00\x48\x39\x60\x00\x08\x44\x00\x00\x02\x38"
append search "\x60\x00\x80\x39\x60\x00\x07\x78\x63\x07\xC6\x44"
append search "\x00\x00\x02\x38\xC0\xFF\xFF\x90\xDF\x00\x04\xEB"
append search "\xBF\x00\x50\x2F\xBD\x00\x00\x41\x9C\x00\xD0\x2F"
append search "\xBD\x40\x00\x40\x9E\x01\xB0\x3C\x00\x4C\x49\x81"
append search "\x27\x01\x68\x60\x00\x4D\x47\x7F\x89\x00\x00\x40"
append search "\x9E\x01\x9C\x80\x07\x01\x70\x90\x1F\x00\x1C\x81"
append search "\x07\x01\x74\x91\x1F\x00\x24\x80\x07\x01\x6C\x2F"
append search "\x80\x00\x01\x41\x9E\x00\xA8\x2F\x80\x00\x02\x3B"
append search "\xA0\x00\x00\x41\x9E\x00\x60\x60\x00\x00\x00\xE8"
append search "\x01\x00\xE0\x7F\xA3\xEB\x78\xEB\x81\x00\xB0\xEB"
append search "\xA1\x00\xB8\x7C\x08\x03\xA6\xEB\xC1\x00\xC0\xEB"
append search "\xE1\x00\xC8\x38\x21\x00\xD0\x4E\x80\x00\x20\x48"
append search "\x00\x10\xE1\x60\x00\x00\x00\x38\x80\x00\x88\xF8"
append search "\x7F\x00\x58\x38\xA1\x00\x70\x7F\x83\xE3\x78\x38"
append search "\xC0\x00\x08\x48\x0B\x72\x55"


set replace "\x15\x73\x49\x60\x00\x00\x00\x2F\x83\x00\x00\x7C"
append replace "\x7E\x1B\x78\x7C\x7D\x07\xB4\x41\x9C\x00\xF4\x3B"
append replace "\xA1\x00\x78\x38\x80\x00\xDE\x38\xA0\x00\x30\x7F"
append replace "\xA3\xEB\x78\x7F\xDC\x07\xB4\x4B\xFE\x35\x19\x60"
append replace "\x00\x00\x00\x7F\xA4\xEB\x78\x7F\x83\xE3\x78\x48"
append replace "\x15\x73\x5D\x60\x00\x00\x00\x2F\x83\x00\x00\x7C"
append replace "\x60\x1B\x78\x41\x9C\x02\x14\x88\x1F\x00\x32\xE8"
append replace "\x61\x00\xA0\x2F\x80\x00\x00\xF8\x7F\x00\x58\x40"
append replace "\x9E\x00\xCC\x2B\xA3\x3F\xFF\x40\xDD\x02\x0C\x38"
append replace "\x03\xC0\x00\xE8\xE2\xA6\xF8\x93\xDF\x00\x04\xF8"
append replace "\x1F\x00\x38\x39\x27\x01\x68\x38\x00\x40\x00\x38"
append replace "\x60\x00\x40\xF9\x3F\x00\x40\x78\x63\x07\xC6\xF8"
append replace "\x1F\x00\x48\x39\x60\x00\x08\x44\x00\x00\x02\x38"
append replace "\x60\x00\x80\x39\x60\x00\x07\x78\x63\x07\xC6\x44"
append replace "\x00\x00\x02\x38\xC0\xFF\xFF\x90\xDF\x00\x04\xEB"
append replace "\xBF\x00\x50\x2F\xBD\x00\x00\x41\x9C\x00\xD0\x2F"
append replace "\xBD\x40\x00\x40\x9E\x01\xB0\x3C\x00\x4C\x49\x81"
append replace "\x27\x01\x68\x60\x00\x4D\x47\x7F\x89\x00\x00\x40"
append replace "\x9E\x01\x9C\x80\x07\x01\x70\x90\x1F\x00\x1C\x81"
append replace "\x07\x01\x74\x91\x1F\x00\x24\x80\x07\x01\x6C\x2F"
append replace "\x80\x00\x01\x41\x9E\x00\xA8\x2F\x80\x00\x02\x3B"
append replace "\xA0\x00\x00\x41\x9E\x00\x60\x60\x00\x00\x00\xE8"
append replace "\x01\x00\xE0\x7F\xA3\xEB\x78\xEB\x81\x00\xB0\xEB"
append replace "\xA1\x00\xB8\x7C\x08\x03\xA6\xEB\xC1\x00\xC0\xEB"
append replace "\xE1\x00\xC8\x38\x21\x00\xD0\x4E\x80\x00\x20\x48"
append replace "\x00\x10\xE1\x60\x00\x00\x00\x38\x80\x00\x88\xF8"
append replace "\x7F\x00\x58\x38\xA1\x00\x70\x7F\x83\xE3\x78\x38"
append replace "\xC0\x00\x08\x48\x15\x72\xA1"
			
			catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
			
			log "Part 4"
			log "Patching 446 ps2netemu for Cobra Features"
			
			set search "\x7F\xA4\xEB\x78\x38\x60\x00\x00\x48\x0B\x59\x7D\x60\x00\x00\x00"
            set replace "\x7F\xA4\xEB\x78\x38\x60\x00\x00\x48\x15\x62\x99\x60\x00\x00\x00"
			
			catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
			
			log "Part 5"
			log "Patching 446 ps2netemu for Cobra Features"
			
			set search "\x60\x00\x00\x00\x2F\x86\x00\x00\x7C\x08\x02\xA6"
            append search "\xF8\x21\xFE\xF1\xF9\xC1\x00\x80"
			
			set replace "\x60\x00\x00\x00\x3C\x00\x00\x28\x60\x00\x91\xB0"
            append replace "\x7C\x09\x03\xA6\x4E\x80\x04\x20"
			
			catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
			
			log "Part 6 -- offset 0x299050"
			log "Patching 446 ps2netemu Cobra Features... It may take awhile, pls sit back and relax!"
			
			log "Note: Let's assume...that u have Enabled the **Cobra-3BIN Task** to make the Set Complete!!"
			
			set search "\xE8\x0C\x00\x00\xE8\x2C\x00\x08\xE8\x4C\x00\x10"
append search "\xE8\x6C\x00\x18\xE8\x8C\x00\x20\xE8\xAC\x00\x28"
append search "\xE8\xCC\x00\x30\xE8\xEC\x00\x38\xE9\x0C\x00\x40"
append search "\xE9\x2C\x00\x48\xE9\x4C\x00\x50\xE9\x6C\x00\x58"
append search "\xE9\x8C\x00\x60\x4E\x80\x00\x20\x7C\x89\x03\xA6"
append search "\x7C\x08\x02\xA6\xF8\x00\x99\x18\x4E\x80\x04\x21"
append search "\xE8\x00\x99\x18\x7C\x08\x03\xA6\x4E\x80\x00\x20"
append search "\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00"
			
			set replace "\xE8\x0C\x00\x00\xE8\x2C\x00\x08\xE8\x4C\x00\x10"
append replace "\xE8\x6C\x00\x18\xE8\x8C\x00\x20\xE8\xAC\x00\x28"
append replace "\xE8\xCC\x00\x30\xE8\xEC\x00\x38\xE9\x0C\x00\x40"
append replace "\xE9\x2C\x00\x48\xE9\x4C\x00\x50\xE9\x6C\x00\x58"
append replace "\xE9\x8C\x00\x60\x4E\x80\x00\x20\x7C\x89\x03\xA6"
append replace "\x7C\x08\x02\xA6\xF8\x00\x99\x18\x4E\x80\x04\x21"
append replace "\xE8\x00\x99\x18\x7C\x08\x03\xA6\x4E\x80\x00\x20"
append replace "\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x48\x00\x00\x10\x48\x00\x00\x5C\x48\x00\x00\xA8"
append replace "\x48\x00\x00\xF4\x7C\x08\x02\xA6\xF8\x01\x00\x20"
append replace "\xF8\x41\x00\x28\x48\x00\x00\x05\x38\x00\x00\x00"
append replace "\x38\x40\x00\x00\x64\x42\x00\x29\x60\x42\x19\xE0"
append replace "\x64\x00\x00\x28\x60\x00\x90\xC0\x7C\x00\x10\x50"
append replace "\x7C\x48\x02\xA6\x38\x42\xFF\xF0\x7C\x42\x02\x14"
append replace "\x48\x00\x03\xE5\xE8\x41\x00\x28\xE8\x01\x00\x20"
append replace "\x7C\x08\x03\xA6\x4E\x80\x00\x20\x60\x00\x00\x00"
append replace "\x7C\x08\x02\xA6\xF8\x01\x00\x20\xF8\x41\x00\x28"
append replace "\x48\x00\x00\x05\x38\x00\x00\x00\x38\x40\x00\x00"
append replace "\x64\x42\x00\x29\x60\x42\x19\xE0\x64\x00\x00\x28"
append replace "\x60\x00\x91\x10\x7C\x00\x10\x50\x7C\x48\x02\xA6"
append replace "\x38\x42\xFF\xF0\x7C\x42\x02\x14\x48\x00\x02\xD1"
append replace "\xE8\x41\x00\x28\xE8\x01\x00\x20\x7C\x08\x03\xA6"
append replace "\x4E\x80\x00\x20\x60\x00\x00\x00\x7C\x08\x02\xA6"
append replace "\xF8\x01\x00\x20\xF8\x41\x00\x28\x48\x00\x00\x05"
append replace "\x38\x00\x00\x00\x38\x40\x00\x00\x64\x42\x00\x29"
append replace "\x60\x42\x19\xE0\x64\x00\x00\x28\x60\x00\x91\x60"
append replace "\x7C\x00\x10\x50\x7C\x48\x02\xA6\x38\x42\xFF\xF0"
append replace "\x7C\x42\x02\x14\x48\x00\x02\x0D\xE8\x41\x00\x28"
append replace "\xE8\x01\x00\x20\x7C\x08\x03\xA6\x4E\x80\x00\x20"
append replace "\x60\x00\x00\x00\x7C\x08\x02\xA6\xF8\x01\x00\x20"
append replace "\xF8\x41\x00\x28\x48\x00\x00\x05\x38\x00\x00\x00"
append replace "\x38\x40\x00\x00\x64\x42\x00\x29\x60\x42\x19\xE0"
append replace "\x64\x00\x00\x28\x60\x00\x91\xB0\x7C\x00\x10\x50"
append replace "\x7C\x48\x02\xA6\x38\x42\xFF\xF0\x7C\x42\x02\x14"
append replace "\xF8\x61\x00\x30\xF8\x81\x00\x38\xF8\xA1\x00\x40"
append replace "\xF8\xC1\x00\x48\x48\x00\x00\x55\xE8\x41\x00\x28"
append replace "\x7C\x64\x07\xB4\x2C\x04\xC5\x61\x40\x82\x00\x38"
append replace "\xE8\x61\x00\x30\xE8\x81\x00\x38\xE8\xA1\x00\x40"
append replace "\xE8\xC1\x00\x48\x3C\x00\x00\x13\x60\x00\x33\x04"
append replace "\x7C\x09\x03\xA6\x2F\x86\x00\x00\x3C\x00\x00\x28"
append replace "\x60\x00\x92\x40\xF8\x21\xFE\xF1\xF9\xC1\x00\x80"
append replace "\x4E\x80\x04\x21\xE8\x01\x00\x20\x7C\x08\x03\xA6"
append replace "\x4E\x80\x00\x20\xF8\x21\xFF\x71\x7C\x08\x02\xA6"
append replace "\xFB\x81\x00\x70\x7C\x6A\x1B\x78\xEB\x82\x80\x00"
append replace "\x38\x60\xC5\x61\xF8\x01\x00\xA0\xFB\xC1\x00\x80"
append replace "\x7C\xDE\x33\x78\xFB\xE1\x00\x88\x7C\xBF\x2B\x78"
append replace "\xFB\xA1\x00\x78\xE9\x7C\x00\x00\x88\x0B\x00\x04"
append replace "\x2F\x80\x00\x00\x41\x9E\x00\xF0\x80\x0B\x08\x08"
append replace "\x2F\x80\x00\x00\x40\x9E\x00\x98\xE9\x22\x80\x08"
append replace "\x3B\xA0\x00\x01\x7C\xA3\x2B\x78\x93\xAB\x08\x08"
append replace "\x38\x80\x00\x00\xF8\x41\x00\x28\x7C\xC5\x33\x78"
append replace "\xE8\x09\x00\x00\xE9\x69\x00\x10\x7C\x09\x03\xA6"
append replace "\xE8\x49\x00\x08\x4E\x80\x04\x21\xE8\x41\x00\x28"
append replace "\xE9\x7C\x00\x00\x38\x00\x08\x00\x3D\x20\x4C\x49"
append replace "\x90\x1F\x00\x0C\x61\x29\x4D\x47\xE9\x4B\x08\x10"
append replace "\x91\x3F\x00\x00\x79\x40\xAA\xC2\x90\x1F\x00\x08"
append replace "\x88\x0B\x08\x04\x2F\x80\x00\x00\x40\x9E\x00\x0C"
append replace "\x93\xBF\x00\x04\x48\x00\x00\x74\x38\x00\x00\x02"
append replace "\x90\x1F\x00\x04\x88\x0B\x08\x05\x2F\x80\x00\x00"
append replace "\x41\x9E\x00\x60\x38\x00\x09\x30\x90\x1F\x00\x0C"
append replace "\x7C\x0A\x03\x92\x90\x1F\x00\x08\x48\x00\x00\x4C"
append replace "\x88\x0B\x08\x04\x2F\x80\x00\x00\x41\x9E\x00\x14"
append replace "\x88\x0B\x08\x05\x2F\x80\x00\x00\x40\x9E\x00\x08"
append replace "\x38\x84\xFF\xE8\xE9\x22\x80\x10\x7D\x43\x53\x78"
append replace "\xF8\x41\x00\x28\x7F\xE5\xFB\x78\x7F\xC6\xF3\x78"
append replace "\xE8\x09\x00\x00\xE9\x69\x00\x10\x7C\x09\x03\xA6"
append replace "\xE8\x49\x00\x08\x4E\x80\x04\x21\xE8\x41\x00\x28"
append replace "\x7F\xC3\x07\xB4\xE8\x01\x00\xA0\xEB\x81\x00\x70"
append replace "\xEB\xA1\x00\x78\x7C\x08\x03\xA6\xEB\xC1\x00\x80"
append replace "\xEB\xE1\x00\x88\x38\x21\x00\x90\x4E\x80\x00\x20"
append replace "\x00\x00\x00\x00\x00\x00\x00\x01\x80\x04\x00\x00"
append replace "\xE9\x22\x80\x00\x7C\x08\x02\xA6\xF8\x21\xFF\x91"
append replace "\xF8\x01\x00\x80\x7C\xCB\x07\xB4\xE9\x29\x00\x00"
append replace "\x88\x09\x00\x04\x2F\x80\x00\x00\x41\x9E\x00\x10"
append replace "\xE8\x09\x08\x10\xF8\x05\x00\x00\x48\x00\x00\x28"
append replace "\xE9\x22\x80\x10\xF8\x41\x00\x28\xE8\x09\x00\x00"
append replace "\xE9\x69\x00\x10\x7C\x09\x03\xA6\xE8\x49\x00\x08"
append replace "\x4E\x80\x04\x21\xE8\x41\x00\x28\x7C\x6B\x1B\x78"
append replace "\xE8\x01\x00\x80\x7D\x63\x5B\x78\x38\x21\x00\x70"
append replace "\x7C\x08\x03\xA6\x4E\x80\x00\x20\x00\x00\x00\x00"
append replace "\x00\x00\x00\x01\x80\x00\x00\x00\xE9\x22\x80\x18"
append replace "\x7C\x08\x02\xA6\xF8\x21\xFF\x81\xFB\xE1\x00\x78"
append replace "\x7C\x9F\x23\x78\xF8\x01\x00\x90\xF8\x41\x00\x28"
append replace "\xE8\x09\x00\x00\xE9\x69\x00\x10\x7C\x09\x03\xA6"
append replace "\xE8\x49\x00\x08\x4E\x80\x04\x21\xE8\x41\x00\x28"
append replace "\xE9\x22\x80\x00\xE9\x09\x00\x00\x88\x08\x00\x04"
append replace "\x2F\x80\x00\x00\x41\x9E\x00\x60\x89\x7F\x00\x28"
append replace "\x88\x1F\x00\x29\x79\x6B\xC1\xC6\x89\x3F\x00\x2A"
append replace "\x78\x00\x83\xC6\x89\x5F\x00\x2D\x79\x29\x45\xC6"
append replace "\x7C\x00\x5B\x78\x89\x7F\x00\x2B\x79\x4A\x83\xE4"
append replace "\x7D\x29\x03\x78\x88\x1F\x00\x2C\x79\x6B\x07\xC6"
append replace "\x78\x00\xC1\xE4\x7D\x6B\x4B\x78\x89\x3F\x00\x2E"
append replace "\x7C\x00\x5B\x78\x79\x29\x45\xE4\x7D\x4A\x03\x78"
append replace "\x88\x1F\x00\x2F\x7D\x29\x53\x78\x7C\x00\x4B\x78"
append replace "\xF8\x08\x08\x10\xE8\x01\x00\x90\xEB\xE1\x00\x78"
append replace "\x38\x21\x00\x80\x7C\x08\x03\xA6\x4E\x80\x00\x20"
append replace "\x00\x00\x00\x00\x00\x00\x00\x01\x80\x01\x00\x00"
append replace "\xF8\x21\xFF\x41\x7C\x08\x02\xA6\xFB\x81\x00\xA0"
append replace "\xEB\x82\x80\x00\xF8\x01\x00\xD0\xFB\x61\x00\x98"
append replace "\xFB\x21\x00\x88\x7C\x79\x1B\x78\xFB\x41\x00\x90"
append replace "\x7C\x9A\x23\x78\xE9\x3C\x00\x00\xFB\xA1\x00\xA8"
append replace "\xFB\xC1\x00\xB0\xFB\xE1\x00\xB8\x83\x69\x00\x00"
append replace "\x2F\x9B\x00\x00\x40\x9E\x01\x58\x7C\x83\x23\x78"
append replace "\xE8\x82\x80\x20\x48\x00\x02\xE5\x60\x00\x00\x00"
append replace "\x2F\xA3\x00\x00\x41\x9E\x01\x30\xE9\x22\x80\x30"
append replace "\x38\x60\x00\x00\xF8\x41\x00\x28\xE8\x82\x80\x28"
append replace "\xE8\x09\x00\x00\xE9\x69\x00\x10\x7C\x09\x03\xA6"
append replace "\xE8\x49\x00\x08\x4E\x80\x04\x21\xE8\x41\x00\x28"
append replace "\x2F\x83\x00\x00\x7C\x7D\x1B\x78\x41\x9C\x00\xFC"
append replace "\xEB\xC2\x80\x10\x38\x80\x00\x00\x38\xA1\x00\x70"
append replace "\x38\xC0\x00\x01\xE8\x1E\x00\x00\xE9\x7E\x00\x10"
append replace "\x7C\x09\x03\xA6\xE8\x5E\x00\x08\x4E\x80\x04\x21"
append replace "\xE8\x41\x00\x28\x88\x01\x00\x70\xE9\x3C\x00\x00"
append replace "\x38\x80\x00\x01\x54\x00\x07\xFE\x38\xC0\x07\xFF"
append replace "\x98\x09\x08\x04\x7F\xA3\xEB\x78\xE8\xBC\x00\x00"
append replace "\xF8\x41\x00\x28\xE8\x1E\x00\x00\x38\xA5\x00\x04"
append replace "\xE9\x7E\x00\x10\x7C\x09\x03\xA6\xE8\x5E\x00\x08"
append replace "\x4E\x80\x04\x21\xE8\x41\x00\x28\xEB\xFC\x00\x00"
append replace "\xE8\x82\x80\x38\x38\xA0\x00\x0A\x38\x7F\x00\x04"
append replace "\x48\x00\x01\x9D\x60\x00\x00\x00\x2F\xA3\x00\x00"
append replace "\x41\x9E\x00\x0C\x9B\x7F\x00\x04\x48\x00\x00\x48"
append replace "\x88\x1F\x08\x04\x2F\x80\x00\x00\x41\x9E\x00\x3C"
append replace "\xF8\x41\x00\x28\x7F\xA3\xEB\x78\xE8\x1E\x00\x00"
append replace "\x38\x80\x08\x00\xE9\x7E\x00\x10\x38\xA1\x00\x71"
append replace "\x7C\x09\x03\xA6\x38\xC0\x00\x01\xE8\x5E\x00\x08"
append replace "\x4E\x80\x04\x21\xE8\x41\x00\x28\xE9\x3C\x00\x00"
append replace "\x88\x01\x00\x71\x98\x09\x08\x05\xE9\x22\x80\x40"
append replace "\x7F\xA3\xEB\x78\xF8\x41\x00\x28\xE8\x09\x00\x00"
append replace "\xE9\x69\x00\x10\x7C\x09\x03\xA6\xE8\x49\x00\x08"
append replace "\x4E\x80\x04\x21\xE8\x41\x00\x28\xE9\x22\x80\x00"
append replace "\x38\x00\x00\x01\xE9\x29\x00\x00\x90\x09\x00\x00"
append replace "\xE9\x22\x80\x00\xE9\x42\x80\x30\xE8\x89\x00\x00"
append replace "\x88\x04\x00\x04\x2F\x80\x00\x00\x41\x9E\x00\x20"
append replace "\xE8\x0A\x00\x00\x38\x84\x00\x0E\xF8\x41\x00\x28"
append replace "\x38\x60\x00\x00\xE9\x6A\x00\x10\x7C\x09\x03\xA6"
append replace "\x48\x00\x00\x1C\xE8\x0A\x00\x00\x7F\x23\xCB\x78"
append replace "\xF8\x41\x00\x28\x7F\x44\xD3\x78\xE9\x6A\x00\x10"
append replace "\x7C\x09\x03\xA6\xE8\x4A\x00\x08\x4E\x80\x04\x21"
append replace "\xE8\x41\x00\x28\xE8\x01\x00\xD0\xEB\x21\x00\x88"
append replace "\xEB\x41\x00\x90\x7C\x08\x03\xA6\xEB\x61\x00\x98"
append replace "\xEB\x81\x00\xA0\xEB\xA1\x00\xA8\xEB\xC1\x00\xB0"
append replace "\xEB\xE1\x00\xB8\x38\x21\x00\xC0\x4E\x80\x00\x20"
append replace "\x00\x00\x00\x00\x00\x00\x00\x01\x80\x07\x00\x00"
append replace "\x2C\x25\x00\x00\x40\x82\x00\x1C\x48\x00\x00\x60"
append replace "\x38\x63\x00\x01\x38\x84\x00\x01\x41\x86\x00\x54"
append replace "\x41\x9A\x00\x50\x48\x00\x00\x0C\x38\x05\x00\x01"
append replace "\x7C\x09\x03\xA6\x38\xA5\xFF\xFF\x42\x40\x00\x1C"
append replace "\x88\x03\x00\x00\x2C\xA5\x00\x00\x89\x24\x00\x00"
append replace "\x2F\x20\x00\x00\x7F\x89\x00\x00\x41\x9E\xFF\xC8"
append replace "\x89\x23\x00\x00\x38\x60\xFF\xFF\x88\x04\x00\x00"
append replace "\x7F\x89\x00\x40\x4D\x9C\x00\x20\x7C\x60\x00\x26"
append replace "\x54\x63\xF7\xFE\x4E\x80\x00\x20\x38\x60\x00\x00"
append replace "\x4E\x80\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x38\xA5\x00\x01\x39\x20\x00\x00"
append replace "\x7C\xA9\x03\xA6\x48\x00\x00\x30\x7D\x69\x18\xAE"
append replace "\x7C\x09\x20\xAE\x39\x29\x00\x01\x7F\x8B\x00\x00"
append replace "\x41\x9E\x00\x1C\x7F\x8B\x00\x40\x7C\x60\x00\x26"
append replace "\x54\x63\xEF\xFE\x7C\x03\x00\xD0\x60\x03\x00\x01"
append replace "\x4E\x80\x00\x20\x42\x00\xFF\xD4\x38\x60\x00\x00"
append replace "\x4E\x80\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x54\x84\x06\x3E\x48\x00\x00\x14"
append replace "\x38\x63\x00\x01\x40\x9A\x00\x0C\x38\x60\x00\x00"
append replace "\x4E\x80\x00\x20\x88\x03\x00\x00\x7F\x80\x20\x00"
append replace "\x2F\x20\x00\x00\x40\x9E\xFF\xE4\x4E\x80\x00\x20"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\xF8\x21\xFF\x61\x7C\x08\x02\xA6\xFB\xA1\x00\x88"
append replace "\x7C\x9D\x23\x78\xFB\xE1\x00\x98\x7C\x7F\x1B\x78"
append replace "\xFB\x61\x00\x78\xFB\x81\x00\x80\xFB\xC1\x00\x90"
append replace "\xF8\x01\x00\xB0\x8B\x84\x00\x00\x2F\xBC\x00\x00"
append replace "\x41\x9E\x00\x50\x48\x00\x00\x0C\x7F\xC3\xF3\x78"
append replace "\x48\x00\x00\x44\x7C\x83\x23\x78\x48\x00\x00\x7D"
append replace "\x60\x00\x00\x00\x7C\x7B\x1B\x78\x48\x00\x00\x10"
append replace "\x4B\xFF\xFE\xA5\x2F\xA3\x00\x00\x41\x9E\xFF\xDC"
append replace "\x7F\xE3\xFB\x78\x7F\x84\x07\xB4\x4B\xFF\xFF\x61"
append replace "\x7F\xA4\xEB\x78\x7C\x7E\x1B\x79\x7F\x65\xDB\x78"
append replace "\x3B\xFE\x00\x01\x40\x82\xFF\xD8\xE8\x01\x00\xB0"
append replace "\xEB\x61\x00\x78\xEB\x81\x00\x80\x7C\x08\x03\xA6"
append replace "\xEB\xA1\x00\x88\xEB\xC1\x00\x90\xEB\xE1\x00\x98"
append replace "\x38\x21\x00\xA0\x4E\x80\x00\x20\x00\x00\x00\x00"
append replace "\x00\x00\x00\x01\x80\x05\x00\x00\x00\x00\x00\x00"
append replace "\x00\x11\x52\xBC\x00\x00\x00\x00\x00\x74\xFC\x80"
append replace "\xF8\x21\xFF\x81\x7C\x08\x02\xA6\xF8\x01\x00\x90"
append replace "\xF8\x41\x00\x28\x38\x00\x00\x00\x64\x02\x00\x11"
append replace "\x60\x42\x51\x24\x7C\x49\x03\xA6\x64\x02\x00\x74"
append replace "\x60\x42\xFC\x80\x4E\x80\x04\x21\xE8\x41\x00\x28"
append replace "\xE8\x01\x00\x90\x38\x21\x00\x80\x7C\x08\x03\xA6"
append replace "\x4E\x80\x00\x20\x00\x00\x00\x00\x00\x1E\x87\xA4"
append replace "\x00\x00\x00\x00\x00\x74\xFC\x80\x00\x00\x00\x00"
append replace "\x00\x1E\x86\x58\x00\x00\x00\x00\x00\x74\xFC\x80"
append replace "\x00\x00\x00\x00\x00\x1E\x91\x14\x00\x00\x00\x00"
append replace "\x00\x74\xFC\x80\x00\x00\x00\x00\x00\x1E\x82\xA8"
append replace "\x00\x00\x00\x00\x00\x74\xFC\x80\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x2D\x2D\x43\x4F\x42\x52\x41\x2D"
append replace "\x2D\x00\x00\x00\x00\x00\x00\x00\x2F\x74\x6D\x70"
append replace "\x2F\x63\x66\x67\x2E\x62\x69\x6E\x00\x00\x00\x00"
append replace "\x2F\x64\x65\x76\x5F\x68\x64\x64\x30\x2F\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x02\x92\x33\x88\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x28\x99\xA0\x00\x00\x00\x00"
append replace "\x00\x28\x98\xBC\x00\x00\x00\x00\x00\x28\x99\x2C"
append replace "\x00\x00\x00\x00\x00\x28\x99\x3C\x00\x00\x00\x00"
append replace "\x00\x28\x99\x60\x00\x00\x00\x00\x00\x28\x99\x70"
append replace "\x00\x00\x00\x00\x00\x28\x99\x0C\x00\x00\x00\x00"
append replace "\x00\x28\x99\x80\x00\x00\x00\x00\x00\x28\x99\x1C"
append replace "\x00\x00\x00\x00\x00\x28\x90\xC0\x00\x00\x00\x00"
append replace "\x00\x29\x19\xE0\x00\x00\x00\x00\x00\x28\x91\x10"
append replace "\x00\x00\x00\x00\x00\x29\x19\xE0\x00\x00\x00\x00"
append replace "\x00\x28\x91\x60\x00\x00\x00\x00\x00\x29\x19\xE0"
append replace "\x00\x00\x00\x00\x00\x28\x91\xB0\x00\x00\x00\x00"
append replace "\x00\x29\x19\xE0\x00\x00\x00\x00\x00\x28\x92\x4C"
append replace "\x00\x00\x00\x00\x00\x29\x19\xE0\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x93\xA4"
append replace "\x00\x00\x00\x00\x00\x29\x19\xE0\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x94\x18"
append replace "\x00\x00\x00\x00\x00\x29\x19\xE0\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x94\xDC"
append replace "\x00\x00\x00\x00\x00\x29\x19\xE0\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x97\x04"
append replace "\x00\x00\x00\x00\x00\x29\x19\xE0\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x97\x80"
append replace "\x00\x00\x00\x00\x00\x29\x19\xE0\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x97\xD4"
append replace "\x00\x00\x00\x00\x00\x29\x19\xE0\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x98\x0C"
append replace "\x00\x00\x00\x00\x00\x29\x19\xE0"
			
			catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"	
			
			log "Part 7 -- offset 0x1432f0"
			log "Patching 446 ps2netemu for Cobra Features"
			
			set search "\x29\x90\x30\x00\x00\x00\x00\x00\x00\x00\x78\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x96\x00\x00\x00\x01\x00\x00\x00\x00\x00"
append search "\x00\x00\x03\x00\x00\x00\x00\x00\x30\x00\x00\x00"
append search "\x00\x00\x00\x00\x2A\x00\x00\x00\x00\x00\x00\x00"
append search "\x01\xE3\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x9E\x00\x00\x00\x01\x00"
append search "\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00"
append search "\x31\xE3\x38\x00\x00\x00\x00\x00\x2B\xE3\x38\x00"
append search "\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xB2\x00"
append search "\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x02\x00"
append search "\x00\x00\x00\x00\x31\xE3\x40\x00\x00\x00\x00\x00"
append search "\x2B\xE3\x40\x00\x00\x00\x00\x00\x00\x00\x20\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\xC6\x00\x00\x00\x01\x00\x00\x00\x00\x00"
append search "\x00\x00\x02\x00\x00\x00\x00\x00\x31\xE3\x60\x00"
append search "\x00\x00\x00\x00\x2B\xE3\x60\x00\x00\x00\x00\x00"
append search "\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\xDA\x00\x00\x00\x01\x00"
append search "\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00"
append search "\x31\xE3\x80\x00\x00\x00\x00\x00\x2B\xE3\x80\x00"
append search "\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xEE\x00"
append search "\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x02\x00"
append search "\x00\x00\x00\x00\x31\xE3\x88\x00\x00\x00\x00\x00"
append search "\x2B\xE3\x88\x00\x00\x00\x00\x00\x00\x01\x68\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x01\x02\x00\x00\x00\x01\x00\x00\x00\x00\x00"
append search "\x00\x00\x02\x00\x00\x00\x00\x00\x31\xE4\xF0\x00"
append search "\x00\x00\x00\x00\x2B\xE4\xF0\x00\x00\x00\x00\x00"
append search "\x00\x00\xD8\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x01\x16\x00\x00\x00\x01\x00"
append search "\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00"
append search "\x31\xE5\xC8\x00\x00\x00\x00\x00\x2B\xE5\xC8\x00"
append search "\x00\x00\x00\x00\x00\x00\xD8\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x2A\x00"
append search "\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x02\x00"
append search "\x00\x00\x00\x00\x31\xE6\xA0\x00\x00\x00\x00\x00"
append search "\x2B\xE6\xA0\x00\x00\x00\x00\x00\x00\x00\x38\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x01\x3E\x00\x00\x00\x01\x00\x00\x00\x00\x00"
append search "\x00\x00\x02\x00\x00\x00\x00\x00\x31\xE6\xD8\x00"
append search "\x00\x00\x00\x00\x2B\xE6\xD8\x00\x00\x00\x00\x00"
append search "\x00\x2B\x50\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x01\x48\x00\x00\x00\x01\x00"
append search "\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00"
append search "\x32\x12\x80\x00\x00\x00\x00\x00\x2C\x12\x80\x00"
append search "\x00\x00\x00\x00\x37\xB6\x80\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x4F\x00"
append search "\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x02\x00"
append search "\x00\x00\x00\x00\x69\xC9\x00\x00\x00\x00\x00\x00"
append search "\x63\xC9\x00\x00\x00\x00\x00\x00\x08\x0D\x06\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x01\x5B\x00\x00\x00\x01\x00\x00\x00\x00\x00"
append search "\x00\x00\x03\x00\x00\x00\x00\x00\x71\xD6\x08\x00"
append search "\x00\x00\x00\x00\x6B\xD6\x08\x00\x00\x00\x00\x00"
append search "\x02\xA6\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x01\x60\x00\x00\x00\x01\x00"
append search "\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00"
append search "\x74\x7C\x80\x00\x00\x00\x00\x00\x6E\x7C\x80\x00"
append search "\x00\x00\x00\x00\x00\x53\xF8\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x65\x00"
append search "\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x02\x00"
append search "\x00\x00\x00\x00\x82\x10\x00\x00\x00\x00\x00\x00"
append search "\x6F\x10\x00\x00\x00\x00\x00\x00\x00\x45\x20\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x01\x6C\x00\x00\x00\x01\x00\x00\x00\x00\x00"
append search "\x00\x00\x02\x00\x00\x00\x00\x00\x82\x55\x80\x00"
append search "\x00\x00\x00\x00\x6F\x55\x80\x00\x00\x00\x00\x00"
append search "\x0D\x15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x01\x76\x00\x00\x00\x01\x00"
append search "\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00"
append search "\x8F\x6A\x80\x00\x00\x00\x00\x00\x7C\x6A\x80\x00"
append search "\x00\x00\x00\x00\x03\xA3\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x81\x00"
append search "\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x03\x00"
append search "\x00\x00\x00\x00\x93\x0D\x80\x00\x00\x00\x00\x00"
append search "\x80\x0D\x80\x00\x00\x00\x00\x00\x00\x00\x0C\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x01\x8B\x00\x00\x00\x01\x00\x00\x00\x00\x00"
append search "\x00\x00\x03\x00\x00\x00\x00\x00\x93\x0E\x00\x00"
append search "\x00\x00\x00\x00\x80\x0E\x00\x00\x00\x00\x00\x00"
append search "\x00\x2F\xA0\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x01\x97\x00\x00\x00\x01\x00"
append search "\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00"
append search "\x93\x3E\x00\x00\x00\x00\x00\x00\x80\x3E\x00\x00"
append search "\x00\x00\x00\x00\x01\xC4\xB0\x00\x00\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x9D\x00"
append search "\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x02\x00"
append search "\x00\x00\x00\x00\x95\x03\x00\x00\x00\x00\x00\x00"
append search "\x82\x03\x00\x00\x00\x00\x00\x00\x1D\x00\x00\x00"
append search "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append search "\x00\x01\xA6\x00\x00\x00\x08\x00\x00\x00\x00\x00"
append search "\x00\x00\x03\x00\x00\x00\x00\x00\xB2\x03\x00\x00"
append search "\x00\x00\x00\x00\x9F\x03\x00\x00\x00\x00\x00\x01"
append search "\xE0\x30"
			
set replace "\x29\x90\x30\x00\x00\x00\x00\x00\x00\x68\x78\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x96\x00\x00\x00\x01\x00\x00\x00\x00\x00"
append replace "\x00\x00\x03\x00\x00\x00\x00\x00\x30\x00\x00\x00"
append replace "\x00\x00\x00\x00\x2A\x00\x00\x00\x00\x00\x00\x00"
append replace "\x01\xE3\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x9E\x00\x00\x00\x01\x00"
append replace "\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00"
append replace "\x31\xE3\x38\x00\x00\x00\x00\x00\x2B\xE3\x38\x00"
append replace "\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xB2\x00"
append replace "\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x02\x00"
append replace "\x00\x00\x00\x00\x31\xE3\x40\x00\x00\x00\x00\x00"
append replace "\x2B\xE3\x40\x00\x00\x00\x00\x00\x00\x00\x20\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\xC6\x00\x00\x00\x01\x00\x00\x00\x00\x00"
append replace "\x00\x00\x02\x00\x00\x00\x00\x00\x31\xE3\x60\x00"
append replace "\x00\x00\x00\x00\x2B\xE3\x60\x00\x00\x00\x00\x00"
append replace "\x00\x00\x20\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\xDA\x00\x00\x00\x01\x00"
append replace "\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00"
append replace "\x31\xE3\x80\x00\x00\x00\x00\x00\x2B\xE3\x80\x00"
append replace "\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xEE\x00"
append replace "\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x02\x00"
append replace "\x00\x00\x00\x00\x31\xE3\x88\x00\x00\x00\x00\x00"
append replace "\x2B\xE3\x88\x00\x00\x00\x00\x00\x00\x01\x68\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x01\x02\x00\x00\x00\x01\x00\x00\x00\x00\x00"
append replace "\x00\x00\x02\x00\x00\x00\x00\x00\x31\xE4\xF0\x00"
append replace "\x00\x00\x00\x00\x2B\xE4\xF0\x00\x00\x00\x00\x00"
append replace "\x00\x00\xD8\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x01\x16\x00\x00\x00\x01\x00"
append replace "\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00"
append replace "\x31\xE5\xC8\x00\x00\x00\x00\x00\x2B\xE5\xC8\x00"
append replace "\x00\x00\x00\x00\x00\x00\xD8\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x2A\x00"
append replace "\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x02\x00"
append replace "\x00\x00\x00\x00\x31\xE6\xA0\x00\x00\x00\x00\x00"
append replace "\x2B\xE6\xA0\x00\x00\x00\x00\x00\x00\x00\x38\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x01\x3E\x00\x00\x00\x01\x00\x00\x00\x00\x00"
append replace "\x00\x00\x02\x00\x00\x00\x00\x00\x31\xE6\xD8\x00"
append replace "\x00\x00\x00\x00\x2B\xE6\xD8\x00\x00\x00\x00\x00"
append replace "\x00\x2B\x50\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x01\x48\x00\x00\x00\x01\x00"
append replace "\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00"
append replace "\x32\x12\x80\x00\x00\x00\x00\x00\x2C\x12\x80\x00"
append replace "\x00\x00\x00\x00\x37\xB6\x80\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x80\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x4F\x00"
append replace "\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x02\x00"
append replace "\x00\x00\x00\x00\x69\xC9\x00\x00\x00\x00\x00\x00"
append replace "\x63\xC9\x00\x00\x00\x00\x00\x00\x08\x0D\x06\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x01\x5B\x00\x00\x00\x01\x00\x00\x00\x00\x00"
append replace "\x00\x00\x03\x00\x00\x00\x00\x00\x71\xD6\x08\x00"
append replace "\x00\x00\x00\x00\x6B\xD6\x08\x00\x00\x00\x00\x00"
append replace "\x02\xA6\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x08\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x01\x60\x00\x00\x00\x01\x00"
append replace "\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00"
append replace "\x74\x7C\x80\x00\x00\x00\x00\x00\x6E\x7C\x80\x00"
append replace "\x00\x00\x00\x00\x00\x53\xF8\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x65\x00"
append replace "\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x02\x00"
append replace "\x00\x00\x00\x00\x82\x10\x00\x00\x00\x00\x00\x00"
append replace "\x6F\x10\x00\x00\x00\x00\x00\x00\x00\x45\x20\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x01\x6C\x00\x00\x00\x01\x00\x00\x00\x00\x00"
append replace "\x00\x00\x02\x00\x00\x00\x00\x00\x82\x55\x80\x00"
append replace "\x00\x00\x00\x00\x6F\x55\x80\x00\x00\x00\x00\x00"
append replace "\x0D\x15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x01\x76\x00\x00\x00\x01\x00"
append replace "\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00"
append replace "\x8F\x6A\x80\x00\x00\x00\x00\x00\x7C\x6A\x80\x00"
append replace "\x00\x00\x00\x00\x03\xA3\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x81\x00"
append replace "\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x03\x00"
append replace "\x00\x00\x00\x00\x93\x0D\x80\x00\x00\x00\x00\x00"
append replace "\x80\x0D\x80\x00\x00\x00\x00\x00\x00\x00\x0C\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x01\x8B\x00\x00\x00\x01\x00\x00\x00\x00\x00"
append replace "\x00\x00\x03\x00\x00\x00\x00\x00\x93\x0E\x00\x00"
append replace "\x00\x00\x00\x00\x80\x0E\x00\x00\x00\x00\x00\x00"
append replace "\x00\x2F\xA0\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x01\x97\x00\x00\x00\x01\x00"
append replace "\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00"
append replace "\x93\x3E\x00\x00\x00\x00\x00\x00\x80\x3E\x00\x00"
append replace "\x00\x00\x00\x00\x01\xC4\xB0\x00\x00\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x40\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x9D\x00"
append replace "\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x02\x00"
append replace "\x00\x00\x00\x00\x95\x03\x00\x00\x00\x00\x00\x00"
append replace "\x82\x03\x00\x00\x00\x00\x00\x00\x1D\x00\x00\x00"
append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00\x00\x00"
append replace "\x00\x01\xA6\x00\x00\x00\x08\x00\x00\x00\x00\x00"
append replace "\x00\x00\x03\x00\x00\x00\x00\x00\xB2\x03\x00\x00"
append replace "\x00\x00\x00\x00\x9F\x03\x00\x00\x00\x00\x00\x01"
append replace "\xE0\x40"
			
			catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf]"
        }
    }
}
