#!/usr/bin/tclsh
#
# ps3mfw -- PS3 MFW creator
#
# Copyright (C) Anonymous Developers (Code Monkeys)
#
# This software is distributed under the terms of the GNU General Public
# License ("GPL") version 3, as published by the Free Software Foundation.
#
    
# Priority: 99
# Description: Auto Generate Pre-definated CFW's

# Option --auto-gen-ac1d: Auto Generate AC1D CFW
# Option --auto-gen-rogero: Auto Generate Rogero CFW
# Option --customize-cfw: Customize your autogenerated MFW


# Type --auto-gen-ac1d: boolean
# Type --auto-gen-rogero: boolean
# Type --customize-cfw: boolean


namespace eval ::auto_gen_cfw {

    array set ::auto_gen_cfw::options {
        --auto-gen-ac1d false
        --auto-gen-rogero false 
		--customize-cfw false
    }
    
    proc main {} {
        debug "Setting vars"
	    variable options
        set ::SUF ""
		set ::CFW 0
        set ::a "3.41"
        set ::b "3.55"
        set ::c "4.30"
        set ::d "4.31"
		set ::release ""
		set ::build ""
		set ::bdate ""
		set VERSION_TXT [file join dev_flash vsh etc version.txt]
	    set ::spoof {4.31 59249 20121027 0001:CEX-ww 4906@security/sdk_branches/release_431/trunk 49507@sys/sdk_branches/release_431/trunk 16072@x3/branches/target43x 6218@paf/branches/target43x 91288@vsh/branches/target43x 85@sys_jp/branches/target43x 9073@emu/branches/target101/ps1 9080@emu/branches/target430/ps1_net 9039@emu/branches/target202/ps1_new 9040@emu/branches/target400/ps2 16771@branches/target400/gx 16770@branches/soft190/soft 9097@emu/branches/target430/psp 3924@emerald/target42x 19089@bdp/prof5/branches/target42x}
        set ::psc {netconf_plugin.sprx sysconf_plugin.sprx}
        set ::psn {libad_core.sprx libmedi.sprx libsysutil_np_clans.sprx libsysutil_np_commerce2.sprx libsysutil_np_util.sprx autodownload_plugin.sprx download_plugin.sprx esehttp.sprx eula_cddb_plugin.sprx eula_hcopy_plugin.sprx eula_net_plugin.sprx explore_category_friend.sprx explore_category_game.sprx explore_category_music.sprx explore_category_network.sprx explore_category_photo.sprx explore_category_psn.sprx explore_category_sysconf.sprx explore_category_tv.sprx explore_category_user.sprx explore_category_video.sprx explore_plugin.sprx explore_plugin_ft.sprx explore_plugin_np.sprx friendtrophy_plugin.sprx game_ext_plugin.sprx hknw_plugin.sprx nas_plugin.sprx newstore_plugin.sprx np_eula_plugin.sprx np_trophy_plugin.sprx np_trophy_util.sprx photo_network_sharing_plugin.sprx profile_plugin.sprx regcam_plugin.sprx sysconf_plugin.sprx videoeditor_plugin.sprx videoplayer_plugin.sprx videoplayer_util.sprx vsh.self x3_mdimp11.sprx x3_mdimp7.sprx}
        set ::pso {netconf_plugin.sprx sysconf_plugin.sprx}
        set ::son {eula_net_plugin.sprx mintx_client.sprx}
        set ::sny "videodownloader_plugin.sprx"	 
        set ::allDevXmlAc1d {category_game_tool2.xml category_game.xml category_network.xml category_psn.xml registory.xml}
		set ::allDevSelfsNEW {vsh.self explore_category_game.sprx explore_plugin.sprx}
        #set ::allDevSelfsAc1d {netconf_plugin.sprx sysconf_plugin.sprx libad_core.sprx libmedi.sprx libsysutil_np_clans.sprx libsysutil_np_commerce2.sprx libsysutil_np_util.sprx autodownload_plugin.sprx download_plugin.sprx esehttp.sprx eula_cddb_plugin.sprx eula_hcopy_plugin.sprx eula_net_plugin.sprx explore_category_friend.sprx explore_category_game.sprx explore_category_music.sprx explore_category_network.sprx explore_category_photo.sprx explore_category_psn.sprx explore_category_sysconf.sprx explore_category_tv.sprx explore_category_user.sprx explore_category_video.sprx explore_plugin.sprx explore_plugin_ft.sprx explore_plugin_np.sprx friendtrophy_plugin.sprx game_ext_plugin.sprx hknw_plugin.sprx nas_plugin.sprx newstore_plugin.sprx np_eula_plugin.sprx np_trophy_plugin.sprx np_trophy_util.sprx photo_network_sharing_plugin.sprx profile_plugin.sprx regcam_plugin.sprx sysconf_plugin.sprx videoeditor_plugin.sprx videoplayer_plugin.sprx videoplayer_util.sprx vsh.self x3_mdimp11.sprx x3_mdimp7.sprx netconf_plugin.sprx sysconf_plugin.sprx eula_net_plugin.sprx mintx_client.sprx videodownloader_plugin.sprx vsh.self}
		set ::allDevResourceAc1d {sysconf_plugin.rco xmb_ingame.rco explore_plugin_full.rco}
		set ::allDevXmlRogero {category_game_tool2.xml category_game.xml}
		set ::allCosFilesOLD {lv0 lv1.self lv2_kernel.self spu_pkg_rvk_verifier.self emer_init.self}
		set ::allCosFilesNEW {lv0 lv1.self lv2_kernel.self spu_pkg_rvk_verifier.self}
		set ::fwVersion ""
		
		debug "All vars set"
     
        ::auto_gen_cfw::check_version
        
        if {${::CFW} != "0"  && ${::SUF} == ${::c} || ${::SUF} == ${::d}} {
            log "Checking if more tasks are selected"
            if {[::auto_gen_cfw::check_task] != "true"} {
                log "Check Error! Other tasks are selected!"
                log "To prevent you from bricking your Console..."
                log "You can't use 'Auto Generate CFW' together with any other option"
				after 20000 
				exit 0
            } else {
                log "Check OK! No other tasks are selected, will now start creating CFW ${::CFW} ${::SUF}"
				if {${::SUF} == ${::c} || ${::SUF} == ${::d}} {
				    ::copy_ps3_game_standart
				}
				if {${::CFW} == "Rogero"} {
				    set fwversion " Rogero v2.03"
					::modify_coreos_file ${::allCosFilesNEW} ::auto_gen_cfw::patch_self
					::modify_devflash_file [file join dev_flash vsh module vsh.self] ::auto_gen_cfw::patch_self
					::modify_rco_file [file join dev_flash vsh resource sysconf_plugin.rco] ::auto_gen_cfw::patch_rco
					::modify_devflash_files ${::allDevXmlRogero} ::auto_gen_cfw::patch_xml
					
					set coldboot_raf [file join dev_flash vsh resource coldboot.raf]
                    set CBRR [file join ${::CUSTOM_TEMPLAT_RAF} rogero.raf]
					
					if {[::auto_gen_cfw::callback_files $CBRR] == "true"} {
                        ::auto_gen_cfw::copy_customized_file $CBRR $coldboot_raf
			        } else {
			            log "WARNING! Could not find custom coldboot raf"
			        }
					::set_pup_build [::get_pup_build]
				    ::modify_pup_version_file "Rogero " " v2.03"	
			    } elseif {${::CFW} == "AC1D"} { 
				    set fwversion " AC1D v3"
					::modify_coreos_files ${::allCosFilesNEW} ::auto_gen_cfw::patch_self
				    ::modify_devflash_files [file join dev_flash vsh module] ${::allDevSelfsNEW} ::auto_gen_cfw::patch_self
					::modify_rco_files [file join dev_flash vsh resource] ${::allDevResourceAc1d} ::auto_gen_cfw::patch_rco
				    ::auto_gen_cfw::find_nodes [file join ${::CUSTOM_TEMPLAT_DIR} mfw_templat.xml]
					::modify_devflash_files [file join dev_flash vsh resource explore xmb] ${::allDevXmlAc1d} ::auto_gen_cfw::patch_xml
					
					set coldboot_raf [file join dev_flash vsh resource coldboot.raf]
                    set coldboot_stereo [file join dev_flash vsh resource coldboot_stereo.ac3]
                    set coldboot_multi [file join dev_flash vsh resource coldboot_multi.ac3]
					set CBRA [file join ${::CUSTOM_TEMPLAT_RAF} acid.raf]
                    set CBMA [file join ${::CUSTOM_TEMPLAT_AC3} acid_multi.ac3]
                    set CBSA [file join ${::CUSTOM_TEMPLAT_AC3} acid_stereo.ac3]
					
					if {[file exists $CBRA] != 0 || [file exists $CBMA] != 0 || [file exists $CBSA] != 0} {
					    log "All AC1D CCF's found "
						log "Copy customized coldboot files into dev_flash"
						modify_devflash_file [file join dev_flash vsh resource coldboot.raf] ::auto_gen_cfw::copy_customized_file $CBRA
						log "Copy $CBRA to $coldboot_raf"
			            modify_devflash_file [file join dev_flash vsh resource coldboot_multi.ac3] ::auto_gen_cfw::copy_customized_file $CBMA
						log "Copy $CBMA to $coldboot_multi"
					    modify_devflash_file [file join dev_flash vsh resource coldboot_stereo.ac3] ::auto_gen_cfw::copy_customized_file $CBSA
						log "Copy $CBSA to $coldboot_stereo"
					} else {
						log "Warning! Could not find custom coldboot files"
					}
				 
					::set_pup_build [::get_pup_build]
				    ::modify_pup_version_file "AC1D " " v3.0"
				}   
				if {${::SUF} <= ${::c} && ${::SUF} >= ${::a}} {
		            log "Changing firmware version.txt & index.dat file"
			        ::modify_devflash_file $VERSION_TXT ::auto_gen_cfw::version_txt
					::modify_upl_file ::auto_gen_cfw::upl_xml
		        }	
            }         
        } else {
		    log "CFW Model or Version suffix error"
			after 20000
			exit 0
		}
    }
    
    proc patch_xml {xml} {
	    debug "in patch_xml now"
        if {${::CFW} == "AC1D"} {
            if {${::SELF} == "dev_flash/vsh/resource/explore/xmb/category_network.xml"} {
			    ::auto_gen_cfw::remove_line_from_network_cat ${::CUSTOM_DEVFLASH_DIR}/${::SELF}
			    ::auto_gen_cfw::read_cat ${::CUSTOM_DEVFLASH_DIR}/${::SELF}
				::auto_gen_cfw::inject_nodes ${::CUSTOM_DEVFLASH_DIR}/${::SELF}
			}
			if {${::SELF} == "dev_flash/vsh/resource/explore/xmb/category_psn.xml"} {
			    ::auto_gen_cfw::inject_cat ${::CUSTOM_DEVFLASH_DIR}/${::SELF}
			}
			if {${::SELF} == "dev_flash/vsh/resource/explore/xmb/registory.xml"} {
			    ::auto_gen_cfw::alpha_sort ${::CUSTOM_DEVFLASH_DIR}/${::SELF}
                ::auto_gen_cfw::rape_sfo ${::CUSTOM_DEVFLASH_DIR}/${::SELF}
			}
        }
        if {${::CFW} == "Rogero" || ${::CFW} == "AC1D"} {
		    if {${::SELF} == "dev_flash/vsh/resource/explore/xmb/category_game_tool2.xml"} {
			    ::auto_gen_cfw::find_nodes1 ${::CUSTOM_DEVFLASH_DIR}/${::SELF}
			}
		    if {${::SELF} == "dev_flash/vsh/resource/explore/xmb/category_game.xml"} {
			    ::auto_gen_cfw::inject_nodes2 ${::CUSTOM_DEVFLASH_DIR}/${::SELF}
			}
        }
    }
    
    proc patch_self {self} {
	    debug "in patch_self now"
		debug "self = ${::SELF}"
		::modify_self_file $self ::auto_gen_cfw::patch_elf
    }
	
	proc patch_rco {path} {
	    if {${::SELF} == "dev_flash/vsh/resource/explore_plugin_full.rco" || ${::SELF} == "dev_flash/vsh/resource/xmb_ingame.rco"} {
		    ::auto_gen_cfw::callback_homebrew ${::CUSTOM_DEVFLASH_DIR}/${::SELF}_dir
		} elseif {${::SELF} == "dev_flash/vsh/resource/sysconf_plugin.rco"} {
		    ::auto_gen_cfw::callback_fwversion ${::CUSTOM_DEVFLASH_DIR}/${::SELF}_dir
		}
	}
    
    proc alpha_sort {path} {
        log "Patching Alphabetical Sort for Games in file [file tail $path]"
        sed_in_place [file join $path] -Game:Common.stat.rating-Game:Common.timeCreated+Game:Common.titleForSort-Game:Game.category -Game:Common.stat.rating-Game:Common.title+Game:Common.titleForSort-Game:Game.category
        sed_in_place [file join $path] -Game:Common.stat.rating+Game:Common.timeCreated+Game:Common.titleForSort-Game:Game.category -Game:Common.stat.rating+Game:Common.title+Game:Common.titleForSort-Game:Game.category
        sed_in_place [file join $path] -Game:Common.stat.rating-Game:Common.stat.timeLastUsed+Game:Common.titleForSort-Game:Common.timeCreated-Game:Game.category -Game:Common.stat.rating-Game:Common.stat.timeLastUsed+Game:Common.titleForSort-Game:Common.title-Game:Game.category
        sed_in_place [file join $path] -Game:Common.stat.rating+Game:Common.titleForSort-Game:Common.timeCreated-Game:Game.category -Game:Common.stat.rating+Game:Common.titleForSort-Game:Common.title-Game:Game.category
        sed_in_place [file join $path] -Game:Common.stat.rating+Game:Game.gameCategory-Game:Common.timeCreated+Game:Common.titleForSort -Game:Common.stat.rating+Game:Game.gameCategory-Game:Common.title+Game:Common.titleForSort
    }
    
    proc rape_sfo {path} {
	    set rapeo "cond=An+Game:Game.category"
		set rapen "cond=An+Game:Game.category X4+An+Game:Game.category X0+An+Game:Game.category"
		
        log "Patching Rape SFO in file [file tail $path]"
        sed_in_place [file join $path] $rapeo $rapen        
    }
    
    proc callback_homebrew {path} {		
        log "Patching English.xml into [file tail $path]"
        sed_in_place [file join $path English.xml] Network Homebrew
        
        log "Patching German.xml into [file tail $path]"
        sed_in_place [file join $path German.xml] Network Homebrew
        
        log "Patching Korean.xml into [file tail $path]"
        sed_in_place [file join $path Korean.xml] Network Homebrew
        
        log "Patching Russian.xml into [file tail $path]"
        sed_in_place [file join $path Russian.xml] Network Homebrew
        
        log "Patching Swedish.xml into [file tail $path]"
        sed_in_place [file join $path Swedish.xml] Network Homebrew
        
        log "Patching Spanish.xml into [file tail $path]"
        sed_in_place [file join $path Spanish.xml] Network Homebrew
        
        log "Patching Portugese.xml into [file tail $path]"
        sed_in_place [file join $path Portugese.xml] Network Homebrew
        
        log "Patching Norwegian.xml into [file tail $path]"
        sed_in_place [file join $path Norwegian.xml] Network Homebrew
        
        log "Patching Japanese.xml into [file tail $path]"
        sed_in_place [file join $path Japanese.xml] Network Homebrew
        
        log "Patching Italian.xml into [file tail $path]"
        sed_in_place [file join $path Italian.xml] Network Homebrew
        
        log "Patching French.xml into [file tail $path]"
        sed_in_place [file join $path French.xml] Network Homebrew
        
        log "Patching Finnish.xml into [file tail $path]"
        sed_in_place [file join $path Finnish.xml] Network Homebrew
        
        log "Patching Dutch.xml into [file tail $path]"
        sed_in_place [file join $path Dutch.xml] Network Homebrew
        
        log "Patching Danish.xml into [file tail $path]"
        sed_in_place [file join $path Danish.xml] Network Homebrew
        
        log "Patching ChineseTrad.xml into [file tail $path]"
        sed_in_place [file join $path ChineseTrad.xml] Network Homebrew
        
        log "Patching ChineseSimpl.xml into [file tail $path]"
        sed_in_place [file join $path ChineseSimpl.xml] Network Homebrew
		
		::auto_gen_cfw::callback_discless ${::CUSTOM_DEVFLASH_DIR}/${::SELF}_dir
    }
    
    proc callback_discless {path} {
        log "Patching English.xml into [file tail $path]"
        sed_in_place [file join $path English.xml] /app_home/PS3_GAME/ Discless
        
        log "Patching German.xml into [file tail $path]"
        sed_in_place [file join $path German.xml] /app_home/PS3_GAME/ Discless
        
        log "Patching Korean.xml into [file tail $path]"
        sed_in_place [file join $path Korean.xml] /app_home/PS3_GAME/ Discless
        
        log "Patching Russian.xml into [file tail $path]"
        sed_in_place [file join $path Russian.xml] /app_home/PS3_GAME/ Discless
        
        log "Patching Swedish.xml into [file tail $path]"
        sed_in_place [file join $path Swedish.xml] /app_home/PS3_GAME/ Discless
        
        log "Patching Spanish.xml into [file tail $path]"
        sed_in_place [file join $path Spanish.xml] /app_home/PS3_GAME/ Discless
        
        log "Patching Portugese.xml into [file tail $path]"
        sed_in_place [file join $path Portugese.xml] /app_home/PS3_GAME/ Discless
        
        log "Patching Norwegian.xml into [file tail $path]"
        sed_in_place [file join $path Norwegian.xml] /app_home/PS3_GAME/ Discless
        
        log "Patching Japanese.xml into [file tail $path]"
        sed_in_place [file join $path Japanese.xml] /app_home/PS3_GAME/ Discless
        
        log "Patching Italian.xml into [file tail $path]"
        sed_in_place [file join $path Italian.xml] /app_home/PS3_GAME/ Discless
        
        log "Patching French.xml into [file tail $path]"
        sed_in_place [file join $path French.xml] /app_home/PS3_GAME/ Discless
        
        log "Patching Finnish.xml into [file tail $path]"
        sed_in_place [file join $path Finnish.xml] /app_home/PS3_GAME/ Discless
        
        log "Patching Dutch.xml into [file tail $path]"
        sed_in_place [file join $path Dutch.xml] /app_home/PS3_GAME/ Discless
        
        log "Patching Danish.xml into [file tail $path]"
        sed_in_place [file join $path Danish.xml] /app_home/PS3_GAME/ Discless
        
        log "Patching ChineseTrad.xml into [file tail $path]"
        sed_in_place [file join $path ChineseTrad.xml] /app_home/PS3_GAME/ Discless
        
        log "Patching ChineseSimpl.xml into [file tail $path]"
        sed_in_place [file join $path ChineseSimpl.xml] /app_home/PS3_GAME/ Discless
    }
	
	proc callback_fwversion {path} {
        log "Patching English.xml into [file tail $path]"
        sed_in_place [file join $path English.xml] %1.1 %1.1${::fwVersion}
        
        log "Patching German.xml into [file tail $path]"
        sed_in_place [file join $path German.xml] %1.1 %1.1${::fwVersion}
        
        log "Patching Korean.xml into [file tail $path]"
        sed_in_place [file join $path Korean.xml] %1.1 %1.1${::fwVersion}
        
        log "Patching Russian.xml into [file tail $path]"
        sed_in_place [file join $path Russian.xml] %1.1 %1.1${::fwVersion}
        
        log "Patching Swedish.xml into [file tail $path]"
        sed_in_place [file join $path Swedish.xml] %1.1 %1.1${::fwVersion}
        
        log "Patching Spanish.xml into [file tail $path]"
        sed_in_place [file join $path Spanish.xml] %1.1 %1.1${::fwVersion}
        
        log "Patching Portugese.xml into [file tail $path]"
        sed_in_place [file join $path Portugese.xml] %1.1 %1.1${::fwVersion}
        
        log "Patching Norwegian.xml into [file tail $path]"
        sed_in_place [file join $path Norwegian.xml] %1.1 %1.1${::fwVersion}
        
        log "Patching Japanese.xml into [file tail $path]"
        sed_in_place [file join $path Japanese.xml] %1.1 %1.1${::fwVersion}
        
        log "Patching Italian.xml into [file tail $path]"
        sed_in_place [file join $path Italian.xml] %1.1 %1.1${::fwVersion}
        
        log "Patching French.xml into [file tail $path]"
        sed_in_place [file join $path French.xml] %1.1 %1.1${::fwVersion}
        
        log "Patching Finnish.xml into [file tail $path]"
        sed_in_place [file join $path Finnish.xml] %1.1 %1.1${::fwVersion}
        
        log "Patching Dutch.xml into [file tail $path]"
        sed_in_place [file join $path Dutch.xml] %1.1 %1.1${::fwVersion}
        
        log "Patching Danish.xml into [file tail $path]"
        sed_in_place [file join $path Danish.xml] %1.1 %1.1${::fwVersion}
        
        log "Patching ChineseTrad.xml into [file tail $path]"
        sed_in_place [file join $path ChineseTrad.xml] %1.1 %1.1${::fwVersion}
        
        log "Patching ChineseSimpl.xml into [file tail $path]"
        sed_in_place [file join $path ChineseSimpl.xml] %1.1 %1.1${::fwVersion}
    }
    
    proc change_welcome_string {path} {
        log "Changing Welcome string to Hombrew segment"       
        sed_in_place [file join $path category_network.xml] key="seg_browser"> key="seg_hbrew">
    }
    
    proc clean_net { file } {
        log "Modifying XML: [file tail ${file}]"
        log "Cleaning Homebrew category"
		set xml [::xml::LoadFile $file]
     
        set xml [::remove_node_from_xmb_xml $xml "seg_browser" "Internet Browser"]
        set xml [::remove_node_from_xmb_xml $xml "seg_folding_at_home" "Life with PlayStation "]
        set xml [::remove_node_from_xmb_xml $xml "seg_kensaku" "Internet Search"]
        set xml [::remove_node_from_xmb_xml $xml "seg_manual" "Online Instruction Manuals"]
        set xml [::remove_node_from_xmb_xml $xml "seg_premo" "Remote Play"]
        set xml [::remove_node_from_xmb_xml $xml "seg_dlctrl" "Download Controle"]
		
		::xml::SaveToFile $xml $file
		log "Saving XML"
    }
    
    proc read_cat { file } {
        log "Parsing XML: [file tail $file]"
        set xml [::xml::LoadFile $file]
        
        set ::query_manual [::xml::GetNodeByAttribute $xml "XMBML:View:Items:Query" key "seg_manual"]
        set ::view_manual [::xml::GetNodeByAttribute $xml "XMBML:View" id "seg_manual"]
        
        if {$::query_manual == "" || $::view_manual == "" } {
            die "Could not parse $file"
        }
        
        set ::query_premo [::xml::GetNodeByAttribute $xml "XMBML:View:Items:Query" key "seg_premo"]
        set ::view_premo [::xml::GetNodeByAttribute $xml "XMBML:View" id "seg_premo"]
        
        if {$::query_premo == "" || $::view_premo == "" } {
            die "Could not parse $file"
        }
        
        set ::query_browser [::xml::GetNodeByAttribute $xml "XMBML:View:Items:Query" key "seg_browser"]
        set ::view_browser [::xml::GetNodeByAttribute $xml "XMBML:View" id "seg_browser"]
        
        if {$::query_browser == "" || $::view_browser == "" } {
            die "Could not parse $file"
        }
        
        set ::query_kensaku [::xml::GetNodeByAttribute $xml "XMBML:View:Items:Query" key "seg_kensaku"]
        set ::view_kensaku [::xml::GetNodeByAttribute $xml "XMBML:View" id "seg_kensaku"]
        
        if {$::query_kensaku == "" || $::view_kensaku == "" } {
            die "Could not parse $file"
        }
        
        set ::query_dlctrl [::xml::GetNodeByAttribute $xml "XMBML:View:Items:Query" key "seg_dlctrl"]
        
        if {$::query_dlctrl == "" } {
            die "Could not parse $file"
        }
    }
    
    proc inject_cat { file } {
        log "Modifying XML: [file tail $file]"
        set xml [::xml::LoadFile $file]
        
        set xml [::xml::InsertNode $xml [::xml::GetNodeIndicesByAttribute $xml "XMBML:View:Items:Query" key ""] $::query_dlctrl]
     
        unset ::query_dlctrl
        
        set xml [::xml::InsertNode $xml [::xml::GetNodeIndicesByAttribute $xml "XMBML:View:Items:Query" key "" ] $::query_kensaku]
        set xml [::xml::InsertNode $xml {2 end 0} $::view_kensaku]
      
        unset ::query_kensaku
        unset ::view_kensaku
        
        set xml [::xml::InsertNode $xml [::xml::GetNodeIndicesByAttribute $xml "XMBML:View:Items:Query" key "" ] $::query_browser]
        set xml [::xml::InsertNode $xml {2 end 0} $::view_browser]
     
        unset ::query_browser
        unset ::view_browser
        
        set xml [::xml::InsertNode $xml [::xml::GetNodeIndicesByAttribute $xml "XMBML:View:Items:Query" key "" ] $::query_premo]
        set xml [::xml::InsertNode $xml {2 end 0} $::view_premo]
     
        unset ::query_premo
        unset ::view_premo
        
        set xml [::xml::InsertNode $xml [::xml::GetNodeIndicesByAttribute $xml "XMBML:View:Items:Query" key "" ] $::query_manual]
        set xml [::xml::InsertNode $xml {2 end 0} $::view_manual]
     
        unset ::query_manual
        unset ::view_manual
        
		log "Saving XML"
        ::xml::SaveToFile $xml $file
    }
    
    proc find_nodes { file } {
        log "Parsing XML: [file tail $file]"
        set xml [::xml::LoadFile $file]
        
        set ::query_emulator [::xml::GetNodeByAttribute $xml "XMBML:View:Items:Query" key "seg_emulator"]
        set ::view_emulator [::xml::GetNodeByAttribute $xml "XMBML:View" id "seg_emulator"]
        set ::view_emu [::xml::GetNodeByAttribute $xml "XMBML:View" id "seg_emu"]
     
        if {$::query_emulator == "" || $::view_emulator == "" || $::view_emu == "" } {
            die "Could not parse $file"
        }
     
        set ::query_hbrew [::xml::GetNodeByAttribute $xml "XMBML:View:Items:Query" key "seg_hbrew"]
        set ::view_hbrew [::xml::GetNodeByAttribute $xml "XMBML:View" id "seg_hbrew"]
        set ::view_brew [::xml::GetNodeByAttribute $xml "XMBML:View" id "seg_brew"]
      
        if {$::query_hbrew == "" || $::view_hbrew == "" || $::view_brew == "" } {
            die "Could not parse $file"
        }
     
        set ::query_package_manager [::xml::GetNodeByAttribute $xml "XMBML:View:Items:Query" key "seg_package_manager"]
        set ::view_package_manager [::xml::GetNodeByAttribute $xml "XMBML:View" id "seg_package_manager"]
        set ::view_pkg_files [::xml::GetNodeByAttribute $xml "XMBML:View" id "seg_pkg_files"]
        set ::view_pkg_fixed [::xml::GetNodeByAttribute $xml "XMBML:View" id "seg_pkg_fixed"]
        set ::view_install_pkg_fixed [::xml::GetNodeByAttribute $xml "XMBML:View" id "seg_install_pkg_fixed"]
        set ::view_delete_pkg_fixed [::xml::GetNodeByAttribute $xml "XMBML:View" id "seg_delete_pkg_fixed"]
        set ::view_pkg_install_fixed [::xml::GetNodeByAttribute $xml "XMBML:View" id "seg_pkg_install_fixed"]
        set ::view_pkg_install_flash [::xml::GetNodeByAttribute $xml "XMBML:View" id "seg_pkg_install_flash"]
        set ::view_pkg_install_hdd0 [::xml::GetNodeByAttribute $xml "XMBML:View" id "seg_pkg_install_hdd0"]
        set ::view_pkg_install_usb [::xml::GetNodeByAttribute $xml "XMBML:View" id "seg_pkg_install_usb"]
        set ::view_pkg_install_orig [::xml::GetNodeByAttribute $xml "XMBML:View" id "seg_pkg_install_orig"]
        set ::view_pkg_delete_fixed [::xml::GetNodeByAttribute $xml "XMBML:View" id "seg_pkg_delete_fixed"]
        set ::view_pkg_delete_hdd0 [::xml::GetNodeByAttribute $xml "XMBML:View" id "seg_pkg_delete_hdd0"]
        set ::view_pkg_delete_usb [::xml::GetNodeByAttribute $xml "XMBML:View" id "seg_pkg_delete_usb"]
        set ::view_pkg_delete_orig [::xml::GetNodeByAttribute $xml "XMBML:View" id "seg_pkg_delete_orig"]
        
        if {$::query_package_manager == "" || $::view_package_manager == "" || $::view_pkg_files == "" || $::view_pkg_fixed == "" || $::view_install_pkg_fixed == "" || $::view_delete_pkg_fixed == "" || $::view_pkg_install_fixed == "" || $::view_pkg_install_flash == "" || $::view_pkg_install_hdd0 == "" || $::view_pkg_install_usb == "" || $::view_pkg_install_orig == "" || $::view_pkg_delete_fixed == "" || $::view_pkg_delete_hdd0 == "" || $::view_pkg_delete_usb == "" || $::view_pkg_delete_orig == "" } {
            die "Could not parse $file"
        }
    }
    
    proc find_nodes1 { file } {
        log "Parsing XML: [file tail $file]"
        set xml [::xml::LoadFile $file]
        
        set ::query_gamedebug [::xml::GetNodeByAttribute $xml "XMBML:View:Items:Query" key "seg_gamedebug"]
        set ::view_gamedebug [::xml::GetNodeByAttribute $xml "XMBML:View" id "seg_gamedebug"]
     
        if {$::query_gamedebug == "" || $::view_gamedebug== "" } {
            die "Could not parse $file"
        }
    }
    
    proc inject_nodes { file } {
        log "Modifying XML: [file tail $file]"
        set xml [::xml::LoadFile $file]
        
        set xml [::xml::InsertNode $xml [::xml::GetNodeIndicesByAttribute $xml "XMBML:View:Items:Query" key "seg_gameexit"] $::query_emulator]
        set xml [::xml::InsertNode $xml {2 end 0} $::view_emulator]
        set xml [::xml::InsertNode $xml {2 end 0} $::view_emu]
     
        unset ::query_emulator
        unset ::view_emulator
        unset ::view_emu
     
        set xml [::xml::InsertNode $xml [::xml::GetNodeIndicesByAttribute $xml "XMBML:View:Items:Query" key "seg_gameexit"] $::query_hbrew]
        set xml [::xml::InsertNode $xml {2 end 0} $::view_hbrew]
        set xml [::xml::InsertNode $xml {2 end 0} $::view_brew]
     
        unset ::query_hbrew
        unset ::view_hbrew
        unset ::view_brew
        
        set xml [::xml::InsertNode $xml [::xml::GetNodeIndicesByAttribute $xml "XMBML:View:Items:Query" key "seg_gameexit"] $::query_package_manager]
        set xml [::xml::InsertNode $xml {2 end 0} $::view_package_manager]
        set xml [::xml::InsertNode $xml {2 end 0} $::view_pkg_files]
        set xml [::xml::InsertNode $xml {2 end 0} $::view_pkg_fixed]
        set xml [::xml::InsertNode $xml {2 end 0} $::view_install_pkg_fixed]
        set xml [::xml::InsertNode $xml {2 end 0} $::view_delete_pkg_fixed]
        set xml [::xml::InsertNode $xml {2 end 0} $::view_pkg_install_fixed]
        set xml [::xml::InsertNode $xml {2 end 0} $::view_pkg_install_flash]
        set xml [::xml::InsertNode $xml {2 end 0} $::view_pkg_install_hdd0]
        set xml [::xml::InsertNode $xml {2 end 0} $::view_pkg_install_usb]
        set xml [::xml::InsertNode $xml {2 end 0} $::view_pkg_install_orig]
        set xml [::xml::InsertNode $xml {2 end 0} $::view_pkg_delete_fixed]
        set xml [::xml::InsertNode $xml {2 end 0} $::view_pkg_delete_hdd0]
        set xml [::xml::InsertNode $xml {2 end 0} $::view_pkg_delete_usb]
        set xml [::xml::InsertNode $xml {2 end 0} $::view_pkg_delete_orig]
        
        unset ::query_package_manager
        unset ::view_package_manager
        unset ::view_pkg_files
        unset ::view_pkg_fixed
        unset ::view_install_pkg_fixed
        unset ::view_delete_pkg_fixed
        unset ::view_pkg_install_fixed
        unset ::view_pkg_install_flash
        unset ::view_pkg_install_hdd0
        unset ::view_pkg_install_usb
        unset ::view_pkg_install_orig
        unset ::view_pkg_delete_fixed
        unset ::view_pkg_delete_hdd0
        unset ::view_pkg_delete_usb
        unset ::view_pkg_delete_orig
		
		log "Saving XML"
        ::xml::SaveToFile $xml $file
        ::auto_gen_cfw::clean_net ${::CUSTOM_DEVFLASH_DIR}/${::SELF}
       
            
        ::auto_gen_cfw::change_welcome_string ${::CUSTOM_DEVFLASH_DIR}/dev_flash/vsh/resource/explore/xmb
    }
    
    proc inject_nodes2 { file } {
        log "Modifying XML: [file tail $file]"
        set xml [::xml::LoadFile $file]
     
        set xml [::xml::InsertNode $xml [::xml::GetNodeIndicesByAttribute $xml "XMBML:View:Items:Query" key "seg_gameexit"] $::query_gamedebug]
        set xml [::xml::InsertNode $xml {2 end 0} $::view_gamedebug]
     
        log "Saving XML"
        ::xml::SaveToFile $xml $file
    }

    proc patch_elf {elf} {
        log "Patching [file tail $elf]"
        
        if {${::SELF} == "lv1.self"} {
            log "Patching LV1 hypervisor to add peek/poke support (1189356)"
         
            set search    "\x38\x00\x00\x00\x64\x00\xff\xff\x60\x00\xff\xec\xf8\x03\x00\xc0"
	        append search "\x4e\x80\x00\x20\x38\x00\x00\x00"
            set replace   "\xe8\x83\x00\x18\xe8\x84\x00\x00\xf8\x83\x00\xc8"
         
            catch_die {::patch_elf $elf $search 4 $replace} \
            "Unable to patch self [file tail $elf]"
         
            set search    "\x4e\x80\x00\x20\x38\x00\x00\x00\x64\x00\xff\xff\x60\x00\xff\xec"
	        append search "\xf8\x03\x00\xc0\x4e\x80\x00\x20"
            set replace   "\xe8\xa3\x00\x20\xe8\x83\x00\x18\xf8\xa4\x00\x00"
         
            catch_die {::patch_elf $elf $search 8 $replace} \
            "Unable to patch self [file tail $elf]"
        }
        
        if {${::SUF} == ${::c} || ${::SUF} == ${::d}} {
            if {${::SELF} == "lv0"} {
                log "Patching Lv0 to disable CoreOS ECDSA check"
             
                set search  "\xE8\x61\x00\x70\x80\x81\x00\x7C\x48\x00\x09\xB1\xEB"
                set replace "\x60\x00\x00\x00"
             
                catch_die {::patch_elf $elf $search 8 $replace} \
                "Unable to patch self [file tail $elf]"
            }
            
            if {${::SELF} == "spu_pkg_rvk_verifier.self"} {
                log "Patching SPKG ECDSA verifier to disable ECDSA check"
                
                set search     "\x40\x80\x0A\x05\x34\x02\xC0\x80\x1C\x28\x00\x81\x3F\xE0\x02\x83"
                append search  "\x34\xFF\xC0\xD0\x34\xFF\x80\xD1\x34\xFF\x40\xD2\x35\x00\x00\x00"
                set replace    "\x40\x80\x00\x03"
              
                catch_die {::patch_elf $elf $search 12 $replace} \
                "Unable to patch self [file tail $elf]"
				
            }
            
            if {${::SELF} == "lv2_kernel.self"} {
                log "Patching LV2 peek&poke for 4.xx CFW"
             
                set search     "\x63\xFF\x00\x3E\x4B\xFF\xFF\x0C"
                set replace    "\x3F\xE0\x80\x01\x3B\xE0\x00\x00"
             
                catch_die {::patch_elf $elf $search 0 $replace} \
                "Unable to patch self [file tail $elf]"
              
                set search     "\x51\x7C\x7D\x1B\x78\x4B\xFF\xFF\x34\xF8\x21\xFF\x61\x7C\x08\x02\xA6"
                set replace    "\x48\x02\x62\xC4"
             
                catch_die {::patch_elf $elf $search 9 $replace} \
                "Unable to patch self [file tail $elf]"    
             
                set search     "\x41\x9E\xFF\xD4\x38\xDE"
                set replace    "\x60\x00\x00\x00"
             
                catch_die {::patch_elf $elf $search 0 $replace} \
                "Unable to patch self [file tail $elf]"
             
                log "Patching LV1 peek&poke call permission for LV2 into LV2"
             
                set search     "\x7C\x71\x43\xA6\x7C\x92\x43\xA6\x48\x00\x00\x00\x00\x00\x00\x00"
                append search  "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
                append search  "\x7C\x71\x43\xA6\x7C\x92\x43\xA6"
                set replace    "\xE8\x63\x00\x00\x4E\x80\x00\x20\xF8\x83\x00\x00\x4E\x80\x00\x20"
                append replace "\x7C\x08\x02\xA6\xF8\x01\x00\x10\x39\x60\x00\xB6\x44\x00\x00\x22"
                append replace "\x7C\x83\x23\x78\xE8\x01\x00\x10\x7C\x08\x03\xA6\x4E\x80\x00\x20"
                append replace "\x7C\x08\x02\xA6\xF8\x01\x00\x10\x39\x60\x00\xB7\x44\x00\x00\x22"
                append replace "\x38\x60\x00\x00\xE8\x01\x00\x10\x7C\x08\x03\xA6\x4E\x80\x00\x20"
                append replace "\x7C\x08\x02\xA6\xF8\x01\x00\x10\x7D\x4B\x53\x78\x44\x00\x00\x22"
                append replace "\xE8\x01\x00\x10\x7C\x08\x03\xA6\x4E\x80\x00\x20\x80\x00\x00\x00"
                append replace "\x00\x00\x17\x0C\x80\x00\x00\x00\x00\x00\x17\x14\x80\x00\x00\x00"
                append replace "\x00\x00\x17\x1C\x80\x00\x00\x00\x00\x00\x17\x3C\x80\x00\x00\x00"
                append replace "\x00\x00\x17\x5C"
             
                catch_die {::patch_elf $elf $search 2060 $replace} \
                "Unable to patch self [file tail $elf]"
                
                set search     "\x80\x00\x00\x00\x00\x2F\xEA\x40"
                set replace    "\x80\x00\x00\x00\x00\x00\x17\x78\x80\x00\x00\x00\x00\x00\x17\x80"
                append replace "\x80\x00\x00\x00\x00\x00\x17\x88\x80\x00\x00\x00\x00\x00\x17\x90"
                append replace "\x80\x00\x00\x00\x00\x00\x17\x98"
               
                catch_die {::patch_elf $elf $search 16 $replace} \
                "Unable to patch self [file tail $elf]"
             
                log "Patching LV2 with SysCall36 4.xx CFW"
              
                set search     "\x41\x9E\x00\xD8\x41\x9D\x00\xC0\x2F\x84\x00\x04\x40\x9C\x00\x48"
                set replace    "\x60\x00\x00\x00\x2F\x84\x00\x04\x48\x00\x00\x98"
              
                catch_die {::patch_elf $elf $search 4 $replace} \
                "Unable to patch self [file tail $elf]"
                
                set search     "\x41\x9E\x00\x70\xE8\x61\x01\x88"
                set replace    "\x60\x00\x00\x00"
              
                catch_die {::patch_elf $elf $search 0 $replace} \
                "Unable to patch self [file tail $elf]"
                
                set search     "\x4B\xFF\xF3\x31\x54\x63\x06\x3E\x2F\x83\x00\x00\x41\x9E\x00\x70"
                set replace    "\x60\x00\x00\x00"
             
                catch_die {::patch_elf $elf $search 12 $replace} \
                "Unable to patch self [file tail $elf]"
             
                log "Patching Hermes payload 4.xx into LV2"
             
                set search     "\x52\x52\x30\x20\x3A\x20\x30\x78"
                set replace    "\xF8\x21\xFF\x61\x7C\x08\x02\xA6\xFB\x81\x00\x80\xFB\xA1\x00\x88"
                append replace "\xFB\xE1\x00\x98\xFB\x41\x00\x70\xFB\x61\x00\x78\xF8\x01\x00\xB0"
                append replace "\x7C\x9C\x23\x78\x7C\x7D\x1B\x78\x3B\xE0\x00\x01\x7B\xFF\xF8\x06"
                append replace "\x67\xE4\x00\x2E\x60\x84\xA0\x0C\x38\xA0\x00\x02\x4B\xD6\x47\x71"
                append replace "\x28\x23\x00\x00\x40\x82\x00\x28\x67\xFF\x00\x2E\x63\xFF\xA0\x1C"
                append replace "\xE8\x7F\x00\x00\x28\x23\x00\x00\x41\x82\x00\x14\xE8\x7F\x00\x08"
                append replace "\x38\x9D\x00\x09\x4B\xD6\x46\xF5\xEB\xBF\x00\x00\x7F\xA3\xEB\x78"
                append replace "\x4B\xFD\x9C\xF4\x2F\x61\x70\x70\x5F\x68\x6F\x6D\x65\x00\x00\x00"
                append replace "\x00\x00\x00\x00\x80\x00\x00\x00\x00\x2E\xA0\x2C\x80\x00\x00\x00"
                append replace "\x00\x2E\xA0\x3A\x2F\x64\x65\x76\x5F\x66\x6C\x61\x73\x68\x2F\x6D"
                append replace "\x66\x77\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
             
                catch_die {::patch_elf $elf $search 0 $replace} \
                "Unable to patch self [file tail $elf]"
            }
            
            if {${::SELF} == "lv1.self"} {
                log "Patching LV1 hypervisior to remove LV2 protection"
             
                set search  "\x41\x9E\x00\x20\xE8\x62\x8A"
                set replace "\x48\x00"
             
                catch_die {::patch_elf $elf $search 0 $replace} \
                "Unable to patch self [file tail $elf]"
             
                log "Patching System Manager to disable integrity check (OtherOS++/downgrader) (2216116)"   
              
                set search  "\x38\x60\x00\x01\xf8\x01\x00\x90\x88\x1f\x00\x00\x2f\x80\x00\x00"
                set replace "\x60\x00\x00\x00"
              
                catch_die {::patch_elf $elf $search 20 $replace} \
                "Unable to patch self [file tail $elf]"
             
                log "Patch CoreOS Hash check. Product mode always on (downgrader) (2891684) 4.xx CFW"
                set search "\x41\x9E\x00\x1C\x7F\x63\xDB\x78\xE8\xA2\x85\x78"
                set replace "\x60\x00\x00\x00"
             
                catch_die {::patch_elf $elf $search 0 $replace} \
                "Unable to patch self [file tail $elf]"
            }
            
            if {${::SELF} == "dev_flash/vsh/module/vsh.self"} {
                log "Patching [file tail $elf] to allow unsigned act.dat & .rif files"
              
                set search "\x4B\xDC\x03\xA9"
                set replace "\x38\x60\x00\x00"
              
                catch_die {::patch_elf $elf $search 0 $replace} \
                "Unable to patch self [file tail $elf]"
             
                log "Patching [file tail $elf] to disable delating of unsigned act.dat & .rif files"
                set search "\x48\x3D\x55\x6D"
                set replace "\x38\x60\x00\x00"
             
                catch_die {::patch_elf $elf $search 0 $replace} \
                "Unable to patch self [file tail $elf]"
             
            }
			
			if {${::SELF} == "dev_flash/vsh/module/explore_category_game.sprx" || ${::SELF} == "dev_flash/vsh/module/explore_plugin.sprx"} {
			    log "Patching [file tail $elf] to enable Install Package Files in XMB"
              
                set search "\xF8\x21\xFE\xD1\x7C\x08\x02\xA6\xFB\x81\x01\x10\x3B\x81\x00\x70"
                set replace "\x38\x60\x00\x01\x4E\x80\x00\x20"
              
                catch_die {::patch_elf $elf $search 0 $replace} \
                "Unable to patch self [file tail $elf]"
			}
            
            if {${::CFW} == "AC1D"} {
                if {${::SELF} == "lv2_kernel.self"} {
                    log "Patching NPDRM ECDSA check disabled"
                 
                    set search     "\x41\x9E\xFD\x68\x4B\xFF\xFD\x68\xE9\x22\x99\x90\x7C\x08\x02\xA6"
                    set replace    "\x38\x60\x00\x00\x4E\x80\x00\x20"
                 
                    catch_die {::patch_elf $elf $search 8 $replace} \
                    "Unable to patch self [file tail $elf]"
                }
                
                if {${::SELF} == "netconf_plugin.sprx" || ${::SELF} == "sysconf_plugin.sprx"} {
                    log "Patching [file tail $elf] to disable communication with playstation.com"
                    
                    set search  "\x70\x6c\x61\x79\x73\x74\x61\x74\x69\x6f\x6e\x2e\x63\x6f\x6d"
                    set replace "\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x2e\x63\x6f\x6d"
                    
                    catch_die {::patch_file_multi $elf $search 0 $replace} \
                    "Unable to patch self [file tail $elf]"
                }
                
                if {${::SELF} == "libad_core.sprx" || ${::SELF} == "libmedi.sprx" || ${::SELF} == "libsysutil_np_clans.sprx" || ${::SELF} == "libsysutil_np_commerce2.sprx" || ${::SELF} == "libsysutil_np_util.sprx" || ${::SELF} == "autodownload_plugin.sprx" || ${::SELF} == "download_plugin.sprx" || ${::SELF} == "esehttp.sprx" || ${::SELF} == "eula_cddb_plugin.sprx" || ${::SELF} == "eula_hcopy_plugin.sprx" || ${::SELF} == "eula_net_plugin.sprx" || ${::SELF} == "explore_category_friend.sprx" || ${::SELF} == "explore_category_game.sprx" || ${::SELF} == "explore_category_music.sprx" || ${::SELF} == "explore_category_network.sprx" || ${::SELF} == "explore_category_photo.sprx" || ${::SELF} == "explore_category_psn.sprx" || ${::SELF} == "explore_category_sysconf.sprx" || ${::SELF} == "explore_category_tv.sprx" || ${::SELF} == "explore_category_user.sprx" || ${::SELF} == "explore_category_video.sprx" || ${::SELF} == "explore_plugin.sprx" || ${::SELF} == "explore_plugin_ft.sprx" || ${::SELF} == "explore_plugin_np.sprx" || ${::SELF} == "friendtrophy_plugin.sprx" || ${::SELF} == "game_ext_plugin.sprx" || ${::SELF} == "hknw_plugin.sprx" || ${::SELF} == "nas_plugin.sprx" || ${::SELF} == "newstore_plugin.sprx" || ${::SELF} == "np_eula_plugin.sprx" || ${::SELF} == "np_trophy_plugin.sprx" || ${::SELF} == "np_trophy_util.sprx" || ${::SELF} == "photo_network_sharing_plugin.sprx" || ${::SELF} == "profile_plugin.sprx" || ${::SELF} == "regcam_plugin.sprx" || ${::SELF} == "sysconf_plugin.sprx" || ${::SELF} == "videoeditor_plugin.sprx" || ${::SELF} == "videoplayer_plugin.sprx" || ${::SELF} == "videoplayer_util.sprx" || ${::SELF} == "vsh.self" || ${::SELF} == "x3_mdimp11.sprx" || ${::SELF} == "x3_mdimp7.sprx"} {
                    log "Patching [file tail $elf] to disable communication with playstation.net"
                    
                    set search  "\x70\x6c\x61\x79\x73\x74\x61\x74\x69\x6f\x6e\x2e\x6e\x65\x74"
                    set replace "\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x2e\x6e\x65\x74"
                 
                    catch_die {::patch_file_multi $elf $search 0 $replace} \
                    "Unable to patch self [file tail $elf]"
                 
                    set search  "\x70\x00\x6c\x00\x61\x00\x79\x00\x73\x00\x74\x00\x61\x00\x74\x00\x69\x00\x6f\x00\x6e\x00\x2e\x00\x6e\x00\x65\x00\x74"
                    set replace "\x61\x00\x61\x00\x61\x00\x61\x00\x61\x00\x61\x00\x61\x00\x61\x00\x61\x00\x61\x00\x61\x00\x2e\x00\x6e\x00\x65\x00\x74"
                 
                    catch_die {::patch_file_multi $elf $search 0 $replace} \
                    "Unable to patch self [file tail $elf]"
                }
                
                if {${::SELF} == "netconf_plugin.sprx" || ${::SELF} == "sysconf_plugin.sprx"} {
                    log "Patching [file tail $elf] to disable communication with playstation.org"
                    
                    set search  "\x70\x6c\x61\x79\x73\x74\x61\x74\x69\x6f\x6e\x2e\x6f\x72\x67"
                    set replace "\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x2e\x6f\x72\x67"
                 
                    catch_die {::patch_file_multi $elf $search 0 $replace} \
                    "Unable to patch self [file tail $elf]"
                }
                
                if {${::SELF} == "eula_net_plugin.sprx" || ${::SELF} == "mintx_client.sprx"} {
                    log "Patching [file tail $elf] to disable communication with sony.com"
                    
                    set search  "\x73\x6f\x6e\x79\x2e\x63\x6f\x6d"
                    set replace "\x61\x61\x61\x61\x2e\x63\x6f\x6d"
                 
                    catch_die {::patch_file_multi $elf $search 0 $replace} \
                    "Unable to patch self [file tail $elf]"
                }
                
                if {${::SELF} == ${::sny}} {
                    log "Patching [file tail $elf] to disable communication with sony.co.jp"
                    
                    set search  "\x73\x6f\x6e\x79\x2e\x63\x6f\x2e\x6a\x70"
                    set replace "\x61\x61\x61\x61\x2e\x63\x6f\x2e\x6a\x70"
                 
                    catch_die {::patch_file_multi $elf $search 0 $replace} \
                    "Unable to patch self [file tail $elf]"
                }
            }
        }
        
        if {${::SUF} == ${::a} || ${::SUF} == ${::b}} {
            if {${::SELF} == "lv2_kernel.self"} {
                log "Patching LV2 to allow Peek and Poke support (3.55)"
              
                set search    "\xEB\xA1\x00\x88\x38\x60\x00\x00\xEB\xC1\x00\x90\xEB\xE1\x00\x98"
                append search "\x7C\x08\x03\xA6\x7C\x63\x07\xB4\x38\x21\x00\xA0\x4E\x80\x00\x20"
                append search "\x3C\x60\x80\x01\x60\x63\x00\x03\x4E\x80\x00\x20\x3C\x60\x80\x01"
                append search "\x60\x63\x00\x03\x4E\x80\x00\x20"
                set replace   "\xE8\x63\x00\x00\x60\x00\x00\x00\x4E\x80\x00\x20\xF8\x83\x00\x00\x60\x00\x00\x00"
              
                catch_die {::patch_elf $elf $search 32 $replace} \
                "Unable to patch self [file tail $elf]"
             
                log "Patching LV2 to allow LV1 Peek and Poke support (3.55)"
             
                set search     "\x7C\x71\x43\xA6\x7C\x92\x43\xA6\x7C\xB3\x43\xA6\x48"
                set replace    "\x7C\x08\x02\xA6\xF8\x01\x00\x10\x39\x60\x00\xB6\x44\x00\x00\x22"
	            append replace "\x7C\x83\x23\x78\xE8\x01\x00\x10\x7C\x08\x03\xA6\x4E\x80\x00\x20"
	            append replace "\x7C\x08\x02\xA6\xF8\x01\x00\x10\x39\x60\x00\xB7\x44\x00\x00\x22"
	            append replace "\x38\x60\x00\x00\xE8\x01\x00\x10\x7C\x08\x03\xA6\x4E\x80\x00\x20"
             
                catch_die {::patch_elf $elf $search 5644 $replace} \
                "Unable to patch self [file tail $elf]"
              
                set search     "\xEB\xA1\x00\x88\x38\x60\x00\x00\xEB\xC1\x00\x90\xEB\xE1\x00\x98"
                append search  "\x7C\x08\x03\xA6\x7C\x63\x07\xB4\x38\x21\x00\xA0\x4E\x80\x00\x20"
                set replace    "\x4B\xFE\x83\xB8\x60\x00\x00\x00\x60\x00\x00\x00\x4B\xFE\x83\xCC"
	            append replace "\x60\x00\x00\x00\x60\x00\x00\x00"
             
                catch_die {::patch_elf $elf $search 56 $replace} \
                "Unable to patch self [file tail $elf]"
             
                log "Patching LV2 to allow LV1 Call support (3.55)"
              
                set search     "\x7C\x71\x43\xA6\x7C\x92\x43\xA6\x7C\xB3\x43\xA6\x48"
                set replace    "\x7C\x08\x02\xA6\xF8\x01\x00\x10\x7D\x4B\x53\x78\x44\x00\x00\x22"
	            append replace "\xE8\x01\x00\x10\x7C\x08\x03\xA6\x4E\x80\x00\x20"
             
                catch_die {::patch_elf $elf $search 5708 $replace} \
                "Unable to patch self [file tail $elf]"
             
                set search     "\xEB\xA1\x00\x88\x38\x60\x00\x00\xEB\xC1\x00\x90\xEB\xE1\x00\x98"
                append search  "\x7C\x08\x03\xA6\x7C\x63\x07\xB4\x38\x21\x00\xA0\x4E\x80\x00\x20"
                set replace    "\x4B\xFE\x83\xE0\x60\x00\x00\x00\x60\x00\x00\x00"
             
                catch_die {::patch_elf $elf $search 80 $replace} \
                "Unable to patch self [file tail $elf]"
            }
            
            if {${::SELF} == "lv1.self"} {
                log "Patching LV1 hypervisor to allow mapping of any memory area (1006151)"
             
                set search  "\x39\x08\x05\x48\x39\x20\x00\x00\x38\x60\x00\x00\x4b\xff\xfc\x45"
                set replace "\x01"
             
                catch_die {::patch_elf $elf $search 7 $replace} \
                "Unable to patch self [file tail $elf]"
             
                log "Patch CoreOS Hash check. Product mode always on (downgrader) (2891684)"
             
                set search "\x41\x9E\x00\x1C\x7F\x63\xDB\x78\xE8\xA2\x85\x68\x38\x80\x00\x01"
                set replace "\x60\x00\x00\x00"
             
                catch_die {::patch_elf $elf $search 0 $replace} \
                "Unable to patch self [file tail $elf]"
            }
         
            if {${::CFW} == "AC1D"} {
                if {${::SELF} == "lv2_kernel.self"} {
                    log "Patching Hermes payload 3.55 into LV2"
                 
                    set search     "\x4B\xFF\xFD\x04\xE8\x01\x00\x90\x60\x63\x00\x02\xEB\xC1\x00\x70"
                    set replace    "\x25\x64\x25\x73\x25\x30\x31\x36\x6C\x78\x25\x30\x31\x36\x6C\x6C"
                    append replace "\x78\x25\x30\x31\x36\x6C\x6C\x78\x25\x73\x25\x73\x25\x30\x38\x78"
                    append replace "\x25\x64\x25\x31\x64\x25\x31\x64\x25\x31\x64\x41\x41\x41\x0A\x00"
                    append replace "\xF8\x21\xFF\x31\x7C\x08\x02\xA6\xF8\x01\x00\xE0\xFB\xE1\x00\xC8"
                    append replace "\x38\x81\x00\x70\x4B\xEC\xF7\x85\x3B\xE0\x00\x01\x7B\xFF\xF8\x06"
                    append replace "\x67\xFF\x00\x2B\x63\xFF\xE5\x5C\xE8\x7F\x00\x00\x2C\x23\x00\x00"
                    append replace "\x41\x82\x00\x0C\x38\x80\x00\x27\x4B\xDA\x2A\xAD\x38\x80\x00\x27"
                    append replace "\x38\x60\x08\x00\x4B\xDA\x26\x65\xF8\x7F\x00\x00\xE8\x81\x00\x70"
                    append replace "\x4B\xD9\x01\x65\xE8\x61\x00\x70\x38\x80\x00\x27\x4B\xDA\x2A\x89"
                    append replace "\xE8\x7F\x00\x00\x4B\xD9\x01\x79\xE8\x9F\x00\x00\x7C\x64\x1A\x14"
                    append replace "\xF8\x7F\x00\x08\x38\x60\x00\x00\xEB\xE1\x00\xC8\xE8\x01\x00\xE0"
                    append replace "\x38\x21\x00\xD0\x7C\x08\x03\xA6\x4E\x80\x00\x20\x00\x00\x00\x00"
                    append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
                    append replace "\x80\x00\x00\x00\x00\x2B\xE4\xD0\x00\x00\x00\x00\x00\x00\x00\x00"
                    append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
                    append replace "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
                    append replace "\xF8\x21\xFF\x61\x7C\x08\x02\xA6\xFB\x81\x00\x80\xFB\xA1\x00\x88"
                    append replace "\xFB\xE1\x00\x98\xFB\x41\x00\x70\xFB\x61\x00\x78\xF8\x01\x00\xB0"
                    append replace "\x7C\x9C\x23\x78\x7C\x7D\x1B\x78\x3B\xE0\x00\x01\x7B\xFF\xF8\x06"
                    append replace "\x67\xE4\x00\x2B\x60\x84\xE6\x64\x38\xA0\x00\x09\x4B\xD9\x00\xFD"
                    append replace "\x28\x23\x00\x00\x40\x82\x00\x30\x67\xFF\x00\x2B\x63\xFF\xE5\x5C"
                    append replace "\xE8\x7F\x00\x00\x28\x23\x00\x00\x41\x82\x00\x14\xE8\x7F\x00\x08"
                    append replace "\x38\x9D\x00\x09\x4B\xD9\x00\x81\xEB\xBF\x00\x00\x7F\xA3\xEB\x78"
                    append replace "\x4B\xFF\x4C\x8C\x7F\xA3\xEB\x78\x3B\xE0\x00\x01\x7B\xFF\xF8\x06"
                    append replace "\x67\xE4\x00\x2B\x60\x84\xE6\x6E\x38\xA0\x00\x09\x4B\xD9\x00\xAD"
                    append replace "\x28\x23\x00\x00\x40\x82\x00\x28\x67\xFF\x00\x2B\x63\xFF\xE5\x5C"
                    append replace "\xE8\x7F\x00\x00\x28\x23\x00\x00\x41\x82\x00\x14\xE8\x7F\x00\x08"
                    append replace "\x38\x9D\x00\x09\x4B\xD9\x00\x31\xEB\xBF\x00\x00\x7F\xA3\xEB\x78"
                    append replace "\x4B\xFF\x4C\x3C\x2F\x64\x65\x76\x5F\x62\x64\x76\x64\x00\x2F\x61"
                    append replace "\x70\x70\x5F\x68\x6F\x6D\x65\x00"
                 
                    catch_die {::patch_elf $elf $search 0 $replace} \
                    "Unable to patch self [file tail $elf]"
                    
                    log "Patching Hermes payload pointer Syscall_Map_Open_Desc"    
                    set search     "\x"
                    set replace    "\x80\x00\x00\x00\x00\x2B\xE5\x70"
                 
                    catch_die {::patch_elf $elf $search 0 $replace} \
                    "Unable to patch self [file tail $elf]"
                 
                    log "Patching LV2 SysCall36 CFW 3.55"
                 
                    set search     "\x7C\x7F\x1B\x78\x41\xC2\x00\x58\x80\x1F\x00\x48\x2F\x80\x00\x02"
                    set replace    "\x60\x00\x00\x00\x80\x1F\x00\x48\x48\x00\x00\x98"
                 
                    catch_die {::patch_elf $elf $search 4 $replace} \
                    "Unable to patch self [file tail $elf]"
                  
                    set search     "\x7C\xF9\x3B\x78\x90\x1D\x00\x80\x90\x1D\x00\x84\xF9\x3D\x00\x90"
                    append search  "\x91\x3D\x00\x98\xF8\xDD\x00\xA0"
                    set replace    "\x60\x00\x00\x00\x90\x1D\x00\x80\x90\x1D\x00\x84\xF9\x3D\x00\x90"
                    append replace "\x91\x3D\x00\x98\x60\x00\x00\x00"
                 
                    catch_die {::patch_elf $elf $search 0 $replace} \
                    "Unable to patch self [file tail $elf]"
                }
				
				if {${::SELF} == "emer_init.self"} {
                    log "Patching [file tail $elf] to disable searching for update packages in GAME disc"
                  
                    set search  "\x80\x01\x00\x74\x2f\x80\x00\x00\x40\x9e\x00\x14\x7f\xa3\xeb\x78"
                    set replace "\x38\x00\x00\x01"
                 
                    catch_die {::patch_elf $elf $search 0 $replace} \
                    "Unable to patch self [file tail $elf]"
                }
            }  
        }
        
        if {${::SUF} == ${::b}} {
            if {${::SELF} == "vsh"} {
                log "Patching [file tail $elf] to allow unsigned act.dat & .rif files"
             
                set search "\x4B\xCF\x5B\x45"
                set replace "\x38\x60\x00\x00"
              
                catch_die {::patch_elf $elf $search 0 $replace} \
                "Unable to patch self [file tail $elf]"
             
                log "Patching [file tail $elf] to disable delating of unsigned act.dat & .rif files"
                set search "\x48\x31\xB4\x65"
                set replace "\x38\x60\x00\x00"
              
                catch_die {::patch_elf $elf $search 0 $replace} \
                "Unable to patch self [file tail $elf]"
            }          
        }
        
        if {${::SUF} == ${::a}} {
            if {${::SELF} == "vsh"} {
                log "Patching [file tail $elf] to allow unsigned act.dat & .rif files"
             
                set search "\x4B\xCF\xAF\xB1"
                set replace "\x38\x60\x00\x00"
              
                catch_die {::patch_elf $elf $search 0 $replace} \
                "Unable to patch self [file tail $elf]"
             
                log "Patching [file tail $elf] to disable delating of unsigned act.dat & .rif files"
                set search "\x48\x31\x43\xAD"
                set replace "\x38\x60\x00\x00"
             
                catch_die {::patch_elf $elf $search 0 $replace} \
                "Unable to patch self [file tail $elf]"
            }       
        }
     
        if {${::SUF} <= ${::c} && ${::SUF} >= ${::a}} {
            if {${::SELF} == "vsh.self"} {
                variable options
                set release [lindex ${::spoof} 0]
                set build [lindex ${::spoof} 1]
             
                log "Patching [file tail $elf] with new build/version number for PSN access"
             
                debug "Patching build number"
                set search "[format %0.5d [::get_pup_build]]"
                set replace "[format %0.5d $build]"
                catch_die {::patch_elf $elf $search 0 $replace} "Unable to patch self [file tail $elf] with [::hexify $replace]"
             
                debug "Patching version number"
                set search "99.99"
                set major [lindex [split $release "."] 0]
                set minor [lindex [split $release "."] 1]
                set replace "[format %0.2d ${major}].[format %0.2d ${minor}]\x00\x00\0x00\0x00"
                catch_die {::patch_elf $elf $search 8 $replace} "Unable to patch self [file tail $elf]"
		    }
        } 
    }
	
	proc get_fw_release {filename} {
        set results [grep "^release:" $filename]
        set release [string trim [regsub "^release:" $results {}] ":"]
        return [string trim $release]
    }

    proc get_fw_build {filename} {
        set results [grep "^build:" $filename]
        set build [string trim [regsub "^build:" $results {}] ":"]
        return [string trim $build]
    }

    proc get_fw_target {filename} {
        set results [grep "^target:" $filename]
        set target [regsub "^target:" $results {}]
        return [string trim $target]
    }

    proc get_fw_security {filename} {
        set results [grep "^security:" $filename]
        set security [string trim [regsub "^security:" $results {}] ":"]
        return [string trim $security]
    }

    proc get_fw_system {filename} {
        set results [grep "^system:" $filename]
        set system [string trim [regsub "^system:" $results {}] ":"]
        return [string trim $system]
    }

    proc get_fw_x3 {filename} {
        set results [grep "^x3:" $filename]
        set x3 [string trim [regsub "^x3:" $results {}] ":"]
        return [string trim $x3]
    }

    proc get_fw_paf {filename} {
        set results [grep "^paf:" $filename]
        set paf [string trim [regsub "^paf:" $results {}] ":"]
        return [string trim $paf]
    }

    proc get_fw_vsh {filename} {
        set results [grep "^vsh:" $filename]
        set vsh [string trim [regsub "^vsh:" $results {}] ":"]
        return [string trim $vsh]
    }

    proc get_fw_sys_jp {filename} {
        set results [grep "^sys_jp:" $filename]
        set sys_jp [string trim [regsub "^sys_jp:" $results {}] ":"]
        return [string trim $sys_jp]
    }

    proc get_fw_ps1emu {filename} {
        set results [grep "^ps1emu:" $filename]
        set ps1emu [string trim [regsub "^ps1emu:" $results {}] ":"]
        return [string trim $ps1emu]
    }

    proc get_fw_ps1netemu {filename} {
        set results [grep "^ps1netemu:" $filename]
        set ps1netemu [string trim [regsub "^ps1netemu:" $results {}] ":"]
        return [string trim $ps1netemu]
    }

    proc get_fw_ps1newemu {filename} {
        set results [grep "^ps1newemu:" $filename]
        set ps1newemu [string trim [regsub "^ps1newemu:" $results {}] ":"]
        return [string trim $ps1newemu]
    }

    proc get_fw_ps2emu {filename} {
        set results [grep "^ps2emu:" $filename]
        set ps2emu [string trim [regsub "^ps2emu:" $results {}] ":"]
        return [string trim $ps2emu]
    }

    proc get_fw_ps2gxemu {filename} {
        set results [grep "^ps2gxemu:" $filename]
        set ps2gxemu [string trim [regsub "^ps2gxemu:" $results {}] ":"]
        return [string trim $ps2gxemu]
    }

    proc get_fw_ps2softemu {filename} {
        set results [grep "^ps2softemu:" $filename]
        set ps2softemu [string trim [regsub "^ps2softemu:" $results {}] ":"]
        return [string trim $ps2softemu]
    }

    proc get_fw_pspemu {filename} {
        set results [grep "^pspemu:" $filename]
        set pspemu [string trim [regsub "^pspemu:" $results {}] ":"]
        return [string trim $pspemu]
    }

    proc get_fw_emerald {filename} {
        set results [grep "^emerald:" $filename]
        set emerald [string trim [regsub "^emerald:" $results {}] ":"]
        return [string trim $emerald]
    }

    proc get_fw_bdp {filename} {
        set results [grep "^bdp:" $filename]
        set bdp [string trim [regsub "^bdp:" $results {}] ":"]
        return [string trim $bdp]
    }

    proc get_fw_auth {filename} {
        set results [grep "^auth:" $filename]
        set auth [string trim [regsub "^auth:" $results {}] ":"]
        return [string trim $auth]
    }
	
	proc version_txt {filename} {
        set release [lindex ${::spoof} 0]
        set build [lindex ${::spoof} 1]
        set bdate [lindex ${::spoof} 2]
        set target [lindex ${::spoof} 3]
        set security [lindex ${::spoof} 4]
        set system [lindex ${::spoof} 5]
        set x3 [lindex ${::spoof} 6]
        set paf [lindex ${::spoof} 7]
        set vsh [lindex ${::spoof} 8]
        set sys_jp [lindex ${::spoof} 9]
        set ps1emu [lindex ${::spoof} 10]
        set ps1netemu [lindex ${::spoof} 11]
        set ps1newemu [lindex ${::spoof} 12]
        set ps2emu [lindex ${::spoof} 13]
        set ps2gxemu [lindex ${::spoof} 14]
        set ps2softemu [lindex ${::spoof} 15]
        set pspemu [lindex ${::spoof} 16]
        set emerald [lindex ${::spoof} 17]
        set bdp [lindex ${::spoof} 18]
        set auth [lindex ${::spoof} 1]
		set major [lindex [split $release "."] 0]
        set minor [lindex [split $release "."] 1]
        set nano "0"
        set fd [open $filename r]
        set data [read $fd]
        close $fd
       
        if {$release != [get_fw_release $filename]} {
            set major [lindex [split $release "."] 0]
            set minor [lindex [split $release "."] 1]
            set nano "0"
            debug "Setting release to release:[format %0.2d ${major}].[format %0.2d ${minor}][format %0.2d ${nano}]:"
            set data [regsub {release:[0-9]+\.[0-9]+:} $data "release:[format %0.2d ${major}].[format %0.2d ${minor}][format %0.2d ${nano}]:"]
        }
     
        if {$build != [get_fw_build $filename]} {
            set build_num $build
            set build_date $bdate
            debug "Setting build to build:${build_num},${build_date}:"
           set data [regsub {build:[0-9]+,[0-9]+:} $data "build:${build_num},${build_date}:"]
        }
     
        if {$target != [get_fw_target $filename]} {
            set target_num [lindex [split $target ":"] 0]
            set target_string [lindex [split $target ":"] 1]
            debug "Setting target to target:${target_num}:${target_string}"
            set data [regsub {target:[0-9]+:[A-Z]+-ww} $data "target:${target_num}:${target_string}"]
        }
     
        if {$security != [get_fw_security $filename]} {
            set security_string [lindex [split $security ":"] 0]
            debug "Setting security to security:${security_string}:"
            set data [regsub {security:(.*?):} $data "security:${security_string}:"]
        }
     
        if {$system != [get_fw_system $filename]} {
            set system_string [lindex [split $system ":"] 0]
            debug "Setting system to system:${system_string}:"
            set data [regsub {system:(.*?):} $data "system:${system_string}:"]
        }
     
        if {$x3 != [get_fw_x3 $filename]} {
            set x3_string [lindex [split $x3 ":"] 0]
            debug "Setting x3 to x3:${x3_string}:"
            set data [regsub {x3:(.*?):} $data "x3:${x3_string}:"]
        }
     
        if {$paf != [get_fw_paf $filename]} {
            set paf_string [lindex [split $paf ":"] 0]
            debug "Setting paf to paf:${paf_string}:"
            set data [regsub {paf:(.*?):} $data "paf:${paf_string}:"]
        }
     
        if {$vsh != [get_fw_vsh $filename]} {
            set vsh_string [lindex [split $vsh ":"] 0]
            debug "Setting vsh to vsh:${vsh_string}:"
            set data [regsub {vsh:(.*?):} $data "vsh:${vsh_string}:"]
        }
     
        if {$sys_jp != [get_fw_sys_jp $filename]} {
            set sys_jp_string [lindex [split $sys_jp ":"] 0]
            debug "Setting sys_jp to sys_jp:${sys_jp_string}:"
            set data [regsub {sys_jp:(.*?):} $data "sys_jp:${sys_jp_string}:"]
        }
     
        if {$ps1emu != [get_fw_ps1emu $filename]} {
            set ps1emu_string [lindex [split $ps1emu ":"] 0]
            debug "Setting ps1emu to ps1emu:${ps1emu_string}:"
            set data [regsub {ps1emu:(.*?):} $data "ps1emu:${ps1emu_string}:"]
        }
     
        if {$ps1netemu != [get_fw_ps1netemu $filename]} {
            set ps1netemu_string [lindex [split $ps1netemu ":"] 0]
            debug "Setting ps1netemu to ps1netemu:${ps1netemu_string}:"
            set data [regsub {ps1netemu:(.*?):} $data "ps1netemu:${ps1netemu_string}:"]
        }
     
        if {$ps1newemu != [get_fw_ps1newemu $filename]} {
            set ps1newemu_string [lindex [split $ps1newemu ":"] 0]
            debug "Setting ps1newemu to ps1newemu:${ps1newemu_string}:"
            set data [regsub {ps1newemu:(.*?):} $data "ps1newemu:${ps1newemu_string}:"]
        }
     
        if {$ps2emu != [get_fw_ps2emu $filename]} {
            set ps2emu_string [lindex [split $ps2emu ":"] 0]
            debug "Setting ps2emu to ps2emu:${ps2emu_string}:"
            set data [regsub {ps2emu:(.*?):} $data "ps2emu:${ps2emu_string}:"]
        }
     
        if {$ps2gxemu != [get_fw_ps2gxemu $filename]} {
            set ps2gxemu_string [lindex [split $ps2gxemu ":"] 0]
            debug "Setting ps2gxemu to ps2gxemu:${ps2gxemu_string}:"
            set data [regsub {ps2gxemu:(.*?):} $data "ps2gxemu:${ps2gxemu_string}:"]
        }
     
        if {$ps2softemu != [get_fw_ps2softemu $filename]} {
            set ps2softemu_string [lindex [split $ps2softemu ":"] 0]
            debug "Setting ps2softemu to ps2softemu:${ps2softemu_string}:"
            set data [regsub {ps2softemu:(.*?):} $data "ps2softemu:${ps2softemu_string}:"]
        }
     
        if {$pspemu != [get_fw_pspemu $filename]} {
            set pspemu_string [lindex [split $pspemu ":"] 0]
            debug "Setting pspemu to pspemu:${pspemu_string}:"
            set data [regsub {pspemu:(.*?):} $data "pspemu:${pspemu_string}:"]
        }
     
        if {$emerald != [get_fw_emerald $filename]} {
            set emerald_string [lindex [split $emerald ":"] 0]
            debug "Setting emeral to emerald:${emerald_string}:"
            set data [regsub {emerald:(.*?):} $data "emerald:${emerald_string}:"]
        }
     
        if {$bdp != [get_fw_bdp $filename]} {
            set bdp_string [lindex [split $bdp ":"] 0]
            debug "Setting bdp to bdp:${bdp_string}:"
            set data [regsub {bdp:(.*?):} $data "bdp:${bdp_string}:"]
        }
     
        if {$auth != [get_fw_auth $filename]} {
            debug "Setting auth to auth:$auth:"
            set data [regsub {auth:[0-9]+:} $data "auth:$auth:"]
        }
     
        set fd [open $filename w]
        puts -nonewline $fd $data
        close $fd
     
        set index_dat [file join [file dirname $filename] index.dat]
        shell "dat" [file nativename $filename] [file nativename $index_dat]
		debug "Test !! release is set to $release"
    }

    proc upl_xml {filename} {
	    set release [lindex ${::spoof} 0]
        set build [lindex ${::spoof} 1]
        set bdate [lindex ${::spoof} 2]
        set target [lindex ${::spoof} 3]
        set security [lindex ${::spoof} 4]
        set system [lindex ${::spoof} 5]
        set x3 [lindex ${::spoof} 6]
        set paf [lindex ${::spoof} 7]
        set vsh [lindex ${::spoof} 8]
        set sys_jp [lindex ${::spoof} 9]
        set ps1emu [lindex ${::spoof} 10]
        set ps1netemu [lindex ${::spoof} 11]
        set ps1newemu [lindex ${::spoof} 12]
        set ps2emu [lindex ${::spoof} 13]
        set ps2gxemu [lindex ${::spoof} 14]
        set ps2softemu [lindex ${::spoof} 15]
        set pspemu [lindex ${::spoof} 16]
        set emerald [lindex ${::spoof} 17]
        set bdp [lindex ${::spoof} 18]
        set auth [lindex ${::spoof} 1]
		set major [lindex [split $release "."] 0]
        set minor [lindex [split $release "."] 1]
        set nano "0"
	 
	    debug "Test !! release is set to $release"
        debug "Setting UPL.xml.pkg :: release to ${::release} :: build to ${::build},${::bdate}"
     
        set search [::get_header_key_upl_xml $filename Version Version]
        set replace "[format %0.2d ${major}].[format %0.2d ${minor}][format %0.2d ${nano}]:"
        if { $search != "" && $search != $replace } {
            set xml [::set_header_key_upl_xml $filename Version "${replace}" Version]
            if { $xml == "" } {
                die "spoof failed:: search: $search :: replace: $replace"
            }
        }
     
        set search [::get_header_key_upl_xml $filename Build Build]
        set replace "${build},${bdate}"
        if { $search != "" && $search != $replace } {
            set xml [::set_header_key_upl_xml $filename Build "${replace}" Build]
            if { $xml == "" } {
                die "spoof failed:: search: $search :: replace: $replace"
            }
        }
        ::set_pup_build [incr build]
    }
    
	# checks CFW model and pup version and put it into a var
    proc check_version { } {
	    debug "Checking CFW Model"
        if {!$::auto_gen_cfw::options(--auto-gen-ac1d) && $::auto_gen_cfw::options(--auto-gen-rogero)} {
            set ::CFW "Rogero"
			debug "Setting CFW Model OK! var = ${::CFW}"
        }        
        if {$::auto_gen_cfw::options(--auto-gen-ac1d) && !$::auto_gen_cfw::options(--auto-gen-rogero)} {
            set ::CFW "AC1D"
			debug "Setting CFW Model OK! var = ${::CFW}"
        }       
        if {$::auto_gen_cfw::options(--auto-gen-ac1d) && $::auto_gen_cfw::options(--auto-gen-rogero)} {
            log "Warning! You enabled more then one CFW to auto generate"
            log "Warning! This is not allowed. Please select only one CFW to auto generate"
        }
		debug "checking pup version"
		set ::SUF [::get_pup_version]
		debug "Getting pup version OK! var = ${::SUF}"
    }
	
	# checks all tasks if no other one are selected
	proc check_task { } {
	    set ida [::get_selected_tasks]
        foreach task  {$ida} {
            if {$task == "add_license_msg" || $task == "change_coreos_file" || $task == "change_devflash_file" || $task == "clean_friends" || $task == "clean_game" || $task == "clean_music" || $task == "clean_network" || $task == "clean_photo" || $task == "clean_psn" || $task == "clean_sysconf" || $task == "clean_tv" || $task == "clean_video" || $task == "customize_firmware" || $task == "patch_cos" || $task == "patch_lv1" || $task == "patch_privacy" || $task == "patch_pup" || $task == "patch_vsh" || $task == "patch_xmb" || $task == "patch_xmb_plugin"} {
                return "false"
            } else {
			    return "true"
		    }
		}
    }
    
    proc callback_files { file } {
        if {[file exists $file] != 0} {
            return "true"
        } else {
            return "false"
        }
    }
    
    proc copy_customized_file { dst src } {
        log "Replacing default firmware file [file tail $dst] with [file tail $src]"
        copy_file -force $src $dst
    }
	
	# fix for network cat, sony left a unclosed brace which will "modify_xml" command cause a error
	proc remove_line_from_network_cat {file} {
	    set src $file
	    set tmpname ${src}.work
     
        set source [open $file]
        set destination [open $tmpname w]
        set content [read $source]
        close $source
        set lines [split $content \n]
        set lines_after_deletion [lreplace $lines 47 47]
        puts -nonewline $destination [join $lines_after_deletion \n]
        close $destination
        file rename -force $tmpname $file
	}
}