
#include <stdio.h>
#include <stdlib.h>

static void hash(unsigned long long n1, unsigned long long n2,
    unsigned long long n3, unsigned long long n4, unsigned long *h1, unsigned long *h2);

/*
 * main
 */
int main(int argc, char **argv)
{
    unsigned long long n1, n2, n3, n4;
	unsigned long h1, h2;

    n1 = 0;
    n2 = 0;
    n3 = 0;
    n4 = 0;

    if (argc > 1)
        n1 = strtoull(argv[1], NULL, 0);

    if (argc > 2)
        n2 = strtoull(argv[2], NULL, 0);

    if (argc > 3)
        n3 = strtoull(argv[3], NULL, 0);

    if (argc > 4)
        n4 = strtoull(argv[4], NULL, 0);

    printf("0x%llx 0x%llx 0x%llx 0x%llx\n", n1, n2, n3, n4);

    hash(n1, n2, n3, n4, &h1, &h2);

    printf("0x%08x 0x%08x", h1, h2);

	exit(0);
}

/*
 * hash
 */
static void hash(unsigned long long n1, unsigned long long n2,
    unsigned long long n3, unsigned long long n4, unsigned long *h1, unsigned long *h2)
{
    unsigned long long h;
	unsigned long hl;

    h = ((((n1 ^ n4) >> 32) ^ (n2 ^ n3)) ^ (((n2 ^ n3) >> 32) ^ (n1 ^ n4))) & ~0xC0000000ULL;

    *h1 = h & 0xFFFFFFFFULL;

	/*
	printf("h=0x%llx\n", h);
	*/

	h = ((h & 0x55555555ULL) << 1) | ((h & 0xAAAAAAAAULL) >> 1);

	h = ((h & 0x33333333ULL) << 2) | ((h & 0xCCCCCCCCULL) >> 2);

	h = ((h & 0xF0F0F0FULL) << 4) | ((h & 0xF0F0F0F0ULL) >> 4);

	hl = (h << 8) | ((h & 0xFF000000ULL) >> 24);

	hl = (hl & ~0xFF000000UL) | ((h & 0xFFULL) << 24);

	hl = (hl & ~0x0000FF00UL) | (((h << 24) | (h >> 8)) & 0x0000FF00ULL);

	hl |= 0x1; 

	*h2 = hl;
}
