
#include <stdio.h>
#include <stdlib.h>

static void dump_repo_node(unsigned char *repo_node);

static void dump_repo_node_field(unsigned char *field);

static void usage(char *progname);

static unsigned char vtable_addr[8] =
{
	0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0x7f, 0x58,
};

/*
 * main
 */
int main(int argc, char **argv)
{
	unsigned char addr[8], repo_node[78];
	FILE *fp;
	long size;
	int nodes;

	if (argc != 2)
		usage(argv[0]);

	fp = fopen(argv[1], "r");
	if (fp == NULL)
	{
		fprintf(stderr, "couldn't open file: '%s'\n", argv[1]);
		exit(1);
	}

	fseek(fp, 0, SEEK_END);
    size = ftell(fp);

	fseek(fp, 0, SEEK_SET);

	nodes = 0;

	while (1)
	{
		if (fread(addr, 1, 8, fp) != 8)
			break;

		if (memcmp(vtable_addr, addr, 8) != 0)
			continue;

		if (fread(repo_node, 1, 0x70, fp) != 0x70)
			break;

		dump_repo_node(repo_node);

		printf("\n\n");

		nodes++;
	}

	fclose(fp);

	printf("total number of nodes = %d\n", nodes);

	exit(0);
}

/*
 * dump_repo_node
 */
static void dump_repo_node(unsigned char *repo_node)
{
	dump_repo_node_field(repo_node + 0x38);
	dump_repo_node_field(repo_node + 0x40);
	dump_repo_node_field(repo_node + 0x48);
	dump_repo_node_field(repo_node + 0x50);
	dump_repo_node_field(repo_node + 0x60);
	dump_repo_node_field(repo_node + 0x68);
}

/*
 * dump_repo_node_field
 */
static void dump_repo_node_field(unsigned char *field)
{
	int i;
	char s[8];

	for (i = 0; i < 8; i++)
		s[i] = (field[i] >= 32 && field[i] <= 126) ? field[i] : '.';

	printf("%s", s);

	for (i = 0; i < 8; i++)
		printf(" %02x", field[i]);

	printf("\n");
}

/*
 * usage
 */
static void usage(char *progname)
{
	fprintf(stderr, "usage: %s <HV dump>\n");
	exit(1);
}
