#include "common.h"
#include "peek_poke.h"
#include "hvcall.h"
#include "mm.h"

#include <psl1ght/lv2.h>
#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <assert.h>
#include <unistd.h>
#include <sysutil/video.h>
#include <rsx/gcm.h>
#include <rsx/reality.h>
#include <io/pad.h>
#include <sys/stat.h>
#include <dirent.h>

#include "sconsole.h"

FILE * debug_log_file;
FILE * hv_log_file;
int debug_me=1;
u64 mmap_lpar_addr = 0;
int debug_sock = -1;
char debug_buffer[100];
char hv_buffer[10][100];
char debug_msgs[10][100];
uint64_t lv2start = 0x8000000000000000ULL;
uint64_t lv2end = 0x8000000000800000ULL;

#define PATCH_FLAG_EXEC		1
#define PATCH_FLAG_BACKUP	2
#define PATCH_FLAG_DEREF	4
#define PATCH_FLAG_LV1		8
#define MAX_PATCH_FILES	10
#define RAM_SIZE		(256*1024*1024)

#define NUM_SPE			8
#define SPE_START_ADDR		0x20000000000ull
#define SPE_MMIO_SIZE		(NUM_SPE * 0x80000ull + NUM_SPE * 0x2000ull)



void debug_log(char txt[])
{
	int i;

	for(i=0;i<9;i++)
		strcpy(debug_msgs[i],debug_msgs[i+1]);

	snprintf(debug_msgs[9], 100, txt);

	if(debug_log_file && debug_me)
		fprintf(debug_log_file, "%s\r\n", txt);
}

u64 get_dbg_con_buffer()
{
	if(lv1_peek(0x647fb0) == 0x655040ULL) //fat
		return 0x655040ULL;
	else if(lv1_peek(0x66FF60) == 0x66EF00ULL) //slim
		return 0x66EF00ULL;
	else
		return 0;
}


int is_buffer_end(u64 val)
{
	int i;
	u64 tmp;

	for(i=0;i<64;i+=8)
	{
		tmp=((val & (0xFFULL << i)) >> i);
		if(tmp==0 || tmp>0xD0)
			return (i / 8);
	}
	return -1;
}

int dump_hv_debug_console_buffer(u64 offset, FILE * fp)
{
	int end=0, i=0, sz=0;
	u64 val;

	while(i<0x1000 && !end)
	{	
		val = lv1_peek(offset + i);
		__asm__("sync");
		sz = is_buffer_end(val);
		if(sz<0)
		{
			fwrite(&val,sizeof(u64),1,fp);
		}else{
			fwrite(&val,(7-sz),1,fp);
			end++;
		}

		i+=8;
	}
	return (i- sz - 1);
}

int map_ram(u64 start_addr, u64 size)
{
	int result;

	if (!mmap_lpar_addr)
	{
		result =
		    lv1_undocumented_function_114(start_addr, 0xc, size, &mmap_lpar_addr);
		if (result != 0) {
			//snprintf(debug_buffer,100,"Error code %d calling lv1_undocumented_function_114\n", result);
			//debug_log(debug_buffer);
			return 0;
		}
	}
	usleep(100);

	result =
	    mm_map_lpar_memory_region(mmap_lpar_addr, HV_BASE, size, 0xc, 0);
	if (result)
	{
		lv1_undocumented_function_115(mmap_lpar_addr);
		mmap_lpar_addr = 0;
		return 0;
	}
	return 1;
}

void unmap_ram()
{
	if (mmap_lpar_addr != 0)
	{
		lv1_undocumented_function_115(mmap_lpar_addr);
		mmap_lpar_addr = 0;
	}
}

void patch_lv2_protection()
{
	// changes protected area of lv2 to first byte only
	lv1_poke(0x363a78, 0x0000000000000001ULL);
	lv1_poke(0x363a80, 0xe0d251b556c59f05ULL);
	lv1_poke(0x363a88, 0xc232fcad552c80d7ULL);
	lv1_poke(0x363a90, 0x65140cd200000000ULL);

}

typedef struct {
	int height;
	int width;
	uint32_t *ptr;
	// Internal stuff
	uint32_t offset;
} buffer;

gcmContextData *context;
VideoResolution res;
int currentBuffer = 0;
buffer *buffers[2];

void waitFlip()
{
	// Block the PPU thread untill the previous flip operation has finished.
	while (gcmGetFlipStatus() != 0)
		usleep(200);
	gcmResetFlipStatus();
}

void flip(s32 buffer)
{
	assert(gcmSetFlip(context, buffer) == 0);
	realityFlushBuffer(context);
	gcmSetWaitFlip(context);
}

void makeBuffer(int id, int size)
{
	buffer *buf = malloc(sizeof(buffer));
	buf->ptr = rsxMemAlign(16, size);
	assert(buf->ptr != NULL);

	assert(realityAddressToOffset(buf->ptr, &buf->offset) == 0);
	assert(gcmSetDisplayBuffer
	       (id, buf->offset, res.width * 4, res.width, res.height) == 0);

	buf->width = res.width;
	buf->height = res.height;
	buffers[id] = buf;
}

void init_screen()
{
	void *host_addr = memalign(1024 * 1024, 1024 * 1024);
	assert(host_addr != NULL);

	context = realityInit(0x10000, 1024 * 1024, host_addr);
	assert(context != NULL);

	VideoState state;
	assert(videoGetState(0, 0, &state) == 0);
	assert(state.state == 0);

	assert(videoGetResolution(state.displayMode.resolution, &res) == 0);

	VideoConfiguration vconfig;
	memset(&vconfig, 0, sizeof(VideoConfiguration));
	vconfig.resolution = state.displayMode.resolution;
	vconfig.format = VIDEO_BUFFER_FORMAT_XRGB;
	vconfig.pitch = res.width * 4;

	assert(videoConfigure(0, &vconfig, NULL, 0) == 0);
	assert(videoGetState(0, 0, &state) == 0);

	s32 buffer_size = 4 * res.width * res.height;

	gcmSetFlipMode(GCM_FLIP_VSYNC);
	makeBuffer(0, buffer_size);
	makeBuffer(1, buffer_size);

	gcmResetFlipStatus();
	flip(1);
}

int patch_HV(int patch_num)
{

		//PRINTF("patching lv2 mem protection\n");
		//patch_lv2_protection();
		//remove_new_poke();

		uint64_t val = 0;

		//-------------------- HV proc 9
			
		// enable printk 9
		if(patch_num<2)
		{
			val = lv1_peek(0x75b4b0);
			lv1_poke(0x75b4b0, 0x0000000100000001ULL);
		}


		//com lib debug
		if(patch_num==0)
		{
			lv1_poke(0x75b560, 0x0000000000000003ULL);
			val = lv1_peek(0x75b560);
			lv1_poke(0x75b558, ((val & 0xFFFFFFFF00FFFFFFULL) | 0x01000000));
		}

		// storage debug
		if(patch_num==1)
		{
			val = lv1_peek(0x75b2c0);
			lv1_poke(0x75b2c0, ((0xFFFFFFFF & val) | 0x0000000300000000ULL));
		}

		//-------------------- HV proc 6

		// enable printk 6
		if(patch_num==2||patch_num==3)
			lv1_poke(0x0075b4b8, 0x0000000100000001ULL);

		// Setting ss.sb_mngr.debug.level

		if(patch_num==2)
		{
			val = lv1_peek(0x0075b478);
			lv1_poke(0x0075b478, ( (val & 0xFFFFFFFF) | 0x0000000100000000ULL));
			lv1_poke(0x0075b480, 0x0000000000000003ULL);
		}

		//update manager
		if(patch_num==3)
		{
			val = lv1_peek(0x0075b1e8);
			lv1_poke(0x0075b1e8, ( (val & 0xFFFFFFFF) | 0x0000000300000000ULL));
		}

		//-------------------- HV proc 5
		
		// enable printk 5
		if(patch_num==4)
		{
			lv1_poke(0xe0e70, 0x0000000100000001ULL);
			lv1_poke(0xe0e78, 0x0000000100000001ULL);
		}

		// enable SYSCON debug
		if(patch_num==4)
		{
			lv1_poke(0xe0e38, 0x0000000000000003ULL);
			val = lv1_peek(0xe0e30);
			lv1_poke(0xe0e30, ((0xFFFFFFFF & val) | 0x0000000100000000ULL));
		}

		//-------------------- HV proc 3

		// enable printk 3
		if(patch_num==5)
		{
			lv1_poke(0x8d940, 0x0000000100000001ULL);

			// enable Dispatch Manager debug
			lv1_poke(0x8d8c0, 0x0000000000000003ULL);
			val = lv1_peek(0x8d8b8);
			lv1_poke(0x8d8b8, ((0x00FFFFFFFFFFFFFFULL & val) | 0x0100000000000000ULL));
		}

		// enable VTRM debug
		if(patch_num==6)
		{
			lv1_poke(0x75b3d8, 0x0000000000000003ULL);
			val = lv1_peek(0x75b3d0);
			lv1_poke(0x75b3d0, ((0x00FFFFFFFFFFFFFFULL & val) | 0x0100000000000000ULL));
		}

		// patch DM policies
		if(patch_num==7)
		{
			val = lv1_peek(0x16f3b8);
			lv1_poke(0x16f3b8, ((0xFFFFFFFF00000000ULL & val) | 0x0000000060000000ULL));

			val = lv1_peek(0x16f458);
			lv1_poke(0x16f458, ((0xFFFFFFFFULL & val) | 0x3be0000100000000ULL));
			
			val = lv1_peek(0x16f460);
			lv1_poke(0x16f460, ((0xFFFFFFFFULL & val) | 0x3860000000000000ULL));

			val = lv1_peek(0x16f3e0);
			lv1_poke(0x16f3e0, ((0xFFFFFFFF00000000ULL & val) | 0x0000000038600001ULL));

		}
	return 1;
}




s32 main(s32 argc, const char *argv[])
{

	char patches[8][40] = {"Com Lib debug","Storage Manager debug","SB Manager debug","Update Manager debug","SYSCON debug","Dispatch Manager debug","VTRM debug","patch Dispatch Manager policies"};
	int is_patched[8] = {0,0,0,0,0,0,0,0};
	PadInfo padinfo;
	PadData paddata;

	int run=1;
	int n_patches=8;
	int current_patch_idx=0;
	int i,j;
	u64 dj,val, hv_debug_buffer_offset=0;
	FILE * df;

	init_screen();
	ioPadInit(7);

	// write log to usb0 if present
	
	debug_log_file = fopen("/dev_usb000/HVDebug.log", "w");
	hv_log_file = fopen("/dev_usb000/hv_debug_console.log", "w+");

	// map hv
	if(!map_ram(0, HV_SIZE))
	{
		usleep(1000);
		if(!map_ram(0, HV_SIZE))
		{
			debug_log("failed to map lv1");
			df = fopen("/dev_hdd0/lv2.bin", "wb");
			for(dj=lv2start;dj<lv2end;dj+=8)
			{
				val = lv2_peek(dj);
				fwrite(&val,sizeof(u64),1,df);
			}
			debug_log("lv2 dump successful");
			fclose(df);
			exit(0);
		}
	}

	patch_lv2_protection();


	/*
	   Init the console: arguments (background color, font color, framebuffer, screen width, screen height)
	   sconsoleInit(int bgColor, int fgColor, int screenWidth, int screenHeight)
	 */
	sconsoleInit(FONT_COLOR_BLACK, FONT_COLOR_GREEN, res.width, res.height);
	char ts[1000];


	while (run) {
		ioPadGetInfo(&padinfo);
		for (i = 0; i < MAX_PADS; i++) {
			if (padinfo.status[i]) {
				ioPadGetData(i, &paddata);
				if (paddata.BTN_CROSS)
				{
					if ((current_patch_idx < n_patches) && (!is_patched[current_patch_idx]))
						is_patched[current_patch_idx]=patch_HV(current_patch_idx);
				}
				else if (paddata.BTN_CIRCLE)
				{
					run=0;
				}
				else if (paddata.BTN_SQUARE)
				{
					//TODO: detect ps3 type and use correct offset

					hv_debug_buffer_offset = get_dbg_con_buffer();
					if(hv_debug_buffer_offset)
					{
						val = dump_hv_debug_console_buffer(hv_debug_buffer_offset, hv_log_file);
						snprintf(debug_buffer,100,"read %ld bytes from hv debug console buffer", val);
						debug_log(debug_buffer);
					}else{
						debug_log("debug buffer not found: unsupported ps3 model");
					}
				}
				else if (paddata.BTN_TRIANGLE)
				{
					df = fopen("/dev_hdd0/hv.bin", "wb");
					for(dj=0;dj<HV_SIZE;dj+=8)
					{
						val = lv1_peek(dj);
						fwrite(&val,sizeof(u64),1,df);
					}
					debug_log("hv dump successful");
					fclose(df);
				}
				else if (paddata.BTN_R1)
				{
					df = fopen("/dev_hdd0/lv2.bin", "wb");
					for(dj=lv2start;dj<lv2end;dj+=8)
					{
						val = lv2_peek(dj);
						fwrite(&val,sizeof(u64),1,df);
					}
					debug_log("lv2 dump successful");
					fclose(df);
				}
				else if (paddata.BTN_L1)
				{
					if (Lv2Syscall8 (837, (u64) "CELL_FS_UTILITY:HDD1", (u64) "CELL_FS_FAT", (u64) "/dev_cache", 0, 0, 0, 0, 0))
						debug_log("hdd1 mount failed!");
  					else
						debug_log("hdd1 mounted as /dev_cache!");
				}
				else if (paddata.BTN_L2)
				{
					if (Lv2Syscall1 (838, (u64) "/dev_cache"))
						debug_log("hdd1 unmount failed!");
  					else
						debug_log("hdd1 unmounted (/dev_cache)!");
				}
				else if (paddata.BTN_UP)
				{
					if (current_patch_idx > 0)
						current_patch_idx --;
				}
				else if (paddata.BTN_DOWN)
				{
					if (current_patch_idx < n_patches - 1)
						current_patch_idx ++;
				}
			}
		}

		usleep(150000);

		waitFlip();

		//background
		for (i = 0; i < res.height; i++) {
			for (j = 0; j < res.width; j++)
				buffers[currentBuffer]->ptr[i * res.width + j] =
				    FONT_COLOR_BLACK;
		}

		for (i = 0; i < n_patches; i++)
		{
			snprintf (ts, 1000, "%c [%c] %s", (current_patch_idx == i) ? '>' : ' ', (is_patched[i]) ? 'X' : ' ', patches[i]);
			print(50, 100 + i * 40, ts, buffers[currentBuffer]->ptr);
		}
		print (50, 100 + MAX_PATCH_FILES * 40, " X: patch       O: exit       /\\: dump hv to hdd      square: dump debug console to usb0", buffers[currentBuffer]->ptr);

		if(debug_me)
		{
			print (50, 100 + (MAX_PATCH_FILES+2) * 40, "Verbose:", buffers[currentBuffer]->ptr);
			for (i = 0; i < 10; i++)
				print (50, 100 + (MAX_PATCH_FILES+3) * 40 + i*40, debug_msgs[i], buffers[currentBuffer]->ptr);

		}else{
			print (50, 100 + (MAX_PATCH_FILES+2) * 40, "HV DEBUG CONSOLE BUFFER:", buffers[currentBuffer]->ptr);
			for (i = 0; i < 10; i++)
				print (50, 100 + (MAX_PATCH_FILES+3) * 40 + i*40, hv_buffer[i], buffers[currentBuffer]->ptr);
		}

		flip(currentBuffer);
		currentBuffer = !currentBuffer;
	}


	
	if(debug_log_file)
		fclose(debug_log_file);
	if(hv_log_file)
		fclose(hv_log_file);
	unmap_ram();
	PRINTF("done, exiting\n");
	return 0;
}
