#!/bin/bash
source "${HOME}/.profile"

export ROCKDEV_ROM_NAME="rom.img"

export ROCKDEV_SCRIPTS="$(realpath "$(dirname "${0}")")"
export ROCKDEV_ROOT="$(realpath "${ROCKDEV_SCRIPTS}/..")"
export ROCKDEV_SCRATCH="$(realpath "${ROCKDEV_ROOT}/scratch")"
export ROCKDEV_SCRATCH_SHARE="//192.168.11.8/Scratch/rockchip"
export ROCKDEV_ROMDUMP_DIR="$(realpath "${ROCKDEV_ROOT}/${ROCKDEV_ROM_NAME}.dump/")"
export ROCKDEV_SUPER_TARGET_DIR="${ROCKDEV_ROMDUMP_DIR}/Image/"
export ROCKDEV_SUPER_WORK_DIR="${ROCKDEV_ROOT}/super"

export PATH="${ROCKDEV_SCRIPTS}:$PATH"

export MAGISK=1

if [ -d "$HOME/dev/otatools/bin" ]; then
    export PATH="$HOME/dev/otatools/bin:$PATH"
fi

export PS1="${debian_chroot:+($debian_chroot)}\[\033[01;32m\]\u@\h\[\033[00m\]:\[\033[01;34m\]\w\[\033[00m\] (rockdev)\$ "

pause() {
	read -n1 -p "Press any key to continue..."
}
export -f pause

wait() {
	for f in $(seq ${1} -1 0); do
		echo -ne "\r${2:-"Waiting for %s sec..."}" | sed "s|%s|${f}|"
		if [ "${f}" != "0" ]; then
			sleep 1
		fi
	done
	echo ""
}
export -f wait

chkerr() {
	if [ ${1} -ne 0 ]; then
		echo "Error code ${1}"
		exit "${1}"
	fi
}
export -f chkerr

runcmd() {
	echo "${@}"
	"${@}"
	chkerr $?
}
export -f runcmd



mountcifs() {
	if [ ! -d "${ROCKDEV_SCRATCH}" ]; then
		mkdir "${ROCKDEV_SCRATCH}"
	fi

	if [ $(grep "${ROCKDEV_SCRATCH}" /etc/mtab -c) -eq 0 ]; then
		echo "Mounting scratch share..."
		sudo mount -t cifs -o "credentials=${ROCKDEV_ROOT}/.smbpass,uid=$(id -u),gid=$(id -g),file_mode=0660,dir_mode=0770" "${ROCKDEV_SCRATCH_SHARE}" "${ROCKDEV_SCRATCH}"
	fi
}

if [ -n "${ROCKDEV_SCRATCH_SHARE}" ]; then
	mountcifs
fi

bash --login --noprofile
