/*
 *---------------------------------------------------------------------------*
 *                                                                           *
 *          COPYRIGHT 2003-2007 SAMSUNG ELECTRONICS CO., LTD.                *
 *                          ALL RIGHTS RESERVED                              *
 *                                                                           *
 *   Permission is hereby granted to licensees of Samsung Electronics        *
 *   Co., Ltd. products to use or abstract this computer program only in     *
 *   accordance with the terms of the NAND FLASH MEMORY SOFTWARE LICENSE     *
 *   AGREEMENT for the sole purpose of implementing a product based on       *
 *   Samsung Electronics Co., Ltd. products. No other rights to reproduce,   *
 *   use, or disseminate this computer program, whether in part or in        *
 *   whole, are granted.                                                     *
 *                                                                           *
 *   Samsung Electronics Co., Ltd. makes no representation or warranties     *
 *   with respect to the performance of this computer program, and           *
 *   specifically disclaims any responsibility for any damages,              *
 *   special or consequential, connected with the use of this program.       *
 *                                                                           *
 *---------------------------------------------------------------------------*
*/
/**
 *  @version 	RFS_1.2.3p1
 *  @file	include/linux/fsr_if.h
 *  @brief	FSR interface to export commands and macros to utils, fat
 *
 *
 */

#ifndef _FSR_IF_H_
#define _FSR_IF_H_

#ifndef __KERNEL__
/*Warning*/
/*If you modify BML, you must check this definition*/
/*****************************************************************************/
/* Partition Entry ID of BML_LoadPIEntry()                                   */
/* Partition Entry ID from 0 to 0x0FFFFFFF is reserved in BML                */
/* Following ID is the pre-defined value and User can use Partition Entry ID */
/* from PARTITION_USER_DEF_BASE                                              */
/*****************************************************************************/

#define     PARTITION_ID_NBL                0  /* NAND bootloader stage 1, 2     */
#define     PARTITION_ID_BOOTLOADER         1  /* NAND bootloader stage 3 */
#define     PARTITION_ID_BOOT_PARAMETER     2  /* NAND bootloader parameter     of stage 3 */
#define     PARTITION_ID_COPIEDOS           3  /* OS image copied from NAND
                                                  flash memory to RAM     */
#define     PARTITION_ID_ROOT_FILESYSTEM    4  /* OS image loaded on demand      */
#define     PARTITION_ID_BMLAREA5           5  /* BML area 5              */
#define     PARTITION_ID_BMLAREA6           6  /* BML area 6              */
#define     PARTITION_ID_BMLAREA7           7  /* BML area 7              */
#define     PARTITION_ID_BMLAREA8           8  /* BML area 8              */
#define     PARTITION_ID_BMLAREA9           9  /* BML area 9              */
#define     PARTITION_ID_BMLAREA10          10 /* BML area 10             */
#define     PARTITION_ID_BMLAREA11          11 /* BML area 11             */
#define     PARTITION_ID_BMLAREA12          12 /* BML area 12             */
#define     PARTITION_ID_BMLAREA13          13 /* BML area 13             */
#define     PARTITION_ID_BMLAREA14          14 /* BML area 14             */
#define     PARTITION_ID_BMLAREA15          15 /* BML area 15             */
#define     PARTITION_ID_BMLAREA16          16 /* BML area 16             */
#define     PARTITION_ID_BMLAREA17          17 /* BML area 17             */
#define     PARTITION_ID_BMLAREA18          18 /* BML area 18             */
#define     PARTITION_ID_BMLAREA19          19 /* BML area 19             */
#define     PARTITION_ID_FILESYSTEM0        20 /* file system 0           */
#define     PARTITION_ID_FILESYSTEM1        21 /* file system 1           */
#define     PARTITION_ID_FILESYSTEM2        22 /* file system 2           */
#define     PARTITION_ID_FILESYSTEM3        23 /* file system 3           */
#define     PARTITION_ID_FILESYSTEM4        24 /* file system 4           */
#define     PARTITION_ID_FILESYSTEM5        25 /* file system 5           */
#define     PARTITION_ID_FILESYSTEM6        26 /* file system 6           */
#define     PARTITION_ID_FILESYSTEM7        27 /* file system 7           */
#define     PARTITION_ID_BMLAREA28          28 /* BML area 28             */
#define     PARTITION_ID_BMLAREA29          29 /* BML area 29             */
#define     PARTITION_ID_RESERVED           30 /* DUMMY area 30           */

#endif


/**
 * This file defines some macros that will be shared by user and kernel
 */
#ifdef CONFIG_FSR_DUAL_VOLUME
	#define FSR_MAX_VOLUMES		2
#else
	#define FSR_MAX_VOLUMES		1
#endif

/* this is support 30 partition*/
#define MASK(x)					((1U << (x)) -1)			
#define PARTITION_BITS			5
#define PARTITION_MASK			MASK(PARTITION_BITS)
#define MAX_FLASH_PARTITIONS	((0x1 << PARTITION_BITS) - 1)
#define MAX_PAGE_SIZE 4096

/* Device major number*/
#define BLK_DEVICE_BML	137
#define BLK_DEVICE_STL	138
#define BLK_DEVICE_TINY_FSR	139
/* distinguish chip and partition during dump and restore */
#define FSR_CHIP		0xaabb
#define FSR_PART		0xaacc
#define MAGIC_STR_SIZE		8

/* LLD level ioctl command */
#define LLD_GET_DEV_INFO	0x8A31
#define LLD_BOOT_READ		0x8A32
#define LLD_BOOT_WRITE		0x8A33

typedef struct {
	int msize_blk;
	int msize_page;
	int pages_blk;
} LLD_DEVINFO_T;

/* BML level ioctl commands */    
#define BML_GET_DEV_INFO	0x8A21 
#define BML_GET_PARTITION	0x8A22
#define BML_SET_PARTITION	0x8A23
#define BML_FORMAT			0x8A24
#define BML_ERASE_ALL		0x8A25
#define BML_ERASE_PARTITION	0x8A26
#define BML_DUMP			0x8A27
#define BML_RESTORE			0x8A28
#define BML_UNLOCK_ALL		0x8A29
#define BML_SET_RW_AREA		0x8A2A
#define FSR_DUMP            0x8A2B

typedef struct {
	unsigned int	offset;
	unsigned char mbuf[MAX_PAGE_SIZE];
} PAGEINFO_T;

typedef struct {
	int	phy_unit_size;  /* in bytes expect spare*/
	int	num_units;
	int	page_msize; /* main size in page */
	int dump_size; /* spare size in page */
} BML_DEVINFO_T;

typedef struct {
	int    num_parts;
	int    part_size[MAX_FLASH_PARTITIONS];  /* in number of units */
	int    part_id[MAX_FLASH_PARTITIONS]; /* device class */
	int    part_attr[MAX_FLASH_PARTITIONS]; /* device class */
	int    part_addr[MAX_FLASH_PARTITIONS]; /* device class */
} BML_PARTTAB_T;

typedef struct {
	unsigned int    status;
	unsigned int    dump_size;
	unsigned int    dump_parts[MAX_FLASH_PARTITIONS];
	unsigned char   *dump_pBuf;
} BML_DUMP_T;

/* STL level ioctl commands */
#define STL_FORMAT		0x8A01  /* STL format     */
#define STL_GET_DEV_INFO	0x8A02  /* STL stat	  */
#define STL_CLEAN		0x8A03  /* STL clean	  */
#define STL_SYNC		0x8A13  /* STL sync       */
#define STL_MAPDESTROY		0x8A14  /* STL mapdestroy */

typedef struct {
	unsigned int total_sectors;
	unsigned int page_size;
}stl_info_t;

#endif /* _FSR_IF_H_ */
