// 20080611 created..
#ifndef _SAMSUNG_SXGA_H_
#define _SAMSUNG_SXGA_H_

/*******************************************************************************************
 #  Display resolution standards #

	QCIF: 176 x 144
	CIF: 352 x 288
	QVGA: 320 x 240
	VGA: 640 x 480 
	SVGA: 800 x 600 
	XGA: 1024 x 768 
	WXGA: 1280 x 800 
	QVGA: 1280 x 960 
	SXGA: 1280 x 1024 
	SXGA+: 1400 x 1050 
	WSXGA+: 1680 x 1050 
	UXGA: 1600 x 1200 
	WUXGA: 1920 x 1200 
	QXGA: 2048 x 1536
********************************************************************************************/

//#include "../bits.h"

/* Camera information 
 * FPC Label : Samsung MEGA Pixel Camera : V4220 REV06 
 * Modified by charles -Initial function of '3AA' test routine
 * Modified and tested by YongHwui.Kim <yonghwui.kim@samsung.com> for S5K3AAEX Camera
 */
                                                                                
#define CHIP_DELAY 0xFF
                                                                                
typedef struct samsung_t{
        unsigned char subaddr;
        unsigned char value;
        unsigned char page;
} po4010_t;

#if 0
// mihee 080508 start
typedef struct samsung_short_t{
        unsigned short subaddr;
        unsigned short value;
        unsigned short page;
} po4010_short_t;
// mihee 080508 end
#endif

#ifdef CONFIG_CPU_S3C24A0A
#define TRY_HIGH_CLOCK 1
#endif

				//***************************************************
				//  name: 	S5K3AAEX EVT2 setfile
				//  ver:		v2.61	
				//  history: 	
				//	v0.0	start from 040908 setfile
				//	v1.0	arange register
				//	v1.01	change MCLK(25Mhz) and Frame rate(7fps)
				//	v2.0	adjust register setting for 3AA EVT2
				//		- color correction, RGB shding off, hsync start position, Mirror, fps
				//		- Color Tuning, YGRPDLY 
				//	v2.1	change Frame rate(7.5fps) and Total gain to x4 
				//		(because of reducing visual noise at low illumination)
				//		- change BPRM AGC Max and FrameAE start 
				//		improve AE speed
				//	v2.2	modify AWB G gain and solve 50hz flicker detection fail in 25MHz 7.5fps
				//	v2.3	Adjust gamma, Dark Slice, white point, Hue gain,
				//		White Balance B control, Y gain On, Digital Clamp On
				//		lower AWB G gain
				//	v2.4	Adjust AE window weight, Y Gamma, WhitePoint, Shading and BPR Max Thres.
				// 	v2.41	Adjust AE/AWB window and AWB internal window boundary to decrease skin color tracking
				// 	v2.411	special version for PSCDS
				// 	v2.412	RGB shading off
				//	v2.5	Lens change STW to Sekonix 
				//		adjust White point and Y shading Coef (RGB shading off)
				//	v2.6	New Tuning because of Full YC off and YCbCr Coef change
				//		Gamma, Dark Slice, color matrix (not use), Color suppress
				//		R Gain and DBPR agc MIN/MAX
				//	v2.61	VCK inversion(data rising)
				//***************************************************
				///////////////////////////////////////////////////

//#if defined(CONFIG_VIDEO_SAMSUNG_PO4010)
po4010_t po4010_preview[] = 
{
	{0x03,0x01},
	{0xff,0xff},
};

po4010_t po4010_reg[] = 
{
#if 0
	{0x03,0x01},
	{0x03,0x01},
	{0x1A,0xF7},
	{0x03,0x00},
	{0x09,0x03},
	{0x0D,0x62},
	{0x20,0x55},
	{0x22,0x57},
	{0x25,0x3d},//P_noise
	{0x34,0x1F},
	{0x36,0x00},//1,f
	{0x37,0x16},//f
	{0x29,0x10},
	{0x3E,0x1A},
	{0x3F,0x20},
	{0xC5,0x01},
	{0xC6,0xB0},
	{0xC7,0x02},
	{0xC8,0x06},
	{0x26,0x59},
	{0x27,0x70},
	{0x28,0x7A},
	{0x2A,0x07},
	{0x4F,0x83},
	{0x5C,0xFF},
	{0x95,0x20},
	{0x9C,0x20},
	{0x9D,0x00},
	{0x4A,0xF4},
	{0x8C,0x00},
	{0x9E,0x00},
	{0x9F,0x00},
	{0xA0,0x00},
	{0xA1,0x02},
	{0xA2,0x0B},
	{0xA3,0x0C},
	{0xA4,0x00},
	{0xA5,0xFF},
	{0xA7,0x99},//99
	{0xA8,0x9b},//9b
	{0xA9,0x9b},//9b
	{0xAA,0x9b},//9b
	{0xAB,0xc8},//b3
	{0xAC,0xc8},//b3
	{0xAD,0x00},
	{0xAE,0xFF},
	{0xB1,0x3a},//3e
	{0xB2,0x6f},
	{0xB3,0x41},
	{0xB4,0x73},
	{0xB7,0x13},//f
	{0xB8,0x01},//f
	{0xB9,0x0f},//f
	{0xBa,0xd7},//f
	{0xBe,0x10},//f
	{0xBf,0x35},//f
	{0xc0,0xe1},//f
	{0xc1,0x40},//f
	{0xc2,0xa7},//f
	{0xc3,0x01},//f
	{0xc4,0x43},//f
	{0xc5,0x01},//f
	{0xc6,0xb0},//f
	{0xc7,0x01},//f
	{0xc8,0xb0},//f
	{0x06,0x01},
	{0x07,0xB0},
	{0x4B,0x10},//90

	{0x03,0x01},
	{0x3b,0x20},//24 
	{0x42,0x00}, 
	{0x43,0x08}, 
	{0x44,0x12}, 
	{0x45,0x1b}, 
	{0x46,0x28}, 
	{0x47,0x3e}, 
	{0x48,0x56}, 
	{0x49,0x74}, 
	{0x4A,0x8d}, 
	{0x4B,0xa7}, 
	{0x4C,0xBe}, 
	{0x4D,0xd2}, 
	{0x4E,0xe2}, 
	{0x4F,0xf2}, 
	{0x50,0xFF},

	{0x56,0xFB},
	{0x57,0xFB},
	{0x58,0xFB},
	{0x59,0xFB},
	{0x5A,0xFB},
	{0x5B,0xFB},
	{0x5C,0xFB},
	{0x5D,0xFB},
	{0x56,0x00},
	{0x57,0x00},
	{0x58,0x00},
	{0x59,0x00},
	{0x5A,0x00},
	{0x5B,0x00},
	{0x5C,0x00},
	{0x5D,0x00},
	{0x38,0x28},
	{0x6A,0x08},
	{0x52,0x06},
	{0x53,0x1b},//16
	{0x54,0x1b},//16
	{0x55,0x00},
	{0x03,0x02},
	{0x05,0x7F},
	{0x1F,0x80},
	{0x28,0x0C},
	{0x2B,0x0a},
	{0x2C,0xE0},
	{0x2D,0xE0},
	{0x41,0x00},
	{0x42,0x8C},
	{0x43,0x00},
	{0x44,0x65},
	{0x45,0x00},
	{0x46,0x50},
	{0x47,0x00},
	{0x48,0x4F},
	{0x4A,0x00},
	{0x4B,0x04},//00
	{0x4C,0x08},
	{0x4D,0x10},
	{0x4E,0x1D},
	{0x4F,0x14},
	{0x56,0x00},
	{0x57,0x00},
	{0x58,0x00},
	{0x59,0x10},
	{0x5A,0x10},
	{0x5B,0x05},
	{0x5C,0x00},
	{0x5D,0x00},
	{0x5E,0x10},
	{0x5F,0x1F},
	{0x60,0x1F},
	{0x61,0x1F},
	{0x62,0x00},
	{0x63,0x00},
	{0x64,0x00},
	{0x65,0x00},//04
	{0x66,0x1F},
	{0x67,0x1F},
	{0x6E,0x00},
	{0x6F,0x04},
	{0x70,0x08},
	{0x71,0x10},
	{0x72,0x1F},
	{0x73,0x1F},
	{0x7A,0x00},
	{0x7B,0x00},
	{0x7C,0x00},
	{0x7D,0x28},
	{0x7E,0x28},
	{0x7F,0x3F},
	{0x96,0x00},
	{0x97,0xFF},
	{0x98,0xFF},
	{0x99,0x00},
	{0x9A,0xFF},
	{0x9B,0xFF},
	{0x9C,0x00},
	{0x9D,0x00},
	{0x9E,0xFF},
	{0x9F,0xFF},
	{0xA0,0x00},
	{0xA1,0xFF},
	{0xA2,0xFF},
	{0xA3,0x00},
	{0xA4,0xF0},//ff
	{0xA5,0x10},//00
	{0xA6,0xFF},
	{0xA7,0x3a},
	{0xA8,0x93},
	{0xA9,0x87},
	{0xAA,0x8F},
	{0xAB,0x3D},
	{0xAC,0x8E},
	{0xAD,0x82},
	{0xAE,0x9B},
	{0xAF,0x3D},
	{0xB5,0x83}, //85
	{0xB6,0x85},
	{0xB7,0x68},
	{0xB8,0x60},
	{0xB9,0x20},
	{0xBA,0x40},
	{0xBB,0x70},
	{0xBC,0x08},
	{0xBD,0x0A},
	{0xBE,0x1A},
	{0xBF,0x25},
	{0xC0,0x60},
	{0xC1,0xB0},
	{0xC2,0x06},
	{0xC8,0x08},
	{0xC9,0x10},
	{0xCA,0x10},
	{0xCB,0x10},
	{0xCC,0x40},
	{0xCD,0x80},
	{0xCE,0xFF},
	{0x08,0x04},
	{0x94,0x04},
	{0x91,0x8a},//88 
	{0x92,0x86},//86
	{0x93,0x06},
	{0xD0,0x2B},
	{0xD1,0x00},
	{0xD2,0x00},
	{0xD3,0x2B},
	{0xD4,0x22},
	{0xD5,0x00},
	{0xD6,0x00},
	{0xD7,0x22},
	{0xD8,0x28},//24
	{0xDB,0x1b},//16
	{0xD9,0x28},//1A22
	{0xDA,0x1b},//1419
	{0xDC,0x28},//2028
	{0xDF,0x1b},//16
	{0xE0,0x45},
	{0xDD,0x63},//61
	{0xE1,0x64},//65
	{0x13,0x02},
	{0x14,0x37},
	{0x15,0x05},
	{0x16,0xe8},
	{0x18,0x0f}, //1c1e1b
	{0x19,0x30}, //af6000
	{0x1B,0x2a}, //1c1e1b
	{0x1C,0x86}, //1f6000
	{0x20,0x00},
	{0x21,0xA2},
	{0x03,0x00},
	{0x11,0x0C},

	{0x03,0x00},
	{0x0B,0x01},
	{0x0C,0x01},
	{0x0D,0x62},
	{0x0E,0x01},
	{0x0F,0x20},
	{0x11,0x0E},
	{0x13,0x2E},
	{0x15,0x60},

	{0x03,0x01},
	{0x27,0x20},
	{0x28,0x20},
	{0x2A,0x04},
	{0x15,0x00},

	{0x03,0x02},
	{0x3D,0x01},
	{0x3E,0x60},
	{0x3F,0x01},
	{0x40,0x20},
	{0x41,0x00},
	{0x42,0x7A},
	{0x43,0x00},
	{0x44,0x65},
	{0x45,0x00},
	{0x46,0x7C},
	{0x47,0x00},
	{0x48,0x66},

	{0xff,0xff},
#else
#if 0	
	{0x03,0x01},	
	{0x03,0x01},	
	{0x1a,0xf7},
	{0x03,0x01},
	{0x10,0xf0},
	{0x03,0x00},
	{0x06,0x03},
	{0x07,0x29},
	{0x09,0x07},
	{0x0b,0x07},
	{0x0c,0x01},
	{0x0d,0x66},
	{0x0e,0x01},
	{0x0f,0x26},
	{0x11,0x14},
	{0x13,0x34},
	{0x15,0x60},
	{0x16,0x01},
	{0x20,0x40},
	{0x21,0x40},
	{0x22,0x40},
	{0x25,0x2d},
	{0x26,0x59},
	{0x27,0x70},
	{0x28,0x7a},
	{0x29,0x10},
	{0x2a,0x17},
	{0x34,0x1f},
	{0x36,0x20},
	{0x37,0x00},
	{0x38,0x40},
	{0x39,0xa8},
	{0x3a,0x35},
	{0x3b,0xe2},
	{0x4a,0xb4},
	{0x4b,0x90},
	{0x4f,0x83},
	{0x5c,0xff},
	{0xb1,0x38},
	{0xb2,0x73},
	{0xb3,0x41},
	{0xb4,0x73},
	{0xc5,0x01},
	{0xc6,0xb0},
	{0xc7,0x01},
	{0xc8,0xb0},
	{0x03,0x01},
	{0x16,0x22},
	{0x27,0x20},
	{0x28,0x20},
	{0x2a,0x04},
	{0x34,0x40},
	{0x35,0x01},
	{0x38,0x00},
	{0x42,0x00},
	{0x43,0x08},
	{0x44,0x15},
	{0x45,0x22},
	{0x46,0x2d},
	{0x47,0x40},
	{0x48,0x50},
	{0x49,0x67},
	{0x4a,0x77},
	{0x4b,0x95},
	{0x4c,0xae},
	{0x4d,0xc5},
	{0x4e,0xda},
	{0x4f,0xed},
	{0x50,0xff},
	{0x52,0x20},
	{0x53,0x18},
	{0x54,0x18},
	{0x55,0x16},
	{0x56,0x00},
	{0x57,0x00},
	{0x58,0x00},
	{0x59,0x00},
	{0x5a,0x00},
	{0x5b,0x00},
	{0x5c,0x00},
	{0x5d,0x00},
	{0x6a,0x08},
	{0x03,0x02},
	{0x05,0x7f},
	{0x08,0x04},
	{0x13,0x06},
	{0x14,0x52},
	{0x15,0x06},
	{0x16,0x53},
	{0x18,0x38},
	{0x19,0xef},
	{0x1b,0x5b},
	{0x1c,0x19},
	{0x1d,0x00},
	{0x1e,0x01},
	{0x1f,0x0c},
	{0x20,0x03},
	{0x21,0x29},
	{0x28,0x0c},
	{0x2b,0x0a},
	{0x2c,0xe0},
	{0x2d,0xe0},
	{0x3d,0x01},
	{0x3e,0x60},
	{0x3f,0x01},
	{0x40,0x20},
	{0x41,0x00},
	{0x42,0x72},
	{0x43,0x00},
	{0x44,0x5d},
	{0x45,0x00},
	{0x46,0x7c},
	{0x47,0x00},
	{0x48,0x66},
	{0x4a,0x02},
	{0x4b,0x02},
	{0x4c,0x08},
	{0x4d,0x1a},
	{0x4e,0x1c},
	{0x4f,0x1f},
	{0x56,0x00},
	{0x57,0x00},
	{0x58,0x00},
	{0x59,0x10},
	{0x5a,0x10},
	{0x5b,0x10},
	{0x5c,0x00},
	{0x5d,0x00},
	{0x5e,0x00},
	{0x5f,0x18},
	{0x60,0x1b},
	{0x61,0x1f},
	{0x62,0x00},
	{0x63,0x00},
	{0x64,0x00},
	{0x65,0x03},
	{0x66,0x15},
	{0x67,0x15},
	{0x6e,0x00},
	{0x6f,0x04},
	{0x70,0x08},
	{0x71,0x15},
	{0x72,0x1a},
	{0x73,0x1f},
	{0x7a,0x00},
	{0x7b,0x00},
	{0x7c,0x00},
	{0x7d,0x00},
	{0x7e,0x08},
	{0x7f,0x1f},
	{0x91,0x80},
	{0x92,0x80},
	{0x93,0x06},
	{0x94,0x04},
	{0xa4,0xf0},
	{0xa5,0x10},
	{0xa6,0xff},
	{0xa7,0x3a},
	{0xa8,0x93},
	{0xa9,0x87},
	{0xaa,0x8f},
	{0xab,0x3d},
	{0xac,0x8e},
	{0xad,0x82},
	{0xae,0x9b},
	{0xaf,0x3d},
	{0xb5,0x82},
	{0xb6,0x7f},
	{0xb7,0x68},
	{0xb8,0x60},
	{0xb9,0x20},
	{0xba,0x40},
	{0xbb,0x70},
	{0xbc,0x08},
	{0xbd,0x0a},
	{0xbe,0x1a},
	{0xbf,0x25},
	{0xc0,0x60},
	{0xc1,0xb0},
	{0xc2,0x06},
	{0xc8,0x08},
	{0xc9,0x10},
	{0xca,0x10},
	{0xcb,0x10},
	{0xcc,0x40},
	{0xcd,0x80},
	{0xce,0xff},
	{0xd0,0x28},
	{0xd1,0x00},
	{0xd2,0x00},
	{0xd3,0x28},
	{0xd4,0x25},
	{0xd5,0x00},
	{0xd6,0x00},
	{0xd7,0x25},
	{0xd8,0x24},
	{0xdb,0x16},
	{0xd9,0x24},
	{0xda,0x16},
	{0xdc,0x24},
	{0xdf,0x16},
	{0xe0,0x45},
	{0xdd,0x61},
	{0xe1,0x65},
	{0x03,0x03},
	{0x4d,0x8e},
	{0x6a,0x83},
	{0x6b,0x84},
	{0x6c,0x81},
	{0x6d,0x81},
	{0x4f,0x00},
	{0x50,0x00},
	{0x51,0x00},
	{0x52,0x0a},
	{0x53,0x0a},
	{0x54,0x0a},
	{0x55,0x00},
	{0x56,0x10},
	{0x58,0x00},
	{0x59,0x00},
	{0x5a,0x00},
	{0x5b,0x00},
	{0x5c,0x00},
	{0x5d,0x00},
	{0x5e,0x00},
	{0x5f,0x40},
	{0x84,0x20},
	{0x05,0x7f},
	{0x03,0x00},
	{0x06,0x03},
	{0x07,0x29},
	{0x03,0x02},
	{0x13,0x06},
	{0x14,0x52},
	{0x15,0x06},
	{0x16,0x53},
	{0x18,0x38},
	{0x19,0xef},
	{0x1b,0x5b},
	{0x1c,0x19},
	{0x20,0x03},
	{0x21,0x29},

	{0xff,0xff}
#else
	{0x03,0x01},
	{0x03,0x01},
	{0x1a,0xf7},
	{0x03,0x00},
	{0x09,0x03},
	{0x0d,0x62},
	{0x20,0x55},
	{0x22,0x57},
	{0x25,0x3d},
	{0x34,0x1f},
	{0x36,0x00},
	{0x37,0x16},
	{0x29,0x10},
	{0x3e,0x1a},
	{0x3f,0x20},
	{0xc5,0x01},
	{0xc6,0xb0},
	{0xc7,0x02},
	{0xc8,0x06},
	{0x26,0x59},
	{0x27,0x70},
	{0x28,0x7a},
	{0x2a,0x17},
	{0x4f,0x83},
	{0x5c,0xff},
	{0x95,0x20},
	{0x9c,0x20},
	{0x9d,0x00},
	{0x4a,0xB4},
	{0x8c,0x00},
	{0x9e,0x00},
	{0x9f,0x00},
	{0xa0,0x00},
	{0xa1,0x02},
	{0xa2,0x0b},
	{0xa3,0x0c},
	{0xa4,0x00},
	{0xa5,0xff},
	{0xa7,0x99},
	{0xa8,0x9b},
	{0xa9,0x9b},
	{0xaa,0x9b},
	{0xab,0xba},
	{0xac,0xba},
	{0xad,0x00},
	{0xae,0xff},
	{0xb1,0x40},
	{0xb2,0x6f},
	{0xb3,0x41},
	{0xb4,0x7b},
	{0xb7,0x13},
	{0xb8,0x01},
	{0xb9,0x0f},
	{0xba,0xd7},
	{0xbe,0x10},
	{0xbf,0x35},
	{0xc0,0xe1},
	{0xc1,0x40},
	{0xc2,0xa7},
	{0xc3,0x01},
	{0xc4,0x43},
	{0xc5,0x01},
	{0xc6,0xb0},
	{0xc7,0x01},
	{0xc8,0xb0},
	{0x06,0x01},
	{0x07,0xb0},
	{0x4b,0x90},
	{0x03,0x01},
	{0x16,0x04},
	{0x3b,0x20},
	{0x42,0x00},
	{0x43,0x08},
	{0x44,0x12},
	{0x45,0x1b},
	{0x46,0x28},
	{0x47,0x3e},
	{0x48,0x56},
	{0x49,0x74},
	{0x4a,0x8d},
	{0x4b,0xa7},
	{0x4c,0xbe},
	{0x4d,0xd2},
	{0x4e,0xe2},
	{0x4f,0xf2},
	{0x50,0xff},
	{0x56,0xfb},
	{0x57,0xfb},
	{0x58,0xfb},
	{0x59,0xfb},
	{0x5a,0xfb},
	{0x5b,0xfb},
	{0x5c,0xfb},
	{0x5d,0xfb},
	{0x56,0x00},
	{0x57,0x00},
	{0x58,0x00},
	{0x59,0x00},
	{0x5a,0x00},
	{0x5b,0x00},
	{0x5c,0x00},
	{0x5d,0x00},
	{0x38,0x28},
	{0x6a,0x08},
	{0x52,0x06},
	{0x53,0x1b},
	{0x54,0x1b},
	{0x55,0x00},
	{0x03,0x02},
	{0x05,0x7f},
	{0x1f,0x80},
	{0x28,0x0c},
	{0x2b,0x0a},
	{0x2c,0xe0},
	{0x2d,0xe0},
	{0x41,0x00},
	{0x42,0x8c},
	{0x43,0x00},
	{0x44,0x65},
	{0x45,0x00},
	{0x46,0x50},
	{0x47,0x00},
	{0x48,0x4f},
	{0x4a,0x00},
	{0x4b,0x04},
	{0x4c,0x08},
	{0x4d,0x10},
	{0x4e,0x1d},
	{0x4f,0x14},
	{0x56,0x00},
	{0x57,0x00},
	{0x58,0x00},
	{0x59,0x10},
	{0x5a,0x10},
	{0x5b,0x05},
	{0x5c,0x00},
	{0x5d,0x00},
	{0x5e,0x10},
	{0x5f,0x1f},
	{0x60,0x1f},
	{0x61,0x1f},
	{0x62,0x00},
	{0x63,0x00},
	{0x64,0x00},
	{0x65,0x14},
	{0x66,0x1f},
	{0x67,0x1a},
	{0x6e,0x00},
	{0x6f,0x04},
	{0x70,0x08},
	{0x71,0x10},
	{0x72,0x1f},
	{0x73,0x1f},
	{0x7a,0x00},
	{0x7b,0x00},
	{0x7c,0x00},
	{0x7d,0x28},
	{0x7e,0x28},
	{0x7f,0x3f},
	{0x96,0x00},
	{0x97,0xff},
	{0x98,0xff},
	{0x99,0x00},
	{0x9a,0xff},
	{0x9b,0xff},
	{0x9c,0x00},
	{0x9d,0x00},
	{0x9e,0xff},
	{0x9f,0xff},
	{0xa0,0x00},
	{0xa1,0xff},
	{0xa2,0xff},
	{0xa3,0x00},
	{0xa4,0xf0},
	{0xa5,0x10},
	{0xa6,0xff},
	{0xa7,0x3a},
	{0xa8,0x93},
	{0xa9,0x87},
	{0xaa,0x8f},
	{0xab,0x3d},
	{0xac,0x8e},
	{0xad,0x82},
	{0xae,0x9b},
	{0xaf,0x3d},
	{0xb5,0x85},
	{0xb6,0x85},
	{0xb7,0x68},
	{0xb8,0x60},
	{0xb9,0x20},
	{0xba,0x40},
	{0xbb,0x70},
	{0xbc,0x08},
	{0xbd,0x0a},
	{0xbe,0x1a},
	{0xbf,0x25},
	{0xc0,0x60},
	{0xc1,0xb0},
	{0xc2,0x06},
	{0xc8,0x08},
	{0xc9,0x10},
	{0xca,0x10},
	{0xcb,0x10},
	{0xcc,0x40},
	{0xcd,0x80},
	{0xce,0xff},
	{0x08,0x04},
	{0x94,0x04},
	{0x91,0x8a},
	{0x92,0x86},
	{0x93,0x06},
	{0xd0,0x2b},
	{0xd1,0x00},
	{0xd2,0x00},
	{0xd3,0x2b},
	{0xd4,0x22},
	{0xd5,0x00},
	{0xd6,0x00},
	{0xd7,0x22},
	{0xd8,0x28},
	{0xdb,0x1b},
	{0xd9,0x2a},
	{0xda,0x1b},
	{0xdc,0x2a},
	{0xdf,0x1b},
	{0xe0,0x45},
	{0xdd,0x63},
	{0xe1,0x64},
	{0x13,0x02},
	{0x14,0x37},
	{0x15,0x05},
	{0x16,0xe8},
	{0x18,0x0f},
	{0x19,0x30},
	{0x1b,0x25},
	{0x1c,0xf8},
	{0x20,0x00},
	{0x21,0xa2},
	{0x03,0x00},
	{0x0b,0x01},
	{0x0c,0x01},
	{0x0d,0x62},
	{0x0e,0x01},
	{0x0f,0x20},
	{0x11,0x0e},
	{0x13,0x2e},
	{0x15,0x60},
	{0x03,0x01},
	{0x27,0x20},
	{0x28,0x20},
	{0x2a,0x04},
	{0x15,0x00},
	{0x03,0x02},
	{0x3d,0x01},
	{0x3e,0x60},
	{0x3f,0x01},
	{0x40,0x20},
	{0x41,0x00},
	{0x42,0x7a},
	{0x43,0x00},
	{0x44,0x65},
	{0x45,0x00},
	{0x46,0x7c},
	{0x47,0x00},
	{0x48,0x66},

	{0xff,0xff}

#endif
#endif
};


// ==================================================//   
// 	WB_AUTO                              //
// ==================================================//  
po4010_t po4010_wb_auto[] = 
{
	{0x03,0x02},
	{0x04,0x98},
};

// ==================================================//   
// 	WB_DAYLIGHT                       		//
// ==================================================//  
po4010_t po4010_wb_daylight[] = 
{
	{0x03,0x02},
	{0x04,0x9C},
	{0x03,0x00},
	{0x20,0x63},
	{0x22,0x4A},
};

// ==================================================//   
// 	WB_CLOUDY_DAYLIGHT                       	//
// ==================================================//  
po4010_t po4010_wb_cloudy[] = 
{
	{0x03,0x02},
	{0x04,0x9C},
	{0x03,0x00},
	{0x20,0x6A},
	{0x22,0x4A},
};

// ==================================================//   
// WB_INCANDESCENT                     //
// ==================================================//  
po4010_t po4010_wb_incandescent[] = 
{
	{0x03,0x02},
	{0x04,0x9C},
	{0x03,0x00},
	{0x20,0x41},
	{0x22,0x6C},
};

// ==================================================//   
// WB_FLUORESCENT                     //
// ==================================================//  
po4010_t po4010_wb_fluorescent[] = 
{
	{0x03,0x02},
	{0x04,0x9C},
	{0x03,0x00},
	{0x20,0x56},
	{0x22,0x6A},
};

// ==================================================//   
// BR_1                               //
// ==================================================//  
po4010_t po4010_br_1[] = 
{
	{0x03,0x01},
	{0x35,0xC1},
};

// ==================================================//   
// BR_2                               //
// ==================================================//  
po4010_t po4010_br_2[] = 
{
	{0x03,0x01},
	{0x35,0xD1},
};

// ==================================================//   
// BR_3                                //
// ==================================================//  
po4010_t po4010_br_3[] = 
{
	{0x03,0x01},
	{0x35,0xE1},
};

// ==================================================//   
// BR_4                                //
// ==================================================//  
po4010_t po4010_br_4[] = 
{
	{0x03,0x01},
	{0x35,0xF1},
};

// ==================================================//   
// BR_5                                //
// ==================================================//  
po4010_t po4010_br_5[] = 
{
	{0x03,0x01},
	{0x35,0x01},
};

// ==================================================//   
// BR_6                                //
// ==================================================//  
po4010_t po4010_br_6[] = 
{
	{0x03,0x01},
	{0x35,0x11},
};

// ==================================================//   
// BR_7                               //
// ==================================================//  
po4010_t po4010_br_7[] = 
{
	{0x03,0x01},
	{0x35,0x21},
};

// ==================================================//   
// BR_8                               //
// ==================================================//  
po4010_t po4010_br_8[] = 
{
	{0x03,0x01},
	{0x35,0x31},
};

// ==================================================//   
// BR_9                               //
// ==================================================//  
po4010_t po4010_br_9[] = 
{
	{0x03,0x01},
	{0x35,0x41},
};

// ==================================================//   
// EFFECT_OFF                          	//                           
// ==================================================//  
po4010_t po4010_effect_off[] = 
{
	{0x03,0x02},
	{0x38,0x03},
	{0x03,0x01},
	{0x06,0x01},
};

// ==================================================//  
// EFFECT_MONO                       		//
// ==================================================//
po4010_t po4010_effect_mono[] = 
{
	{0x03,0x01},
	{0x06,0x81},
	{0x2C,0x00},
	{0x2D,0x00},
};

// ==================================================//   
// EFFECT_SEPIA                       	// 
// ==================================================//   
po4010_t po4010_effect_sepia[] = 
{
	{0x03,0x01},
	{0x06,0x81},
	{0x2C,0xA0},
	{0x2D,0x20},
};

// ==================================================//   
// EFFECT_NEGATIVE                     	// 
// ==================================================//  
po4010_t po4010_effect_negative[] = 
{
	{0x03,0x02},
	{0x38,0x02},
	{0x03,0x01},
	{0x06,0x09},
};

// ==================================================//   
// EFFECT_AQUA                     	// 
// ==================================================//  
po4010_t po4010_effect_aqua[] = 
{
	{0x03,0x01},
	{0x06,0x81},
	{0x2C,0x20},
	{0x2D,0xC0},
};

// ==================================================//   
// EFFECT_GREEN                     	// 
// ==================================================//  
po4010_t po4010_effect_green[] = 
{
	{0x03,0x01},
	{0x06,0x81},
	{0x2C,0xC0},
	{0x2D,0xC0},
};

// ==================================================//   
// SPOT_ON                     	// 
// ==================================================//  
po4010_t po4010_spot_on[] = 
{
	{0x03,0x02},
	{0x28,0x0C},
};

// ==================================================//   
// SPOT_OFF                     	// 
// ==================================================//  
po4010_t po4010_spot_off[] = 
{
	{0x03,0x02},
	{0x28,0x00},
};

// ==================================================//   
// FLIP_OFF                     	// 
// ==================================================//  
po4010_t po4010_flip_off[] = 
{
	{0x03,0x00},
	{0x4A,0xF4},
};

// ==================================================//   
// FLIP_MIRROR                     	// 
// ==================================================//  
po4010_t po4010_flip_mirror[] = 
{
	{0x03,0x00},
	{0x4A,0x74},
};

// ==================================================//   
// FLIP_WATER                     	// 
// ==================================================//  
po4010_t po4010_flip_water[] = 
{
	{0x03,0x00},
	{0x4A,0xB4},
};

// ==================================================//   
// FLIP_MIRROR_WATER                     	// 
// ==================================================//  
po4010_t po4010_flip_mirror_water[] = 
{
	{0x03,0x00},
	{0x4A,0x34},
};

//#else
//#error No samsung CIS moudule !
//#endif

// For VGA ( 640 x 480) on 4CA module
po4010_t po4010_reg_vga[] = 
{
	// To do.
};

// For SVGA ( 800 x 600) on 4CA module
po4010_t po4010_reg_svga[] = 
{
	// To do.
};

// For SXGA (1280 x 1024 = 1.3M) on 4CA module
po4010_t po4010_reg_sxga[] = 
{
	// To do.
};


// For UXGA (1600 x 1200 = 2M) on 4CA module
po4010_t po4010_reg_uxga[] = 
{
	// To do.
};

// For SQVGA on 4CA module
po4010_t po4010_reg_qsvga[] = 
{
	// To do.
};

#define po4010_INIT_REGS (sizeof(po4010_reg)/sizeof(po4010_reg[0]))
#define po4010_UXGA_REGS (sizeof(po4010_reg_uxga)/sizeof(po4010_reg_uxga[0]))
#define po4010_SVGA_REGS (sizeof(po4010_reg_svga)/sizeof(po4010_reg_svga[0]))
#define po4010_VGA_REGS (sizeof(po4010_reg_vga)/sizeof(po4010_reg_vga[0]))
#define po4010_QSVGA_REGS (sizeof(po4010_reg_qsvga)/sizeof(po4010_reg_qsvga[0]))



//#define PO4010_RISC_REGS 0xEB
//#define PO4010_ISP_REGS 0xFB /* S5C7323X */
//#define PO4010_CIS_REGS 0x2F /* S5K437LA03 */
                                                                                                                                                                                                                                  
//#define PO4010_REGS (0x1000)


#endif

