
#ifndef _SAMSUNG_SXGA_H_
#define _SAMSUNG_SXGA_H_

/*******************************************************************************************
 #  Display resolution standards #

	QCIF: 176 x 144
	CIF: 352 x 288
	QVGA: 320 x 240
	VGA: 640 x 480 
	SVGA: 800 x 600 
	XGA: 1024 x 768 
	WXGA: 1280 x 800 
	QVGA: 1280 x 960 
	SXGA: 1280 x 1024 
	SXGA+: 1400 x 1050 
	WSXGA+: 1680 x 1050 
	UXGA: 1600 x 1200 
	WUXGA: 1920 x 1200 
	QXGA: 2048 x 1536
********************************************************************************************/

//#include "../bits.h"

/* Camera information 
 * FPC Label : Samsung MEGA Pixel Camera : V4220 REV06 
 * Modified by charles -Initial function of '3AA' test routine
 * Modified and tested by YongHwui.Kim <yonghwui.kim@samsung.com> for S5K3AAEX Camera
 */
                                                                                
#define CHIP_DELAY 0xFF
                                                                                
typedef struct samsung_t{
        unsigned char subaddr;
        unsigned char value;
        unsigned char page;
} ait848_t;

// mihee 080508 start
typedef struct samsung_short_t{
        unsigned short subaddr;
        unsigned short value;
        unsigned short page;
} ait848_short_t;
// mihee 080508 end

#ifdef CONFIG_CPU_S3C24A0A
#define TRY_HIGH_CLOCK 1
#endif

				//***************************************************
				//  name: 	S5K3AAEX EVT2 setfile
				//  ver:		v2.61	
				//  history: 	
				//	v0.0	start from 040908 setfile
				//	v1.0	arange register
				//	v1.01	change MCLK(25Mhz) and Frame rate(7fps)
				//	v2.0	adjust register setting for 3AA EVT2
				//		- color correction, RGB shding off, hsync start position, Mirror, fps
				//		- Color Tuning, YGRPDLY 
				//	v2.1	change Frame rate(7.5fps) and Total gain to x4 
				//		(because of reducing visual noise at low illumination)
				//		- change BPRM AGC Max and FrameAE start 
				//		improve AE speed
				//	v2.2	modify AWB G gain and solve 50hz flicker detection fail in 25MHz 7.5fps
				//	v2.3	Adjust gamma, Dark Slice, white point, Hue gain,
				//		White Balance B control, Y gain On, Digital Clamp On
				//		lower AWB G gain
				//	v2.4	Adjust AE window weight, Y Gamma, WhitePoint, Shading and BPR Max Thres.
				// 	v2.41	Adjust AE/AWB window and AWB internal window boundary to decrease skin color tracking
				// 	v2.411	special version for PSCDS
				// 	v2.412	RGB shading off
				//	v2.5	Lens change STW to Sekonix 
				//		adjust White point and Y shading Coef (RGB shading off)
				//	v2.6	New Tuning because of Full YC off and YCbCr Coef change
				//		Gamma, Dark Slice, color matrix (not use), Color suppress
				//		R Gain and DBPR agc MIN/MAX
				//	v2.61	VCK inversion(data rising)
				//***************************************************
				///////////////////////////////////////////////////
				
//#if defined(CONFIG_VIDEO_SAMSUNG_S5K4CA)
ait848_short_t ait848_preview[] = 
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x0688 },	//#lowlight recovery#
	{ 0x0F12, 0x3100 },	//#R#
	{ 0x002A, 0x06AA },
	{ 0x0F12, 0x2D00 },	//#G#
	{ 0x002A, 0x06CC },
	{ 0x0F12, 0x2000 },	//#B#

	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x02B6 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0001 },
	{ 0xffff, 0xffff },
};

ait848_short_t ait848_init0[] = 
{
   { 0x0028, 0xD000 },
   { 0x002A, 0x1030 },
   { 0x0f12, 0x0000 },
   { 0x002A, 0x0014 },
   { 0x0f12, 0x0001 },
};
//delay 100ms phone SW //

ait848_short_t ait848_init1[] = 
{
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x2700 },
	{ 0x0F12, 0xB510 },
	{ 0x0F12, 0xF000 },
	{ 0x0F12, 0xF889 },
	{ 0x0F12, 0xBC10 },
	{ 0x0F12, 0xBC08 },
	{ 0x0F12, 0x4718 },
	{ 0x0F12, 0xB570 },
	{ 0x0F12, 0x0015 },
	{ 0x0F12, 0x000C },
	{ 0x0F12, 0x0011 },
	{ 0x0F12, 0xF000 },
	{ 0x0F12, 0xF8C4 },
	{ 0x0F12, 0x494D },
	{ 0x0F12, 0x00A8 },
	{ 0x0F12, 0x500C },
	{ 0x0F12, 0xBC70 },
	{ 0x0F12, 0xBC08 },
	{ 0x0F12, 0x4718 },
	{ 0x0F12, 0x0002 },
	{ 0x0F12, 0x484C },
	{ 0x0F12, 0x494A },
	{ 0x0F12, 0xE7EF },
	{ 0x0F12, 0xB510 },
	{ 0x0F12, 0x8802 },
	{ 0x0F12, 0x0004 },
	{ 0x0F12, 0x494A },
	{ 0x0F12, 0x1C50 },
	{ 0x0F12, 0x8020 },
	{ 0x0F12, 0x4849 },
	{ 0x0F12, 0xF7FF },
	{ 0x0F12, 0xFFE7 },
	{ 0x0F12, 0x8822 },
	{ 0x0F12, 0x4948 },
	{ 0x0F12, 0x1C50 },
	{ 0x0F12, 0x8020 },
	{ 0x0F12, 0x4846 },
	{ 0x0F12, 0x1C80 },
	{ 0x0F12, 0xF7FF },
	{ 0x0F12, 0xFFDF },
	{ 0x0F12, 0x8822 },
	{ 0x0F12, 0x4945 },
	{ 0x0F12, 0x1C50 },
	{ 0x0F12, 0x8020 },
	{ 0x0F12, 0x4842 },
	{ 0x0F12, 0x1D00 },
	{ 0x0F12, 0xF7FF },
	{ 0x0F12, 0xFFD7 },
	{ 0x0F12, 0x8822 },
	{ 0x0F12, 0x4942 },
	{ 0x0F12, 0x1C50 },
	{ 0x0F12, 0x8020 },
	{ 0x0F12, 0x20E3 },
	{ 0x0F12, 0x0180 },
	{ 0x0F12, 0xF7FF },
	{ 0x0F12, 0xFFCF },
	{ 0x0F12, 0x8822 },
	{ 0x0F12, 0x493F },
	{ 0x0F12, 0x1C50 },
	{ 0x0F12, 0x8020 },
	{ 0x0F12, 0x483A },
	{ 0x0F12, 0x3008 },
	{ 0x0F12, 0xF7FF },
	{ 0x0F12, 0xFFC7 },
	{ 0x0F12, 0xBC10 },
	{ 0x0F12, 0xBC08 },
	{ 0x0F12, 0x4718 },
	{ 0x0F12, 0x493B },
	{ 0x0F12, 0xB5F1 },
	{ 0x0F12, 0x8808 },
	{ 0x0F12, 0x884A },
	{ 0x0F12, 0xB084 },
	{ 0x0F12, 0x2318 },
	{ 0x0F12, 0x4350 },
	{ 0x0F12, 0x9000 },
	{ 0x0F12, 0x4838 },
	{ 0x0F12, 0x2500 },
	{ 0x0F12, 0x5EC2 },
	{ 0x0F12, 0x231C },
	{ 0x0F12, 0x9201 },
	{ 0x0F12, 0x5EC2 },
	{ 0x0F12, 0x2320 },
	{ 0x0F12, 0x2400 },
	{ 0x0F12, 0x9202 },
	{ 0x0F12, 0x5EC0 },
	{ 0x0F12, 0x9003 },
	{ 0x0F12, 0x4834 },
	{ 0x0F12, 0x8807 },
	{ 0x0F12, 0x4831 },
	{ 0x0F12, 0x00A6 },
	{ 0x0F12, 0x1830 },
	{ 0x0F12, 0x30FF },
	{ 0x0F12, 0x3041 },
	{ 0x0F12, 0x6900 },
	{ 0x0F12, 0x9900 },
	{ 0x0F12, 0x4378 },
	{ 0x0F12, 0x0A00 },
	{ 0x0F12, 0xF000 },
	{ 0x0F12, 0xF876 },
	{ 0x0F12, 0x4A2E },
	{ 0x0F12, 0x0400 },
	{ 0x0F12, 0x0061 },
	{ 0x0F12, 0x1889 },
	{ 0x0F12, 0x0C00 },
	{ 0x0F12, 0x83C8 },
	{ 0x0F12, 0xA901 },
	{ 0x0F12, 0x5989 },
	{ 0x0F12, 0x1C64 },
	{ 0x0F12, 0x4348 },
	{ 0x0F12, 0x1945 },
	{ 0x0F12, 0x2C03 },
	{ 0x0F12, 0xD3E7 },
	{ 0x0F12, 0x3580 },
	{ 0x0F12, 0x0228 },
	{ 0x0F12, 0x0C00 },
	{ 0x0F12, 0x8090 },
	{ 0x0F12, 0x9904 },
	{ 0x0F12, 0x20FF },
	{ 0x0F12, 0x1C40 },
	{ 0x0F12, 0x6008 },
	{ 0x0F12, 0xB005 },
	{ 0x0F12, 0xBCF0 },
	{ 0x0F12, 0xBC08 },
	{ 0x0F12, 0x4718 },
	{ 0x0F12, 0xB570 },
	{ 0x0F12, 0x4C22 },
	{ 0x0F12, 0x4D23 },
	{ 0x0F12, 0x7820 },
	{ 0x0F12, 0x2800 },
	{ 0x0F12, 0xD104 },
	{ 0x0F12, 0x89A8 },
	{ 0x0F12, 0x2800 },
	{ 0x0F12, 0xD001 },
	{ 0x0F12, 0xF000 },
	{ 0x0F12, 0xF858 },
	{ 0x0F12, 0x89A8 },
	{ 0x0F12, 0x491F },
	{ 0x0F12, 0x7020 },
	{ 0x0F12, 0x89E8 },
	{ 0x0F12, 0x7008 },
	{ 0x0F12, 0xE782 },
	{ 0x0F12, 0x2000 },
	{ 0x0F12, 0x2101 },
	{ 0x0F12, 0xB508 },
	{ 0x0F12, 0x9100 },
	{ 0x0F12, 0xF7FF },
	{ 0x0F12, 0xFF80 },
	{ 0x0F12, 0x4668 },
	{ 0x0F12, 0xF7FF },
	{ 0x0F12, 0xFF81 },
	{ 0x0F12, 0x466B },
	{ 0x0F12, 0x881A },
	{ 0x0F12, 0x4918 },
	{ 0x0F12, 0x1C50 },
	{ 0x0F12, 0x9000 },
	{ 0x0F12, 0x4817 },
	{ 0x0F12, 0xF000 },
	{ 0x0F12, 0xF849 },
	{ 0x0F12, 0x466B },
	{ 0x0F12, 0x881A },
	{ 0x0F12, 0x4916 },
	{ 0x0F12, 0x1C50 },
	{ 0x0F12, 0x9000 },
	{ 0x0F12, 0x4815 },
	{ 0x0F12, 0xF000 },
	{ 0x0F12, 0xF841 },
	{ 0x0F12, 0xB001 },
	{ 0x0F12, 0xBC08 },
	{ 0x0F12, 0x4718 },
	{ 0x0F12, 0x2668 },
	{ 0x0F12, 0x7000 },
	{ 0x0F12, 0x2D03 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0xD57C },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x4284 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x38BA },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0xD805 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x4FBF },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x2101 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x68B8 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x1EDC },
	{ 0x0F12, 0x7000 },
	{ 0x0F12, 0x0CAC },
	{ 0x0F12, 0x7000 },
	{ 0x0F12, 0x241C },
	{ 0x0F12, 0x7000 },
	{ 0x0F12, 0x2488 },
	{ 0x0F12, 0x7000 },
	{ 0x0F12, 0x1199 },
	{ 0x0F12, 0x7000 },
	{ 0x0F12, 0x12D4 },
	{ 0x0F12, 0x7000 },
	{ 0x0F12, 0x119A },
	{ 0x0F12, 0x7000 },
	{ 0x0F12, 0x27F7 },
	{ 0x0F12, 0x7000 },
	{ 0x0F12, 0x83C1 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x2785 },
	{ 0x0F12, 0x7000 },
	{ 0x0F12, 0x8EA1 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x4778 },
	{ 0x0F12, 0x46C0 },
	{ 0x0F12, 0xC000 },
	{ 0x0F12, 0xE59F },
	{ 0x0F12, 0xFF1C },
	{ 0x0F12, 0xE12F },
	{ 0x0F12, 0xCD19 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x4778 },
	{ 0x0F12, 0x46C0 },
	{ 0x0F12, 0xF004 },
	{ 0x0F12, 0xE51F },
	{ 0x0F12, 0xD978 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x4778 },
	{ 0x0F12, 0x46C0 },
	{ 0x0F12, 0xC000 },
	{ 0x0F12, 0xE59F },
	{ 0x0F12, 0xFF1C },
	{ 0x0F12, 0xE12F },
	{ 0x0F12, 0x567D },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x4778 },
	{ 0x0F12, 0x46C0 },
	{ 0x0F12, 0xC000 },
	{ 0x0F12, 0xE59F },
	{ 0x0F12, 0xFF1C },
	{ 0x0F12, 0xE12F },
	{ 0x0F12, 0xCD77 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x614D },
	{ 0x0F12, 0x2072 },
	{ 0x0F12, 0x3231 },
	{ 0x0F12, 0x3220 },
	{ 0x0F12, 0x3030 },
	{ 0x0F12, 0x0038 },
	{ 0x0F12, 0x2008 },
	{ 0x0F12, 0x0304 },
	{ 0x0F12, 0xE031 },
	{ 0x0F12, 0x0377 },
	{ 0x0F12, 0x0780 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0028, 0xD000 },
	{ 0x002A, 0x1000 },
	{ 0x0F12, 0x0001 },
	{ 0x0028, 0x7000 },   
	{ 0x002A, 0x0288 },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x1882 },
	{ 0x0F12, 0x0002 },
	{ 0x002A, 0x0314 },
	{ 0x0F12, 0x00C0 },
	{ 0x0F12, 0x00AA },
	{ 0x0F12, 0x0040 },
	{ 0x0F12, 0x0055 },
	{ 0x002A, 0x1716 },
	{ 0x0F12, 0x0004 },         
	{ 0x002A, 0x031C },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x1636 },
	{ 0x0F12, 0x00E6 },  	
	{ 0x002A, 0x0AFA },
	{ 0x0F12, 0x1D4C },       
	{ 0x002A, 0x1838 },
	{ 0x0F12, 0x501B },
	{ 0x002A, 0x1840 },
	{ 0x0F12, 0x000C },
	{ 0x0F12, 0x0190 },
	{ 0x0F12, 0x3FC0 },
	{ 0x0F12, 0x03E8 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0010 },
	{ 0x0F12, 0x0020 },
	{ 0x0F12, 0x0008 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x00C0 },
	{ 0x0F12, 0x00F0 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x03E8 },
	{ 0x0F12, 0x0020 },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x16C8 },
	{ 0x0F12, 0x3FC0 },
	{ 0x0F12, 0x003F },
	{ 0x002A, 0x16B8 },          
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x165C },          
	{ 0x0F12, 0x0050 },
	{ 0x0F12, 0x005F },
	{ 0x0F12, 0x006E },
	{ 0x0F12, 0x0078 },
	{ 0x0F12, 0x0082 },
	{ 0x0F12, 0x008C },
	{ 0x0F12, 0x0096 },
	{ 0x0F12, 0x009B },
	{ 0x0F12, 0x00A0 },
	{ 0x0F12, 0x00A5 },
	{ 0x0F12, 0x00AA },
	{ 0x0F12, 0x00AF },
	{ 0x0F12, 0x00B4 },
	{ 0x0F12, 0x00B9 },
	{ 0x0F12, 0x00BE },
	{ 0x0F12, 0x00C3 },
	{ 0x0F12, 0x00C8 },
	{ 0x0F12, 0x00CD },
	{ 0x0F12, 0x00CF },
	{ 0x0F12, 0x00D1 },
	{ 0x0F12, 0x00D3 },
	{ 0x0F12, 0x00D5 },
	{ 0x0F12, 0x00D7 },
	{ 0x002A, 0x165A },
	{ 0x0F12, 0x0016 },
	{ 0x002A, 0x174C },
	{ 0x0F12, 0x0100 },
	{ 0x002A, 0x163C },    
	{ 0x0F12, 0x00D7 },    //          #default position#  
	{ 0x002A, 0x161C },    //          #below address 70001600#
	{ 0x0F12, 0x84A8 },    //          #usSearch flags# 
	{ 0x002A, 0x1626 },    //          #fine search#
	{ 0x0F12, 0x0004 },    //
	{ 0x0F12, 0x0004 },    //          #fine search#
	{ 0x002A, 0x16CE },    //          #reduction#
	{ 0x0F12, 0x0002 },    //          #overlap ratio#
	{ 0x0F12, 0xFFFF },    //
	{ 0x0028, 0xD000 },
	{ 0x002A, 0x1082 },
	{ 0x0F12, 0x5555 },
	{ 0x0F12, 0x5555 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0040 },

	{ 0x002A, 0xA004 },
	{ 0x0F12, 0x0048 },

	{ 0x002A, 0xA06E },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0xA074 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x0080 },

	{ 0x002A, 0xA070 },
	{ 0x0F12, 0x000B },
	{ 0x0F12, 0x0040 },

	{ 0x002A, 0xA082 },
	{ 0x0F12, 0x0095 },  
	{ 0x0F12, 0x0081 },  

	{ 0x002A, 0xA088 },
	{ 0x0F12, 0x0040 },
	{ 0x0F12, 0x0040 },

	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0020 },

	{ 0x002A, 0xA092 },
	{ 0x0F12, 0x0037 },

	{ 0x0F12, 0x0011 },

	{ 0x002A, 0xA098 },
	{ 0x0F12, 0x00EF },  
	{ 0x0F12, 0x0008 },
	{ 0x0F12, 0x0006 },
	{ 0x0F12, 0x0060 },

	{ 0x0F12, 0x000F },  
	{ 0x002A, 0xA0A4 },
	{ 0x0F12, 0x008D },

	{ 0x002A, 0xA0A8 },
	{ 0x0F12, 0x00DF },
	{ 0x0F12, 0x00F8 },
	{ 0x0F12, 0x0001 },  
	{ 0x0F12, 0x0040 },
	{ 0x0F12, 0x0002 },
	{ 0x0F12, 0x0040 },
	{ 0x0F12, 0x0000 },

	{ 0x0F12, 0x009B },

	{ 0x0F12, 0x0095 },  
	{ 0x0F12, 0x0081 },  

	{ 0x0F12, 0x0004 },  

	{ 0x002A, 0xA0C8 },
	{ 0x0F12, 0x0004 },

	{ 0x002A, 0xA0C0 },
	{ 0x0F12, 0x0007 },

	{ 0x0F12, 0x0006 },
	{ 0x0F12, 0x0068 },

	{ 0x0028, 0x7000 },
	{ 0x002A, 0x1474 },
	{ 0x0F12, 0x0036 },
	{ 0x002A, 0x0B0C },
	{ 0x0F12, 0x0003 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x03A8 },
	{ 0x002A, 0x0610 },
	{ 0x0F12, 0x0682 }, 	//#lt_uPREMaxExp1#
	{ 0x0F12, 0x4E20 },	//#lt_uPREMaxExp2#
	{ 0x002A, 0x060C },	
	{ 0x0F12, 0x0341 },	//#lt_uCAPMaxExp1#
	{ 0x0F12, 0x4650 },	//#lt_uCAPMaxExp2#   
	{ 0x002A, 0x0614 },	
	{ 0x0F12, 0x0200 },	//#lt_uMaxAnGain1#
	{ 0x0F12, 0x04E0 },	//#lt_uMaxAnGain2#
	{ 0x0F12, 0x0100 },  // #lt_uMaxDigGain#

	{ 0x002A, 0x05F8 },
	{ 0x0F12, 0x010E },
	{ 0x0F12, 0x00F5 },

	{ 0x002A, 0x0578 },
	{ 0x0F12, 0x007F },
	{ 0x002A, 0x04C2 },
	{ 0x0F12, 0x0002 },
	{ 0x0F12, 0x0001 },

	{ 0x002A, 0x0B94 },
	{ 0x0F12, 0x0001 },    //# 50Hz flicker table #
	{ 0x0F12, 0x0101 },  
	{ 0x0F12, 0x0302 },  
	{ 0x0F12, 0x0503 },  
	{ 0x0F12, 0x0907 },  
	{ 0x0F12, 0x0016 },  
	{ 0x0F12, 0x0000 },  
	{ 0x0F12, 0x0000 },  
	{ 0x0F12, 0x0000 },  

	{ 0x0F12, 0x0101 },   //# 60Hz flicker table #
	{ 0x0F12, 0x0302 },
	{ 0x0F12, 0x0604 },  	
	{ 0x0F12, 0x1008 },  	
	{ 0x0F12, 0x0016 },  	
	{ 0x0F12, 0x0000 },  	
	{ 0x0F12, 0x0000 },  	
	{ 0x0F12, 0x0000 }, 
	{ 0x002A, 0x0B56 },
	{ 0x0F12, 0x38A4 },

	{ 0x002A, 0x0262 },
	{ 0x0F12, 0x5DC0 },
	{ 0x0F12, 0x0000 },


	{ 0x002A, 0x0276 },
	{ 0x0F12, 0x1D4C },


	{ 0x002A, 0x027A },
	{ 0x0F12, 0x3020 },
	{ 0x002A, 0x0278 },
	{ 0x0F12, 0x29F0 },


	{ 0x002A, 0x0270 },
	{ 0x0F12, 0x0003 },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x026A },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x0288 },
	{ 0x0F12, 0x0001 },


	{ 0x002A, 0x0B28 },
	{ 0x0F12, 0x1B58 },
	{ 0x002A, 0x0B2C },
	{ 0x0F12, 0x1B58 },
	{ 0x002A, 0x0B30 },
	{ 0x0F12, 0x1B58 },
	{ 0x002A, 0x0B00 },
	{ 0x0F12, 0x0000 },


	{ 0x002A, 0x032A },
	{ 0x0F12, 0x0400 },
	{ 0x0F12, 0x0300 },
	{ 0x0F12, 0x0005 },
	{ 0x0F12, 0x3020 },
	{ 0x0F12, 0x29F0 },
	{ 0x002A, 0x033C },
	{ 0x0F12, 0x0682 },   
	{ 0x0F12, 0x02AB },  //# 15 fps # 
	{ 0x002A, 0x0334 },  // 0x0334 (preview)
	{ 0x0F12, 0x0072 }, //0x0042 },  // 0x0042 -> 1 bit pclk inversion...    4 },5 bit Yfirst }, cb/cr first....
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x034A },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },


	{ 0x002A, 0x03F2 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0800 },
	{ 0x0F12, 0x0600 },
	{ 0x0F12, 0x0005 },
	{ 0x002A, 0x0400 },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x03FA },
	{ 0x0F12, 0x3020 },
	{ 0x0F12, 0x29F0 },
	{ 0x002A, 0x0406 },
	{ 0x0F12, 0x0FA0 },  	   // #1388 #
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x03FE },   // 0x03FE ( capture)
	{ 0x0F12, 0x0072 },//0x0042 },   // 0x00 42 -> 1 bit pclk inversion...    4 bit Yfirst },   5bit cb/cr first...
	{ 0x002A, 0x0402 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0002 },



	{ 0x002A, 0x02E2 },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x02E6 },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x02BE },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x02E4 },
	{ 0x0F12, 0x0001 },




	{ 0x002A, 0x0A78 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },


	{ 0x002A, 0x09EE },
	{ 0x0F12, 0x00B1 },
	{ 0x0F12, 0xFF47 },
	{ 0x0F12, 0x00B9 },
	{ 0x0F12, 0x00B1 },


	{ 0x0F12, 0x003B },
	{ 0x0F12, 0x0000 },


	{ 0x002A, 0x0A08 },
	{ 0x0F12, 0x000E },
	{ 0x0F12, 0x0012 },
	{ 0x0F12, 0x0019 },
	{ 0x0F12, 0x0034 },
	{ 0x0F12, 0x0044 },
	{ 0x0F12, 0x0052 },
	{ 0x0F12, 0x0058 },


	{ 0x002A, 0x09E2 },
	{ 0x0F12, 0x0016 },
	{ 0x0F12, 0x001E },
	{ 0x0F12, 0x0024 },
	{ 0x0F12, 0x0038 },
	{ 0x0F12, 0x004C },
	{ 0x0F12, 0x0058 },




	{ 0x002A, 0x1566 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0009 },
	{ 0x0F12, 0x0011 },
	{ 0x0F12, 0x0018 },
	{ 0x0F12, 0x0032 },
	{ 0x0F12, 0x004A },
	{ 0x0F12, 0x0051 },
	{ 0x0F12, 0x0056 },

	{ 0x0F12, 0x010C },
	{ 0x0F12, 0x010C },
	{ 0x0F12, 0x0109 },
	{ 0x0F12, 0x0105 },
	{ 0x0F12, 0x0102 },
	{ 0x0F12, 0x00FB },
	{ 0x0F12, 0x00F8 },
	{ 0x0F12, 0x00F4 },





	{ 0x002A, 0x0A18 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },


	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },


	{ 0x002A, 0x0A5C },
	{ 0x0F12, 0x30F0 },  //#Ram address#
	{ 0x0F12, 0x7000 },

	{ 0x002A, 0x30F0 },  //# shading start #
	{ 0x0F12, 0x0157 },
	{ 0x0F12, 0x0121 },
	{ 0x0F12, 0x00EC },
	{ 0x0F12, 0x00C2 },
	{ 0x0F12, 0x00A0 },
	{ 0x0F12, 0x008E },
	{ 0x0F12, 0x0089 },
	{ 0x0F12, 0x0091 },
	{ 0x0F12, 0x00AA },
	{ 0x0F12, 0x00CD },
	{ 0x0F12, 0x00F9 },
	{ 0x0F12, 0x0130 },
	{ 0x0F12, 0x016B },
	{ 0x0F12, 0x012D },
	{ 0x0F12, 0x00F7 },
	{ 0x0F12, 0x00BF },
	{ 0x0F12, 0x0091 },
	{ 0x0F12, 0x006E },
	{ 0x0F12, 0x005B },
	{ 0x0F12, 0x0056 },
	{ 0x0F12, 0x0060 },
	{ 0x0F12, 0x0079 },
	{ 0x0F12, 0x009F },
	{ 0x0F12, 0x00CF },
	{ 0x0F12, 0x0107 },
	{ 0x0F12, 0x014A },
	{ 0x0F12, 0x010A },
	{ 0x0F12, 0x00D3 },
	{ 0x0F12, 0x0097 },
	{ 0x0F12, 0x0067 },
	{ 0x0F12, 0x0044 },
	{ 0x0F12, 0x0030 },
	{ 0x0F12, 0x002C },
	{ 0x0F12, 0x0036 },
	{ 0x0F12, 0x004F },
	{ 0x0F12, 0x0077 },
	{ 0x0F12, 0x00AB },
	{ 0x0F12, 0x00E9 },
	{ 0x0F12, 0x0129 },
	{ 0x0F12, 0x00F4 },
	{ 0x0F12, 0x00BB },
	{ 0x0F12, 0x007C },
	{ 0x0F12, 0x004A },
	{ 0x0F12, 0x0027 },
	{ 0x0F12, 0x0014 },
	{ 0x0F12, 0x0010 },
	{ 0x0F12, 0x001A },
	{ 0x0F12, 0x0034 },
	{ 0x0F12, 0x005D },
	{ 0x0F12, 0x0094 },
	{ 0x0F12, 0x00D3 },
	{ 0x0F12, 0x0115 },
	{ 0x0F12, 0x00E6 },
	{ 0x0F12, 0x00AC },
	{ 0x0F12, 0x006C },
	{ 0x0F12, 0x0039 },
	{ 0x0F12, 0x0016 },
	{ 0x0F12, 0x0005 },
	{ 0x0F12, 0x0002 },
	{ 0x0F12, 0x000C },
	{ 0x0F12, 0x0025 },
	{ 0x0F12, 0x004D },
	{ 0x0F12, 0x0085 },
	{ 0x0F12, 0x00C6 },
	{ 0x0F12, 0x0108 },
	{ 0x0F12, 0x00E4 },
	{ 0x0F12, 0x00AA },
	{ 0x0F12, 0x0069 },
	{ 0x0F12, 0x0037 },
	{ 0x0F12, 0x0013 },
	{ 0x0F12, 0x0003 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0009 },
	{ 0x0F12, 0x0023 },
	{ 0x0F12, 0x004C },
	{ 0x0F12, 0x0084 },
	{ 0x0F12, 0x00C6 },
	{ 0x0F12, 0x0108 },
	{ 0x0F12, 0x00EB },
	{ 0x0F12, 0x00B1 },
	{ 0x0F12, 0x0073 },
	{ 0x0F12, 0x0040 },
	{ 0x0F12, 0x001C },
	{ 0x0F12, 0x000A },
	{ 0x0F12, 0x0007 },
	{ 0x0F12, 0x0012 },
	{ 0x0F12, 0x002E },
	{ 0x0F12, 0x0059 },
	{ 0x0F12, 0x0091 },
	{ 0x0F12, 0x00D3 },
	{ 0x0F12, 0x0114 },
	{ 0x0F12, 0x00FC },
	{ 0x0F12, 0x00C6 },
	{ 0x0F12, 0x0088 },
	{ 0x0F12, 0x0057 },
	{ 0x0F12, 0x0033 },
	{ 0x0F12, 0x0020 },
	{ 0x0F12, 0x001D },
	{ 0x0F12, 0x0029 },
	{ 0x0F12, 0x0046 },
	{ 0x0F12, 0x0072 },
	{ 0x0F12, 0x00A9 },
	{ 0x0F12, 0x00E8 },
	{ 0x0F12, 0x0129 },
	{ 0x0F12, 0x0116 },
	{ 0x0F12, 0x00E2 },
	{ 0x0F12, 0x00A7 },
	{ 0x0F12, 0x0078 },
	{ 0x0F12, 0x0055 },
	{ 0x0F12, 0x0043 },
	{ 0x0F12, 0x0040 },
	{ 0x0F12, 0x004D },
	{ 0x0F12, 0x0069 },
	{ 0x0F12, 0x0096 },
	{ 0x0F12, 0x00C9 },
	{ 0x0F12, 0x0105 },
	{ 0x0F12, 0x0145 },
	{ 0x0F12, 0x013B },
	{ 0x0F12, 0x0108 },
	{ 0x0F12, 0x00D2 },
	{ 0x0F12, 0x00A6 },
	{ 0x0F12, 0x0085 },
	{ 0x0F12, 0x0075 },
	{ 0x0F12, 0x0072 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x009B },
	{ 0x0F12, 0x00C6 },
	{ 0x0F12, 0x00F5 },
	{ 0x0F12, 0x012C },
	{ 0x0F12, 0x0166 },
	{ 0x0F12, 0x0165 },
	{ 0x0F12, 0x0137 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x00D9 },
	{ 0x0F12, 0x00BC },
	{ 0x0F12, 0x00AC },
	{ 0x0F12, 0x00AA },
	{ 0x0F12, 0x00B6 },
	{ 0x0F12, 0x00D0 },
	{ 0x0F12, 0x00F5 },
	{ 0x0F12, 0x0122 },
	{ 0x0F12, 0x0155 },
	{ 0x0F12, 0x0188 },
	{ 0x0F12, 0x0118 },
	{ 0x0F12, 0x00EA },
	{ 0x0F12, 0x00BE },
	{ 0x0F12, 0x009D },
	{ 0x0F12, 0x0083 },
	{ 0x0F12, 0x0074 },
	{ 0x0F12, 0x0070 },
	{ 0x0F12, 0x0075 },
	{ 0x0F12, 0x0087 },
	{ 0x0F12, 0x00A2 },
	{ 0x0F12, 0x00C2 },
	{ 0x0F12, 0x00F2 },
	{ 0x0F12, 0x012D },
	{ 0x0F12, 0x00F8 },
	{ 0x0F12, 0x00D1 },
	{ 0x0F12, 0x00A1 },
	{ 0x0F12, 0x007C },
	{ 0x0F12, 0x0061 },
	{ 0x0F12, 0x0051 },
	{ 0x0F12, 0x004D },
	{ 0x0F12, 0x0054 },
	{ 0x0F12, 0x0066 },
	{ 0x0F12, 0x0083 },
	{ 0x0F12, 0x00A7 },
	{ 0x0F12, 0x00D6 },
	{ 0x0F12, 0x010F },
	{ 0x0F12, 0x00DA },
	{ 0x0F12, 0x00B2 },
	{ 0x0F12, 0x007F },
	{ 0x0F12, 0x0059 },
	{ 0x0F12, 0x003D },
	{ 0x0F12, 0x002B },
	{ 0x0F12, 0x0028 },
	{ 0x0F12, 0x0030 },
	{ 0x0F12, 0x0043 },
	{ 0x0F12, 0x0061 },
	{ 0x0F12, 0x0089 },
	{ 0x0F12, 0x00B9 },
	{ 0x0F12, 0x00F1 },
	{ 0x0F12, 0x00C5 },
	{ 0x0F12, 0x009D },
	{ 0x0F12, 0x0068 },
	{ 0x0F12, 0x003F },
	{ 0x0F12, 0x0023 },
	{ 0x0F12, 0x0012 },
	{ 0x0F12, 0x000F },
	{ 0x0F12, 0x0018 },
	{ 0x0F12, 0x002C },
	{ 0x0F12, 0x004C },
	{ 0x0F12, 0x0076 },
	{ 0x0F12, 0x00A7 },
	{ 0x0F12, 0x00DE },
	{ 0x0F12, 0x00B8 },
	{ 0x0F12, 0x0090 },
	{ 0x0F12, 0x005B },
	{ 0x0F12, 0x0031 },
	{ 0x0F12, 0x0015 },
	{ 0x0F12, 0x0006 },
	{ 0x0F12, 0x0004 },
	{ 0x0F12, 0x000C },
	{ 0x0F12, 0x0020 },
	{ 0x0F12, 0x0040 },
	{ 0x0F12, 0x006C },
	{ 0x0F12, 0x009D },
	{ 0x0F12, 0x00D3 },
	{ 0x0F12, 0x00B6 },
	{ 0x0F12, 0x008D },
	{ 0x0F12, 0x0059 },
	{ 0x0F12, 0x002F },
	{ 0x0F12, 0x0012 },
	{ 0x0F12, 0x0004 },
	{ 0x0F12, 0x0002 },
	{ 0x0F12, 0x000A },
	{ 0x0F12, 0x0020 },
	{ 0x0F12, 0x0041 },
	{ 0x0F12, 0x006C },
	{ 0x0F12, 0x00A0 },
	{ 0x0F12, 0x00D1 },
	{ 0x0F12, 0x00BC },
	{ 0x0F12, 0x0094 },
	{ 0x0F12, 0x0061 },
	{ 0x0F12, 0x0039 },
	{ 0x0F12, 0x001A },
	{ 0x0F12, 0x000B },
	{ 0x0F12, 0x0009 },
	{ 0x0F12, 0x0012 },
	{ 0x0F12, 0x0029 },
	{ 0x0F12, 0x004B },
	{ 0x0F12, 0x0075 },
	{ 0x0F12, 0x00AA },
	{ 0x0F12, 0x00DE },
	{ 0x0F12, 0x00CD },
	{ 0x0F12, 0x00A5 },
	{ 0x0F12, 0x0073 },
	{ 0x0F12, 0x004C },
	{ 0x0F12, 0x002F },
	{ 0x0F12, 0x001F },
	{ 0x0F12, 0x001D },
	{ 0x0F12, 0x0025 },
	{ 0x0F12, 0x003E },
	{ 0x0F12, 0x0060 },
	{ 0x0F12, 0x0089 },
	{ 0x0F12, 0x00B8 },
	{ 0x0F12, 0x00EF },
	{ 0x0F12, 0x00E5 },
	{ 0x0F12, 0x00BF },
	{ 0x0F12, 0x008F },
	{ 0x0F12, 0x0069 },
	{ 0x0F12, 0x004F },
	{ 0x0F12, 0x003F },
	{ 0x0F12, 0x003C },
	{ 0x0F12, 0x0047 },
	{ 0x0F12, 0x005C },
	{ 0x0F12, 0x007F },
	{ 0x0F12, 0x00A5 },
	{ 0x0F12, 0x00D1 },
	{ 0x0F12, 0x0108 },
	{ 0x0F12, 0x0108 },
	{ 0x0F12, 0x00E2 },
	{ 0x0F12, 0x00B4 },
	{ 0x0F12, 0x0092 },
	{ 0x0F12, 0x0079 },
	{ 0x0F12, 0x006A },
	{ 0x0F12, 0x0068 },
	{ 0x0F12, 0x0072 },
	{ 0x0F12, 0x0086 },
	{ 0x0F12, 0x00A7 },
	{ 0x0F12, 0x00C9 },
	{ 0x0F12, 0x00F1 },
	{ 0x0F12, 0x0123 },
	{ 0x0F12, 0x013B },
	{ 0x0F12, 0x010E },
	{ 0x0F12, 0x00DF },
	{ 0x0F12, 0x00C0 },
	{ 0x0F12, 0x00A9 },
	{ 0x0F12, 0x009C },
	{ 0x0F12, 0x009A },
	{ 0x0F12, 0x00A4 },
	{ 0x0F12, 0x00B6 },
	{ 0x0F12, 0x00D1 },
	{ 0x0F12, 0x00F3 },
	{ 0x0F12, 0x011A },
	{ 0x0F12, 0x0140 },
	{ 0x0F12, 0x0114 },
	{ 0x0F12, 0x00E7 },
	{ 0x0F12, 0x00B9 },
	{ 0x0F12, 0x0097 },
	{ 0x0F12, 0x007E },
	{ 0x0F12, 0x0070 },
	{ 0x0F12, 0x006E },
	{ 0x0F12, 0x0075 },
	{ 0x0F12, 0x008A },
	{ 0x0F12, 0x00A8 },
	{ 0x0F12, 0x00CA },
	{ 0x0F12, 0x00FA },
	{ 0x0F12, 0x0133 },
	{ 0x0F12, 0x00F6 },
	{ 0x0F12, 0x00CE },
	{ 0x0F12, 0x009E },
	{ 0x0F12, 0x0079 },
	{ 0x0F12, 0x005D },
	{ 0x0F12, 0x004F },
	{ 0x0F12, 0x004C },
	{ 0x0F12, 0x0054 },
	{ 0x0F12, 0x0068 },
	{ 0x0F12, 0x0089 },
	{ 0x0F12, 0x00B0 },
	{ 0x0F12, 0x00DF },
	{ 0x0F12, 0x0118 },
	{ 0x0F12, 0x00D8 },
	{ 0x0F12, 0x00B1 },
	{ 0x0F12, 0x007E },
	{ 0x0F12, 0x0057 },
	{ 0x0F12, 0x003B },
	{ 0x0F12, 0x002A },
	{ 0x0F12, 0x0028 },
	{ 0x0F12, 0x0030 },
	{ 0x0F12, 0x0045 },
	{ 0x0F12, 0x0065 },
	{ 0x0F12, 0x0090 },
	{ 0x0F12, 0x00C0 },
	{ 0x0F12, 0x00F7 },
	{ 0x0F12, 0x00C4 },
	{ 0x0F12, 0x009D },
	{ 0x0F12, 0x0068 },
	{ 0x0F12, 0x003F },
	{ 0x0F12, 0x0022 },
	{ 0x0F12, 0x0011 },
	{ 0x0F12, 0x000F },
	{ 0x0F12, 0x0018 },
	{ 0x0F12, 0x002D },
	{ 0x0F12, 0x004E },
	{ 0x0F12, 0x007A },
	{ 0x0F12, 0x00AC },
	{ 0x0F12, 0x00E1 },
	{ 0x0F12, 0x00B8 },
	{ 0x0F12, 0x0090 },
	{ 0x0F12, 0x005B },
	{ 0x0F12, 0x0031 },
	{ 0x0F12, 0x0013 },
	{ 0x0F12, 0x0005 },
	{ 0x0F12, 0x0002 },
	{ 0x0F12, 0x000A },
	{ 0x0F12, 0x001F },
	{ 0x0F12, 0x003F },
	{ 0x0F12, 0x006B },
	{ 0x0F12, 0x009D },
	{ 0x0F12, 0x00D0 },
	{ 0x0F12, 0x00B4 },
	{ 0x0F12, 0x008C },
	{ 0x0F12, 0x0058 },
	{ 0x0F12, 0x002E },
	{ 0x0F12, 0x0010 },
	{ 0x0F12, 0x0003 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0007 },
	{ 0x0F12, 0x001C },
	{ 0x0F12, 0x003C },
	{ 0x0F12, 0x0066 },
	{ 0x0F12, 0x0099 },
	{ 0x0F12, 0x00CA },
	{ 0x0F12, 0x00BA },
	{ 0x0F12, 0x0093 },
	{ 0x0F12, 0x0060 },
	{ 0x0F12, 0x0037 },
	{ 0x0F12, 0x0018 },
	{ 0x0F12, 0x0008 },
	{ 0x0F12, 0x0006 },
	{ 0x0F12, 0x000D },
	{ 0x0F12, 0x0023 },
	{ 0x0F12, 0x0042 },
	{ 0x0F12, 0x006B },
	{ 0x0F12, 0x009D },
	{ 0x0F12, 0x00D1 },
	{ 0x0F12, 0x00C9 },
	{ 0x0F12, 0x00A3 },
	{ 0x0F12, 0x0071 },
	{ 0x0F12, 0x0049 },
	{ 0x0F12, 0x002B },
	{ 0x0F12, 0x001A },
	{ 0x0F12, 0x0017 },
	{ 0x0F12, 0x001E },
	{ 0x0F12, 0x0034 },
	{ 0x0F12, 0x0053 },
	{ 0x0F12, 0x007A },
	{ 0x0F12, 0x00A7 },
	{ 0x0F12, 0x00DD },
	{ 0x0F12, 0x00E1 },
	{ 0x0F12, 0x00BC },
	{ 0x0F12, 0x008B },
	{ 0x0F12, 0x0066 },
	{ 0x0F12, 0x004A },
	{ 0x0F12, 0x0039 },
	{ 0x0F12, 0x0035 },
	{ 0x0F12, 0x003D },
	{ 0x0F12, 0x004F },
	{ 0x0F12, 0x006E },
	{ 0x0F12, 0x0090 },
	{ 0x0F12, 0x00BB },
	{ 0x0F12, 0x00F3 },
	{ 0x0F12, 0x0103 },
	{ 0x0F12, 0x00DE },
	{ 0x0F12, 0x00B0 },
	{ 0x0F12, 0x008D },
	{ 0x0F12, 0x0073 },
	{ 0x0F12, 0x0063 },
	{ 0x0F12, 0x005F },
	{ 0x0F12, 0x0066 },
	{ 0x0F12, 0x0076 },
	{ 0x0F12, 0x0092 },
	{ 0x0F12, 0x00B2 },
	{ 0x0F12, 0x00D9 },
	{ 0x0F12, 0x010B },
	{ 0x0F12, 0x0133 },
	{ 0x0F12, 0x0109 },
	{ 0x0F12, 0x00D9 },
	{ 0x0F12, 0x00BA },
	{ 0x0F12, 0x00A2 },
	{ 0x0F12, 0x0093 },
	{ 0x0F12, 0x008F },
	{ 0x0F12, 0x0095 },
	{ 0x0F12, 0x00A4 },
	{ 0x0F12, 0x00BA },
	{ 0x0F12, 0x00DA },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0128 },
	{ 0x0F12, 0x00F2 },
	{ 0x0F12, 0x00CE },
	{ 0x0F12, 0x00A4 },
	{ 0x0F12, 0x0085 },
	{ 0x0F12, 0x006E },
	{ 0x0F12, 0x0063 },
	{ 0x0F12, 0x0062 },
	{ 0x0F12, 0x006B },
	{ 0x0F12, 0x0081 },
	{ 0x0F12, 0x009E },
	{ 0x0F12, 0x00C2 },
	{ 0x0F12, 0x00F1 },
	{ 0x0F12, 0x0125 },
	{ 0x0F12, 0x00D6 },
	{ 0x0F12, 0x00B5 },
	{ 0x0F12, 0x0089 },
	{ 0x0F12, 0x0068 },
	{ 0x0F12, 0x0050 },
	{ 0x0F12, 0x0044 },
	{ 0x0F12, 0x0043 },
	{ 0x0F12, 0x004C },
	{ 0x0F12, 0x0062 },
	{ 0x0F12, 0x0083 },
	{ 0x0F12, 0x00A9 },
	{ 0x0F12, 0x00D7 },
	{ 0x0F12, 0x010B },
	{ 0x0F12, 0x00BA },
	{ 0x0F12, 0x009A },
	{ 0x0F12, 0x006C },
	{ 0x0F12, 0x0049 },
	{ 0x0F12, 0x0031 },
	{ 0x0F12, 0x0023 },
	{ 0x0F12, 0x0022 },
	{ 0x0F12, 0x002C },
	{ 0x0F12, 0x0042 },
	{ 0x0F12, 0x0061 },
	{ 0x0F12, 0x0089 },
	{ 0x0F12, 0x00B9 },
	{ 0x0F12, 0x00EC },
	{ 0x0F12, 0x00AA },
	{ 0x0F12, 0x0088 },
	{ 0x0F12, 0x0059 },
	{ 0x0F12, 0x0035 },
	{ 0x0F12, 0x001B },
	{ 0x0F12, 0x000E },
	{ 0x0F12, 0x000C },
	{ 0x0F12, 0x0016 },
	{ 0x0F12, 0x002C },
	{ 0x0F12, 0x004B },
	{ 0x0F12, 0x0074 },
	{ 0x0F12, 0x00A4 },
	{ 0x0F12, 0x00D5 },
	{ 0x0F12, 0x009E },
	{ 0x0F12, 0x007D },
	{ 0x0F12, 0x004D },
	{ 0x0F12, 0x0029 },
	{ 0x0F12, 0x000F },
	{ 0x0F12, 0x0003 },
	{ 0x0F12, 0x0001 },
	{ 0x0F12, 0x000A },
	{ 0x0F12, 0x001D },
	{ 0x0F12, 0x003C },
	{ 0x0F12, 0x0064 },
	{ 0x0F12, 0x0093 },
	{ 0x0F12, 0x00C5 },
	{ 0x0F12, 0x009D },
	{ 0x0F12, 0x007B },
	{ 0x0F12, 0x004C },
	{ 0x0F12, 0x0028 },
	{ 0x0F12, 0x000D },
	{ 0x0F12, 0x0001 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0007 },
	{ 0x0F12, 0x001A },
	{ 0x0F12, 0x0037 },
	{ 0x0F12, 0x005E },
	{ 0x0F12, 0x008C },
	{ 0x0F12, 0x00BC },
	{ 0x0F12, 0x00A3 },
	{ 0x0F12, 0x0083 },
	{ 0x0F12, 0x0054 },
	{ 0x0F12, 0x0030 },
	{ 0x0F12, 0x0015 },
	{ 0x0F12, 0x0008 },
	{ 0x0F12, 0x0006 },
	{ 0x0F12, 0x000D },
	{ 0x0F12, 0x0021 },
	{ 0x0F12, 0x003E },
	{ 0x0F12, 0x0063 },
	{ 0x0F12, 0x0091 },
	{ 0x0F12, 0x00C1 },
	{ 0x0F12, 0x00B2 },
	{ 0x0F12, 0x0093 },
	{ 0x0F12, 0x0065 },
	{ 0x0F12, 0x0043 },
	{ 0x0F12, 0x0028 },
	{ 0x0F12, 0x0019 },
	{ 0x0F12, 0x0016 },
	{ 0x0F12, 0x001E },
	{ 0x0F12, 0x0032 },
	{ 0x0F12, 0x004E },
	{ 0x0F12, 0x0072 },
	{ 0x0F12, 0x009C },
	{ 0x0F12, 0x00CE },
	{ 0x0F12, 0x00C9 },
	{ 0x0F12, 0x00AB },
	{ 0x0F12, 0x007F },
	{ 0x0F12, 0x005E },
	{ 0x0F12, 0x0045 },
	{ 0x0F12, 0x0037 },
	{ 0x0F12, 0x0033 },
	{ 0x0F12, 0x003B },
	{ 0x0F12, 0x004D },
	{ 0x0F12, 0x0069 },
	{ 0x0F12, 0x0088 },
	{ 0x0F12, 0x00B1 },
	{ 0x0F12, 0x00E3 },
	{ 0x0F12, 0x00EC },
	{ 0x0F12, 0x00CB },
	{ 0x0F12, 0x00A2 },
	{ 0x0F12, 0x0084 },
	{ 0x0F12, 0x006C },
	{ 0x0F12, 0x005F },
	{ 0x0F12, 0x005B },
	{ 0x0F12, 0x0063 },
	{ 0x0F12, 0x0072 },
	{ 0x0F12, 0x008B },
	{ 0x0F12, 0x00A9 },
	{ 0x0F12, 0x00CF },
	{ 0x0F12, 0x00FE },
	{ 0x0F12, 0x0118 },
	{ 0x0F12, 0x00F5 },
	{ 0x0F12, 0x00C9 },
	{ 0x0F12, 0x00AE },
	{ 0x0F12, 0x0098 },
	{ 0x0F12, 0x008C },
	{ 0x0F12, 0x0089 },
	{ 0x0F12, 0x008E },
	{ 0x0F12, 0x009C },
	{ 0x0F12, 0x00B2 },
	{ 0x0F12, 0x00CF },
	{ 0x0F12, 0x00F6 },
	{ 0x0F12, 0x011E },     // # shading end #
	         
	         
	         
	{ 0x002A, 0x0688 },  		//#gamma#
	{ 0x0F12, 0x3100 },
	{ 0x0F12, 0x5E3A },
	{ 0x0F12, 0x5273 },
	{ 0x0F12, 0x373D },
	{ 0x0F12, 0x2C2A },
	{ 0x0F12, 0x2925 },
	{ 0x0F12, 0x2322 },
	{ 0x0F12, 0x1519 },
	{ 0x0F12, 0x1815 },
	{ 0x0F12, 0x0A09 },
	{ 0x0F12, 0x0A0C },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x0909 },
	{ 0x0F12, 0x0A09 },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x070B },
	{ 0x0F12, 0x0608 },
	{ 0x0F12, 0x2D00 },
	{ 0x0F12, 0x6537 },
	{ 0x0F12, 0x5773 },
	{ 0x0F12, 0x373B },
	{ 0x0F12, 0x2E29 },
	{ 0x0F12, 0x2829 },
	{ 0x0F12, 0x2125 },
	{ 0x0F12, 0x161B },
	{ 0x0F12, 0x1012 },
	{ 0x0F12, 0x0A09 },
	{ 0x0F12, 0x0A0C },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x0909 },
	{ 0x0F12, 0x0A09 },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x070B },
	{ 0x0F12, 0x0608 },
	{ 0x0F12, 0x2000 },
	{ 0x0F12, 0x672A },
	{ 0x0F12, 0x6279 },
	{ 0x0F12, 0x3C3B },
	{ 0x0F12, 0x2D2A },
	{ 0x0F12, 0x2829 },
	{ 0x0F12, 0x2127 },
	{ 0x0F12, 0x161B },
	{ 0x0F12, 0x0F12 },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x0A0C },
	{ 0x0F12, 0x090A },
	{ 0x0F12, 0x090A },
	{ 0x0F12, 0x0909 },
	{ 0x0F12, 0x090B },
	{ 0x0F12, 0x070C },
	{ 0x0F12, 0x0509 },


	{ 0x0F12, 0x1E00 }, //  # gamma #
	{ 0x0F12, 0x7D29 },
	{ 0x0F12, 0x5776 },
	{ 0x0F12, 0x383B },
	{ 0x0F12, 0x2E29 },
	{ 0x0F12, 0x2727 },
	{ 0x0F12, 0x1E1D },
	{ 0x0F12, 0x1619 },
	{ 0x0F12, 0x1317 },
	{ 0x0F12, 0x0D0F },
	{ 0x0F12, 0x0A0C },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x0909 },
	{ 0x0F12, 0x0A09 },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x070B },
	{ 0x0F12, 0x0608 }, 
	{ 0x0F12, 0x1E00 },
	{ 0x0F12, 0x7D29 },
	{ 0x0F12, 0x5776 },
	{ 0x0F12, 0x383B },
	{ 0x0F12, 0x2E29 },
	{ 0x0F12, 0x2727 },
	{ 0x0F12, 0x1E1D },
	{ 0x0F12, 0x1619 },
	{ 0x0F12, 0x1317 },
	{ 0x0F12, 0x0D0F },
	{ 0x0F12, 0x0A0C },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x0909 },
	{ 0x0F12, 0x0A09 },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x070B },
	{ 0x0F12, 0x0608 },
	{ 0x0F12, 0x1F00 },
	{ 0x0F12, 0x7D28 },
	{ 0x0F12, 0x5776 },
	{ 0x0F12, 0x383B },
	{ 0x0F12, 0x2E29 },
	{ 0x0F12, 0x2727 },
	{ 0x0F12, 0x1E1D },
	{ 0x0F12, 0x1619 },
	{ 0x0F12, 0x1317 },
	{ 0x0F12, 0x0D0F },
	{ 0x0F12, 0x0A0C },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x0909 },
	{ 0x0F12, 0x0A09 },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x070B },
	{ 0x0F12, 0x0608 },
	         
	{ 0x0F12, 0x1E00 },   //# gamma #
	{ 0x0F12, 0x7D29 },
	{ 0x0F12, 0x5776 },
	{ 0x0F12, 0x383B },
	{ 0x0F12, 0x2E29 },
	{ 0x0F12, 0x2727 },
	{ 0x0F12, 0x1E1D },
	{ 0x0F12, 0x1619 },
	{ 0x0F12, 0x1317 },
	{ 0x0F12, 0x0D0F },
	{ 0x0F12, 0x0A0C },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x0909 },
	{ 0x0F12, 0x0A09 },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x070B },
	{ 0x0F12, 0x0608 },
	{ 0x0F12, 0x1E00 },
	{ 0x0F12, 0x7D29 },
	{ 0x0F12, 0x5776 },
	{ 0x0F12, 0x383B },
	{ 0x0F12, 0x2E29 },
	{ 0x0F12, 0x2727 },
	{ 0x0F12, 0x1E1D },
	{ 0x0F12, 0x1619 },
	{ 0x0F12, 0x1317 },
	{ 0x0F12, 0x0D0F },
	{ 0x0F12, 0x0A0C },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x0909 },
	{ 0x0F12, 0x0A09 },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x070B },
	{ 0x0F12, 0x0608 },            
	{ 0x0F12, 0x1F00 },
	{ 0x0F12, 0x7D28 },
	{ 0x0F12, 0x5776 },
	{ 0x0F12, 0x383B },
	{ 0x0F12, 0x2E29 },
	{ 0x0F12, 0x2727 },
	{ 0x0F12, 0x1E1D },
	{ 0x0F12, 0x1619 },
	{ 0x0F12, 0x1317 },
	{ 0x0F12, 0x0D0F },
	{ 0x0F12, 0x0A0C },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x0909 },
	{ 0x0F12, 0x0A09 },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x070B },
	{ 0x0F12, 0x0608 },
	         
	         
	         
	         
	{ 0x002A, 0x1090 },
	{ 0x0F12, 0x0014 },
	{ 0x002A, 0x1094 },
	{ 0x0F12, 0x0014 },
	         
	{ 0x002A, 0x10EC },
	{ 0x0F12, 0x0007 },
	         
	{ 0x002A, 0x10F2 },
	{ 0x0F12, 0x0007 },
	{ 0x0F12, 0x000E },
	         
	         
	         
	{ 0x002A, 0x0CE4 },
	{ 0x0F12, 0x0365 },
	{ 0x0F12, 0x038C },
	{ 0x0F12, 0x030C },
	{ 0x0F12, 0x038B },
	{ 0x0F12, 0x02E0 },
	{ 0x0F12, 0x037D },
	{ 0x0F12, 0x02CB },
	{ 0x0F12, 0x036E },
	{ 0x0F12, 0x02BA },
	{ 0x0F12, 0x0350 },
	{ 0x0F12, 0x02AB },
	{ 0x0F12, 0x0331 },
	{ 0x0F12, 0x029D },
	{ 0x0F12, 0x0316 },
	{ 0x0F12, 0x028D },
	{ 0x0F12, 0x0301 },
	{ 0x0F12, 0x027A },
	{ 0x0F12, 0x02EE },
	{ 0x0F12, 0x0268 },
	{ 0x0F12, 0x02E0 },
	{ 0x0F12, 0x0255 },
	{ 0x0F12, 0x02D3 },
	{ 0x0F12, 0x024D },
	{ 0x0F12, 0x02C8 },
	{ 0x0F12, 0x0246 },
	{ 0x0F12, 0x02BC },
	{ 0x0F12, 0x023D },
	{ 0x0F12, 0x02AF },
	{ 0x0F12, 0x0233 },
	{ 0x0F12, 0x02A2 },
	{ 0x0F12, 0x0225 },
	{ 0x0F12, 0x0291 },
	{ 0x0F12, 0x0212 },
	{ 0x0F12, 0x0281 },
	{ 0x0F12, 0x0205 },
	{ 0x0F12, 0x0270 },
	{ 0x0F12, 0x01F9 },
	{ 0x0F12, 0x0264 },
	{ 0x0F12, 0x01EF },
	{ 0x0F12, 0x025B },
	{ 0x0F12, 0x01DE },
	{ 0x0F12, 0x024D },
	{ 0x0F12, 0x01D2 },
	{ 0x0F12, 0x023C },
	{ 0x0F12, 0x01CA },
	{ 0x0F12, 0x0229 },
	{ 0x0F12, 0x01C8 },
	{ 0x0F12, 0x021D },
	{ 0x0F12, 0x01C9 },
	{ 0x0F12, 0x0210 },
	{ 0x0F12, 0x01D2 },
	{ 0x0F12, 0x0202 },
	{ 0x0F12, 0x01E1 },
	{ 0x0F12, 0x01EF },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },


	{ 0x0F12, 0x0004 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x001B },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0152 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0020 },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x0D98 },
	{ 0x0F12, 0x00E0 },
	{ 0x002A, 0x0D96 },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x0DAC },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },



	{ 0x002A, 0x0E00 },
	{ 0x0F12, 0x025B },   	//#awb outdoor#
	{ 0x0F12, 0x026C },
	{ 0x0F12, 0x0246 },
	{ 0x0F12, 0x027C },
	{ 0x0F12, 0x0238 },
	{ 0x0F12, 0x027C },
	{ 0x0F12, 0x022B },
	{ 0x0F12, 0x0279 },
	{ 0x0F12, 0x021B },
	{ 0x0F12, 0x0273 },
	{ 0x0F12, 0x0209 },
	{ 0x0F12, 0x026B },
	{ 0x0F12, 0x01F8 },
	{ 0x0F12, 0x0261 },
	{ 0x0F12, 0x01EF },
	{ 0x0F12, 0x0258 },
	{ 0x0F12, 0x01E6 },
	{ 0x0F12, 0x024A },
	{ 0x0F12, 0x01E7 },
	{ 0x0F12, 0x023D },
	{ 0x0F12, 0x01EE },
	{ 0x0F12, 0x0228 },
	{ 0x0F12, 0x01F9 },
	{ 0x0F12, 0x0215 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },


	{ 0x0F12, 0x0004 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x000C },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x022B },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0030 },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x0E78 },
	{ 0x0F12, 0x00C0 },
	{ 0x002A, 0x0E76 },
	{ 0x0F12, 0x0000 },



	{ 0x002A, 0x0EE0 },
	{ 0x0F12, 0x02EC },
	{ 0x0F12, 0x0462 },
	{ 0x0F12, 0x02C9 },
	{ 0x0F12, 0x0462 },
	{ 0x0F12, 0x02A6 },
	{ 0x0F12, 0x0462 },
	{ 0x0F12, 0x0283 },
	{ 0x0F12, 0x0462 },
	{ 0x0F12, 0x0260 },
	{ 0x0F12, 0x0462 },
	{ 0x0F12, 0x023D },
	{ 0x0F12, 0x0462 },
	{ 0x0F12, 0x021B },
	{ 0x0F12, 0x0462 },
	{ 0x0F12, 0x01F8 },
	{ 0x0F12, 0x0462 },
	{ 0x0F12, 0x01D5 },
	{ 0x0F12, 0x0457 },
	{ 0x0F12, 0x01B2 },
	{ 0x0F12, 0x0422 },
	{ 0x0F12, 0x018F },
	{ 0x0F12, 0x03EC },
	{ 0x0F12, 0x016C },
	{ 0x0F12, 0x03B7 },
	{ 0x0F12, 0x014A },
	{ 0x0F12, 0x0381 },
	{ 0x0F12, 0x0127 },
	{ 0x0F12, 0x034C },
	{ 0x0F12, 0x0104 },
	{ 0x0F12, 0x0316 },
	{ 0x0F12, 0x00FD },
	{ 0x0F12, 0x02E1 },
	{ 0x0F12, 0x00FC },
	{ 0x0F12, 0x02AB },
	{ 0x0F12, 0x00FC },
	{ 0x0F12, 0x027E },
	{ 0x0F12, 0x00FB },
	{ 0x0F12, 0x0258 },
	{ 0x0F12, 0x00FA },
	{ 0x0F12, 0x0232 },
	{ 0x0F12, 0x00F9 },
	{ 0x0F12, 0x020C },
	{ 0x0F12, 0x00F9 },
	{ 0x0F12, 0x01E6 },
	{ 0x0F12, 0x00F8 },
	{ 0x0F12, 0x01C0 },
	{ 0x0F12, 0x00F7 },
	{ 0x0F12, 0x019A },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },


	{ 0x0F12, 0x0005 },
	{ 0x0F12, 0x0005 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0018 },
	{ 0x0F12, 0x00AB },
	{ 0x0F12, 0x0122 },
	{ 0x0F12, 0x0032 },
	{ 0x0F12, 0x0000 },


	{ 0x002A, 0x0FC0 },
	{ 0x0F12, 0x032F },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x017A },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x7300 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x000A },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x0FD4 },
	{ 0x0F12, 0x00E0 },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x10AE },
	{ 0x0F12, 0x0001 },



	{ 0x002A, 0x115A },
	{ 0x0F12, 0x0101 },


	{ 0x002A, 0x1152 },
	{ 0x0F12, 0x00B5 },
	{ 0x0F12, 0x00B5 },
	{ 0x0F12, 0x00CA },
	{ 0x0F12, 0x009D },
	{ 0x002A, 0x1140 },
	{ 0x0F12, 0x00C8 },
	{ 0x0F12, 0x00D2 },
	{ 0x0F12, 0x00D7 },
	{ 0x0F12, 0x0FEC },
	{ 0x0F12, 0x100A },
	{ 0x0F12, 0x101E },
	{ 0x0F12, 0x1050 },
	{ 0x0F12, 0x1069 },
	{ 0x0F12, 0x1082 },
	{ 0x002A, 0x10F8 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x00D0 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x00D0 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x00D0 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0xFF80 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0xFF80 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0xFF80 },




	{ 0x002A, 0x1082 },
	{ 0x0F12, 0x0129 },
	{ 0x0F12, 0x011E },

	{ 0x002A, 0x10E4 },
	{ 0x0F12, 0x000E },
	{ 0x0F12, 0x0009 },
	{ 0x002A, 0x10E0 },
	{ 0x0F12, 0x0161 },
	{ 0x0F12, 0x00BD },

	{ 0x002A, 0x10C8 },
	{ 0x0F12, 0x0E74 },
	{ 0x0F12, 0x0096 },
	{ 0x0F12, 0x03E8 },
	{ 0x0F12, 0x0096 },
	{ 0x002A, 0x10E8 },
	{ 0x0F12, 0x00DE },
	{ 0x002A, 0x10D0 },
	{ 0x0F12, 0x000A },
	{ 0x002A, 0x10EA },
	{ 0x0F12, 0x0154 },
	{ 0x002A, 0x10DA },
	{ 0x0F12, 0x000E },
	{ 0x002A, 0x1080 },
	{ 0x0F12, 0x0032 },
	{ 0x002A, 0x10DC },
	{ 0x0F12, 0x001E },
	{ 0x002A, 0x10D2 },
	{ 0x0F12, 0x001B },
	{ 0x0F12, 0x000E },
	{ 0x0F12, 0x0008 },
	{ 0x0F12, 0x0004 },




	{ 0x002A, 0x20FC },
	{ 0x0F12, 0x008A },
	{ 0x0F12, 0x00A0 },
	{ 0x002A, 0x2102 },
	{ 0x0F12, 0x008A },
	{ 0x0F12, 0x00A0 },

	{ 0x002A, 0x20C0 },
	{ 0x0F12, 0x008A },
	{ 0x0F12, 0x00A0 },
	{ 0x002A, 0x20C6 },
	{ 0x0F12, 0x008A },
	{ 0x0F12, 0x00A0 },

	{ 0x002A, 0x2138 },
	{ 0x0F12, 0x008A },
	{ 0x0F12, 0x00A0 },
	{ 0x002A, 0x213E },
	{ 0x0F12, 0x008A },
	{ 0x0F12, 0x00A0 },

	{ 0x002A, 0x2174 },
	{ 0x0F12, 0x008A },
	{ 0x0F12, 0x00A0 },
	{ 0x002A, 0x217A },
	{ 0x0F12, 0x008A },
	{ 0x0F12, 0x00A0 },

	{ 0x002A, 0x10B4 },
	{ 0x0F12, 0x0001 },





	{ 0x002A, 0x0D90 },
	{ 0x0F12, 0x0020 },
	{ 0x002A, 0x0D98 },
	{ 0x0F12, 0x00E0 },
	{ 0x002A, 0x0E70 },
	{ 0x0F12, 0x0030 },
	{ 0x002A, 0x0E78 },
	{ 0x0F12, 0x00C0 },


	{ 0x002A, 0x108A },
	{ 0x0F12, 0x0001 },







	{ 0x002A, 0x115E },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x1164 },
	{ 0x0F12, 0x0030 },
	{ 0x0F12, 0x00C8 },
	{ 0x0F12, 0x012C },
	{ 0x0F12, 0x0258 },
	{ 0x0F12, 0x0003 },







	{ 0x002A, 0x09D4 },
	{ 0x0F12, 0x3568 },
	{ 0x0F12, 0x7000 },

	{ 0x002A, 0x3568 },
	{ 0x0F12, 0x0106 },
	{ 0x0F12, 0xFFFA },
	{ 0x0F12, 0x001C },
	{ 0x0F12, 0x00EE },
	{ 0x0F12, 0x00D2 },
	{ 0x0F12, 0xFFD4 },
	{ 0x0F12, 0xFF94 },
	{ 0x0F12, 0x0149 },
	{ 0x0F12, 0xFFD6 },
	{ 0x0F12, 0xFF99 },
	{ 0x0F12, 0x00E8 },
	{ 0x0F12, 0x00A1 },
	{ 0x0F12, 0xFFEE },
	{ 0x0F12, 0xFFFD },
	{ 0x0F12, 0x0124 },
	{ 0x0F12, 0x00B5 },
	{ 0x0F12, 0xFFBC },
	{ 0x0F12, 0x0123 },

	{ 0x0F12, 0x0106 },
	{ 0x0F12, 0xFFFA },
	{ 0x0F12, 0x001C },
	{ 0x0F12, 0x00EE },
	{ 0x0F12, 0x00D2 },
	{ 0x0F12, 0xFFD4 },
	{ 0x0F12, 0xFF94 },
	{ 0x0F12, 0x0149 },
	{ 0x0F12, 0xFFD6 },
	{ 0x0F12, 0xFF99 },
	{ 0x0F12, 0x00E8 },
	{ 0x0F12, 0x00A1 },
	{ 0x0F12, 0xFFEE },
	{ 0x0F12, 0xFFFD },
	{ 0x0F12, 0x0124 },
	{ 0x0F12, 0x00B5 },
	{ 0x0F12, 0xFFBC },
	{ 0x0F12, 0x0123 },

	{ 0x0F12, 0x0106 },
	{ 0x0F12, 0xFFFA },
	{ 0x0F12, 0x001C },
	{ 0x0F12, 0x00EE },
	{ 0x0F12, 0x00D2 },
	{ 0x0F12, 0xFFD4 },
	{ 0x0F12, 0xFF94 },
	{ 0x0F12, 0x0149 },
	{ 0x0F12, 0xFFD6 },
	{ 0x0F12, 0xFF99 },
	{ 0x0F12, 0x00E8 },
	{ 0x0F12, 0x00A1 },
	{ 0x0F12, 0xFFEE },
	{ 0x0F12, 0xFFFD },
	{ 0x0F12, 0x0124 },
	{ 0x0F12, 0x00B5 },
	{ 0x0F12, 0xFFBC },
	{ 0x0F12, 0x0123 },

	{ 0x0F12, 0x0106 },
	{ 0x0F12, 0xFFFA },
	{ 0x0F12, 0x001C },
	{ 0x0F12, 0x00EE },
	{ 0x0F12, 0x00D2 },
	{ 0x0F12, 0xFFD4 },
	{ 0x0F12, 0xFF94 },
	{ 0x0F12, 0x0149 },
	{ 0x0F12, 0xFFD6 },
	{ 0x0F12, 0xFF99 },
	{ 0x0F12, 0x00E8 },
	{ 0x0F12, 0x00A1 },
	{ 0x0F12, 0xFFEE },
	{ 0x0F12, 0xFFFD },
	{ 0x0F12, 0x0124 },
	{ 0x0F12, 0x00B5 },
	{ 0x0F12, 0xFFBC },
	{ 0x0F12, 0x0123 },

	{ 0x0F12, 0x0106 },
	{ 0x0F12, 0xFFFA },
	{ 0x0F12, 0x001C },
	{ 0x0F12, 0x00EE },
	{ 0x0F12, 0x00D2 },
	{ 0x0F12, 0xFFD4 },
	{ 0x0F12, 0xFF94 },
	{ 0x0F12, 0x0149 },
	{ 0x0F12, 0xFFD6 },
	{ 0x0F12, 0xFF99 },
	{ 0x0F12, 0x00E8 },
	{ 0x0F12, 0x00A1 },
	{ 0x0F12, 0xFFEE },
	{ 0x0F12, 0xFFFD },
	{ 0x0F12, 0x0124 },
	{ 0x0F12, 0x00B5 },
	{ 0x0F12, 0xFFBC },
	{ 0x0F12, 0x0123 },

	{ 0x0F12, 0x0106 },
	{ 0x0F12, 0xFFFA },
	{ 0x0F12, 0x001C },
	{ 0x0F12, 0x00EE },
	{ 0x0F12, 0x00D2 },
	{ 0x0F12, 0xFFD4 },
	{ 0x0F12, 0xFF94 },
	{ 0x0F12, 0x0149 },
	{ 0x0F12, 0xFFD6 },
	{ 0x0F12, 0xFF99 },
	{ 0x0F12, 0x00E8 },
	{ 0x0F12, 0x00A1 },
	{ 0x0F12, 0xFFEE },
	{ 0x0F12, 0xFFFD },
	{ 0x0F12, 0x0124 },
	{ 0x0F12, 0x00B5 },
	{ 0x0F12, 0xFFBC },
	{ 0x0F12, 0x0123 },


	{ 0x002A, 0x09DC },
	{ 0x0F12, 0x3640 },
	{ 0x0F12, 0x7000 },


	{ 0x002A, 0x3640 },  	//#outdoor ccm#
	{ 0x0F12, 0x0121 },
	{ 0x0F12, 0xFFFE },
	{ 0x0F12, 0xFFFE },
	{ 0x0F12, 0x00C7 },
	{ 0x0F12, 0x00FF },
	{ 0x0F12, 0xFFCD },
	{ 0x0F12, 0xFF7A },
	{ 0x0F12, 0x0170 },
	{ 0x0F12, 0xFFC6 },
	{ 0x0F12, 0xFF7B },
	{ 0x0F12, 0x00FC },
	{ 0x0F12, 0x00AB },
	{ 0x0F12, 0xFFDD },
	{ 0x0F12, 0xFFF0 },
	{ 0x0F12, 0x0142 },
	{ 0x0F12, 0x00BA },
	{ 0x0F12, 0xFFA0 },
	{ 0x0F12, 0x013D },







	{ 0x002A, 0x0AA8 },
	{ 0x0F12, 0x0005 },
	{ 0x0F12, 0x0014 },
	{ 0x0F12, 0x007D },
	{ 0x0F12, 0x0384 },
	{ 0x0F12, 0x07D0 },


	{ 0x0F12, 0x0005 },
	{ 0x0F12, 0x0014 },
	{ 0x0F12, 0x007D },
	{ 0x0F12, 0x03B6 },
	{ 0x0F12, 0x07D0 },




	{ 0x002A, 0x0AE4 },
	{ 0x0F12, 0x3664 },
	{ 0x0F12, 0x7000 },

	{ 0x002A, 0x3664 },   //#DenThresh start#
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x006E },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0066 },
	{ 0x0F12, 0x0032 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x00F8 },
	{ 0x0F12, 0x000C },
	{ 0x0F12, 0x00FF },
	{ 0x0F12, 0x03FF },
	{ 0x0F12, 0x0107 },
	{ 0x0F12, 0x0031 },
	{ 0x0F12, 0x0019 },
	{ 0x0F12, 0x0200 },
	{ 0x0F12, 0x0300 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x01F4 },
	{ 0x0F12, 0x00D5 },
	{ 0x0F12, 0x00DE },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x00F3 },
	{ 0x0F12, 0x0020 },
	{ 0x0F12, 0x0078 },
	{ 0x0F12, 0x0070 },
	{ 0x0F12, 0x0104 },
	{ 0x0F12, 0x0003 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0200 },
	{ 0x0F12, 0xFFFF },
	{ 0x0F12, 0x5F63 },
	{ 0x0F12, 0x0601 },
	{ 0x0F12, 0x8009 },
	{ 0x0F12, 0x061E },
	{ 0x0F12, 0x0A1E },
	{ 0x0F12, 0x0F0F },
	{ 0x0F12, 0x0005 },
	{ 0x0F12, 0x040A },
	{ 0x0F12, 0x2800 }, 
	{ 0x0F12, 0x8004 },
	{ 0x0F12, 0x0808 },
	{ 0x0F12, 0x9110 },
	{ 0x0F12, 0x049B },
	{ 0x0F12, 0x0F23 },
	{ 0x0F12, 0x048A },
	{ 0x0F12, 0x2211 },
	{ 0x0F12, 0x1B00 },
	{ 0x0F12, 0x0214 },
	{ 0x0F12, 0x40FF },
	{ 0x0F12, 0x0A0F },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x180F },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0909 },
	{ 0x0F12, 0x4D0F },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0065 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x7AFE },
	{ 0x0F12, 0xE7CF },
	{ 0x0F12, 0x5BDB },
	{ 0x0F12, 0x072B },
	{ 0x0F12, 0x007E },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x006E },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0066 },
	{ 0x0F12, 0x0032 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x00F8 },
	{ 0x0F12, 0x000C },
	{ 0x0F12, 0x00FF },
	{ 0x0F12, 0x03FF },
	{ 0x0F12, 0x0107 },
	{ 0x0F12, 0x0031 },
	{ 0x0F12, 0x0019 },
	{ 0x0F12, 0x0200 },
	{ 0x0F12, 0x0300 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x01F4 },
	{ 0x0F12, 0x00D5 },
	{ 0x0F12, 0x00DE },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x00F3 },
	{ 0x0F12, 0x0020 },
	{ 0x0F12, 0x0078 },
	{ 0x0F12, 0x0070 },
	{ 0x0F12, 0x0104 },
	{ 0x0F12, 0x0003 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0xFFFF },
	{ 0x0F12, 0x5F63 },
	{ 0x0F12, 0x0601 },
	{ 0x0F12, 0x8009 },
	{ 0x0F12, 0x061E },
	{ 0x0F12, 0x0A1E },
	{ 0x0F12, 0x0F0F },
	{ 0x0F12, 0x0005 },
	{ 0x0F12, 0x040A },
	{ 0x0F12, 0x2800 }, 
	{ 0x0F12, 0x8004 },
	{ 0x0F12, 0x0808 },
	{ 0x0F12, 0x9110 },
	{ 0x0F12, 0x049B },
	{ 0x0F12, 0x0F23 },
	{ 0x0F12, 0x048A },
	{ 0x0F12, 0x2211 },
	{ 0x0F12, 0x1B00 },
	{ 0x0F12, 0x0214 },
	{ 0x0F12, 0x40FF },
	{ 0x0F12, 0x0A0F },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x180F },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0909 },
	{ 0x0F12, 0x511F },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0065 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x7AFE },
	{ 0x0F12, 0xE7CF },
	{ 0x0F12, 0x5BDB },
	{ 0x0F12, 0x072B },
	{ 0x0F12, 0x007E },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x006E },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x003A },
	{ 0x0F12, 0x0032 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x00F8 },
	{ 0x0F12, 0x000C },
	{ 0x0F12, 0x00FF },
	{ 0x0F12, 0x03FF },
	{ 0x0F12, 0x0107 },
	{ 0x0F12, 0x0038 },
	{ 0x0F12, 0x0019 },
	{ 0x0F12, 0x0200 },
	{ 0x0F12, 0x0300 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x01F4 },
	{ 0x0F12, 0x0009 },
	{ 0x0F12, 0x0012 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0020 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0070 },
	{ 0x0F12, 0x0104 },
	{ 0x0F12, 0x0003 },
	{ 0x0F12, 0x0500 },
	{ 0x0F12, 0x0005 },
	{ 0x0F12, 0xFFFF },
	{ 0x0F12, 0x393D },
	{ 0x0F12, 0x0001 },
	{ 0x0F12, 0x8000 },
	{ 0x0F12, 0x061E },
	{ 0x0F12, 0x0A1E },
	{ 0x0F12, 0x0F0F },
	{ 0x0F12, 0x0005 },
	{ 0x0F12, 0x040A },
	{ 0x0F12, 0x1800 },
	{ 0x0F12, 0x8004 },
	{ 0x0F12, 0x0508 },
	{ 0x0F12, 0x000A },
	{ 0x0F12, 0x0500 },
	{ 0x0F12, 0x0F23 },
	{ 0x0F12, 0x008A },
	{ 0x0F12, 0x2211 },
	{ 0x0F12, 0x1B00 },
	{ 0x0F12, 0x0114 },
	{ 0x0F12, 0x40FF },
	{ 0x0F12, 0x0A0F },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x180F },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0909 },
	{ 0x0F12, 0x8064 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x7ADE },
	{ 0x0F12, 0xE7CF },
	{ 0x0F12, 0x58D3 },
	{ 0x0F12, 0x072B },
	{ 0x0F12, 0x007E },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x006E },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x003A },
	{ 0x0F12, 0x0032 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x00F8 },
	{ 0x0F12, 0x000C },
	{ 0x0F12, 0x00FF },
	{ 0x0F12, 0x03FF },
	{ 0x0F12, 0x0158 },
	{ 0x0F12, 0x004C },
	{ 0x0F12, 0x0019 },
	{ 0x0F12, 0x0200 },
	{ 0x0F12, 0x0300 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x01F4 },
	{ 0x0F12, 0x0009 },
	{ 0x0F12, 0x0012 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0020 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0070 },
	{ 0x0F12, 0x0104 },
	{ 0x0F12, 0x0003 },
	{ 0x0F12, 0x0500 },
	{ 0x0F12, 0x0005 },
	{ 0x0F12, 0xFFFF },
	{ 0x0F12, 0x1F16 },  	//# denoise low #
	{ 0x0F12, 0x0601 },
	{ 0x0F12, 0x8009 },
	{ 0x0F12, 0x061E },
	{ 0x0F12, 0x0A1E },
	{ 0x0F12, 0x0F0F },
	{ 0x0F12, 0x0005 },
	{ 0x0F12, 0x040A },
	{ 0x0F12, 0x2C00 }, 
	{ 0x0F12, 0x8050 }, 
	{ 0x0F12, 0x0508 },
	{ 0x0F12, 0x110A },
	{ 0x0F12, 0x0500 },
	{ 0x0F12, 0x0F23 },
	{ 0x0F12, 0x008A },
	{ 0x0F12, 0x2211 },
	{ 0x0F12, 0x1B00 },
	{ 0x0F12, 0x0114 },
	{ 0x0F12, 0x40FF },
	{ 0x0F12, 0x0A0F },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x180F },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0909 },
	{ 0x0F12, 0x8064 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x7ADE },
	{ 0x0F12, 0xE7CF },
	{ 0x0F12, 0x58D3 },
	{ 0x0F12, 0x072B },
	{ 0x0F12, 0x007E },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x006E },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x003A },
	{ 0x0F12, 0x0032 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x00F8 },
	{ 0x0F12, 0x000C },
	{ 0x0F12, 0x00FF },
	{ 0x0F12, 0x03FF },
	{ 0x0F12, 0x0158 },
	{ 0x0F12, 0x004C },
	{ 0x0F12, 0x0019 },
	{ 0x0F12, 0x0200 },
	{ 0x0F12, 0x0300 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x01F4 },
	{ 0x0F12, 0x0009 },
	{ 0x0F12, 0x0012 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0020 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0070 },
	{ 0x0F12, 0x0104 },
	{ 0x0F12, 0x0003 },
	{ 0x0F12, 0x0500 },
	{ 0x0F12, 0x0005 },
	{ 0x0F12, 0xFFFF },
	{ 0x0F12, 0x140F },  	//# denoise low#
	{ 0x0F12, 0x0601 },
	{ 0x0F12, 0x8009 },
	{ 0x0F12, 0x061E },
	{ 0x0F12, 0x0A1E },
	{ 0x0F12, 0x0F0F },
	{ 0x0F12, 0x0005 },
	{ 0x0F12, 0x040A },
	{ 0x0F12, 0x2C00 }, 
	{ 0x0F12, 0x8050 }, 
	{ 0x0F12, 0x0508 },
	{ 0x0F12, 0x0F0A },
	{ 0x0F12, 0x0500 },
	{ 0x0F12, 0x0F23 },
	{ 0x0F12, 0x0090 },
	{ 0x0F12, 0x2214 },
	{ 0x0F12, 0x1B00 },
	{ 0x0F12, 0x0114 },
	{ 0x0F12, 0x40FF },
	{ 0x0F12, 0x0A0F },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x180F },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0909 },
	{ 0x0F12, 0x8064 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x7ADE },
	{ 0x0F12, 0xE7CF },
	{ 0x0F12, 0x58D3 },
	{ 0x0F12, 0x072B },
	{ 0x0F12, 0x007E },    //#DenThresh end#
	{ 0x002A, 0x028A },
	{ 0x0F12, 0x0001 },


	{ 0x002A, 0x057C },
	{ 0x0F12, 0x0001 },

	{ 0x002A, 0x057C },
	{ 0x0F12, 0x0001 },

	{ 0x002A, 0x057C },
	{ 0x0F12, 0x0001 },

	             
	 // # end #    
	             
	{ 0xffff, 0xffff },

};

//////////////
// CapturewMode
/////////////
ait848_short_t ait848_capture[] = 
{
	{ 0xFCFC, 0xD000 },

	//#  ********** forbidden area  #                                     
	{ 0x0028, 0x7000 },  

	{ 0x002A, 0x03F2 },  
	{ 0x0F12, 0x0001 },	// # 0001   1:MPEG AE on	  0: off   #
	                   
	//# Configuration Switch   #
	{ 0x002A, 0x02EA },  
	{ 0x0F12, 0x0000 },  
	//# Configuration Update   #
	{ 0x002A, 0x02BE },  
	{ 0x0F12, 0x0001 },  	 //#  update configuration  #
	{ 0x002A, 0x02EC },  
	{ 0x0F12, 0x0001 },  
	//# Performing capture     #
	{ 0x002A, 0x02B6 },  
	{ 0x0F12, 0x0001 },  	 //# capture run  #
	{ 0x0F12, 0x0001 },  
	          
	{ 0xffff, 0xffff},
};


/////////////////////
// SnapshotLowLightMode
/////////////////////
ait848_short_t ait848_snapshot_low[] = 
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x0330 },
	{ 0x0F12, 0x1770 },
	{ 0x0F12, 0x05DC },
	{ 0x002A, 0x03FA },
	{ 0x0F12, 0x1770 },
	{ 0x0F12, 0x05DC },
	{ 0x002A, 0x028A },  //#REG_TC_IPRM_InitPArAmsUpDAtED#
	{ 0x0F12, 0x0001 },
	{ 0x0028, 0x7000 },  //#preview updata#
	{ 0x002A, 0x02B6 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0001 },
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0xD000 },  //#CFPN EDit 0506# 
	{ 0x002A, 0xA092 },
	{ 0x0F12, 0x0033 }, 
	{ 0x002A, 0xA0A8 },  //#0517 TP#
	{ 0x0F12, 0x00FF }, 
	{ 0x0F12, 0x00FF },
	{ 0x002A, 0xA0BC },
	{ 0x0F12, 0x0008 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x0688 },  //#lowlight rECovEry#
	{ 0x0F12, 0x0C7A },	//#R#
	{ 0x002A, 0x06AA },
	{ 0x0F12, 0x0C73 },	//#G#
	{ 0x002A, 0x06CC },
	{ 0x0F12, 0x0C7A },	//#B#   
	{ 0x0028, 0xD000 },                       
	{ 0x002A, 0xA094 }, 
	{ 0x0F12, 0x0001 },                                     
	{ 0x0028, 0x7000 },                                                  
	{ 0x002A, 0x3668 },
	{ 0x0F12, 0x0080 },
	{ 0x002A, 0x36EA },
	{ 0x0F12, 0x0080 },
	{ 0x002A, 0x36D8 },
	{ 0x0F12, 0x0090 },
	{ 0x0F12, 0x00C0 },	 // #iRGB GAin #                 
	{ 0x002A, 0x375A },
	{ 0x0F12, 0x0090 },	
	{ 0x0F12, 0x00C0 },	 //#iRGB GAin #                              
	                   
	{ 0x002A, 0x04C0 }, 
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0001 },
	                   
	                   
	{ 0x002A, 0x03F2 }, 
	{ 0x0F12, 0x0001 }, 
	                   
	                   
	{ 0x002A, 0x02EA }, 
	{ 0x0F12, 0x0000 }, 
	                   
	{ 0x002A, 0x02BE }, 
	{ 0x0F12, 0x0001 }, 
	{ 0x002A, 0x02EC }, 
	{ 0x0F12, 0x0001 }, 
	                   
	{ 0x002A, 0x02B6 }, 
	{ 0x0F12, 0x0001 }, 
	{ 0x0F12, 0x0001 },
	 
	{ 0xffff, 0xffff },

};



////////////////////
// SnapshotNightMode
///////////////////

ait848_short_t ait848_snapshot_nightmode[] = 
{
	{ 0xFCFC, 0xD000 },


	{ 0x0028, 0xD000 },    //#CFPN edit 0506# 
	{ 0x002A, 0xa092 },
	{ 0x0F12, 0x0033 }, 
	        
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x0614 },
	{ 0x0F12, 0x0150 },	//#lt_uMaxAnGain1#
	{ 0x0F12, 0x04E0 },	//#lt_uMaxAnGain2#
	{ 0x0F12, 0x0100 },  //#lt_uMaxDigGain#     
	  
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x0688 },	//#lowlight recovery#
	{ 0x0F12, 0x0C60 },	//#R#
	{ 0x002A, 0x06AA },
	{ 0x0F12, 0x0C60 },	//#G#
	{ 0x002A, 0x06CC },
	{ 0x0F12, 0x0C60 },	//#B#
	                
	{ 0x0028, 0xD000 }, 
	                
	                   
	{ 0x002A, 0xA094 }, 
	{ 0x0F12, 0x0001 },
	                
	                                    
	{ 0x0028, 0x7000 }, 
	                                                  
	{ 0x002A, 0x3668 },
	{ 0x0F12, 0x0080 },
	{ 0x002A, 0x36EA },
	{ 0x0F12, 0x0080 },
	                   
	                   
	{ 0x002A, 0x36D2 },
	{ 0x0F12, 0x1064 },
	{ 0x002A, 0x36D8 },
	{ 0x0F12, 0x0060 },
	{ 0x0F12, 0x0090 },	//#iRGB Gain#
	{ 0x002A, 0x3754 },
	{ 0x0F12, 0x5864 },	//#GAMMA#
	{ 0x002A, 0x375A },
	{ 0x0F12, 0x0060 },	
	{ 0x0F12, 0x0090 },	//#iRGB Gain#
	
	                     
	{ 0x002A, 0x04C0 }, // #  #
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0001 },
	                   
	                   
	{ 0x002A, 0x03F2 }, 
	{ 0x0F12, 0x0001 }, 
	                   
	                   
	{ 0x002A, 0x02EA }, 
	{ 0x0F12, 0x0000 }, 
	                   
	{ 0x002A, 0x02BE }, 
	{ 0x0F12, 0x0001 }, 
	{ 0x002A, 0x02EC }, 
	{ 0x0F12, 0x0001 }, 
	                   
	{ 0x002A, 0x02B6 }, 
	{ 0x0F12, 0x0001 }, 
	{ 0x0F12, 0x0001 },
	    
	{ 0xffff, 0xffff },

};


////////////////
// NightMode_ON
///////////////
ait848_short_t ait848_nightmode_on[] = 
{
	{ 0xFCFC, 0xD000 },
	              
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x0610 },
	{ 0x0F12, 0x0682 },
	{ 0x0F12, 0xC350 },
	{ 0x002A, 0x060C },
	{ 0x0F12, 0x0682 },
	{ 0x0F12, 0xC350 },
	{ 0x002A, 0x0614 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0800 },
	{ 0x0F12, 0x0100 },
	              
	{ 0x002A, 0x0B94 },
	{ 0x0F12, 0x0000 },
	              
	{ 0x002A, 0x0406 },
	{ 0x0F12, 0x1388 },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x03FE },
	{ 0x0F12, 0x0072 },
	{ 0x002A, 0x0402 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0002 },
	              
	{ 0x002A, 0x02E2 },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x02E6 },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x02BE },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x02E4 },
	{ 0x0F12, 0x0001 },
	              
	{ 0xffff, 0xffff },

};

////////////////
// NightMode_OFF
///////////////
ait848_short_t ait848_nightmode_off[] = 
{
	{ 0xFCFC, 0xD000 },
	 
	{ 0x0028, 0x7000 },

	{ 0x002A, 0x0610 },
	{ 0x0F12, 0x0682 },       //#lt_uPREMaxExp1# 
	{ 0x0F12, 0x4E20 },       //#lt_uPREMaxExp2# 

	{ 0x002A, 0x060C },
	{ 0x0F12, 0x0341 },        //#lt_uCAPMaxExp1# 
	{ 0x0F12, 0x4650 },        //#lt_uCAPMaxExp2#

	{ 0x002A, 0x0614 },
	{ 0x0F12, 0x0200 },   	//#lt_uMaxAnGain1#
	{ 0x0F12, 0x04E0 },        //#lt_uMaxAnGain2#
	{ 0x0F12, 0x0100 },        //#lt_uMaxDigGain#
	              
	{ 0x002A, 0x0B94 },
	{ 0x0F12, 0x0001 },
	              
	{ 0x002A, 0x0406 },
	{ 0x0F12, 0x0FA0 },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x03FE },
	{ 0x0F12, 0x0072 },
	{ 0x002A, 0x0402 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0002 },
	              
	{ 0x002A, 0x02E2 },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x02E6 },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x02BE },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x02E4 },
	{ 0x0F12, 0x0001 },

	{ 0xffff, 0xffff },

};

//---------------------------------------//
// case 23 : FPS_NONFIX                     //
//---------------------------------------//
ait848_short_t ait848_fps_nonfix[] = 
{
	{ 0xFCFC, 0xD000 },                                                            
	{ 0x0028, 0x7000 },                                                            
	{ 0x002A, 0x033C },                                                            
	{ 0x0F12, 0x0682 },       // 15fps	REG_0TC_PCFG_usMaxFrTimeMsecMult10 
	{ 0x0F12, 0x02AB }, 	//15fps REG_0TC_PCFG_usMinFrTimeMsecMult10	
	{ 0x002A, 0x0338 },       //REG_0TC_PCFG_usFrTimeType                          
	{ 0x0F12, 0x0000 },                                                                     
	{ 0x002A, 0x02E2 },       //REG_TC_GP_ActivePrevConfig                         
	{ 0x0F12, 0x0000 },                                                            
	{ 0x002A, 0x02E6 },       //REG_TC_GP_PrevOpenAfterChange                      
	{ 0x0F12, 0x0001 },                                                            
	{ 0x002A, 0x02BE },       //REG_TC_GP_NewConfigSync                            
	{ 0x0F12, 0x0001 },                                                            
	{ 0x002A, 0x02E4 },       //REG_TC_GP_PrevConfigChanged                        
	{ 0x0F12, 0x0001 },     
};

//---------------------------------------//
// case 23 : FPS_15FIX                   //
//---------------------------------------//
ait848_short_t ait848_fps_15fix[] = 
{
	{ 0xFCFC, 0xD000 }, 
	{ 0x0028, 0x7000 }, 
	{ 0x002A, 0x033C }, 
	{ 0x0F12, 0x02AB },       //029B 15fps	REG_0TC_PCFG_usMaxFrTimeMsecMult10
	{ 0x0F12, 0x02AB }, 	//029B 15fps REG_0TC_PCFG_usMinFrTimeMsecMult10
	{ 0x002A, 0x0338 },       //REG_0TC_PCFG_usFrTimeType
	{ 0x0F12, 0x0000 },         
	{ 0x002A, 0x02E2 },       //REG_TC_GP_ActivePrevConfig                      
	{ 0x0F12, 0x0000 }, 
	{ 0x002A, 0x02E6 },       //REG_TC_GP_PrevOpenAfterChange
	{ 0x0F12, 0x0001 }, 
	{ 0x002A, 0x02BE },       //REG_TC_GP_NewConfigSync
	{ 0x0F12, 0x0001 }, 
	{ 0x002A, 0x02E4 },       //REG_TC_GP_PrevConfigChanged
	{ 0x0F12, 0x0001 },    
};

//---------------------------------------//
// case 23 : FPS_7FIX                    //
//---------------------------------------//
ait848_short_t ait848_fps_7fix[] = 
{
	{ 0xFCFC, 0xD000 },                                                         
	{ 0x0028, 0x7000 },                                                         
	{ 0x002A, 0x033C },                                                         
	{ 0x0F12, 0x0500 },       // 7fps	REG_0TC_PCFG_usMaxFrTimeMsecMult10      
	{ 0x0F12, 0x0500 }, 	//7fps REG_0TC_PCFG_usMinFrTimeMsecMult10	
	{ 0x002A, 0x0338 },       //REG_0TC_PCFG_usFrTimeType                       
	{ 0x0F12, 0x0000 },                                                         
	{ 0x002A, 0x02E2 },       //REG_TC_GP_ActivePrevConfig                      
	{ 0x0F12, 0x0000 },                                                         
	{ 0x002A, 0x02E6 },       //REG_TC_GP_PrevOpenAfterChange                   
	{ 0x0F12, 0x0001 },                                                         
	{ 0x002A, 0x02BE },       //REG_TC_GP_NewConfigSync                         
	{ 0x0F12, 0x0001 },                                                         
	{ 0x002A, 0x02E4 },       //REG_TC_GP_PrevConfigChanged                     
	{ 0x0F12, 0x0001 },    
};

////////////
// EFFECT_OFF
////////////
ait848_short_t ait848_effect_off[] = 
{
	{ 0xFCFC, 0xD000 },     
	{ 0x0028, 0x7000 },     
	{ 0x002A, 0x02B0 },     
	{ 0x0F12, 0x0000 },
	                                                    
	{ 0xffff, 0xffff },
};

//---------------------------------------//
// case 16 : MonoEffect                  //
//---------------------------------------//
ait848_short_t ait848_effect_gray[] = 
{
	{ 0xFCFC, 0xD000 },     
	{ 0x0028, 0x7000 },     
	{ 0x002A, 0x02B0 },     
	{ 0x0F12, 0x0001 },
	                                                    
	{ 0xffff, 0xffff },
};

//---------------------------------------//
// case 20 : NegativeEffect              //
//---------------------------------------//
ait848_short_t ait848_effect_negative[] = 
{
	{ 0xFCFC, 0xD000 },     
	{ 0x0028, 0x7000 },     
	{ 0x002A, 0x02B0 },     
	{ 0x0F12, 0x0002 },
	                                                    
	{ 0xffff, 0xffff },
};

/////////////
// EFFECT_SEPIA
/////////////
ait848_short_t ait848_effect_sepia[] = 
{
	{ 0xFCFC, 0xD000 },     
	{ 0x0028, 0x7000 },     
	{ 0x002A, 0x02B0 },     
	{ 0x0F12, 0x0003 },
	                                                               
	{ 0xffff, 0xffff },
};

////////////
// EFFECT_AQUA
/////////////
ait848_short_t ait848_effect_aqua[] = 
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x02B0 },
	{ 0x0F12, 0x0004 },
	              
	{ 0xffff, 0xffff }, 	
};

//---------------------------------------//
// case 19 : GREENEffect(sketch)         //
//---------------------------------------//
ait848_short_t ait848_effect_sketch[] = 
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x02B0 },
	{ 0x0F12, 0x0005 },
	              
	{ 0xffff, 0xffff }, 	
};

/////////////
// WB_Auto
/////////////
ait848_short_t ait848_wb_auto[] = 
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x0CE4 },
	{ 0x0F12, 0x0365 },
	{ 0x0F12, 0x038C },
	{ 0x0F12, 0x030C },
	{ 0x0F12, 0x038B },
	{ 0x0F12, 0x02E0 },
	{ 0x0F12, 0x037D },
	{ 0x0F12, 0x02CB },
	{ 0x0F12, 0x036E },
	{ 0x0F12, 0x02BA },
	{ 0x0F12, 0x0350 },
	{ 0x0F12, 0x02AB },
	{ 0x0F12, 0x0331 },
	{ 0x002A, 0x0D84 },
	{ 0x0F12, 0x0004 },
	{ 0x002A, 0x0D88 },
	{ 0x0F12, 0x001B },
	{ 0x002A, 0x0D8C },
	{ 0x0F12, 0x0152 },
	               
	{ 0x002A, 0x1160 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	               
	{ 0x002A, 0x10A8 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
};

///////////
// WB_Sunny
//////////
ait848_short_t ait848_wb_sunny[] = 
{
	{ 0xFCFC, 0xD000 },
	               
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x1302 },
	{ 0x0F12, 0x0655 },
	{ 0x0F12, 0x0400 },
	{ 0x0F12, 0x04E3 },
	               
	{ 0x002A, 0x0CE4 },
	{ 0x0F12, 0x01F5 },
	{ 0x0F12, 0x022B },
	{ 0x0F12, 0x01E5 },
	{ 0x0F12, 0x0247 },
	{ 0x0F12, 0x01E0 },
	{ 0x0F12, 0x0249 },
	{ 0x0F12, 0x01EB },
	{ 0x0F12, 0x0243 },
	{ 0x0F12, 0x01F9 },
	{ 0x0F12, 0x0238 },
	               
	{ 0x002A, 0x0D84 },
	{ 0x0F12, 0x0004 },
	{ 0x002A, 0x0D88 },
	{ 0x0F12, 0x0005 },
	{ 0x002A, 0x0D8C },
	{ 0x0F12, 0x028F },
		    
	{ 0x002A, 0x1160 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	               
	{ 0x002A, 0x10A8 },
	{ 0x0F12, 0x0001 },
	{ 0x0F12, 0x0002 },
};

///////////
// WB_Cloudy
///////////
ait848_short_t ait848_wb_cloudy[] = 
{
	{ 0xFCFC, 0xD000 },
	               
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x1302 },
	{ 0x0F12, 0x0655 },
	{ 0x0F12, 0x0400 },
	{ 0x0F12, 0x04E3 },
	               
	{ 0x002A, 0x0CE4 },
	{ 0x0F12, 0x01F5 },
	{ 0x0F12, 0x022B },
	{ 0x0F12, 0x01E5 },
	{ 0x0F12, 0x0247 },
	{ 0x0F12, 0x01E0 },
	{ 0x0F12, 0x0249 },
	{ 0x0F12, 0x01EB },
	{ 0x0F12, 0x0243 },
	{ 0x0F12, 0x01F9 },
	{ 0x0F12, 0x0238 },
	               
	{ 0x002A, 0x0D84 },
	{ 0x0F12, 0x0004 },
	{ 0x002A, 0x0D88 },
	{ 0x0F12, 0x0005 },
	{ 0x002A, 0x0D8C },
	{ 0x0F12, 0x028F },
	               
	{ 0x002A, 0x1160 },
	{ 0x0F12, 0x0170 },
	{ 0x0F12, 0x0000 },
	               
	{ 0x002A, 0x10A8 },
	{ 0x0F12, 0x0001 },
	{ 0x0F12, 0x0002 },
};

////////////
// WB_Tungsten
////////////
ait848_short_t ait848_wb_tungsten[] = 
{
	{ 0xFCFC, 0xD000 },
	               
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x1302 },
	{ 0x0F12, 0x0404 },
	{ 0x0F12, 0x0400 },
	{ 0x0F12, 0x085D },
	               
	{ 0x002A, 0x0CE4 },
	{ 0x0F12, 0x031A },
	{ 0x0F12, 0x0350 },
	{ 0x0F12, 0x030A },
	{ 0x0F12, 0x036B },
	{ 0x0F12, 0x0305 },
	{ 0x0F12, 0x036E },
	{ 0x0F12, 0x0310 },
	{ 0x0F12, 0x0368 },
	{ 0x0F12, 0x031E },
	{ 0x0F12, 0x035D },
	               
	{ 0x002A, 0x0D84 },
	{ 0x0F12, 0x0004 },
	{ 0x002A, 0x0D88 },
	{ 0x0F12, 0x0005 },
	{ 0x002A, 0x0D8C },
	{ 0x0F12, 0x016D },
	               
	{ 0x002A, 0x1160 },
	{ 0x0F12, 0xFFB0 },
	{ 0x0F12, 0x0000 },
	               
	{ 0x002A, 0x10A8 },
	{ 0x0F12, 0x0001 },
	{ 0x0F12, 0x0002 },
};

///////////////
// WB_Flourescent
///////////////
ait848_short_t ait848_wb_fluorescent[] = 
{
	{ 0xFCFC, 0xD000 },
	           
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x1302 },
	{ 0x0F12, 0x0544 },
	{ 0x0F12, 0x0400 },
	{ 0x0F12, 0x070A },
	           
	{ 0x002A, 0x0CE4 },
	{ 0x0F12, 0x0278 },
	{ 0x0F12, 0x02AF },
	{ 0x0F12, 0x0269 },
	{ 0x0F12, 0x02CA },
	{ 0x0F12, 0x0264 },
	{ 0x0F12, 0x02CD },
	{ 0x0F12, 0x026E },
	{ 0x0F12, 0x02C7 },
	{ 0x0F12, 0x027C },
	{ 0x0F12, 0x02BB },
	           
	{ 0x002A, 0x0D84 },
	{ 0x0F12, 0x0004 },
	{ 0x002A, 0x0D88 },
	{ 0x0F12, 0x0005 },
	{ 0x002A, 0x0D8C },
	{ 0x0F12, 0x01DC },
	           
	{ 0x002A, 0x1160 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	           
	{ 0x002A, 0x10A8 },
	{ 0x0F12, 0x0001 },
	{ 0x0F12, 0x0002 },
};


////////////
// BR_Minus4
///////////
ait848_short_t ait848_br_minus4[] = 
{
	{ 0xFCFC, 0xD000},
	{ 0x0028, 0x7000},
	{ 0x002A, 0x02A6},
	{ 0x0F12, 0xFF80},
	{ 0x0F12, 0xFF85},
};

//////////
// BR_Minus3
/////////
ait848_short_t ait848_br_minus3[] = 
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x02A6 },
	{ 0x0F12, 0xFFC0 },
	{ 0x0F12, 0xFFC8 },
};

//////////
// BR_Minus2
//////////
ait848_short_t ait848_br_minus2[] = 
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x02A6 },
	{ 0x0F12, 0xFFD0 },
	{ 0x0F12, 0xFFE4 },
};

//////////
// BR_Minus1
//////////
ait848_short_t ait848_br_minus1[] = 
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x02A6 },
	{ 0x0F12, 0xFFE0 },
	{ 0x0F12, 0xFFE4 },
};

/////////
// BR_ZERO
////////
ait848_short_t ait848_br_zero[] = 
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x02A6 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
};

/////////
// BR_Plus1
/////////
ait848_short_t ait848_br_plus1[] = 
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x02A6 },
	{ 0x0F12, 0x0030 },
	{ 0x0F12, 0x0000 },
};

/////////
// BR_Plus2
/////////
ait848_short_t ait848_br_plus2[] = 
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x02A6 },
	{ 0x0F12, 0x0040 },
	{ 0x0F12, 0x0000 },
};

/////////
// BR_Plus3
/////////
ait848_short_t ait848_br_plus3[] =
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x02A6 },
	{ 0x0F12, 0x0060 },
	{ 0x0F12, 0x0000 },
};

/////////
// BR_Plus4
/////////
ait848_short_t ait848_br_plus4[] =
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x02A6 },
	{ 0x0F12, 0x007F },
	{ 0x0F12, 0x0010 },
};

/////////
// ISO_AUTO
/////////
ait848_short_t ait848_iso_auto[] =
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0xD000 },
	{ 0x002A, 0xA0B6 },
	{ 0x0F12, 0x009B },
};

////////
// ISO_50
////////
ait848_short_t ait848_iso50[] =
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0xD000 },
	{ 0x002A, 0xA0B6 },
	{ 0x0F12, 0x00E0 },
};

/////////
// ISO_100
////////
ait848_short_t ait848_iso100[] =
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0xD000 },
	{ 0x002A, 0xA0B6 },
	{ 0x0F12, 0x00C0 },
};

////////
// ISO_200
////////
ait848_short_t ait848_iso200[] =
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0xD000 },
	{ 0x002A, 0xA0B6 },
	{ 0x0F12, 0x0060 },
};

/////////
// ISO_400
////////
ait848_short_t ait848_iso400[] =
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0xD000 },
	{ 0x002A, 0xA0B6 },
	{ 0x0F12, 0x0040 },
};

////////////////////
// SCENE_PORTRAIT_OFF
////////////////////
ait848_short_t ait848_scene_portrait_off[] =
{
	{ 0xFCFC, 0xD000 },                    
	{ 0x0028, 0x7000 },                    
	{ 0x002A, 0x02AC },                    
	{ 0x0F12, 0x0000 },          
	{ 0xffff, 0xffff },  
};     

////////////////////
// SCENE_LANDSCAPE_OFF
////////////////////
ait848_short_t ait848_scene_landscape_off[] =
{
	{ 0xFCFC, 0xD000 },     
	{ 0x0028, 0x7000 },     
	{ 0x002A, 0x02AA },
	{ 0x0F12, 0x0000 },   //sat //
	{ 0x002A, 0x02AC },
	{ 0x0F12, 0x0000 },   //Blur_sharp  //
	{ 0xffff, 0xffff },
};

/////////////////
// SCENE_SPORTS_OFF
/////////////////
ait848_short_t ait848_scene_sports_off[] =
{
	{ 0xFCFC, 0xD000 },     
	{ 0x0028, 0x7000 },     
	{ 0x002A, 0x0618 },   //# Dgain min#
	{ 0x0F12, 0x0100 },
	{ 0xffff, 0xffff },
};

//////////////////
// SCENE_SUNSET_OFF
/////////////////
ait848_short_t ait848_scene_sunset_off[] =
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x1160 },   //#Rgain# 
	{ 0x0F12, 0x0000 },
	{ 0xffff, 0xffff },
};

///////////////
// SCENE_DAWN_OFF
///////////////
ait848_short_t ait848_scene_dawn_off[] =
{
	{ 0xFCFC, 0xD000 },     
	{ 0x0028, 0x7000 },     
	{ 0x002A, 0x1162 },   //#Bgain#        
	{ 0x0F12, 0xfff8 },
	{ 0xffff, 0xffff },
};

/////////////////////////////
// SCENE_SCENE_AGAINSTLIGHT_OFF
/////////////////////////////
ait848_short_t ait848_scene_againstlight_off[] =
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x1482 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	              
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	              
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	              
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0401 },
	{ 0x0F12, 0x0104 },
	{ 0x0F12, 0x0101 },
	              
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0401 },
	{ 0x0F12, 0x0104 },
	{ 0x0F12, 0x0101 },
	              
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0303 },
	{ 0x0F12, 0x0303 },
	{ 0x0F12, 0x0101 },
	              
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	              
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	              
	{ 0x002A, 0x057C },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x057C },
	{ 0x0F12, 0x0001 },
	              
	{ 0xffff, 0xffff }, 
};

////////////////
//SCENE_TEXT_OFF
///////////////
ait848_short_t ait848_scene_text_off[] =
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },          
	{ 0x002A, 0x02AC },          
	{ 0x0F12, 0x0000 },
	{ 0xffff, 0xffff },
};

///////////////////
// SCENE_PORTRAIT_ON
///////////////////
ait848_short_t ait848_scene_portrait_on[] =
{
	{ 0xFCFC, 0xD000 },          
	{ 0x0028, 0x7000 },          
	{ 0x002A, 0x02AC },          
	{ 0x0F12, 0x0060 },
	{ 0xffff, 0xffff },
};

////////////////////
// SCENE_LANDSCAPE_ON
///////////////////
ait848_short_t ait848_scene_landscape_on[] =
{
	{ 0xFCFC, 0xD000 },     
	{ 0xFCFC, 0xD000 },     
	{ 0x0028, 0x7000 },     
	{ 0x002A, 0x02AA },
	{ 0x0F12, 0x0035 },  //#sat #
	{ 0x002A, 0x02AC },
	{ 0x0F12, 0xFFB1 },  //#Blur_sharp  #
	{ 0xffff, 0xffff }, 
};

/////////////////
// SCENE_SPORTS_ON
////////////////
ait848_short_t ait848_scene_sports_on[] =
{
	{ 0xFCFC, 0xD000 },     
	{ 0x0028, 0x7000 },     
	{ 0x002A, 0x0618 },
	{ 0x0F12, 0x0200 },   //#lt_uMaxDigGain #
	                                                                                             
	{ 0xffff, 0xffff },
};

/////////////////
// SCENE_SUNSET_ON
////////////////
ait848_short_t ait848_scene_sunset_on[] =
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x1160 },
	{ 0x0F12, 0x0100 },  //# R Gain offset #
	{ 0xffff, 0xffff },
};

////////////////
// SCENE_DAWN_ON
////////////////
ait848_short_t ait848_scene_dawn_on[] =
{
	{ 0xFCFC, 0xD000 },   
	{ 0x0028, 0x7000 },     
	{ 0x002A, 0x1162 },        
	{ 0x0F12, 0x0100 }, //# B Gain offset #  
	                                                          
	{ 0xffff, 0xffff },
};


//////////////////////
// SCENE_AGAINSTLIGHT_ON
//////////////////////
ait848_short_t ait848_scene_againstlight_on[] =
{
	{ 0xFCFC, 0xD000 },   
	                 
	{ 0xFCFC, 0xD000 },   
	{ 0x0028, 0x7000 },   
	{ 0x002A, 0x1482 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x010F },   
	{ 0x0F12, 0x0F01 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x010F },   
	{ 0x0F12, 0x0F01 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	                 
	{ 0x002A, 0x057C },   
	{ 0x0F12, 0x0001 },   
	                 
	                 
	{ 0xffff, 0xffff },
};

///////////////
// SCENE_TEXT_ON
///////////////
ait848_short_t ait848_scene_text_on[] =
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },          
	{ 0x002A, 0x02AC },          
	{ 0x0F12, 0x004b },
	{ 0xFFFF, 0xFFFF },
};

////////////////////////
// MeasureBrightness_SPOT
///////////////////////
ait848_short_t ait848_measure_brightness_spot[] =
{
	{ 0xFCFC, 0xD000 }, 
	{ 0x0028, 0x7000 }, 
	{ 0x002A, 0x1482 },
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x010F }, 
	{ 0x0F12, 0x0F01 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x010F }, 
	{ 0x0F12, 0x0F01 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 },

	{ 0x002A, 0x057C },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x057C },
	{ 0x0F12, 0x0001 },


	{ 0xffff, 0xffff },

};

///////////////////////////
// MeasureBrightness_Default
//////////////////////////
ait848_short_t ait848_measure_brightness_default[] =
{
	{ 0xFCFC, 0xD000 }, 
	{ 0x0028, 0x7000 }, 
	{ 0x002A, 0x1482 },   //# #    
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	                
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	                
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	                
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0301 }, 
	{ 0x0F12, 0x0103 }, 
	{ 0x0F12, 0x0101 }, 
	                
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0301 }, 
	{ 0x0F12, 0x0103 }, 
	{ 0x0F12, 0x0101 }, 
	                
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0201 }, 
	{ 0x0F12, 0x0102 }, 
	{ 0x0F12, 0x0101 }, 
	                
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0201 }, 
	{ 0x0F12, 0x0102 }, 
	{ 0x0F12, 0x0101 }, 
	                
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 

	{ 0x002A, 0x057C },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x057C },
	{ 0x0F12, 0x0001 },

	{ 0xffff, 0xffff },

};

/////////////////////////////
// MeasureBrightness_CENTER
/////////////////////////////
ait848_short_t ait848_measure_brightness_center[] =
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 }, 
	{ 0x002A, 0x1482 },

	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 

	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 

	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 

	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0808 }, 
	{ 0x0F12, 0x0808 }, 
	{ 0x0F12, 0x0101 },

	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0808 }, 
	{ 0x0F12, 0x0808 }, 
	{ 0x0F12, 0x0101 }, 

	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 

	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 

	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 },

	{ 0x002A, 0x057C },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x057C },
	{ 0x0F12, 0x0001 },

	{ 0xffff, 0xffff },

};

//#else
//#error No samsung CIS moudule !
//#endif


ait848_t ait848_reg[] = 
{
	// To do.
};

// For VGA ( 640 x 480) on 4CA module
ait848_t ait848_reg_vga[] = 
{
	// To do.
};

// For SVGA ( 800 x 600) on 4CA module
ait848_t ait848_reg_svga[] = 
{
	// To do.
};

// For SXGA (1280 x 1024 = 1.3M) on 4CA module
ait848_t ait848_reg_sxga[] = 
{
	// To do.
};

// For UXGA (1600 x 1200 = 2M) on 4CA module
ait848_t ait848_reg_uxga[] = 
{
	// To do.
};

// For SQVGA on 4CA module
ait848_t ait848_reg_qsvga[] = 
{
	// To do.
};

#define S5K4CA_INIT_REGS (sizeof(ait848_reg)/sizeof(ait848_reg[0]))
#define S5K4CA_UXGA_REGS (sizeof(ait848_reg_uxga)/sizeof(ait848_reg_uxga[0]))
#define S5K4CA_SVGA_REGS (sizeof(ait848_reg_svga)/sizeof(ait848_reg_svga[0]))
#define S5K4CA_VGA_REGS (sizeof(ait848_reg_vga)/sizeof(ait848_reg_vga[0]))
#define S5K4CA_QSVGA_REGS (sizeof(ait848_reg_qsvga)/sizeof(ait848_reg_qsvga[0]))

//#define S5K4CA_RISC_REGS 0xEB
//#define S5K4CA_ISP_REGS 0xFB /* S5C7323X */
//#define S5K4CA_CIS_REGS 0x2F /* S5K437LA03 */
                                                                                                                                                                                              
//#define S5K4CA_REGS (0x1000)

#endif

