/* Copyright (c) 2009-2010, Code Aurora Forum. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 *       copyright notice, this list of conditions and the following
 *       disclaimer in the documentation and/or other materials provided
 *       with the distribution.
 *     * Neither the name of Code Aurora Forum, Inc. nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __ARCH_ARM_MACH_MSM_CLOCK_8X60_H
#define __ARCH_ARM_MACH_MSM_CLOCK_8X60_H

enum {
	L_8X60_NONE_CLK = -1,

	/* Peripheral Clocks */
	L_8X60_BBRX_SSBI_CLK,
	L_8X60_GSBI1_UART_CLK,
	L_8X60_GSBI2_UART_CLK,
	L_8X60_GSBI3_UART_CLK,
	L_8X60_GSBI4_UART_CLK,
	L_8X60_GSBI5_UART_CLK,
	L_8X60_GSBI6_UART_CLK,
	L_8X60_GSBI7_UART_CLK,
	L_8X60_GSBI8_UART_CLK,
	L_8X60_GSBI9_UART_CLK,
	L_8X60_GSBI10_UART_CLK,
	L_8X60_GSBI11_UART_CLK,
	L_8X60_GSBI12_UART_CLK,
	L_8X60_GSBI1_QUP_CLK,
	L_8X60_GSBI2_QUP_CLK,
	L_8X60_GSBI3_QUP_CLK,
	L_8X60_GSBI4_QUP_CLK,
	L_8X60_GSBI5_QUP_CLK,
	L_8X60_GSBI6_QUP_CLK,
	L_8X60_GSBI7_QUP_CLK,
	L_8X60_GSBI8_QUP_CLK,
	L_8X60_GSBI9_QUP_CLK,
	L_8X60_GSBI10_QUP_CLK,
	L_8X60_GSBI11_QUP_CLK,
	L_8X60_GSBI12_QUP_CLK,
	L_8X60_GSBI_SIM_SRC_CLK,
	L_8X60_GSBI1_SIM_CLK,
	L_8X60_GSBI2_SIM_CLK,
	L_8X60_GSBI3_SIM_CLK,
	L_8X60_GSBI4_SIM_CLK,
	L_8X60_GSBI5_SIM_CLK,
	L_8X60_GSBI6_SIM_CLK,
	L_8X60_GSBI7_SIM_CLK,
	L_8X60_GSBI8_SIM_CLK,
	L_8X60_GSBI9_SIM_CLK,
	L_8X60_GSBI10_SIM_CLK,
	L_8X60_GSBI11_SIM_CLK,
	L_8X60_GSBI12_SIM_CLK,
	L_8X60_PDM_CLK,
	L_8X60_PRNG_CLK,
	L_8X60_SDC1_CLK,
	L_8X60_SDC2_CLK,
	L_8X60_SDC3_CLK,
	L_8X60_SDC4_CLK,
	L_8X60_SDC5_CLK,
	L_8X60_TSIF_REF_CLK,
	L_8X60_TSSC_CLK,
	L_8X60_USB_HS_XCVR_CLK,
	L_8X60_USB_PHY0_CLK,
	L_8X60_USB_FS1_SRC_CLK,
	L_8X60_USB_FS1_XCVR_CLK,
	L_8X60_USB_FS1_SYS_CLK,
	L_8X60_USB_FS2_SRC_CLK,
	L_8X60_USB_FS2_XCVR_CLK,
	L_8X60_USB_FS2_SYS_CLK,

	/* Fast Peripheral Bus Clocks */
	L_8X60_GSBI1_P_CLK,
	L_8X60_GSBI2_P_CLK,
	L_8X60_GSBI3_P_CLK,
	L_8X60_GSBI4_P_CLK,
	L_8X60_GSBI5_P_CLK,
	L_8X60_GSBI6_P_CLK,
	L_8X60_GSBI7_P_CLK,
	L_8X60_GSBI8_P_CLK,
	L_8X60_GSBI9_P_CLK,
	L_8X60_GSBI10_P_CLK,
	L_8X60_GSBI11_P_CLK,
	L_8X60_GSBI12_P_CLK,
	L_8X60_TSIF_P_CLK,
	L_8X60_USB_FS1_P_CLK,
	L_8X60_USB_FS2_P_CLK,

	/* Multimedia Clocks */
	L_8X60_CAM_CLK,
	L_8X60_CSI_SRC_CLK,
	L_8X60_CSI0_CLK,
	L_8X60_CSI1_CLK,
	L_8X60_GFX2D0_CLK,
	L_8X60_GFX2D1_CLK,
	L_8X60_GFX3D_CLK,
	L_8X60_IJPEG_CLK,
	L_8X60_JPEGD_CLK,
	L_8X60_MDP_CLK,
	L_8X60_MDP_VSYNC_CLK,
	L_8X60_PIXEL_SRC_CLK,
	L_8X60_PIXEL_MDP_CLK,
	L_8X60_PIXEL_LCDC_CLK,
	L_8X60_ROT_CLK,
	L_8X60_TV_SRC_CLK,
	L_8X60_TV_ENC_CLK,
	L_8X60_TV_DAC_CLK,
	L_8X60_VCODEC_CLK,
	L_8X60_MDP_TV_CLK,
	L_8X60_HDMI_TV_CLK,
	L_8X60_DSUB_TV_CLK,
	L_8X60_HDMI_APP_CLK,
	L_8X60_VPE_CLK,
	L_8X60_VFE_CLK,
	L_8X60_CSI0_VFE_CLK,
	L_8X60_CSI1_VFE_CLK,
	L_8X60_GMEM_AXI_CLK,
	L_8X60_JPEGD_AXI_CLK,
	L_8X60_VFE_AXI_CLK,
	L_8X60_AMP_P_CLK,
	L_8X60_APU_P_CLK,
	L_8X60_CSI0_P_CLK,
	L_8X60_CSI1_P_CLK,
	L_8X60_DSI_M_P_CLK,
	L_8X60_FAB_P_CLK,
	L_8X60_IJPEG_P_CLK,
	L_8X60_JPEGD_P_CLK,
	L_8X60_MDP_P_CLK,
	L_8X60_ROT_P_CLK,
	L_8X60_TV_ENC_P_CLK,
	L_8X60_VFE_P_CLK,
	L_8X60_VPE_P_CLK,

	/* LPA Clocks */
	L_8X60_MI2S_SRC_CLK,
	L_8X60_MI2S_CLK,
	L_8X60_MI2S_M_CLK,
	L_8X60_CODEC_I2S_MIC_SRC_CLK,
	L_8X60_CODEC_I2S_MIC_CLK,
	L_8X60_CODEC_I2S_MIC_M_CLK,
	L_8X60_SPARE_I2S_MIC_SRC_CLK,
	L_8X60_SPARE_I2S_MIC_CLK,
	L_8X60_SPARE_I2S_MIC_M_CLK,
	L_8X60_CODEC_I2S_SPKR_SRC_CLK,
	L_8X60_CODEC_I2S_SPKR_CLK,
	L_8X60_CODEC_I2S_SPKR_M_CLK,
	L_8X60_SPARE_I2S_SPKR_SRC_CLK,
	L_8X60_SPARE_I2S_SPKR_CLK,
	L_8X60_SPARE_I2S_SPKR_M_CLK,
	L_8X60_PCM_CLK,

	L_8X60_NR_CLKS
};

struct clk_ops;
extern struct clk_ops clk_ops_8x60;

void pll_enable(int pll);
void pll_disable(int pll);

#define CLK_8X60(clk_name, clk_id, clk_dev, clk_flags) {	\
	.name = clk_name, \
	.id = L_8X60_##clk_id, \
	.ops = &clk_ops_8x60, \
	.flags = clk_flags, \
	.dev = clk_dev, \
	.dbg_name = #clk_id, \
	}

#endif

