/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.scanner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.reader.Reader;
import org.yaml.snakeyaml.scanner.Scanner;
import org.yaml.snakeyaml.scanner.ScannerException;
import org.yaml.snakeyaml.scanner.SimpleKey;
import org.yaml.snakeyaml.tokens.AliasToken;
import org.yaml.snakeyaml.tokens.AnchorToken;
import org.yaml.snakeyaml.tokens.BlockEndToken;
import org.yaml.snakeyaml.tokens.BlockEntryToken;
import org.yaml.snakeyaml.tokens.BlockMappingStartToken;
import org.yaml.snakeyaml.tokens.BlockSequenceStartToken;
import org.yaml.snakeyaml.tokens.DirectiveToken;
import org.yaml.snakeyaml.tokens.DocumentEndToken;
import org.yaml.snakeyaml.tokens.DocumentStartToken;
import org.yaml.snakeyaml.tokens.FlowEntryToken;
import org.yaml.snakeyaml.tokens.FlowMappingEndToken;
import org.yaml.snakeyaml.tokens.FlowMappingStartToken;
import org.yaml.snakeyaml.tokens.FlowSequenceEndToken;
import org.yaml.snakeyaml.tokens.FlowSequenceStartToken;
import org.yaml.snakeyaml.tokens.KeyToken;
import org.yaml.snakeyaml.tokens.ScalarToken;
import org.yaml.snakeyaml.tokens.StreamEndToken;
import org.yaml.snakeyaml.tokens.StreamStartToken;
import org.yaml.snakeyaml.tokens.TagToken;
import org.yaml.snakeyaml.tokens.Token;
import org.yaml.snakeyaml.tokens.ValueToken;
import org.yaml.snakeyaml.util.ArrayStack;

public final class ScannerImpl
implements Scanner {
    private static final Pattern NOT_HEXA = Pattern.compile("[^0-9A-Fa-f]");
    public static final Map<Character, String> ESCAPE_REPLACEMENTS = new HashMap<Character, String>();
    public static final Map<Character, Integer> ESCAPE_CODES = new HashMap<Character, Integer>();
    private final Reader reader;
    private boolean done = false;
    private int flowLevel = 0;
    private List<Token> tokens;
    private int tokensTaken = 0;
    private int indent = -1;
    private ArrayStack<Integer> indents;
    private boolean allowSimpleKey = true;
    private Map<Integer, SimpleKey> possibleSimpleKeys;

    public ScannerImpl(Reader reader) {
        this.reader = reader;
        this.tokens = new ArrayList<Token>(100);
        this.indents = new ArrayStack(10);
        this.possibleSimpleKeys = new LinkedHashMap<Integer, SimpleKey>();
        this.fetchStreamStart();
    }

    @Override
    public boolean checkToken(List<Class<? extends Token>> list) {
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        if (!this.tokens.isEmpty()) {
            if (list.size() == 0) {
                return true;
            }
            Token token = this.tokens.get(0);
            for (Class<? extends Token> clazz : list) {
                if (!clazz.isInstance(token)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean checkToken(Class<? extends Token> clazz) {
        ArrayList<Class<? extends Token>> arrayList = new ArrayList<Class<? extends Token>>();
        arrayList.add(clazz);
        return this.checkToken(arrayList);
    }

    @Override
    public Token peekToken() {
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        return this.tokens.get(0);
    }

    @Override
    public Token getToken() {
        if (!this.tokens.isEmpty()) {
            ++this.tokensTaken;
            return this.tokens.remove(0);
        }
        return null;
    }

    private boolean needMoreTokens() {
        if (this.done) {
            return false;
        }
        if (this.tokens.isEmpty()) {
            return true;
        }
        this.stalePossibleSimpleKeys();
        return this.nextPossibleSimpleKey() == this.tokensTaken;
    }

    private void fetchMoreTokens() {
        this.scanToNextToken();
        this.stalePossibleSimpleKeys();
        this.unwindIndent(this.reader.getColumn());
        char c = this.reader.peek();
        switch (c) {
            case '\u0000': {
                this.fetchStreamEnd();
                return;
            }
            case '%': {
                if (!this.checkDirective()) break;
                this.fetchDirective();
                return;
            }
            case '-': {
                if (this.checkDocumentStart()) {
                    this.fetchDocumentStart();
                    return;
                }
                if (!this.checkBlockEntry()) break;
                this.fetchBlockEntry();
                return;
            }
            case '.': {
                if (!this.checkDocumentEnd()) break;
                this.fetchDocumentEnd();
                return;
            }
            case '[': {
                this.fetchFlowSequenceStart();
                return;
            }
            case '{': {
                this.fetchFlowMappingStart();
                return;
            }
            case ']': {
                this.fetchFlowSequenceEnd();
                return;
            }
            case '}': {
                this.fetchFlowMappingEnd();
                return;
            }
            case ',': {
                this.fetchFlowEntry();
                return;
            }
            case '?': {
                if (!this.checkKey()) break;
                this.fetchKey();
                return;
            }
            case ':': {
                if (!this.checkValue()) break;
                this.fetchValue();
                return;
            }
            case '*': {
                this.fetchAlias();
                return;
            }
            case '&': {
                this.fetchAnchor();
                return;
            }
            case '!': {
                this.fetchTag();
                return;
            }
            case '|': {
                if (this.flowLevel != 0) break;
                this.fetchLiteral();
                return;
            }
            case '>': {
                if (this.flowLevel != 0) break;
                this.fetchFolded();
                return;
            }
            case '\'': {
                this.fetchSingle();
                return;
            }
            case '\"': {
                this.fetchDouble();
                return;
            }
        }
        if (this.checkPlain()) {
            this.fetchPlain();
            return;
        }
        String string = String.valueOf(c);
        for (Character c2 : ESCAPE_REPLACEMENTS.keySet()) {
            String string2 = ESCAPE_REPLACEMENTS.get(c2);
            if (!string2.equals(string)) continue;
            string = "\\" + c2;
            break;
        }
        throw new ScannerException("while scanning for the next token", null, "found character " + c + "'" + string + "' that cannot start any token", this.reader.getMark());
    }

    private int nextPossibleSimpleKey() {
        Iterator<SimpleKey> iterator = this.possibleSimpleKeys.values().iterator();
        if (iterator.hasNext()) {
            SimpleKey simpleKey = iterator.next();
            return simpleKey.getTokenNumber();
        }
        return -1;
    }

    private void stalePossibleSimpleKeys() {
        HashSet<Integer> hashSet = null;
        for (Integer n : this.possibleSimpleKeys.keySet()) {
            SimpleKey simpleKey = this.possibleSimpleKeys.get(n);
            if (simpleKey.getLine() == this.reader.getLine() && this.reader.getIndex() - simpleKey.getIndex() <= 1024) continue;
            if (simpleKey.isRequired()) {
                throw new ScannerException("while scanning a simple key", simpleKey.getMark(), "could not found expected ':'", this.reader.getMark());
            }
            if (hashSet == null) {
                hashSet = new HashSet<Integer>();
            }
            hashSet.add(n);
        }
        if (hashSet != null) {
            for (Integer n : hashSet) {
                this.possibleSimpleKeys.remove(n);
            }
        }
    }

    private void savePossibleSimpleKey() {
        boolean bl;
        boolean bl2 = bl = this.flowLevel == 0 && this.indent == this.reader.getColumn();
        if (!this.allowSimpleKey && bl) {
            throw new YAMLException("A simple key is required only if it is the first token in the current line");
        }
        if (this.allowSimpleKey) {
            this.removePossibleSimpleKey();
            int n = this.tokensTaken + this.tokens.size();
            SimpleKey simpleKey = new SimpleKey(n, bl, this.reader.getIndex(), this.reader.getLine(), this.reader.getColumn(), this.reader.getMark());
            this.possibleSimpleKeys.put(new Integer(this.flowLevel), simpleKey);
        }
    }

    private void removePossibleSimpleKey() {
        if (this.possibleSimpleKeys.keySet().contains(new Integer(this.flowLevel))) {
            SimpleKey simpleKey = this.possibleSimpleKeys.get(new Integer(this.flowLevel));
            if (simpleKey.isRequired()) {
                throw new ScannerException("while scanning a simple key", simpleKey.getMark(), "could not found expected ':'", this.reader.getMark());
            }
            this.possibleSimpleKeys.remove(this.flowLevel);
        }
    }

    private void unwindIndent(int n) {
        if (this.flowLevel != 0) {
            return;
        }
        while (this.indent > n) {
            Mark mark = this.reader.getMark();
            this.indent = this.indents.pop();
            this.tokens.add(new BlockEndToken(mark, mark));
        }
    }

    private boolean addIndent(int n) {
        if (this.indent < n) {
            this.indents.push(this.indent);
            this.indent = n;
            return true;
        }
        return false;
    }

    private void fetchStreamStart() {
        Mark mark = this.reader.getMark();
        StreamStartToken streamStartToken = new StreamStartToken(mark, mark);
        this.tokens.add(streamStartToken);
    }

    private void fetchStreamEnd() {
        this.unwindIndent(-1);
        this.removePossibleSimpleKey();
        this.allowSimpleKey = false;
        this.possibleSimpleKeys = new HashMap<Integer, SimpleKey>();
        Mark mark = this.reader.getMark();
        StreamEndToken streamEndToken = new StreamEndToken(mark, mark);
        this.tokens.add(streamEndToken);
        this.done = true;
    }

    private void fetchDirective() {
        this.unwindIndent(-1);
        this.removePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanDirective();
        this.tokens.add(token);
    }

    private void fetchDocumentStart() {
        this.fetchDocumentIndicator(true);
    }

    private void fetchDocumentEnd() {
        this.fetchDocumentIndicator(false);
    }

    private void fetchDocumentIndicator(boolean bl) {
        this.unwindIndent(-1);
        this.removePossibleSimpleKey();
        this.allowSimpleKey = false;
        Mark mark = this.reader.getMark();
        this.reader.forward(3);
        Mark mark2 = this.reader.getMark();
        Token token = bl ? new DocumentStartToken(mark, mark2) : new DocumentEndToken(mark, mark2);
        this.tokens.add(token);
    }

    private void fetchFlowSequenceStart() {
        this.fetchFlowCollectionStart(false);
    }

    private void fetchFlowMappingStart() {
        this.fetchFlowCollectionStart(true);
    }

    private void fetchFlowCollectionStart(boolean bl) {
        this.savePossibleSimpleKey();
        ++this.flowLevel;
        this.allowSimpleKey = true;
        Mark mark = this.reader.getMark();
        this.reader.forward(1);
        Mark mark2 = this.reader.getMark();
        Token token = bl ? new FlowMappingStartToken(mark, mark2) : new FlowSequenceStartToken(mark, mark2);
        this.tokens.add(token);
    }

    private void fetchFlowSequenceEnd() {
        this.fetchFlowCollectionEnd(false);
    }

    private void fetchFlowMappingEnd() {
        this.fetchFlowCollectionEnd(true);
    }

    private void fetchFlowCollectionEnd(boolean bl) {
        this.removePossibleSimpleKey();
        --this.flowLevel;
        this.allowSimpleKey = false;
        Mark mark = this.reader.getMark();
        this.reader.forward();
        Mark mark2 = this.reader.getMark();
        Token token = bl ? new FlowMappingEndToken(mark, mark2) : new FlowSequenceEndToken(mark, mark2);
        this.tokens.add(token);
    }

    private void fetchFlowEntry() {
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey();
        Mark mark = this.reader.getMark();
        this.reader.forward();
        Mark mark2 = this.reader.getMark();
        FlowEntryToken flowEntryToken = new FlowEntryToken(mark, mark2);
        this.tokens.add(flowEntryToken);
    }

    private void fetchBlockEntry() {
        Mark mark;
        if (this.flowLevel == 0) {
            if (!this.allowSimpleKey) {
                throw new ScannerException(null, null, "sequence entries are not allowed here", this.reader.getMark());
            }
            if (this.addIndent(this.reader.getColumn())) {
                mark = this.reader.getMark();
                this.tokens.add(new BlockSequenceStartToken(mark, mark));
            }
        }
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey();
        mark = this.reader.getMark();
        this.reader.forward();
        Mark mark2 = this.reader.getMark();
        BlockEntryToken blockEntryToken = new BlockEntryToken(mark, mark2);
        this.tokens.add(blockEntryToken);
    }

    private void fetchKey() {
        Mark mark;
        if (this.flowLevel == 0) {
            if (!this.allowSimpleKey) {
                throw new ScannerException(null, null, "mapping keys are not allowed here", this.reader.getMark());
            }
            if (this.addIndent(this.reader.getColumn())) {
                mark = this.reader.getMark();
                this.tokens.add(new BlockMappingStartToken(mark, mark));
            }
        }
        this.allowSimpleKey = this.flowLevel == 0;
        this.removePossibleSimpleKey();
        mark = this.reader.getMark();
        this.reader.forward();
        Mark mark2 = this.reader.getMark();
        KeyToken keyToken = new KeyToken(mark, mark2);
        this.tokens.add(keyToken);
    }

    private void fetchValue() {
        Object object;
        if (this.possibleSimpleKeys.keySet().contains(this.flowLevel)) {
            object = this.possibleSimpleKeys.get(this.flowLevel);
            this.possibleSimpleKeys.remove(this.flowLevel);
            this.tokens.add(((SimpleKey)object).getTokenNumber() - this.tokensTaken, new KeyToken(((SimpleKey)object).getMark(), ((SimpleKey)object).getMark()));
            if (this.flowLevel == 0 && this.addIndent(((SimpleKey)object).getColumn())) {
                this.tokens.add(((SimpleKey)object).getTokenNumber() - this.tokensTaken, new BlockMappingStartToken(((SimpleKey)object).getMark(), ((SimpleKey)object).getMark()));
            }
            this.allowSimpleKey = false;
        } else {
            if (this.flowLevel == 0 && !this.allowSimpleKey) {
                throw new ScannerException(null, null, "mapping values are not allowed here", this.reader.getMark());
            }
            if (this.flowLevel == 0 && this.addIndent(this.reader.getColumn())) {
                object = this.reader.getMark();
                this.tokens.add(new BlockMappingStartToken((Mark)object, (Mark)object));
            }
            this.allowSimpleKey = this.flowLevel == 0;
            this.removePossibleSimpleKey();
        }
        object = this.reader.getMark();
        this.reader.forward();
        Mark mark = this.reader.getMark();
        ValueToken valueToken = new ValueToken((Mark)object, mark);
        this.tokens.add(valueToken);
    }

    private void fetchAlias() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanAnchor(false);
        this.tokens.add(token);
    }

    private void fetchAnchor() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanAnchor(true);
        this.tokens.add(token);
    }

    private void fetchTag() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanTag();
        this.tokens.add(token);
    }

    private void fetchLiteral() {
        this.fetchBlockScalar('|');
    }

    private void fetchFolded() {
        this.fetchBlockScalar('>');
    }

    private void fetchBlockScalar(char c) {
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey();
        Token token = this.scanBlockScalar(c);
        this.tokens.add(token);
    }

    private void fetchSingle() {
        this.fetchFlowScalar('\'');
    }

    private void fetchDouble() {
        this.fetchFlowScalar('\"');
    }

    private void fetchFlowScalar(char c) {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanFlowScalar(c);
        this.tokens.add(token);
    }

    private void fetchPlain() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanPlain();
        this.tokens.add(token);
    }

    private boolean checkDirective() {
        return this.reader.getColumn() == 0;
    }

    private boolean checkDocumentStart() {
        return this.reader.getColumn() == 0 && "---".equals(this.reader.prefix(3)) && "\u0000 \t\r\n\u0085\u2028\u2029".indexOf(this.reader.peek(3)) != -1;
    }

    private boolean checkDocumentEnd() {
        return this.reader.getColumn() == 0 && "...".equals(this.reader.prefix(3)) && "\u0000 \t\r\n\u0085\u2028\u2029".indexOf(this.reader.peek(3)) != -1;
    }

    private boolean checkBlockEntry() {
        return "\u0000 \t\r\n\u0085\u2028\u2029".indexOf(this.reader.peek(1)) != -1;
    }

    private boolean checkKey() {
        if (this.flowLevel != 0) {
            return true;
        }
        return "\u0000 \t\r\n\u0085\u2028\u2029".indexOf(this.reader.peek(1)) != -1;
    }

    private boolean checkValue() {
        if (this.flowLevel != 0) {
            return true;
        }
        return "\u0000 \t\r\n\u0085\u2028\u2029".indexOf(this.reader.peek(1)) != -1;
    }

    private boolean checkPlain() {
        char c = this.reader.peek();
        return "\u0000 \t\r\n\u0085\u2028\u2029-?:,[]{}#&*!|>'\"%@`".indexOf(c) == -1 || "\u0000 \t\r\n\u0085\u2028\u2029".indexOf(this.reader.peek(1)) == -1 && (c == '-' || this.flowLevel == 0 && "?:".indexOf(c) != -1);
    }

    private void scanToNextToken() {
        if (this.reader.getIndex() == 0 && this.reader.peek() == '\ufeff') {
            this.reader.forward();
        }
        boolean bl = false;
        while (!bl) {
            while (this.reader.peek() == ' ') {
                this.reader.forward();
            }
            if (this.reader.peek() == '#') {
                while ("\u0000\r\n\u0085\u2028\u2029".indexOf(this.reader.peek()) == -1) {
                    this.reader.forward();
                }
            }
            if (this.scanLineBreak().length() != 0) {
                if (this.flowLevel != 0) continue;
                this.allowSimpleKey = true;
                continue;
            }
            bl = true;
        }
    }

    private Token scanDirective() {
        Mark mark;
        Mark mark2 = this.reader.getMark();
        this.reader.forward();
        String string = this.scanDirectiveName(mark2);
        List<Object> list = null;
        if ("YAML".equals(string)) {
            list = this.scanYamlDirectiveValue(mark2);
            mark = this.reader.getMark();
        } else if ("TAG".equals(string)) {
            list = this.scanTagDirectiveValue(mark2);
            mark = this.reader.getMark();
        } else {
            mark = this.reader.getMark();
            while ("\u0000\r\n\u0085\u2028\u2029".indexOf(this.reader.peek()) == -1) {
                this.reader.forward();
            }
        }
        this.scanDirectiveIgnoredLine(mark2);
        return new DirectiveToken(string, list, mark2, mark);
    }

    private String scanDirectiveName(Mark mark) {
        int n = 0;
        char c = this.reader.peek(n);
        while ("abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-_".indexOf(c) != -1) {
            c = this.reader.peek(++n);
        }
        if (n == 0) {
            throw new ScannerException("while scanning a directive", mark, "expected alphabetic or numeric character, but found " + c + "(" + c + ")", this.reader.getMark());
        }
        String string = this.reader.prefix(n);
        this.reader.forward(n);
        c = this.reader.peek();
        if ("\u0000 \r\n\u0085\u2028\u2029".indexOf(c) == -1) {
            throw new ScannerException("while scanning a directive", mark, "expected alphabetic or numeric character, but found " + c + "(" + c + ")", this.reader.getMark());
        }
        return string;
    }

    private List<Integer> scanYamlDirectiveValue(Mark mark) {
        while (this.reader.peek() == ' ') {
            this.reader.forward();
        }
        Integer n = this.scanYamlDirectiveNumber(mark);
        if (this.reader.peek() != '.') {
            throw new ScannerException("while scanning a directive", mark, "expected a digit or '.', but found " + this.reader.peek() + "(" + this.reader.peek() + ")", this.reader.getMark());
        }
        this.reader.forward();
        Integer n2 = this.scanYamlDirectiveNumber(mark);
        if ("\u0000 \r\n\u0085\u2028\u2029".indexOf(this.reader.peek()) == -1) {
            throw new ScannerException("while scanning a directive", mark, "expected a digit or ' ', but found " + this.reader.peek() + "(" + this.reader.peek() + ")", this.reader.getMark());
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(2);
        arrayList.add(n);
        arrayList.add(n2);
        return arrayList;
    }

    private Integer scanYamlDirectiveNumber(Mark mark) {
        char c = this.reader.peek();
        if (!Character.isDigit(c)) {
            throw new ScannerException("while scanning a directive", mark, "expected a digit, but found " + c + "(" + c + ")", this.reader.getMark());
        }
        int n = 0;
        while (Character.isDigit(this.reader.peek(n))) {
            ++n;
        }
        Integer n2 = new Integer(this.reader.prefix(n));
        this.reader.forward(n);
        return n2;
    }

    private List<String> scanTagDirectiveValue(Mark mark) {
        while (this.reader.peek() == ' ') {
            this.reader.forward();
        }
        String string = this.scanTagDirectiveHandle(mark);
        while (this.reader.peek() == ' ') {
            this.reader.forward();
        }
        String string2 = this.scanTagDirectivePrefix(mark);
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add(string);
        arrayList.add(string2);
        return arrayList;
    }

    private String scanTagDirectiveHandle(Mark mark) {
        String string = this.scanTagHandle("directive", mark);
        char c = this.reader.peek();
        if (c != ' ') {
            throw new ScannerException("while scanning a directive", mark, "expected ' ', but found " + this.reader.peek() + "(" + c + ")", this.reader.getMark());
        }
        return string;
    }

    private String scanTagDirectivePrefix(Mark mark) {
        String string = this.scanTagUri("directive", mark);
        if ("\u0000 \r\n\u0085\u2028\u2029".indexOf(this.reader.peek()) == -1) {
            throw new ScannerException("while scanning a directive", mark, "expected ' ', but found " + this.reader.peek() + "(" + this.reader.peek() + ")", this.reader.getMark());
        }
        return string;
    }

    private String scanDirectiveIgnoredLine(Mark mark) {
        char c;
        while (this.reader.peek() == ' ') {
            this.reader.forward();
        }
        if (this.reader.peek() == '#') {
            while ("\u0000\r\n\u0085\u2028\u2029".indexOf(this.reader.peek()) == -1) {
                this.reader.forward();
            }
        }
        if ("\u0000\r\n\u0085\u2028\u2029".indexOf(c = this.reader.peek()) == -1) {
            throw new ScannerException("while scanning a directive", mark, "expected a comment or a line break, but found " + c + "(" + c + ")", this.reader.getMark());
        }
        return this.scanLineBreak();
    }

    private Token scanAnchor(boolean bl) {
        Mark mark = this.reader.getMark();
        char c = this.reader.peek();
        String string = c == '*' ? "alias" : "anchor";
        this.reader.forward();
        int n = 0;
        char c2 = this.reader.peek(n);
        while ("abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-_".indexOf(c2) != -1) {
            c2 = this.reader.peek(++n);
        }
        if (n == 0) {
            throw new ScannerException("while scanning an " + string, mark, "expected alphabetic or numeric character, but found but found " + c2, this.reader.getMark());
        }
        String string2 = this.reader.prefix(n);
        this.reader.forward(n);
        c2 = this.reader.peek();
        if ("\u0000 \t\r\n\u0085\u2028\u2029?:,]}%@`".indexOf(c2) == -1) {
            throw new ScannerException("while scanning an " + string, mark, "expected alphabetic or numeric character, but found " + c2 + "(" + this.reader.peek() + ")", this.reader.getMark());
        }
        Mark mark2 = this.reader.getMark();
        Token token = bl ? new AnchorToken(string2, mark, mark2) : new AliasToken(string2, mark, mark2);
        return token;
    }

    private Token scanTag() {
        Mark mark = this.reader.getMark();
        char c = this.reader.peek(1);
        String string = null;
        String string2 = null;
        if (c == '<') {
            this.reader.forward(2);
            string2 = this.scanTagUri("tag", mark);
            if (this.reader.peek() != '>') {
                throw new ScannerException("while scanning a tag", mark, "expected '>', but found " + this.reader.peek() + "(" + this.reader.peek() + ")", this.reader.getMark());
            }
            this.reader.forward();
        } else if ("\u0000 \t\r\n\u0085\u2028\u2029".indexOf(c) != -1) {
            string2 = "!";
            this.reader.forward();
        } else {
            int n = 1;
            boolean bl = false;
            while ("\u0000 \r\n\u0085\u2028\u2029".indexOf(c) == -1) {
                if (c == '!') {
                    bl = true;
                    break;
                }
                c = this.reader.peek(++n);
            }
            string = "!";
            if (bl) {
                string = this.scanTagHandle("tag", mark);
            } else {
                string = "!";
                this.reader.forward();
            }
            string2 = this.scanTagUri("tag", mark);
        }
        c = this.reader.peek();
        if ("\u0000 \r\n\u0085\u2028\u2029".indexOf(c) == -1) {
            throw new ScannerException("while scanning a tag", mark, "expected ' ', but found " + c + "(" + c + ")", this.reader.getMark());
        }
        String[] stringArray = new String[]{string, string2};
        Mark mark2 = this.reader.getMark();
        return new TagToken(stringArray, mark, mark2);
    }

    private Token scanBlockScalar(char c) {
        Mark mark;
        Object object;
        boolean bl = c == '>';
        StringBuffer stringBuffer = new StringBuffer();
        Mark mark2 = this.reader.getMark();
        this.reader.forward();
        Object[] objectArray = this.scanBlockScalarIndicators(mark2);
        Boolean bl2 = (Boolean)objectArray[0];
        int n = (Integer)objectArray[1];
        this.scanBlockScalarIgnoredLine(mark2);
        int n2 = this.indent + 1;
        if (n2 < 1) {
            n2 = 1;
        }
        String string = null;
        int n3 = 0;
        int n4 = 0;
        if (n == -1) {
            object = this.scanBlockScalarIndentation();
            string = (String)object[0];
            n3 = (Integer)object[1];
            mark = (Mark)object[2];
            n4 = Math.max(n2, n3);
        } else {
            n4 = n2 + n - 1;
            object = this.scanBlockScalarBreaks(n4);
            string = (String)object[0];
            mark = (Mark)object[1];
        }
        object = "";
        while (this.reader.getColumn() == n4 && this.reader.peek() != '\u0000') {
            stringBuffer.append(string);
            boolean bl3 = " \t".indexOf(this.reader.peek()) == -1;
            int n5 = 0;
            while ("\u0000\r\n\u0085\u2028\u2029".indexOf(this.reader.peek(n5)) == -1) {
                ++n5;
            }
            stringBuffer.append(this.reader.prefix(n5));
            this.reader.forward(n5);
            object = this.scanLineBreak();
            Object[] objectArray2 = this.scanBlockScalarBreaks(n4);
            string = (String)objectArray2[0];
            mark = (Mark)objectArray2[1];
            if (this.reader.getColumn() != n4 || this.reader.peek() == '\u0000') break;
            if (bl && "\n".equals(object) && bl3 && " \t".indexOf(this.reader.peek()) == -1) {
                if (string.length() != 0) continue;
                stringBuffer.append(" ");
                continue;
            }
            stringBuffer.append((String)object);
        }
        if (bl2 == null || bl2.booleanValue()) {
            stringBuffer.append((String)object);
        }
        if (bl2 != null && bl2.booleanValue()) {
            stringBuffer.append(string);
        }
        return new ScalarToken(stringBuffer.toString(), false, mark2, mark, c);
    }

    private Object[] scanBlockScalarIndicators(Mark mark) {
        Boolean bl = null;
        int n = -1;
        char c = this.reader.peek();
        if (c == '-' || c == '+') {
            bl = c == '+' ? Boolean.TRUE : Boolean.FALSE;
            this.reader.forward();
            c = this.reader.peek();
            if (Character.isDigit(c)) {
                n = Integer.parseInt(String.valueOf(c));
                if (n == 0) {
                    throw new ScannerException("while scanning a block scalar", mark, "expected indentation indicator in the range 1-9, but found 0", this.reader.getMark());
                }
                this.reader.forward();
            }
        } else if (Character.isDigit(c)) {
            n = Integer.parseInt(String.valueOf(c));
            if (n == 0) {
                throw new ScannerException("while scanning a block scalar", mark, "expected indentation indicator in the range 1-9, but found 0", this.reader.getMark());
            }
            this.reader.forward();
            c = this.reader.peek();
            if (c == '-' || c == '+') {
                bl = c == '+' ? Boolean.TRUE : Boolean.FALSE;
                this.reader.forward();
            }
        }
        if ("\u0000 \r\n\u0085\u2028\u2029".indexOf(c = this.reader.peek()) == -1) {
            throw new ScannerException("while scanning a block scalar", mark, "expected chomping or indentation indicators, but found " + c, this.reader.getMark());
        }
        return new Object[]{bl, new Integer(n)};
    }

    private String scanBlockScalarIgnoredLine(Mark mark) {
        char c;
        while (this.reader.peek() == ' ') {
            this.reader.forward();
        }
        if (this.reader.peek() == '#') {
            while ("\u0000\r\n\u0085\u2028\u2029".indexOf(this.reader.peek()) == -1) {
                this.reader.forward();
            }
        }
        if ("\u0000\r\n\u0085\u2028\u2029".indexOf(c = this.reader.peek()) == -1) {
            throw new ScannerException("while scanning a block scalar", mark, "expected a comment or a line break, but found " + c, this.reader.getMark());
        }
        return this.scanLineBreak();
    }

    private Object[] scanBlockScalarIndentation() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Mark mark = this.reader.getMark();
        while (" \r\n\u0085\u2028\u2029".indexOf(this.reader.peek()) != -1) {
            if (this.reader.peek() != ' ') {
                stringBuffer.append(this.scanLineBreak());
                mark = this.reader.getMark();
                continue;
            }
            this.reader.forward();
            if (this.reader.getColumn() <= n) continue;
            n = this.reader.getColumn();
        }
        return new Object[]{stringBuffer.toString(), new Integer(n), mark};
    }

    private Object[] scanBlockScalarBreaks(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        Mark mark = this.reader.getMark();
        while (this.reader.getColumn() < n && this.reader.peek() == ' ') {
            this.reader.forward();
        }
        while ("\r\n\u0085\u2028\u2029".indexOf(this.reader.peek()) != -1) {
            stringBuffer.append(this.scanLineBreak());
            mark = this.reader.getMark();
            while (this.reader.getColumn() < n && this.reader.peek() == ' ') {
                this.reader.forward();
            }
        }
        return new Object[]{stringBuffer.toString(), mark};
    }

    private Token scanFlowScalar(char c) {
        boolean bl = c == '\"';
        StringBuffer stringBuffer = new StringBuffer();
        Mark mark = this.reader.getMark();
        char c2 = this.reader.peek();
        this.reader.forward();
        stringBuffer.append(this.scanFlowScalarNonSpaces(bl, mark));
        while (this.reader.peek() != c2) {
            stringBuffer.append(this.scanFlowScalarSpaces(mark));
            stringBuffer.append(this.scanFlowScalarNonSpaces(bl, mark));
        }
        this.reader.forward();
        Mark mark2 = this.reader.getMark();
        return new ScalarToken(stringBuffer.toString(), false, mark, mark2, c);
    }

    private String scanFlowScalarNonSpaces(boolean bl, Mark mark) {
        StringBuffer stringBuffer;
        block8: {
            char c;
            stringBuffer = new StringBuffer();
            while (true) {
                int n = 0;
                while ("'\"\\\u0000 \t\r\n\u0085\u2028\u2029".indexOf(this.reader.peek(n)) == -1) {
                    ++n;
                }
                if (n != 0) {
                    stringBuffer.append(this.reader.prefix(n));
                    this.reader.forward(n);
                }
                c = this.reader.peek();
                if (!bl && c == '\'' && this.reader.peek(1) == '\'') {
                    stringBuffer.append("'");
                    this.reader.forward(2);
                    continue;
                }
                if (bl && c == '\'' || !bl && "\"\\".indexOf(c) != -1) {
                    stringBuffer.append(c);
                    this.reader.forward();
                    continue;
                }
                if (!bl || c != '\\') break block8;
                this.reader.forward();
                c = this.reader.peek();
                if (ESCAPE_REPLACEMENTS.containsKey(new Character(c))) {
                    stringBuffer.append(ESCAPE_REPLACEMENTS.get(new Character(c)));
                    this.reader.forward();
                    continue;
                }
                if (ESCAPE_CODES.containsKey(new Character(c))) {
                    n = ESCAPE_CODES.get(new Character(c));
                    this.reader.forward();
                    String string = this.reader.prefix(n);
                    if (NOT_HEXA.matcher(string).find()) {
                        throw new ScannerException("while scanning a double-quoted scalar", mark, "expected escape sequence of " + n + " hexadecimal numbers, but found: " + string, this.reader.getMark());
                    }
                    char c2 = (char)Integer.parseInt(string, 16);
                    stringBuffer.append(c2);
                    this.reader.forward(n);
                    continue;
                }
                if ("\r\n\u0085\u2028\u2029".indexOf(c) == -1) break;
                this.scanLineBreak();
                stringBuffer.append(this.scanFlowScalarBreaks(mark));
            }
            throw new ScannerException("while scanning a double-quoted scalar", mark, "found unknown escape character " + c + "(" + c + ")", this.reader.getMark());
        }
        return stringBuffer.toString();
    }

    private String scanFlowScalarSpaces(Mark mark) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (" \t".indexOf(this.reader.peek(n)) != -1) {
            ++n;
        }
        String string = this.reader.prefix(n);
        this.reader.forward(n);
        char c = this.reader.peek();
        if (c == '\u0000') {
            throw new ScannerException("while scanning a quoted scalar", mark, "found unexpected end of stream", this.reader.getMark());
        }
        if ("\r\n\u0085\u2028\u2029".indexOf(c) != -1) {
            String string2 = this.scanLineBreak();
            String string3 = this.scanFlowScalarBreaks(mark);
            if (!"\n".equals(string2)) {
                stringBuffer.append(string2);
            } else if (string3.length() == 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(string3);
        } else {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private String scanFlowScalarBreaks(Mark mark) {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            String string;
            if (("---".equals(string = this.reader.prefix(3)) || "...".equals(string)) && "\u0000 \t\r\n\u0085\u2028\u2029".indexOf(this.reader.peek(3)) != -1) {
                throw new ScannerException("while scanning a quoted scalar", mark, "found unexpected document separator", this.reader.getMark());
            }
            while (" \t".indexOf(this.reader.peek()) != -1) {
                this.reader.forward();
            }
            if ("\r\n\u0085\u2028\u2029".indexOf(this.reader.peek()) == -1) break;
            stringBuffer.append(this.scanLineBreak());
        }
        return stringBuffer.toString();
    }

    private Token scanPlain() {
        Mark mark;
        StringBuffer stringBuffer = new StringBuffer();
        Mark mark2 = mark = this.reader.getMark();
        int n = this.indent + 1;
        String string = "";
        do {
            char c;
            int n2 = 0;
            if (this.reader.peek() == '#') break;
            while (!("\u0000 \t\r\n\u0085\u2028\u2029".indexOf(c = this.reader.peek(n2)) != -1 || this.flowLevel == 0 && c == ':' && "\u0000 \t\r\n\u0085\u2028\u2029".indexOf(this.reader.peek(n2 + 1)) != -1 || this.flowLevel != 0 && ",:?[]{}".indexOf(c) != -1)) {
                ++n2;
            }
            if (this.flowLevel != 0 && c == ':' && "\u0000 \t\r\n\u0085\u2028\u2029,[]{}".indexOf(this.reader.peek(n2 + 1)) == -1) {
                this.reader.forward(n2);
                throw new ScannerException("while scanning a plain scalar", mark, "found unexpected ':'", this.reader.getMark(), "Please check http://pyyaml.org/wiki/YAMLColonInFlowContext for details.");
            }
            if (n2 == 0) break;
            this.allowSimpleKey = false;
            stringBuffer.append(string);
            stringBuffer.append(this.reader.prefix(n2));
            this.reader.forward(n2);
            mark2 = this.reader.getMark();
        } while (!"".equals(string = this.scanPlainSpaces()) && this.reader.peek() != '#' && (this.flowLevel != 0 || this.reader.getColumn() >= n));
        return new ScalarToken(stringBuffer.toString(), mark, mark2, true);
    }

    private String scanPlainSpaces() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (this.reader.peek(n) == ' ') {
            ++n;
        }
        String string = this.reader.prefix(n);
        this.reader.forward(n);
        char c = this.reader.peek();
        if ("\r\n\u0085\u2028\u2029".indexOf(c) != -1) {
            String string2 = this.scanLineBreak();
            this.allowSimpleKey = true;
            String string3 = this.reader.prefix(3);
            if ("---".equals(string3) || "...".equals(string3) && "\u0000 \t\r\n\u0085\u2028\u2029".indexOf(this.reader.peek(3)) != -1) {
                return "";
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            while (" \r\n\u0085\u2028\u2029".indexOf(this.reader.peek()) != -1) {
                if (this.reader.peek() == ' ') {
                    this.reader.forward();
                    continue;
                }
                stringBuffer2.append(this.scanLineBreak());
                string3 = this.reader.prefix(3);
                if (!"---".equals(string3) && (!"...".equals(string3) || "\u0000 \t\r\n\u0085\u2028\u2029".indexOf(this.reader.peek(3)) == -1)) continue;
                return "";
            }
            if (!"\n".equals(string2)) {
                stringBuffer.append(string2);
            } else if (stringBuffer2 == null || stringBuffer2.toString().equals("")) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(stringBuffer2);
        } else {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private String scanTagHandle(String string, Mark mark) {
        char c = this.reader.peek();
        if (c != '!') {
            throw new ScannerException("while scanning a " + string, mark, "expected '!', but found " + c + "(" + c + ")", this.reader.getMark());
        }
        int n = 1;
        c = this.reader.peek(n);
        if (c != ' ') {
            while ("abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-_".indexOf(c) != -1) {
                c = this.reader.peek(++n);
            }
            if (c != '!') {
                this.reader.forward(n);
                throw new ScannerException("while scanning a " + string, mark, "expected '!', but found " + c + "(" + c + ")", this.reader.getMark());
            }
            ++n;
        }
        String string2 = this.reader.prefix(n);
        this.reader.forward(n);
        return string2;
    }

    private String scanTagUri(String string, Mark mark) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        char c = this.reader.peek(n);
        while ("abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-_".indexOf(c) != -1 || "-;/?:@&=+$,_.!~*'()[]%".indexOf(c) != -1) {
            if (c == '%') {
                stringBuffer.append(this.reader.prefix(n));
                this.reader.forward(n);
                n = 0;
                stringBuffer.append(this.scanUriEscapes(string, mark));
            } else {
                ++n;
            }
            c = this.reader.peek(n);
        }
        if (n != 0) {
            stringBuffer.append(this.reader.prefix(n));
            this.reader.forward(n);
            n = 0;
        }
        if (stringBuffer.length() == 0) {
            throw new ScannerException("while scanning a " + string, mark, "expected URI, but found " + c + "(" + c + ")", this.reader.getMark());
        }
        return stringBuffer.toString();
    }

    private String scanUriEscapes(String string, Mark mark) {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.reader.peek() == '%') {
            this.reader.forward();
            try {
                stringBuffer.append(Integer.parseInt(this.reader.prefix(2), 16));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ScannerException("while scanning a " + string, mark, "expected URI escape sequence of 2 hexadecimal numbers, but found " + this.reader.peek(1) + "(" + this.reader.peek(1) + ") and " + this.reader.peek(2) + "(" + this.reader.peek(2) + ")", this.reader.getMark());
            }
            this.reader.forward(2);
        }
        return stringBuffer.toString();
    }

    private String scanLineBreak() {
        char c = this.reader.peek();
        if ("\r\n\u0085".indexOf(c) != -1) {
            if ("\r\n".equals(this.reader.prefix(2))) {
                this.reader.forward(2);
            } else {
                this.reader.forward();
            }
            return "\n";
        }
        if ("\u2028\u2029".indexOf(c) != -1) {
            this.reader.forward();
            return String.valueOf(c);
        }
        return "";
    }

    static {
        ESCAPE_REPLACEMENTS.put(new Character('0'), "\u0000");
        ESCAPE_REPLACEMENTS.put(new Character('a'), "\u0007");
        ESCAPE_REPLACEMENTS.put(new Character('b'), "\b");
        ESCAPE_REPLACEMENTS.put(new Character('t'), "\t");
        ESCAPE_REPLACEMENTS.put(new Character('n'), "\n");
        ESCAPE_REPLACEMENTS.put(new Character('v'), "\u000b");
        ESCAPE_REPLACEMENTS.put(new Character('f'), "\f");
        ESCAPE_REPLACEMENTS.put(new Character('r'), "\r");
        ESCAPE_REPLACEMENTS.put(new Character('e'), "\u001b");
        ESCAPE_REPLACEMENTS.put(new Character(' '), " ");
        ESCAPE_REPLACEMENTS.put(new Character('\"'), "\"");
        ESCAPE_REPLACEMENTS.put(new Character('\\'), "\\");
        ESCAPE_REPLACEMENTS.put(new Character('N'), "\u0085");
        ESCAPE_REPLACEMENTS.put(new Character('_'), "\u00a0");
        ESCAPE_REPLACEMENTS.put(new Character('L'), "\u2028");
        ESCAPE_REPLACEMENTS.put(new Character('P'), "\u2029");
        ESCAPE_CODES.put(new Character('x'), new Integer(2));
        ESCAPE_CODES.put(new Character('u'), new Integer(4));
        ESCAPE_CODES.put(new Character('U'), new Integer(8));
    }
}

